from flask import Flask
from app.config.config import Config
from app.routes import user_routes, auth_routes
from app.models.model import db





def create_app():
    app = Flask(__name__)
    app.config.from_object(Config)
    app.config['SQLALCHEMY_DATABASE_URI'] = 'mysql://root:@127.0.0.1/data_up2'
    app.config['SQLALCHEMY_TRACK_MODIFICATIONS'] = False

    db.init_app(app)

    app.register_blueprint(user_routes.users_bp)
    app.register_blueprint(auth_routes.auth_bp)

    with app.app_context():
        db.create_all()

        return app
 