var corporateName = '';
var roles = '';

function initCognitoSDK() {

    var data = {
        UserPoolId: 'ap-south-1_WS67VV3no',
        ClientId: '2rjsjhv4b17scp25v5geieg793'
    };

    var userPool = new AmazonCognitoIdentity.CognitoUserPool(data);
    var cognitoUser = userPool.getCurrentUser();


    if (cognitoUser != null) {
        cognitoUser.getSession(function (err, session) {
            if (err) {
                console.log("error :: s:: :: " + err);
                var curUrl = "https://demo.tripnomics.com/beta/";
                window.location.href = curUrl;
                return;
            }

            if (session.isValid()) {
                getUserDetails(session);
            }

        });
    }


    return cognitoUser;

}

function addGroups(userName) {


    var selectedGroupName = $('#selectGroup option:selected').val();


    var addUserparams = {
        GroupName: selectedGroupName,
        UserPoolId: 'ap-south-1_WS67VV3no',
        Username: userName
    };


    AWSCognito.config.apiVersions = {
        cognitoidentityserviceprovider: '2016-04-18',
        // other service API versions
    };

    AWS.config.region = 'ap-south-1'; // Region
    AWS.config.credentials = new AWS.CognitoIdentityCredentials({
        IdentityPoolId: 'ap-south-1:dddf6f87-280e-4a01-933f-422193538d5d',
    });

    var cognitoidentityserviceprovider = new AWS.CognitoIdentityServiceProvider();


    cognitoidentityserviceprovider.adminAddUserToGroup(addUserparams, function (err, data) {
        if (err) {
            console.log(err, err.stack);
        } // an error occurred
        else {
            console.log(data);



            swal({
                title: "Group Added Successfully",
                text: selectedGroupName + " is added",
                type: "success"
            });
        } // successful response
    });
}

//showModalUsers

function showModalUsers(username) {
    var groupParams = {
        UserPoolId: 'ap-south-1_WS67VV3no',
        /* required */
        Limit: 10
    };

    var getadminparams = {
        UserPoolId: 'ap-south-1_WS67VV3no',
        Username: username,
        Limit: 10

    };

    AWSCognito.config.apiVersions = {
        cognitoidentityserviceprovider: '2016-04-18',
        // other service API versions
    };

    AWS.config.region = 'ap-south-1'; // Region
    AWS.config.credentials = new AWS.CognitoIdentityCredentials({
        IdentityPoolId: 'ap-south-1:dddf6f87-280e-4a01-933f-422193538d5d',
    });

    var cognitoidentityserviceprovider = new AWS.CognitoIdentityServiceProvider();




    cognitoidentityserviceprovider.listGroups(groupParams, function (err, data) {
        if (err) {
            console.log(err, err.stack); // an error occurred
        } else {

            $('#site_review_modal').modal('show');
            console.log("group datain showDetailUsers :: :: :: " + data); // successful response
            var selectData = '';
            $.map(data.Groups, function (dataChk) {
                selectData += '<option value="' + dataChk.GroupName + '">' + dataChk.GroupName + '</option>';
            });


            $('#site_review_modal .modal-body').html('<div id="site_review_modal"><h2 style="text-align: center; margin: 15px 0px;">Add Following Group</h2><div class="body"><select name="selectGroup" id="selectGroup" class="form-control" style="display: block;"><option value="" selected>Please Select Group</option>' + selectData + '</select>    <div><input type="hidden" value="" id="groupUserName" /><table class="table table-hover table-striped table-mail responsive" id="groupTable"><thead><tr class=""><td class="">Group Name</td><td class="">Roles</td><td class="">Action</td></tr></thead><tbody id="userGroupListTable"></tbody></table></div></div></div>');
            $('#site_review_modal .modal-footer').html('<button type="button" class="btn btn-danger" data-dismiss="modal">Close</button> <button type="button" class="btn btn-primary" data-dismiss="modal" onclick = "addGroups(\'' + username + '\')">Add Group</button>');

            var userGroupData = '';
            $('#groupUserName').val(username);
            cognitoidentityserviceprovider.adminListGroupsForUser(getadminparams, function (err, rtndata) {
                if (err) {
                    console.log(err, err.stack);
                } else {
                    $.map(rtndata.Groups, function (dataChk) {

                        var str = dataChk.RoleArn;
                        var roles = str.substring(str.lastIndexOf("/") + 1);


                        userGroupData += '<tr><td>' + dataChk.GroupName + '</td><td>' + roles + '</td><td><button type="button" class="close" title="Remove Group" data-dismiss="modal" onclick = "removeGroupCheck(\'' + dataChk.GroupName + '\')">&times;</button></td></tr>'
                    });

                    $('tbody#userGroupListTable').html(userGroupData);
                }
            });



        }

    });


}

function toggleUserLock(userName) {
    console.log("username in toggleUser :: :: " + userName);




    if ($("#statusCheck_" + userName).prop('checked') == true) {
        //do something
        changeUserStatus(userName, true);
    } else {
        changeUserStatus(userName, false);
    }

}

function changeUserStatus(userName, status) {
    var params = {
        UserPoolId: 'ap-south-1_WS67VV3no',
        Username: userName
    };

    AWSCognito.config.apiVersions = {
        cognitoidentityserviceprovider: '2016-04-18',
        // other service API versions
    };

    AWS.config.region = 'ap-south-1'; // Region
    AWS.config.credentials = new AWS.CognitoIdentityCredentials({
        IdentityPoolId: 'ap-south-1:dddf6f87-280e-4a01-933f-422193538d5d',
    });

    var cognitoidentityserviceprovider = new AWS.CognitoIdentityServiceProvider();
    if (status) {
        cognitoidentityserviceprovider.adminEnableUser(params, function (err, data) {
            if (err) {
                console.log(err, err.stack); // an error occurred
            } else {
                console.log(data);
                getList();
            } // successful response
        });
    } else {
        cognitoidentityserviceprovider.adminDisableUser(params, function (err, data) {
            if (err) {
                console.log(err, err.stack); // an error occurred
            } else {
                console.log(data); // successful response
                getList();
            }
        });
    }
}

function getList() {


    /* AWSCognito.config.region = 'ap-south-1';

 AWSCognito.config.credentials = new AWSCognito.CognitoIdentityCredentials({
     IdentityPoolId: 'ap-south-1:5dfe7f6a-c7ce-4f45-bf8f-e216239c5499'
 });*/
    var groupParams = {
        UserPoolId: 'ap-south-1_WS67VV3no',
        /* required */
        Limit: 10
    };
    var usergroupparams = {
        GroupName: 'TS_TEAM',
        /* required */
        UserPoolId: 'ap-south-1_WS67VV3no',
        /* required */
        Limit: 10
    };


    var params = {
        UserPoolId: 'ap-south-1_WS67VV3no',
        /* required */
        AttributesToGet: ["email", "locale", "name", "phone_number"],
        Filter: '',
        Limit: 10

    };

    var addUserparams = {
        GroupName: 'TS_TEAM',
        UserPoolId: 'ap-south-1_WS67VV3no',
        Username: '56b2d6ea-24a9-42a8-8354-d626abd650eb'
    };


    var getUserparams = {
        UserPoolId: 'ap-south-1_WS67VV3no',
        /* required */
        Username: '56b2d6ea-24a9-42a8-8354-d626abd650eb' /* required */
    };




    AWSCognito.config.apiVersions = {
        cognitoidentityserviceprovider: '2016-04-18',
        // other service API versions
    };



    /*AWSCognito.config.region = 'ap-south-1'; // Region
    AWSCognito.config.credentials = new AWSCognito.CognitoIdentityCredentials({
        IdentityPoolId: 'ap-south-1:5dfe7f6a-c7ce-4f45-bf8f-e216239c5499',
    });
    */

    AWS.config.region = 'ap-south-1'; // Region
    AWS.config.credentials = new AWS.CognitoIdentityCredentials({
        IdentityPoolId: 'ap-south-1:dddf6f87-280e-4a01-933f-422193538d5d',
    });

    var cognitoidentityserviceprovider = new AWS.CognitoIdentityServiceProvider();

    cognitoidentityserviceprovider.listUsers(params, function (err, data) {
        if (err) {
            console.log(err, err.stack); // an error occurred  
        } else {
            console.log("dataChk in aws auth :: :: " + data);
            console.log("dataChk.Users in aws auth :: :: " + data.Users);
            var tableData = '';
            $.map(data.Users, function (dataChk) {

                console.log("dataChk.Users in aws auth :: :: " + dataChk.Attributes);
                console.log("dataChk.Users in aws auth :: :: " + dataChk);


                console.log("dataChk.Enabled :: :: :: " + dataChk.Enabled);
                var enabledCheck = true;
                var checked = '';
                if (!dataChk.Enabled) {
                    enabledCheck = 'Inactive'
                    checked = '';
                } else {
                    enabledCheck = 'Active'
                    checked = 'checked';
                }

                tableData += '<tr><td>' + dataChk.Attributes[3].Value + '</td><td>' + dataChk.Attributes[0].Value + '</td><td>' + dataChk.Attributes[1].Value + '</td><td>' + dataChk.Attributes[2].Value + '</td><td><div class="i-checks"><label> <input type="checkbox" ' + checked + ' id="statusCheck_' + dataChk.Username + '" onchange="toggleUserLock(\'' + dataChk.Username + '\')"> <i></i> ' + enabledCheck + '</label></div></td><td><input type="button" class="btn btn-primary" value="Add Groups" onclick = "showModalUsers(\'' + dataChk.Username + '\')"/></td></tr>';
            });
            $('tbody#userListTable').html(tableData);
        }

    });

    cognitoidentityserviceprovider.listGroups(groupParams, function (err, data) {
        if (err) {
            console.log(err, err.stack); // an error occurred}
        } else {
            // console.log(data); // successful response} 
            var groupTableData = '';


            $.map(data.Groups, function (dataChk) {
                var str = dataChk.RoleArn;
                var roles = str.substring(str.lastIndexOf("/") + 1);
                groupTableData += '<tr><td>' + dataChk.GroupName + '</td><td>' + dataChk.Description + '</td><td>' + roles +
                    '</td><td>' + dataChk.CreationDate + '</td><td><input type="button" class="btn btn-primary" value="Details" onclick = "showDetailGroups(\'' + dataChk.GroupName + '\')"/></td><input type="hidden" value="" id="userGroupName" /></tr>';
            });
            $('tbody#groupListTable').html(groupTableData);
        }

    });

    /* cognitoidentityserviceprovider.listUsersInGroup(usergroupparams, function (err, data) {
     if (err) console.log(err, err.stack); // an error occurred
     else console.log("before adminGetUseerss ::: :: " + data); // successful response
 });

 cognitoidentityserviceprovider.adminGetUser(getUserparams, function (err, data) {
     if (err) console.log(err, err.stack); // an error occurred
     else console.log("in adminGetUseerss ::: :: " + data); // successful response
 });*/



}




function showDetailGroups(groupName) {

    var usergroupparams = {
        GroupName: groupName,
        /* required */
        UserPoolId: 'ap-south-1_WS67VV3no',
        /* required */
        Limit: 10
    };

    $('#userGroupName').val(groupName);

    AWSCognito.config.apiVersions = {
        cognitoidentityserviceprovider: '2016-04-18',
        // other service API versions
    };

    AWS.config.region = 'ap-south-1'; // Region
    AWS.config.credentials = new AWS.CognitoIdentityCredentials({
        IdentityPoolId: 'ap-south-1:dddf6f87-280e-4a01-933f-422193538d5d',
    });

    var cognitoidentityserviceprovider = new AWS.CognitoIdentityServiceProvider();

    cognitoidentityserviceprovider.listUsersInGroup(usergroupparams, function (err, data) {
        if (err) {
            console.log(err, err.stack); // an error occurred
        } else {
            console.log(data); // successful response
            $('#user_group_modal').modal('show');


            //
            $('#user_group_modal .modal-body').html('<table class="table table-hover table-striped table-mail responsive" id="pnrtable"><thead><tr class=""><td class="">Email</td><td class="">Corporate</td><td class="">Enabled</td><td class="">Status</td></tr></thead><tbody id="groupUserTable"></tbody></table>');

            var groupUserData = '';
            console.log(data);
            $.map(data.Users, function (dataChk) {



                groupUserData += '<tr><td>' + dataChk.Attributes[6].Value + '</td><td>' + dataChk.Attributes[5].Value + '</td><td>' + dataChk.Enabled + '</td><td>' + dataChk.UserStatus + '</td><td><button type="button" class="close" title="Remove User" data-dismiss="modal" onclick = "removeUserCheck(\'' + dataChk.Username + '\')">&times;</button></td></tr>';
            });
            $('tbody#groupUserTable').html(groupUserData);


            $('#user_group_modal .modal-footer').html('<button type="button" class="btn btn-danger" data-dismiss="modal">Close</button>');

        }
    });
}
//groupName

function removeGroupCheck(groupName) {
    swal({
            title: "Are you sure?",
            text: "You can always add Group to this User",
            type: "warning",
            showCancelButton: true,
            confirmButtonColor: "#DD6B55",
            confirmButtonText: "Yes, Remove it!",
            cancelButtonText: "No, cancel please!",
            closeOnConfirm: false,
            closeOnCancel: false
        },
        function (isConfirm) {
            if (isConfirm) {
                removeGroup(groupName, isConfirm);
            } else {
                swal("Cancelled", "You have cancelled this activity", "error");

            }
        });
}

function removeGroup(groupName, isConfirm) {
    var userName = $('#groupUserName').val();


    var removeGroupparams = {
        GroupName: groupName,
        UserPoolId: 'ap-south-1_WS67VV3no',
        Username: userName
    };

    AWSCognito.config.apiVersions = {
        cognitoidentityserviceprovider: '2016-04-18',
        // other service API versions
    };

    AWS.config.region = 'ap-south-1'; // Region
    AWS.config.credentials = new AWS.CognitoIdentityCredentials({
        IdentityPoolId: 'ap-south-1:dddf6f87-280e-4a01-933f-422193538d5d',
    });

    var cognitoidentityserviceprovider = new AWS.CognitoIdentityServiceProvider();



    cognitoidentityserviceprovider.adminRemoveUserFromGroup(removeGroupparams, function (err, data) {
        if (err) {
            console.log(err, err.stack);
            swal("Error ", "Error While Removing User from the Group", "error");

        } else {
            console.log(data);
            swal("Removed!", "This Group got Removed.", "success");

        }
    });
}

function removeUserCheck(userName) {


    swal({
            title: "Are you sure?",
            text: "You can always add user to this Group from Users Section",
            type: "warning",
            showCancelButton: true,
            confirmButtonColor: "#DD6B55",
            confirmButtonText: "Yes, Remove it!",
            cancelButtonText: "No, cancel please!",
            closeOnConfirm: false,
            closeOnCancel: false
        },
        function (isConfirm) {
            if (isConfirm) {
                removeUser(userName, isConfirm);
            } else {
                swal("Cancelled", "You have cancelled this activity", "error");

            }
        });

}

function removeUser(userName, isConfirm) {

    var groupName = $('#userGroupName').val();


    var removeparams = {
        GroupName: groupName,
        UserPoolId: 'ap-south-1_WS67VV3no',
        Username: userName
    };

    AWSCognito.config.apiVersions = {
        cognitoidentityserviceprovider: '2016-04-18',
        // other service API versions
    };

    AWS.config.region = 'ap-south-1'; // Region
    AWS.config.credentials = new AWS.CognitoIdentityCredentials({
        IdentityPoolId: 'ap-south-1:dddf6f87-280e-4a01-933f-422193538d5d',
    });

    var cognitoidentityserviceprovider = new AWS.CognitoIdentityServiceProvider();



    cognitoidentityserviceprovider.adminRemoveUserFromGroup(removeparams, function (err, data) {
        if (err) {
            console.log(err, err.stack);
            swal("Error ", "Error While Removing User from the Group", "error");

        } else {
            console.log(data);
            swal("Removed!", "This User got Removed.", "success");

        }
    });

}

function getUserDetails(session) {
    var idToken = session.getIdToken().getJwtToken();


    if (idToken) {
        var payload = idToken.split('.')[1];
        var tokenobj = JSON.parse(atob(payload));
        var formatted = JSON.stringify(tokenobj, undefined, 2);
        console.log("formatted :: :: :: " + formatted);
        formatted = JSON.parse(formatted);


        //document.getElementById('idtoken').innerHTML = formatted;
        var str = formatted["cognito:roles"].toString();
        var email = formatted["email"].toString();

        


        roles = str.substring(str.lastIndexOf("/") + 1);


        console.log("roles :: :: :: in aws_auth 04-09 test:: :  " + roles);



        if(roles=="Customers"){
            corporateName = formatted["locale"].toString();
            console.log("corporateName in aws_auth.js :: :: " + corporateName);
        }else if(roles=="TS_Team"){
                    console.log("roles in aws_auth.js :: :: " + roles);
        }

    }
    var accToken = session.getAccessToken().getJwtToken();
    console.log("accToken :: :: :: :: " + accToken);
    if (accToken) {
        var payload = accToken.split('.')[1];
        var tokenobj = JSON.parse(atob(payload));
        var formatted = JSON.stringify(tokenobj, undefined, 2);

    }
    var refToken = session.getRefreshToken().getToken();
    console.log("refToken :: :: :: :: " + refToken);
    if (refToken) {
        //document.getElementById('reftoken').innerHTML = refToken.substring(1, 20);
        //tsteam, customer/enterprise, travel agent, 
    }

}
$(document).ready(function () {
    var auth = initCognitoSDK();

    if (auth == null) {
        var curUrl = "https://demo.tripnomics.com/beta/";
        window.location.href = curUrl;
    }
});
