<!DOCTYPE html>
<html>

<head>

    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <title>TPX | Boarding</title>

    <link href="css/bootstrap.min.css" rel="stylesheet">
    <link href="font-awesome/css/font-awesome.css" rel="stylesheet">
    <link href="css/plugins/steps/jquery.steps.css" rel="stylesheet">
    <link href="css/plugins/iCheck/custom.css" rel="stylesheet">
    <link href="css/animate.css" rel="stylesheet">
    <link href="css/style.css" rel="stylesheet">
    <link href="css/plugins/codemirror/codemirror.css" rel="stylesheet">
    <link href="css/plugins/codemirror/ambiance.css" rel="stylesheet">
    <link rel="stylesheet" href="airline_logos/logo.css">


    <style>
        h5 {
            font-size: 15px;
        }

        .itinerary {
            font-size: 11px;
        }

        .table {
            font-size: 15px;
        }

        .table thead {
            font-weight: bold;
        }

        .table tr:hover {
            cursor: pointer;
        }

        .table span {
            font-size: 15px;
        }

        .agl {
            font-size: 15px;
        }

        .labels-font {
            font-size: 12px !important;
        }

        .board1 {
            float: left;
        }



        .cl_img {
            width: 20px;
            cursor: pointer;
            margin-bottom: 5px;
        }

    </style>
    <script>
        var cur_var = {
            'USD': '&#36;',
            'USD': '&#36;',
            'GBP': '&#163;',
            'EUR': '&#128;',
            'INR': '&#x20B9;',
            'AED': '&#x62f;'
        };

    </script>
</head>

<body class="top-navigation md-skin">

    <div id="wrapper" class="lazy" style="display:none">
        <div id="page-wrapper" class="gray-bg">
            <div class="row border-bottom white-bg" id="navbar_container">
            </div>

            <div class="fh-breadcrumb">

                <div class="fh-column">
                    <div class="full-height-scroll">
                        <ul class="list-group elements-list">
                            <li class="list-group-item active">
                                <a data-toggle="tab" href="#tab-1">
                                    
                                    <strong>Overview</strong>
                                    <div class="small m-t-xs">
                                        <p>
                                            
                                        </p>
                                      <p class="m-b-none">
                                           Complete Overview of Tripnomics
                                        </p>
                                    </div>
                                </a>
                            </li>
                            <li class="list-group-item ">
                                <a data-toggle="tab" href="#tab-2">
                                    <!--<small class="pull-right text-muted"> 11.10.2015</small>-->
                                    <strong>Introduction </strong>
                                    <div class="small m-t-xs">
                                        <p class="m-b-xs">
                                            Introducing Enterprise Details
                                            <br/>
                                        </p>
                                        <p class="m-b-none">

                                            <!--<span class="label pull-right label-primary">SPECIAL</span>
                                            <i class="fa fa-map-marker"></i> California 10F/32-->
                                        </p>
                                    </div>
                                </a>
                            </li>
                            <li class="list-group-item">
                                <a data-toggle="tab" href="#tab-3">
                                    <!-- <small class="pull-right text-muted"> 08.04.2015</small>-->
                                    <strong>Contracting </strong>
                                    <div class="small m-t-xs">
                                        <p class="m-b-xs">
                                            and Bridging Process Overview
                                        </p>
                                        <p class="m-b-none">
                                            <!--<i class="fa fa-map-marker"></i> Berlin 120R/15-->
                                        </p>
                                    </div>
                                </a>
                            </li>


                            <li class="list-group-item">
                                <a data-toggle="tab" href="#tab-4">
                                    <!--<small class="pull-right text-muted"> 08.04.2015</small>-->
                                    <strong>Integration </strong>
                                    <div class="small m-t-xs">
                                        <p class="m-b-xs">
                                            GDS Bridging Instructions
                                        </p>
                                        <p class="m-b-none">
                                            <!--<i class="fa fa-map-marker"></i> Berlin 120R/15-->
                                        </p>
                                    </div>
                                </a>
                            </li>

                            <li class="list-group-item">
                                <a data-toggle="tab" href="#tab-5">
                                    <!--<small class="pull-right text-muted"> 08.04.2015</small>-->
                                    <strong>Status of Bridging </strong>
                                    <div class="small m-t-xs">
                                        <p class="m-b-xs">
                                            Status against each necessary Access Level
                                        </p>

                                    </div>
                                </a>
                            </li>







                        </ul>

                    </div>
                </div>

                <div class="full-height">
                    <div class="full-height-scroll white-bg border-left">

                        <div class="element-detail-box">

                            <div class="tab-content">
                                <div id="tab-1" class="tab-pane active">






                                    <div class="row">
                                        <div class="col-lg-12">
                                            <div class="ibox float-e-margins">
                                                <!--<div class="ibox-title">
                                                    <h5>All form elements <small>With custom checbox and radion elements.</small></h5>

                                                </div>-->
                                                <div class="ibox-content">


                                                    <p>
                                                        <strong>Tripnomics</strong> – “The Economics of a trip”; by TravelSpends is a platform that can be deployed for real time air fare validation or hotel rate review. Tripnomics is delivered on a SaaS (software-as-a-service) model. We also support multi-instance deployment optionally. It is domain-engineered around set of core capabilities that can be deployed individually or in bundles to service any workflow in our business solution.
                                                    </p>

                                                    <p> The following describes the workflow in Tripnomics:<br/> 1. Travel Policy of the enterprise is captured in Tripnomics <br/> 2. Enterprise authorized TMC GDS and TravelSpends GDS needs to be bridged. <br/> 3. The ticketed itinerary is reviewed & analyzed to understand the travel itinerary.<br/> 4. Alternate options are checked for acceptance within client specified parameters <br/>5. The ticketed itinerary is monitored for fare-drop until the day of travel. <br/>6. Every itinerary is checked immediately after the date of travel for flown status.<br/> 7. Data is aggregated and visualized for reporting and analysis of spends.

                                                    </p>
                                                    <img src="img/overview.JPG" alt="dashboard" class="img-responsive" style="margin-left: 100px;">

                                                    <p>Inventory Distribution in Travel for airlines and hotels is based on software-driven platforms also known as global distribution systems (GDS) developed and maintained by providers such as TravelPort, Sabre, Amadeus.</p>

                                                    <p>The on-going changes in the travel ecosystem make it mandatory for the enterprise to have access to independent, neutral third-party platforms like Tripnomics that offer feature parity and more importantly an independent validation of the TMC fare/rate offerings and delivery mechanism. It is in response to a dynamic, non-transparent industry offering that the enterprise expects and needs ‘real-time’ travel analytics solutions.
                                                    </p>
                                                    <p>
                                                        In order to address these challenges, Tripnomics performs the below routines:<br/> 1. Monitor “Queue’s” within the GDS and import them into Tripnomics<br/> 2. Retrieve “PNR’s” s from a designated GDS queue and update Tripnomics<br/> 3. Check for alternate itinerary within defined Enterprise parameters<br/> 4. Finalization of alternate flight itinerary and fare conditions along with reason codes<br/> 5. Confirm the status of the transaction as “compliant” or “non-compliant”<br/> 6. Communicate the status and potential savings opportunity to the designated TMC.<br/>

                                                    </p>

                                                    <p>In-order to achieve the above it is essential that the TMC GDS is bridged with the TravelSpends GDS. Kindly refer to the details and work-flow mentioned under “Bridging TMC GDS”.</p>

                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                </div>

                                <div id="tab-2" class="tab-pane ">



                                    <h1>
                                        Introduction
                                    </h1>
                                    <form id="form" action="#" class="wizard-big">

                                        <fieldset>

                                            <div class="row">
                                                <div class="col-md-4">
                                                    <div class="form-group">
                                                        <label>Enterprise Name* </label>
                                                        <input id="priceRange" name="priceRange" type="text" class="form-control ">
                                                    </div>
                                                </div>
                                                <div class="col-md-4">
                                                    <div class="form-group">
                                                        <label>Enterprise Representative*</label>

                                                        <input id="departureTime" name="departureTime" type="number" class="form-control ">

                                                    </div>
                                                </div>



                                                <div class="col-md-4">
                                                    <div class="form-group">
                                                        <label>Representative Designation*</label>

                                                        <input id="arrivalTime" name="arrivalTime" type="number" class="form-control">
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="col-md-4">
                                                    <div class="form-group">
                                                        <label>Email*</label>
                                                        <input id="priceRange" name="priceRange" type="text" class="form-control ">
                                                    </div>
                                                </div>
                                                <div class="col-md-4">
                                                    <div class="form-group">
                                                        <label>Phone Number*</label>

                                                        <input id="departureTime" name="departureTime" type="number" class="form-control ">

                                                    </div>
                                                </div>

                                                <div class="col-md-4">
                                                    <div class="form-group">
                                                        <label>Address*</label>

                                                        <textarea name="otherCriteriaExReason" rows="3" cols="50" class="form-control" placeholder="Address : Max 500 chars" maxlength="500"></textarea>


                                                    </div>
                                                </div>



                                            </div>
                                            <div class="row">





                                                <div class="col-md-4">
                                                    <div class="form-group">
                                                        <label>City*</label>

                                                        <input id="arrivalTime" name="arrivalTime" type="number" class="form-control">
                                                    </div>
                                                </div>
                                                <div class="col-md-4">
                                                    <div class="form-group">
                                                        <label>PIN Code*</label>
                                                        <input id="priceRange" name="priceRange" type="text" class="form-control ">
                                                    </div>
                                                </div>

                                                <div class="col-md-4">
                                                    <div class="form-group">
                                                        <label>State*</label>

                                                        <input id="departureTime" name="departureTime" type="number" class="form-control ">

                                                    </div>
                                                </div>
                                            </div>




                                            <div class="row">

                                                <div class="col-md-4">
                                                    <div class="form-group">
                                                        <label>Country*</label>

                                                        <input id="arrivalTime" name="arrivalTime" type="number" class="form-control">

                                                    </div>



                                                </div>

                                                <div class="col-md-4">
                                                    <div class="form-group">
                                                        <label>Domestic Annual Travel Budget*</label>
                                                        <input id="priceRange" name="priceRange" type="text" class="form-control ">
                                                    </div>
                                                </div>
                                                <div class="col-md-4">
                                                    <div class="form-group">
                                                        <label>International Annual Travel Budget*</label>

                                                        <input id="departureTime" name="departureTime" type="number" class="form-control ">

                                                    </div>
                                                </div>



                                            </div>





                                            <div class="form-group">
                                                <div class="pull-right">
                                                    <button class="btn btn-white" type="submit">Cancel</button>
                                                    <button class="btn btn-primary" type="button" onclick="submitDetails();">Save Changes</button>
                                                </div>
                                            </div>

                                        </fieldset>
                                    </form>


                                </div>

                                <div id="tab-3" class="tab-pane">



                                    <h1>
                                        Contract
                                    </h1>


                                    <div class="text-center pdf-toolbar">

                                        <div class="btn-group">
                                            <button id="prev" class="btn btn-white"><i class="fa fa-long-arrow-left"></i> <span class="hidden-xs">Previous</span></button>
                                            <button id="next" class="btn btn-white"><i class="fa fa-long-arrow-right"></i> <span class="hidden-xs">Next</span></button>
                                            <button id="zoomin" class="btn btn-white"><i class="fa fa-search-plus"></i> <span class="hidden-xs">Zoom In</span></button>
                                            <button id="zoomout" class="btn btn-white"><i class="fa fa-search-minus"></i> <span class="hidden-xs">Zoom Out</span> </button>
                                            <button id="zoomfit" class="btn btn-white"> 100%</button>
                                            <span class="btn btn-white hidden-xs">Page: </span>

                                            <div class="input-group">
                                                <input type="text" class="form-control" id="page_num">

                                                <div class="input-group-btn">
                                                    <button type="button" class="btn btn-white" id="page_count">/ 22</button>
                                                </div>
                                            </div>

                                        </div>
                                    </div>

                                    <div class="text-center m-t-md">
                                        <canvas id="the-canvas" class="pdfcanvas border-left-right border-top-bottom b-r-md "></canvas>
                                    </div>


                                </div>


                                <div id="tab-4" class="tab-pane">



                                    <h1>
                                        Integration
                                    </h1>

                                    <div class="row">
                                        <div class="col-lg-3">
                                            <div class="ibox float-e-margins">
                                                <div class="ibox-title">
                                                    <a onclick="generatePdf('pdf/Amadeus_EOS_form.pdf');">Instruction for Amadeus PDF </a>

                                                </div>
                                                <div class="ibox-content">

                                                    <!--<div class="stat-percent font-bold text-info">20% <i class="fa fa-level-up"></i></div>-->
                                                    <!--<small>New orders</small>-->
                                                </div>
                                            </div>

                                            <div class="ibox float-e-margins">
                                                <div class="ibox-title">

                                                    <a onclick="generatePdf('pdf/Galileo_SVCB_form.pdf');">Instruction for Galileo PDF </a>


                                                </div>
                                                <div class="ibox-content">

                                                    <!--<div class="stat-percent font-bold text-info">20% <i class="fa fa-level-up"></i></div>-->
                                                    <!--<small>New orders</small>-->
                                                </div>
                                            </div>
                                            <div class="ibox float-e-margins">
                                                <div class="ibox-title">
                                                    <a onclick="generatePdf('pdf/Sabre_Access_Form.pdf');">Instruction for Sabre PDF </a>

                                                </div>
                                                <div class="ibox-content">

                                                    <!--<div class="stat-percent font-bold text-info">20% <i class="fa fa-level-up"></i></div>-->
                                                    <!--<small>New orders</small>-->
                                                </div>
                                            </div>

                                        </div>


                                        <div class="col-lg-9" id="media">
                                            <embed src="pdf/Amadeus_EOS_form.pdf" id="integrationPdf" width="750" height="450" alt="pdf" pluginspage="http://www.adobe.com/products/acrobat/readstep2.html">


                                        </div>



                                    </div>


                                </div>










                                <div id="tab-5" class="tab-pane">



                                    <h1>
                                        Confirmation
                                    </h1>


                                    <div class="table-responsive">

                                        <table class="table table-striped table-bordered table-hover confirmationTable">
                                            <thead>
                                                <tr>
                                                    <th>Fields </th>
                                                    <th>Category </th>
                                                    <th>Read </th>
                                                    <th>Write </th>
                                                    <th>Both</th>
                                                    <th>None</th>



                                                </tr>
                                            </thead>

                                            <tbody>
                                                <tr>
                                                    <td>PNO</td>
                                                    <td>Receiver can Retrieve Individual PNR's by All Methods</td>
                                                    <td>
                                                        <div class="i-checks"><label> <input type="checkbox" value=""> <i></i>  </label></div>
                                                    </td>
                                                    <td>
                                                        <div class="i-checks"><label> <input type="checkbox" value=""> <i></i>  </label></div>
                                                    </td>
                                                    <td>
                                                        <div class="i-checks"><label> <input type="checkbox" value="" > <i></i>  </label></div>
                                                    </td>
                                                    <td>
                                                        <div class="i-checks"><label> <input type="checkbox" value="" > <i></i>  </label></div>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td>PNN </td>
                                                    <td>Receiver can Retrieve Individual PNR's by Recloc </td>
                                                    <td>
                                                        <div class="i-checks"><label> <input type="checkbox" value=""> <i></i>  </label></div>
                                                    </td>
                                                    <td>
                                                        <div class="i-checks"><label> <input type="checkbox" value=""> <i></i>  </label></div>
                                                    </td>
                                                    <td>
                                                        <div class="i-checks"><label> <input type="checkbox" value="" > <i></i>  </label></div>
                                                    </td>
                                                    <td>
                                                        <div class="i-checks"><label> <input type="checkbox" value="" > <i></i>  </label></div>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td>PNG </td>
                                                    <td>Receiver can Retrieve Group PNR's by All Methods</td>
                                                    <td>
                                                        <div class="i-checks"><label> <input type="checkbox" value=""> <i></i>  </label></div>
                                                    </td>
                                                    <td>
                                                        <div class="i-checks"><label> <input type="checkbox" value=""> <i></i>  </label></div>
                                                    </td>
                                                    <td>
                                                        <div class="i-checks"><label> <input type="checkbox" value="" > <i></i>  </label></div>
                                                    </td>
                                                    <td>
                                                        <div class="i-checks"><label> <input type="checkbox" value="" > <i></i>  </label></div>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td>PNL </td>
                                                    <td>Receiver can Retrieve Group PNR's by Recloc</td>
                                                    <td>
                                                        <div class="i-checks"><label> <input type="checkbox" value=""> <i></i>  </label></div>
                                                    </td>
                                                    <td>
                                                        <div class="i-checks"><label> <input type="checkbox" value=""> <i></i>  </label></div>
                                                    </td>
                                                    <td>
                                                        <div class="i-checks"><label> <input type="checkbox" value="" > <i></i>  </label></div>
                                                    </td>
                                                    <td>
                                                        <div class="i-checks"><label> <input type="checkbox" value="" > <i></i>  </label></div>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td>RMO </td>
                                                    <td>Receiver can Allow Remote Sign In(Cannot be Read or Write can be only Both)</td>
                                                    <td>
                                                        <div class="i-checks"><label> <input type="checkbox" value=""> <i></i>  </label></div>
                                                    </td>
                                                    <td>
                                                        <div class="i-checks"><label> <input type="checkbox" value=""> <i></i>  </label></div>
                                                    </td>
                                                    <td>
                                                        <div class="i-checks"><label> <input type="checkbox" value="" > <i></i>  </label></div>
                                                    </td>
                                                    <td>
                                                        <div class="i-checks"><label> <input type="checkbox" value="" > <i></i>  </label></div>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td>DCB </td>
                                                    <td>Ticketing(Receiver can access TWD record and ITR)(Recommended READ MODE ONLY) </td>
                                                    <td>
                                                        <div class="i-checks"><label> <input type="checkbox" value=""> <i></i>  </label></div>
                                                    </td>
                                                    <td>
                                                        <div class="i-checks"><label> <input type="checkbox" value=""> <i></i>  </label></div>
                                                    </td>
                                                    <td>
                                                        <div class="i-checks"><label> <input type="checkbox" value="" > <i></i>  </label></div>
                                                    </td>
                                                    <td>
                                                        <div class="i-checks"><label> <input type="checkbox" value="" > <i></i>  </label></div>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td>DEM </td>
                                                    <td>Ticketing(Receiver can access EMD record)(Recommended READ MODE ONLY)</td>
                                                    <td>
                                                        <div class="i-checks"><label> <input type="checkbox" value=""> <i></i>  </label></div>
                                                    </td>
                                                    <td>
                                                        <div class="i-checks"><label> <input type="checkbox" value=""> <i></i>  </label></div>
                                                    </td>
                                                    <td>
                                                        <div class="i-checks"><label> <input type="checkbox" value="" > <i></i>  </label></div>
                                                    </td>
                                                    <td>
                                                        <div class="i-checks"><label> <input type="checkbox" value="" > <i></i>  </label></div>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td>SRP </td>
                                                    <td>Receiver can Access Sales Report(Recommended READ MODE ONLY)</td>
                                                    <td>
                                                        <div class="i-checks"><label> <input type="checkbox" value=""> <i></i>  </label></div>
                                                    </td>
                                                    <td>
                                                        <div class="i-checks"><label> <input type="checkbox" value=""> <i></i>  </label></div>
                                                    </td>
                                                    <td>
                                                        <div class="i-checks"><label> <input type="checkbox" value="" > <i></i>  </label></div>
                                                    </td>
                                                    <td>
                                                        <div class="i-checks"><label> <input type="checkbox" value="" > <i></i>  </label></div>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td>QUE </td>
                                                    <td>Receiver can access Queue bank</td>
                                                    <td>
                                                        <div class="i-checks"><label> <input type="checkbox" value=""> <i></i>  </label></div>
                                                    </td>
                                                    <td>
                                                        <div class="i-checks"><label> <input type="checkbox" value=""> <i></i>  </label></div>
                                                    </td>
                                                    <td>
                                                        <div class="i-checks"><label> <input type="checkbox" value="" > <i></i>  </label></div>
                                                    </td>
                                                    <td>
                                                        <div class="i-checks"><label> <input type="checkbox" value="" > <i></i>  </label></div>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td>CPR</td>
                                                    <td>Receiver can access Customer Profiles </td>
                                                    <td>
                                                        <div class="i-checks"><label> <input type="checkbox" value=""> <i></i>  </label></div>
                                                    </td>
                                                    <td>
                                                        <div class="i-checks"><label> <input type="checkbox" value=""> <i></i>  </label></div>
                                                    </td>
                                                    <td>
                                                        <div class="i-checks"><label> <input type="checkbox" value="" > <i></i>  </label></div>
                                                    </td>
                                                    <td>
                                                        <div class="i-checks"><label> <input type="checkbox" value="" > <i></i>  </label></div>
                                                    </td>
                                                </tr>



                                            </tbody>
                                        </table>
                                        <div class="form-group">
                                            <div class=" pull-right " style="margin-bottom: 20px;">

                                                <button class="btn btn-primary " type="button " onclick="submitDetails(); ">Accept & Continue </button>
                                            </div>
                                        </div>
                                    </div>







                                </div>

                            </div>

                        </div>

                    </div>
                </div>



            </div>


            <div class="footer" id="footer"></div>

        </div>
    </div>



    <!-- Mainly scripts -->
    <script src="js/jquery-3.1.1.min.js "></script>
    <script src="js/bootstrap.min.js "></script>
    <script src="js/plugins/metisMenu/jquery.metisMenu.js "></script>
    <script src="js/plugins/slimscroll/jquery.slimscroll.min.js "></script>

    <script src="dist/aws-cognito-sdk.js"></script>
    <script src="dist/amazon-cognito-identity.js"></script>
    <script src="aws_auth.js"></script>

    <script src="js/plugins/validate/jquery.validate.min.js "></script>
    <script src="js/plugins/steps/jquery.steps.min.js "></script>




    <!-- Custom and plugin javascript -->
    <script src="js/inspinia.js "></script>
    <script src="js/plugins/pace/pace.min.js "></script>
    <script src="js/plugins/pdfjs/pdf.js "></script>

    <!-- Flot -->
    <script src="js/plugins/flot/jquery.flot.js "></script>
    <script src="js/plugins/flot/jquery.flot.tooltip.min.js "></script>
    <script src="js/plugins/flot/jquery.flot.resize.js "></script>

    <!-- Peity -->
    <script src="js/plugins/peity/jquery.peity.min.js "></script>
    <!-- Peity demo -->
    <script src="js/demo/peity-demo.js "></script>

    <!-- iCheck -->
    <script src="js/plugins/iCheck/icheck.min.js "></script>

    <script src="https://unpkg.com/hyperapp"></script>
    <script src="js/components/header.js"></script>
    <script src="js/components/footer.js"></script>


    <script id="script ">
        //
        // If absolute URL from the remote server is provided, configure the CORS
        // header on that server.
        //
        var url = 'pdf/TMC_bridging_process.pdf';


        var pdfDoc = null,
            pageNum = 1,
            pageRendering = false,
            pageNumPending = null,
            scale = 1,
            zoomRange = 0.25,
            canvas = document.getElementById('the-canvas'),
            ctx = canvas.getContext('2d');

        /**
         * Get page info from document, resize canvas accordingly, and render page.
         * @param num Page number.
         */
        function renderPage(num, scale) {
            pageRendering = true;
            // Using promise to fetch the page
            pdfDoc.getPage(num).then(function(page) {
                var viewport = page.getViewport(scale);
                canvas.height = 540;
                canvas.width = 960;

                // Render PDF page into canvas context
                var renderContext = {
                    canvasContext: ctx,
                    viewport: viewport
                };
                var renderTask = page.render(renderContext);

                // Wait for rendering to finish
                renderTask.promise.then(function() {
                    pageRendering = false;
                    if (pageNumPending !== null) {
                        // New page rendering is pending
                        renderPage(pageNumPending);
                        pageNumPending = null;
                    }
                });
            });

            // Update page counters
            document.getElementById('page_num').value = num;
        }

        /**
         * If another page rendering in progress, waits until the rendering is
         * finised. Otherwise, executes rendering immediately.
         */
        function queueRenderPage(num) {
            console.log("num :: " + num);
            if (pageRendering) {
                console.log("inside num :: " + num);
                pageNumPending = num;
            } else {
                console.log("else num :: " + num);
                console.log("else scale :: " + scale);
                renderPage(num, scale);
            }
        }

        /**
         * Displays previous page.
         */
        function onPrevPage() {
            if (pageNum <= 1) {
                return;
            }
            pageNum--;
            var scale = pdfDoc.scale;
            queueRenderPage(pageNum, scale);
        }
        document.getElementById('prev').addEventListener('click', onPrevPage);

        /**
         * Displays next page.
         */
        function onNextPage() {
            if (pageNum >= pdfDoc.numPages) {
                return;
            }
            pageNum++;
            var scale = pdfDoc.scale;
            queueRenderPage(pageNum, scale);
        }
        document.getElementById('next').addEventListener('click', onNextPage);

        /**
         * Zoom in page.
         */
        function onZoomIn() {
            if (scale >= pdfDoc.scale) {
                return;
            }
            scale += zoomRange;
            var num = pageNum;
            renderPage(num, scale)
        }
        document.getElementById('zoomin').addEventListener('click', onZoomIn);

        /**
         * Zoom out page.
         */
        function onZoomOut() {
            if (scale >= pdfDoc.scale) {
                return;
            }
            scale -= zoomRange;
            var num = pageNum;
            queueRenderPage(num, scale);
        }
        document.getElementById('zoomout').addEventListener('click', onZoomOut);

        /**
         * Zoom fit page.
         */
        function onZoomFit() {
            if (scale >= pdfDoc.scale) {
                return;
            }
            scale = 1;
            var num = pageNum;
            queueRenderPage(num, scale);
        }
        document.getElementById('zoomfit').addEventListener('click', onZoomFit);


        /**
         * Asynchronously downloads PDF.
         */
        PDFJS.getDocument(url).then(function(pdfDoc_) {
            pdfDoc = pdfDoc_;
            var documentPagesNumber = pdfDoc.numPages;
            document.getElementById('page_count').textContent = '/ ' + documentPagesNumber;

            $('#page_num').on('change', function() {
                var pageNumber = Number($(this).val());

                if (pageNumber > 0 && pageNumber <= documentPagesNumber) {
                    queueRenderPage(pageNumber, scale);
                }

            });

            // Initial/first page rendering
            renderPage(pageNum, scale);
        });




        function generatePdf(url) {
            // $("#integrationPdf ").attr("src ", url);

            // document.getElementById('integrationPdf').setAttribute('src', url);

            $("#media ").html(" ");
            $("#media ").html('<embed src=" ' + url + ' " id="integrationPdf " width="750 " height="450 " alt="pdf " pluginspage="http://www.adobe.com/products/acrobat/readstep2.html ">');









        }

        $(document).ready(function() {
            $('.lazy').show();
            $('.i-checks').iCheck({
                checkboxClass: 'icheckbox_square-green',
                radioClass: 'iradio_square-green',
            });
        });

    </script>

</body>

</html>
