<!DOCTYPE html>
<html>

<head>

    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <title>TPX | Configuration</title>

    <link href="css/bootstrap.min.css" rel="stylesheet">
    <link href="font-awesome/css/font-awesome.css" rel="stylesheet">
    <link href="css/plugins/steps/jquery.steps.css" rel="stylesheet">
    <link href="css/plugins/iCheck/custom.css" rel="stylesheet">
    <link href="css/animate.css" rel="stylesheet">
    <link href="css/style.css" rel="stylesheet">
    <link rel="stylesheet" href="airline_logos/logo.css">
    <link href="css/plugins/chosen/bootstrap-chosen.css" rel="stylesheet">
    <link href="css/plugins/clockpicker/clockpicker.css" rel="stylesheet">
    <style>
        .filtered{
            max-height: 650px;
            overflow-y: scroll;
        }
        .vc{
            display: table-cell;
            text-align: center;
            vertical-align: middle
        }
        .mb10{
            margin-bottom: 10px;
        }
        .fa-long-arrow-right{
            font-size: 32px;
        }
        .centre {
            margin-top:auto;
            margin-bottom:auto;
            text-align:center;
        }
        .success {
            color: green;
        }
        .title-bg {
            background: #FAFAFB;
        }

        .s13 {
            font-size: 13px;
        }

        .s16 {
            font-size: 16px;
        }

        .s15 {
            font-size: 15px;
        }

        h5 {
            font-size: 15px;
        }

        .itinerary {
            font-size: 11px;
        }

        .table {
            font-size: 15px;
        }

        .table thead {
            font-weight: bold;
        }

        .table tr:hover {
            cursor: pointer;
        }

        .table span {
            font-size: 15px;
        }

        .agl {
            font-size: 15px;
        }

        .labels-font {
            font-size: 12px !important;
        }

        .board1 {
            float: left;
        }

        .navbar-brand {
            background: #ffffff !important;
        }

        .cl_img {
            width: 20px;
            cursor: pointer;
            margin-bottom: 5px;
        }

        .min-ibox-height {
            max-height: 650px;
            overflow-y: scroll;
        }

    </style>
    <script>
        var cur_var = {
            'USD': '&#36;',
            'USD': '&#36;',
            'GBP': '&#163;',
            'EUR': '&#128;',
            'INR': '&#x20B9;',
            'AED': '&#x62f;'
        };

    </script>
</head>

<body class="top-navigation md-skin">
    <div id="wrapper">
        <div id="page-wrapper" class="gray-bg">
            <?php include('navbar.php'); ?>



            <div class="ibox-content" style="padding-bottom: 40px;">
                        <h2>
                            Configuration Details
                        </h2>
                        <p>
                            <!--This example show how to use Steps with jQuery Validation plugin.-->
                        </p>

                        <form id="form" action="#" class="wizard-big">
                            <h1>Domestic</h1>
                            <fieldset>
                                <h2>Domestic Config Information</h2>
                                <div class="row">
                <div class="col-md-2">
                  <div class="form-group">
                      <label>Price Flexibility</label>
                      <input id="priceRange" name="priceRange"
                        type="text" class="form-control ">
                    </div>
                  </div>
                    <div class="col-md-2">
                  <div class="form-group">
                      <label>Currency</label>
                      
                      
                      <select name="currency" id="currency" class="form-control" >
                                                   <option value="">Please select </option>
                                                   <option value="INR">INR</option>
                                                    <option value="USD">USD</option>
                                                   <option value="GBP">GBP</option>
                                                    <option value="EUR">EUR</option>
                                                    <option value="AED">AED</option>
                          
                                                  
                    </select>
                      
                      
                      <!--<input id="priceRange" name="priceRange"
                        type="text" class="form-control ">-->
                    </div>
                  </div>                
                                    
                  <div class="col-md-2">
                      <div class="form-group">
                      <label>Time Flexibility</label>
                          <select name="timeFlexibility" id="timeFlexibility" class="form-control ">
                              <option selected value="0">Departure</option>
                              <option value="1">Arrival</option>
                          
                          </select>

                                          <!-- <input id="departureTime" name="departureTime"
                            type="number" class="form-control " value="2">-->

                      </div>
                  </div>
                                    
                    <div id="departureDiv" class="col-md-2" style="display:block">
                  <div class="form-group">
                  <label>Departure Time</label>

                                       <input id="departureTime" name="departureTime"
                        type="number" class="form-control " value="2">

                  </div>
                  </div>



                  <div id="arrivalDiv" class="col-md-2" style="display:none">
                  <div class="form-group">
                  <label>Arrival Time</label>

                                            <input id="arrivalTime" name="arrivalTime"
                        type="number" class="form-control" value="2">
                  </div>
                  </div>                 
                                    


                  <div class="col-md-4">
                  <div class="form-group">
                  <label>Stops</label>
                  <input id="stops" name="stops"
                        type="number" class="form-control " value="0">
                  </div>
                  </div>
                </div>


                <div class="row">

                <!--<div class="col-md-4">
                  <div class="form-group">
                  <label>Stops</label>
                  <input id="stops" name="stops"
                        type="number" class="form-control " value="0">
                  </div>
                  </div>-->
                    
                   <div class="col-md-3">
                  <div class="form-group">
                      <label>Airline Inclusion</label>

                                            <select id="airlineInclusion" name="airlineInclusion" data-placeholder="Choose an Airline" class="chosen-select" multiple style="width:350px;" tabindex="4">
                                                <option value="">Select</option>
                                                <option value="JetAirways">JetAirways</option>
                                                <option value="Indigo">Indigo</option>
                                                <option value="Vistara">Vistara</option>
                                                <option value="SpiceJet">SpiceJet</option>
                                                <option value="Air Asia">Air Asia</option>
                                                <option value="Air India">Air India</option>
                                        </select>


                    </div>
                  </div>
                    
                    <div class="col-md-3">
                  <div class="form-group">
                      <label>Airline Exclusion</label>

                                            <select id="airlineExclusion" name="airlineExclusion" data-placeholder="Choose an Airline" class="chosen-select" multiple style="width:350px;" tabindex="4">
                                                <option value="">Select</option>
                                                <option value="JetAirways">JetAirways</option>
                                                <option value="Indigo">Indigo</option>
                                                <option value="Vistara">Vistara</option>
                                                <option value="SpiceJet">SpiceJet</option>
                                                <option value="Air Asia">Air Asia</option>
                                                <option value="Air India">Air India</option>
                                        </select>


                    </div>
                  </div>
                    
                    
                    
                    


                <div class="col-md-3">
                  <div class="form-group">
                      <label>Preferred Airline</label>


                                            <select id="preferredAirline" name="preferredAirline" data-placeholder="Choose an Airline" class="chosen-select" multiple style="width:350px;" tabindex="4">
                                                <option value="">Select</option>
                                                <option value="JetAirways">JetAirways</option>
                                                <option value="Indigo">Indigo</option>
                                                <option value="Vistara">Vistara</option>
                                                <option value="SpiceJet">SpiceJet</option>
                                                <option value="Air Asia">Air Asia</option>
                                                <option value="Air India">Air India</option>
                                        </select>



                    </div>
                  </div>

                  <div class="col-md-3">
                  <div class="form-group">
                      <label>Non-Preferred Airline</label>

                       <select id="nonPreferredAirline" name="nonPreferredAirline" data-placeholder="Choose an Airline" class="chosen-select" multiple style="width:350px;" tabindex="4">
                                                <option value="">Select</option>
                                                <option value="JetAirways">JetAirways</option>
                                                <option value="Indigo">Indigo</option>
                                                <option value="Vistara">Vistara</option>
                                                <option value="SpiceJet">SpiceJet</option>
                                                <option value="Air Asia">Air Asia</option>
                                                <option value="Air India">Air India</option>

                                                </select>
                    </div>
                  </div>


                </div>

                <div class="row">


                <div class="col-md-4">
                          <div class="form-group">
                                                <label>Travel Time</label>
                                                <input id="travelTime" name="travelTime"
                                                            type="text" class="form-control ">
                       </div>
                </div>


                  <div class="col-md-4">
                  <div class="form-group">
                  <label>Transit Time</label>
                  <input id="layoverDuration" name="layoverDuration"
                        type="text" class="form-control ">
                  </div>
                  </div>

                                        <div class="col-md-4">
                  <div class="form-group">
                      <label>Fares</label>

                      <select id="fares" name="fares" class="form-control">
                                            <option value="">Select Fares</option>
                                                    <option value="refundable">Refundable</option>
                                                    <option value="non-refundable">Non-Refundable</option>
                                       </select>



                    </div>
                  </div>

                </div>

                <div class="row">
                  <div class="col-md-4">
                  <div class="form-group">
                  <label>Fare Types</label>
                   <select id="fareTypes" name="fareTypes" class="form-control">
                                       <option value="">Select Fare Types</option>
                                                <option value="corporate">Corporate</option>
                                                <option value="retail">Retail</option>
                                       </select>
                  </div>
                  </div>
                  <!--<div class="col-md-4">
                  <div class="form-group">
                  <label>Alternate Departure Airports</label>


                                        <select id="altDepartureAirports" name="altDepartureAirports" class="form-control">
                                       <option value="">Select</option>
                                                <option value="yes">Yes</option>
                                                <option value="no">No</option>
                                       </select>

                  </div>
                  </div>-->
         <!--<div class="col-md-4">
                  <div class="form-group">
                      <label>Alternate Arrival Airports</label>


                                             <select id="altArrivalAirports" name="altArrivalAirports" class="form-control">
                                       <option value="">Select</option>
                                                <option value="yes">Yes</option>
                                                <option value="no">No</option>
                                       </select>

                    </div>
                  </div>
-->
                    
                    <div class="col-md-4">
                      <div class="form-group">
                          <label >Tickets 
                          
                          
                          <a data-toggle="tooltip" data-placement="top" title="You can break or combine the Tickets"><i class="fa fa-info-circle"></i></a></label>
                          <select id="ticket" name="ticket" class="form-control">
                                           <option value="">Select Ticket Types</option>
                                                    <option value="break">Break</option>
                                                    <option value="combine">Combine</option>
                          </select>


                        </div>
                        
                  </div>
                    
                    <div class="col-md-4">
                      <div class="form-group">
                          <label >Allow Retail Fare / Non-Ref Fare 
                          
                          
                          <a data-toggle="tooltip" data-placement="top" title="Enter Fare Difference to Allow Retail Fare / Non-Ref Fare"><i class="fa fa-info-circle"></i></a></label>
                          
                          <input id="fareDifference" name="fareDifference" placeholder="Fare Difference"
                                                            type="text" class="form-control ">
                          


                        </div>
                        
                  </div>

                </div>
                

                            </fieldset>
                            <h1>Intra-Regional</h1>
                            <fieldset>
                                <h2>Intra-Regional Config Information
                                
                                </h2>
                                <h4><small>The itinerary will include at least one air segment with the origin and destination airport being within the same geographical region. For the purpose of clarity a geographical region is defined as a cluster of countries within close proximity of each other like the Middle East region, South East Asia, Indian sub-continent and so on. For enhanced clarity these regions are classified basis the current geo-political classification and widely accepted for economic and aviation definitions.</small></h4>
                                <div class="row">
                <div class="col-md-2">
                  <div class="form-group">
                      <label>Price Flexibility</label>
                      <input id="inrelPriceRange" name="inrelPriceRange"
                        type="text" class="form-control ">
                    </div>
                  </div>
                                    
                    <div class="col-md-2">
                  <div class="form-group">
                      <label>Currency</label>
                      
                      
                      <select name="inrelcurrency" id="inrelcurrency" class="form-control" >
                                                   <option value="">Please select </option>
                                                   <option value="INR">INR</option>
                                                    <option value="USD">USD</option>
                                                   <option value="GBP">GBP</option>
                                                    <option value="EUR">EUR</option>
                                                    <option value="AED">AED</option>
                          
                                                  
                    </select>
                      
                      
                      <!--<input id="priceRange" name="priceRange"
                        type="text" class="form-control ">-->
                    </div>
                  </div>                   
                  <div class="col-md-2">
                  <div class="form-group">
                  <label>Time Flexibility</label>
                      
                      <select name="intraTimeFlexibility" id="intraTimeFlexibility" class="form-control ">
                              <option selected value="0">Departure</option>
                              <option value="1">Arrival</option>
                          
                          </select>
                  <!--<input id="inrelDepartureTime" name="inrelDepartureTime"
                        type="text"  class="form-control" value="4">-->
                  </div>
                  </div>

                    <div id="intradepartureDiv" class="col-md-2" style="display:block">
                  <div class="form-group">
                  <label>Departure Time</label>

                                       <input id="inrelDepartureTime" name="inrelDepartureTime"
                        type="number" class="form-control " value="2">

                  </div>
                  </div>



                  <div id="intraarrivalDiv" class="col-md-2" style="display:none">
                  <div class="form-group">
                  <label>Arrival Time</label>

                                            <input id="inrelArrivalTime" name="inrelArrivalTime"
                        type="number" class="form-control" value="2">
                  </div>
                  </div>                    

                  <!--<div class="col-md-4">
                  <div class="form-group">
                  <label>Arrival Time</label>
                  <input id="inrelArrivalTime" name="inrelArrivalTime"
                        type="text" class="form-control " value="4">
                  </div>
                  </div>-->
                    
                  <div class="col-md-4">
                  <div class="form-group">
                  <label>Stops</label>
                  <input id="inrelStops" name="inrelStops"
                        type="text" class="form-control " value="1">
                  </div>
                  </div>                  
                                    
                                    
                                    
                </div>


                <div class="row">

                <!--<div class="col-md-4">
                  <div class="form-group">
                  <label>Stops</label>
                  <input id="inrelStops" name="inrelStops"
                        type="text" class="form-control " value="1">
                  </div>
                  </div>-->
                    
                    
                <div class="col-md-3">
                  <div class="form-group">
                      <label>Airline Inclusion</label>

                                            <select id="intlAirlineInclusion" name="intlAirlineInclusion" data-placeholder="Choose an Airline" class="chosen-select" multiple style="width:350px;" tabindex="4">
                                                <option value="">Select</option>
                                                <option value="JetAirways">JetAirways</option>
                                                <option value="Indigo">Indigo</option>
                                                <option value="Vistara">Vistara</option>
                                                <option value="SpiceJet">SpiceJet</option>
                                                <option value="Air Asia">Air Asia</option>
                                                <option value="Air India">Air India</option>
                                        </select>


                    </div>
                  </div>
                    <div class="col-md-3">
                  <div class="form-group">
                      <label>Airline Exclusion</label>

                                            <select id="intlAirlineExclusion" name="intlAirlineExclusion" data-placeholder="Choose an Airline" class="chosen-select" multiple style="width:350px;" tabindex="4">
                                                <option value="">Select</option>
                                                <option value="JetAirways">JetAirways</option>
                                                <option value="Indigo">Indigo</option>
                                                <option value="Vistara">Vistara</option>
                                                <option value="SpiceJet">SpiceJet</option>
                                                <option value="Air Asia">Air Asia</option>
                                                <option value="Air India">Air India</option>
                                        </select>


                    </div>
                  </div>


                <div class="col-md-3">
                  <div class="form-group">
                      <label>Preferred Airline</label>

                                            <select id="inrelPreferredAirline" name="inrelPreferredAirline" data-placeholder="Choose an Airline" class="chosen-select" multiple style="width:350px;" tabindex="4">
                                                <option value="">Select</option>
                                                <option value="JetAirways">JetAirways</option>
                                                <option value="Indigo">Indigo</option>
                                                <option value="Vistara">Vistara</option>
                                                <option value="SpiceJet">SpiceJet</option>
                                                <option value="Air Asia">Air Asia</option>
                                                <option value="Air India">Air India</option>
                                        </select>


                    </div>
                  </div>

                  <div class="col-md-3">
                  <div class="form-group">
                      <label>Non-Preferred Airline</label>



                                             <select id="inrelNonPreferredAirline" name="inrelNonPreferredAirline" data-placeholder="Choose an Airline" class="chosen-select" multiple style="width:350px;" tabindex="4">
                                                <option value="">Select</option>
                                                <option value="JetAirways">JetAirways</option>
                                                <option value="Indigo">Indigo</option>
                                                <option value="Vistara">Vistara</option>
                                                <option value="SpiceJet">SpiceJet</option>
                                                <option value="Air Asia">Air Asia</option>
                                                <option value="Air India">Air India</option>
                                        </select>

                    </div>
                  </div>


                </div>

                <div class="row">


                <div class="col-md-4">
                          <div class="form-group">
                                                <label>Travel Time</label>
                                                <input id="inrelTravelTime" name="inrelTravelTime"
                                                            type="text" class="form-control ">
                       </div>
                </div>


                  <div class="col-md-4">
                  <div class="form-group">
                  <label>Transit Time</label>
                  <input id="inrelLayoverDuration" name="inrelLayoverDuration"
                        type="text" class="form-control ">
                  </div>
                  </div>

                                        <div class="col-md-4">
                  <div class="form-group">
                      <label>Fares</label>

                      <select id="inrelFares" name="inrelFares" class="form-control">
                                            <option value="">Select Fares</option>
                                                    <option value="refundable">Refundable</option>
                                                    <option value="non-refundable">Non-Refundable</option>
                                       </select>



                    </div>
                  </div>

                </div>

                <div class="row">
                  <div class="col-md-4">
                  <div class="form-group">
                  <label>Fare Types</label>
                   <select id="inrelFareTypes" name="inrelFareTypes" class="form-control">
                                       <option value="">Select Fare Types</option>
                                                <option value="corporate">Corporate</option>
                                                <option value="retail">Retail</option>
                                       </select>
                  </div>
                  </div>
                  <div class="col-md-4">
                  <div class="form-group">
                  <label>Alternate Departure Airports</label>
                  <select id="inrelAltDepartureAirports" name="inrelAltDepartureAirports" class="form-control">
                                       <option value="">Select</option>
                                                <option value="yes">Yes</option>
                                                <option value="no">No</option>
                                       </select>
                  </div>
                  </div>
                                        <div class="col-md-4">
                  <div class="form-group">
                      <label>Alternate Arrival Airports</label>


            <select id="inrelAltArrivalAirports" name="inrelAltArrivalAirports" class="form-control">
                                       <option value="">Select</option>
                                                <option value="yes">Yes</option>
                                                <option value="no">No</option>
                                       </select>



                    </div>
                  </div>


                </div>
                <div class="row">
                <div class="col-md-4">
                  <div class="form-group">
                      <label>Tickets <a data-toggle="tooltip" data-placement="top" title="You can break or combine the Tickets"><i class="fa fa-info-circle"></i></a></label>
                      <select id="inrelTicket" name="inrelTicket" class="form-control">
                                       <option value="">Select Ticket Types</option>
                                                <option value="break">Break</option>
                                                <option value="combine">Combine</option>
                                       </select>


                    </div>
                  </div>
                    
                     <div class="col-md-4">
                      <div class="form-group">
                          <label >Allow Retail Fare / Non-Ref Fare 
                          
                          
                          <a data-toggle="tooltip" data-placement="top" title="Enter Fare Difference to Allow Retail Fare / Non-Ref Fare"><i class="fa fa-info-circle"></i></a></label>
                          
                          <input id="inrelFareDifference" name="inrelFareDifference" placeholder="Fare Difference"
                                                            type="text" class="form-control ">
                          


                        </div>
                        
                  </div>

                </div>

                            </fieldset>

                            <h1>International</h1>
                            <fieldset>

                                 <h2>International Config Information</h2>
                                <div class="row">
                <div class="col-md-2">
                  <div class="form-group">
                      <label>Price Flexibility</label>
                      <input id="intlPriceRange" name="intlPriceRange"
                        type="text" class="form-control ">
                    </div>
                  </div>
                                    
                <div class="col-md-2">
                  <div class="form-group">
                      <label>Currency</label>
                      
                      
                      <select name="intlcurrency" id="intlcurrency" class="form-control" >
                                                   <option value="">Please select </option>
                                                   <option value="INR">INR</option>
                                                    <option value="USD">USD</option>
                                                   <option value="GBP">GBP</option>
                                                    <option value="EUR">EUR</option>
                                                    <option value="AED">AED</option>
                          
                                                  
                    </select>
                      
                      
                      <!--<input id="priceRange" name="priceRange"
                        type="text" class="form-control ">-->
                    </div>
                  </div>                       
                  <div class="col-md-2">
                  <div class="form-group">
                  <label>Time Flexibility</label>
                       <select name="intlTimeFlexibility" id="intlTimeFlexibility" class="form-control ">
                              <option selected value="0">Departure</option>
                              <option value="1">Arrival</option>
                          
                          </select>
                      
                 <!-- <input id="intlDepartureTime" name="intlDepartureTime"
                        type="text"  class="form-control" value="4">-->
                  </div>
                  </div>

                                     <div id="intlDepartureDiv" class="col-md-2" style="display:block">
                  <div class="form-group">
                  <label>Departure Time</label>

                                       <input id="intlDepartureTime" name="intlDepartureTime"
                        type="number" class="form-control " value="2">

                  </div>
                  </div>



                  <div id="intlArrivalDiv" class="col-md-2" style="display:none">
                  <div class="form-group">
                  <label>Arrival Time</label>

                                            <input id="intlArrivalTime" name="intlArrivalTime"
                        type="number" class="form-control" value="2">
                  </div>
                  </div> 


                  <!--<div class="col-md-4">
                  <div class="form-group">
                  <label>Arrival Time</label>
                  <input id="intlArrivalTime" name="intlArrivalTime"
                        type="text" class="form-control " value="4">
                  </div>
                  </div>-->
                    <div class="col-md-4">
                  <div class="form-group">
                  <label>Stops</label>
                  <input id="intlStops" name="intlStops"
                        type="text" class="form-control " value="1">
                  </div>
                  </div>                
                                    
                                    
                </div>


                <div class="row">

                <!--<div class="col-md-4">
                  <div class="form-group">
                  <label>Stops</label>
                  <input id="intlStops" name="intlStops"
                        type="text" class="form-control " value="1">
                  </div>
                  </div>-->
                    
                    
                     <div class="col-md-3">
                  <div class="form-group">
                      <label>Airline Inclusion</label>

                                            <select id="inrelAirlineInclusion" name="inrelAirlineInclusion" data-placeholder="Choose an Airline" class="chosen-select" multiple style="width:350px;" tabindex="4">
                                                <option value="">Select</option>
                                                <option value="JetAirways">JetAirways</option>
                                                <option value="Indigo">Indigo</option>
                                                <option value="Vistara">Vistara</option>
                                                <option value="SpiceJet">SpiceJet</option>
                                                <option value="Air Asia">Air Asia</option>
                                                <option value="Air India">Air India</option>
                                        </select>


                    </div>
                  </div>
                    
                    <div class="col-md-3">
                  <div class="form-group">
                      <label>Airline Exclusion</label>

                                            <select id="inrelAirlineExclusion" name="inrelAirlineExclusion" data-placeholder="Choose an Airline" class="chosen-select" multiple style="width:350px;" tabindex="4">
                                                <option value="">Select</option>
                                                <option value="JetAirways">JetAirways</option>
                                                <option value="Indigo">Indigo</option>
                                                <option value="Vistara">Vistara</option>
                                                <option value="SpiceJet">SpiceJet</option>
                                                <option value="Air Asia">Air Asia</option>
                                                <option value="Air India">Air India</option>
                                        </select>


                    </div>
                  </div>


                <div class="col-md-3">
                  <div class="form-group">
                      <label>Preferred Airline</label>


                                            <select id="intlPreferredAirline" name="intlPreferredAirline" data-placeholder="Choose an Airline" class="chosen-select" multiple style="width:350px;" tabindex="4">
                                                <option value="">Select</option>
                                                <option value="JetAirways">JetAirways</option>
                                                <option value="Indigo">Indigo</option>
                                                <option value="Vistara">Vistara</option>
                                                <option value="SpiceJet">SpiceJet</option>
                                                <option value="Air Asia">Air Asia</option>
                                                <option value="Air India">Air India</option>
                                        </select>

                    </div>
                  </div>

                  <div class="col-md-3">
                  <div class="form-group">
                      <label>Non-Preferred Airline</label>



                                        <select id="intlNonPreferredAirline" name="intlNonPreferredAirline" data-placeholder="Choose an Airline" class="chosen-select" multiple style="width:350px;" tabindex="4">
                                                <option value="">Select</option>
                                                <option value="JetAirways">JetAirways</option>
                                                <option value="Indigo">Indigo</option>
                                                <option value="Vistara">Vistara</option>
                                                <option value="SpiceJet">SpiceJet</option>
                                                <option value="Air Asia">Air Asia</option>
                                                <option value="Air India">Air India</option>
                                        </select>


                    </div>
                  </div>


                </div>

                <div class="row">


                <div class="col-md-4">
                          <div class="form-group">
                                                <label>Travel Time</label>
                                                <input id="intlTravelTime" name="intlTravelTime"
                                                            type="text" class="form-control ">
                       </div>
                </div>


                  <div class="col-md-4">
                  <div class="form-group">
                  <label>Transit Time</label>
                  <input id="intlLayoverDuration" name="intlLayoverDuration"
                        type="text" class="form-control ">
                  </div>
                  </div>

                                        <div class="col-md-4">
                  <div class="form-group">
                      <label>Fares</label>

                      <select id="intlFares" name="intlFares" class="form-control">
                                            <option value="">Select Fares</option>
                                                    <option value="refundable">Refundable</option>
                                                    <option value="non-refundable">Non-Refundable</option>
                                       </select>



                    </div>
                  </div>

                </div>

                <div class="row">
                  <div class="col-md-4">
                  <div class="form-group">
                  <label>Fare Types</label>
                   <select id="intlFareTypes" name="intlFareTypes" class="form-control">
                                       <option value="">Select Fare Types</option>
                                                <option value="corporate">Corporate</option>
                                                <option value="retail">Retail</option>
                                       </select>
                  </div>
                  </div>
                  <div class="col-md-4">
                  <div class="form-group">
                  <label>Alternate Departure Airports</label>
                   <select id="intlAltDepartureAirports" name="intlAltDepartureAirports" class="form-control">
                                       <option value="">Select</option>
                                                <option value="yes">Yes</option>
                                                <option value="no">No</option>
                                       </select>

                  </div>
                  </div>
                                        <div class="col-md-4">
                  <div class="form-group">
                      <label>Alternate Arrival Airports</label>
                      <select id="intlAltArrivalAirports" name="intlAltArrivalAirports" class="form-control">
                                        <option value="">Select</option>
                                                <option value="yes">Yes</option>
                                                <option value="no">No</option>
                                       </select>
                    </div>
                  </div>


                </div>
                <div class="row">
                <div class="col-md-4">
                  <div class="form-group">
                      <label>Tickets <a data-toggle="tooltip" data-placement="top" title="You can break or combine the Tickets"><i class="fa fa-info-circle"></i></a></label>
                      <select id="intlTicket" name="intlTicket" class="form-control">
                                       <option value="">Select Ticket Types</option>
                                                <option value="break">Break</option>
                                                <option value="combine">Combine</option>
                                       </select>


                    </div>
                  </div>
                    
                     <div class="col-md-4">
                      <div class="form-group">
                          <label >Allow Retail Fare / Non-Ref Fare 
                          
                          
                          <a data-toggle="tooltip" data-placement="top" title="Enter Fare Difference to Allow Retail Fare / Non-Ref Fare"><i class="fa fa-info-circle"></i></a></label>
                          
                          <input id="intlFareDifference" name="intlFareDifference" placeholder="Fare Difference"
                                                            type="text" class="form-control ">
                          


                        </div>
                        
                  </div>
                    
                    <div class="col-md-4">
                      <div class="form-group">
                          <label >Port Of Entry 
                          
                          
                          </label>
                          
                          <input id="intlCountry" name="intlCountry" 
                                                            type="text" class="form-control ">
                          


                        </div>
                        
                  </div>

                </div>
                            </fieldset>

                            <h1>Finish</h1>
                            <fieldset>
                                <h2>Terms and Conditions</h2>
                                <input id="acceptTerms" name="acceptTerms" type="checkbox" class=""> <label for="acceptTerms">I agree with the Terms and Conditions.</label>
                            </fieldset>
                        </form>
            </div>




            <?php include('footer.php'); ?>
        </div>
    </div>



    <!-- Mainly scripts -->
    <script src="js/jquery-3.1.1.min.js"></script>
    <script src="js/bootstrap.min.js"></script>
    <script src="js/plugins/metisMenu/jquery.metisMenu.js"></script>
    <script src="js/plugins/slimscroll/jquery.slimscroll.min.js"></script>
    <script src="js/plugins/clockpicker/clockpicker.js"></script>

    <script src="js/plugins/validate/jquery.validate.min.js"></script>
  <script src="js/plugins/steps/jquery.steps.min.js"></script>




    <!-- Custom and plugin javascript -->
    <script src="js/inspinia.js"></script>
    <script src="js/plugins/pace/pace.min.js"></script>

    <!-- Flot -->
    <script src="js/plugins/flot/jquery.flot.js"></script>
    <script src="js/plugins/flot/jquery.flot.tooltip.min.js"></script>
    <script src="js/plugins/flot/jquery.flot.resize.js"></script>

    <!-- Peity -->
    <script src="js/plugins/peity/jquery.peity.min.js"></script>
    <!-- Peity demo -->
    <script src="js/demo/peity-demo.js"></script>

    <!-- iCheck -->
    <script src="js/plugins/iCheck/icheck.min.js"></script>
     <script src="js/plugins/chosen/chosen.jquery.js"></script>


     <script>
         function populateData(){
             var priceRange =  $('#priceRange').val();
             $('#intlPriceRange').val(priceRange);
             $('#inrelPriceRange').val(priceRange);
 			/*var departureTime =  $('#departureTime').val();
             $('#intlDepartureTime').val(departureTime);
             $('#inrelDepartureTime').val(departureTime);*/
            /* var arrivalTime =  $('#arrivalTime').val();
             $('#intlArrivalTime').val(arrivalTime);
             $('#inrelArrivalTime').val(arrivalTime);*/
 			/*var stops =  $('#stops').val();
             $('#intlStops').val(stops);
             $('#inrelStops').val(stops);*/
             var preferredAirline =  $('#preferredAirline').val();
              $('#intlPreferredAirline').val(preferredAirline);
              $('#inrelPreferredAirline').val(preferredAirline);
 			var nonPreferredAirline =  $('#nonPreferredAirline').val();
             $('#intlNonPreferredAirline').val(nonPreferredAirline);
             $('#inrelNonPreferredAirline').val(nonPreferredAirline);
             var travelTime = $('#travelTime').val();
              $('#intlTravelTime').val(travelTime);
              $('#inrelTravelTime').val(travelTime);
 			var layoverDuration =  $('#layoverDuration').val();
             $('#intlLayoverDuration').val(layoverDuration);
             $('#inrelLayoverDuration').val(layoverDuration);
             var fares =  $('#fares').val();
             $('#intlFares').val(fares);
             $('#inrelFares').val(fares);
 			var fareTypes =  $('#fareTypes').val();
             $('#intlFareTypes').val(fareTypes);
             $('#inrelFareTypes').val(fareTypes);
             var altDepartureAirports =  $('#altDepartureAirports').val();
              $('#intlAltDepartureAirports').val(altDepartureAirports);
              $('#inrelAltDepartureAirports').val(altDepartureAirports);
 			var altArrivalAirports =  $('#altArrivalAirports').val();
             $('#intlAltArrivalAirports').val(altArrivalAirports);
             $('#inrelAltArrivalAirports').val(altArrivalAirports);
             var ticket =  $('#ticket').val();
              $('#intlTicket').val(ticket);
              $('#inrelTicket').val(ticket);

             var currency = $('#currency').val();
              $('#intlcurrency').val(currency);
              $('#inrelcurrency').val(currency);
             
             var airlineInclusion = $('#airlineInclusion').val();
             
              $('#inrelAirlineInclusion').val(airlineInclusion);
              $('#intlAirlineInclusion').val(airlineInclusion);
             
             var airlineExclusion = $('#airlineExclusion').val();
             $('#inrelAirlineExclusion').val(airlineExclusion);
              $('#intlAirlineExclusion').val(airlineExclusion);
             
             
             
             var fareDifference = $('#fareDifference').val();
             $('#inrelFareDifference').val(fareDifference);
             $('#intlFareDifference').val(fareDifference);

         }
         function submitDetails(){

             var domConfigDetails = {
 			"price_flexibility" : $('#priceRange').val(),
            "currency" : $('#currency').val(),    
 			"departure_time" : $('#departureTime').val(),
             "arrival_time" : $('#arrivalTime').val(),
 			"stops" : $('#stops').val(),
            "airline_inclusion" : $('#airlineInclusion').val(), 
            "airline_exclusion" : $('#airlineExclusion').val(),     
             "preferred_airline" : $('#preferredAirline').val(),
 			"non_preferred_airline" : $('#nonPreferredAirline').val(),
             "travel_time" : $('#travelTime').val(),
 			"transit_time" : $('#layoverDuration').val(),
             "fares" : $('#fares').val(),
 			"fare_types" : $('#fareTypes').val(),
             "alternate_departure_airports" : $('#altDepartureAirports').val(),
 			"alternate_arrival_airports" : $('#altArrivalAirports').val(),
             "ticket_breakup" : $('#ticket').val(),
            "fare_difference" :$('#fareDifference').val(),     
                 
                 

 		};
             var intlConfigDetails = {
 			"price_flexibility" : $('#intlPriceRange').val(),
            "currency" : $('#intlcurrency').val(),
 			"departure_time" : $('#intlDepartureTime').val(),
             "arrival_time" : $('#intlArrivalTime').val(),
 			"stops" : $('#intlStops').val(),
            "airline_inclusion" : $('#intlAirlineInclusion').val(), 
             "airline_exclusion" : $('#intlAirlineExclusion').val(),
             "preferred_airline" : $('#intlPreferredAirline').val(),
 			"non_preferred_airline" : $('#intlNonPreferredAirline').val(),
             "travel_time" : $('#intlTravelTime').val(),
 			"transit_time" : $('#intlLayoverDuration').val(),
             "fares" : $('#intlFares').val(),
 			"fare_types" : $('#intlFareTypes').val(),
             "alternate_departure_airports" : $('#intlAltDepartureAirports').val(),
 			"alternate_arrival_airports" : $('#intlAltArrivalAirports').val(),
             "ticket_breakup" : $('#intlTicket').val(),
              "fare_difference" :$('#intlFareDifference').val(),   
            "port_entry" :$('#intlCountry').val(),     

 		};

              var inregConfigDetails = {
 			"price_flexibility" : $('#inrelPriceRange').val(),
            "currency" : $('#inrelcurrency').val(),
 			"departure_time" : $('#inrelDepartureTime').val(),
             "arrival_time" : $('#inrelArrivalTime').val(),
 			"stops" : $('#inrelStops').val(),
                "airline_inclusion" : $('#inrelAirlineInclusion').val(),
                  "airline_exclusion" : $('#inrelAirlineExclusion').val(),
             "preferred_airline" : $('#inrelPreferredAirline').val(),
 			"non_preferred_airline" : $('#inrelNonPreferredAirline').val(),
             "travel_time" : $('#inrelTravelTime').val(),
 			"transit_time" : $('#inrelLayoverDuration').val(),
             "fares" : $('#inrelFares').val(),
 			"fare_types" : $('#inrelFareTypes').val(),
             "alternate_departure_airports" : $('#inrelAltDepartureAirports').val(),
 			"alternate_arrival_airports" : $('#inrelAltArrivalAirports').val(),
             "ticket_breakup" : $('#inrelTicket').val(),
             "fare_difference" :$('#inrelFareDifference').val(),        

 		};

             var formData = {
                 "Domestic" : domConfigDetails,
 			    "International" : intlConfigDetails,
                 "InterRegional" : inregConfigDetails

 			};
             console.log("formData :: ::::: "+JSON.stringify(formData));
             var pdata = JSON.stringify(formData);
             var url = 'insert_data.php';
             $.ajax({
             type: "post",
             url: url,
             data: {
                 data: pdata
                 },
             success: function(data) {
                 alert('Data successfully inserted');
             }
             });
         }





         $(document).ready(function(){
             $("#wizard").steps();
              $('[data-toggle="tooltip"]').tooltip();  
             
             
             $("#timeFlexibility").change(function(){
                 
                 var timeFlex =  $('#timeFlexibility').val();
                  
                 if(timeFlex==1){
                      $('#departureDiv').hide();
                      $('#arrivalDiv').show(); 
                 }else{
                      $('#arrivalDiv').hide(); 
                      $('#departureDiv').show();
               
                 }
                 
               
                 
            });
             $("#intraTimeFlexibility").change(function(){
                 
                 var timeFlex =  $('#intraTimeFlexibility').val();
                  
                 if(timeFlex==1){
                      $('#intradepartureDiv').hide();
                      $('#intraarrivalDiv').show(); 
                 }else{
                      $('#intraarrivalDiv').hide(); 
                      $('#intradepartureDiv').show();
               
                 }
                 
               
                 
            });
             
              $("#intlTimeFlexibility").change(function(){
                 
                 var timeFlex =  $('#intlTimeFlexibility').val();
                console.log("timeFlexibility LL :::: "+timeFlex);  
                  
                 if(timeFlex==1){
                      $('#intlDepartureDiv').hide();
                      $('#intlArrivalDiv').show(); 
                 }else{
                      $('#intlArrivalDiv').hide(); 
                      $('#intlDepartureDiv').show();
               
                 }
                 
               
                 
            });
             
             
             
         });

         $("#form").steps({
                 bodyTag: "fieldset",
                 onStepChanging: function (event, currentIndex, newIndex)
                 {
                     if(currentIndex ===0 &&  newIndex ===1){
                         populateData();
                     }
                     // Always allow going backward even if the current step contains invalid fields!
                     if (currentIndex > newIndex)
                     {
                         return true;
                     }

                     // Forbid suppressing "Warning" step if the user is to young
                     if (newIndex === 3 && Number($("#age").val()) < 18)
                     {
                         return false;
                     }

                     var form = $(this);

                     // Clean up if user went backward before
                     if (currentIndex < newIndex)
                     {
                         // To remove error styles
                         $(".body:eq(" + newIndex + ") label.error", form).remove();
                         $(".body:eq(" + newIndex + ") .error", form).removeClass("error");
                     }

                     // Disable validation on fields that are disabled or hidden.
                     form.validate().settings.ignore = ":disabled,:hidden";

                     // Start validation; Prevent going forward if false
                     return form.valid();
                 },
                 onStepChanged: function (event, currentIndex, priorIndex)
                 {  console.log("inside steps Changed");
                     // Suppress (skip) "Warning" step if the user is old enough.
                     if (currentIndex === 2 && Number($("#age").val()) >= 18)
                     {
                         $(this).steps("next");
                         console.log("dasdsdsadas");

                     }

                     // Suppress (skip) "Warning" step if the user is old enough and wants to the previous step.
                     if (currentIndex === 2 && priorIndex === 3)
                     {
                         $(this).steps("previous");
                          console.log("111111");
                     }


                 },
                 onFinishing: function (event, currentIndex)
                 {
                     var form = $(this);

                     // Disable validation on fields that are disabled.
                     // At this point it's recommended to do an overall check (mean ignoring only disabled fields)

                     form.validate().settings.ignore = ":disabled";
                     console.log("inside finishing");
                     // Start validation; Prevent form submission if false
                     return form.valid();
                 },
                 onFinished: function (event, currentIndex)
                 {

                     var form = $(this);
                     console.log("inside finished");
                     // Submit form input
                     submitDetails();
                 }
             }).validate({
                         errorPlacement: function (error, element)
                         {
                             element.before(error);
                         },
                         rules: {
                             confirm: {
                                 equalTo: "#password"
                             }
                         }
                     });

         $('.chosen-select').chosen({width: "100%"});
         $('.clockpicker1').clockpicker();
     </script>
</body>

</html>
