    
<!DOCTYPE html>
<html>

<head>

    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="shortcut icon" href="images/tsplogo2.png">
    <title>Tripnomics | Dashboard</title>

    <link href="css/bootstrap.min.css" rel="stylesheet">
    <link href="font-awesome/css/font-awesome.css" rel="stylesheet">
    <link href="css/animate.css" rel="stylesheet">
    <link href="css/style.css" rel="stylesheet">
    <link href="css/dx.common.css" rel="stylesheet">

    <link rel="dx-theme" data-theme="generic.light" href="css/dx.light.css" />
</head>

<body class="top-navigation md-skin">
    <div id="tooltip" class="tooltip-hide">
    <p><span id="content"></span></p>
    </div>  
    <div id="wrapper">
        <div id="page-wrapper" class="gray-bg">
            <div class="row border-bottom white-bg" id="navbar_container">
            </div>
            <div class="sidebard-panel">
                <div id="insights_divid">
                    <h5>Top Insights<span class="pull-right"><i class="fa fa-bar-chart" aria-hidden="true"></i></span></h5>
                    <div class="feed-element">
                        <i class="fa  fa-archive pull-left" aria-hidden="true" style="font-size: 2em;margin-top: 5px;"></i>
                        <div class="media-body">
                            <h5 class="m-b-xs">Audit Delivered Overall Savings of <span id="audit-deliver-saving"></span></h5>
                        </div>
                    </div>
                    <div class="feed-element">
                        <h5 class="m-b-xs">Sector with Higher <br>Non-Compliance</h5>
                        <i class="fa  fa-balance-scale pull-left" aria-hidden="true" style="font-size: 2em;"></i>
                        <div class="media-body">
                            <h5 class="m-b-xs" id="top-nc-sector"></h5>
                        </div>
                    </div>
                      <div class="feed-element">
                        <h5 class="m-b-xs">Combination of Non Compliance</h5>
                        <i class="fa fa-percent pull-left" aria-hidden="true" style="font-size: 2.5em;"></i>
                        <div class="media-body">
                            <div class="font-bold text-navy">Domestic <span id="nc-perdom"></span></div>
                            <div class="font-bold text-blue">International <span id="nc-perint"></span></div>
                        </div>
                    </div>
                    <div class="feed-element">
                        <h5 class="m-b-xs">Savings</h5>
                        <i class="fa fa-inr pull-left" aria-hidden="true" style="font-size: 2.5em;"></i>
                        <div class="media-body">
                            <div class="font-bold text-navy">Domestic <span id="total-savings-dom"></span></div>
                            <div class="font-bold text-blue">International <span id="total-savings-int"></span></div>
                        </div>
                    </div>
                    <div class="feed-element">
                        <h5 class="m-b-xs">Combination of Savings</h5>
                        <i class="fa fa-percent pull-left" aria-hidden="true" style="font-size: 2.5em;"></i>
                        <div class="media-body">
                            <div class="font-bold text-navy">Domestic <span id="total-savingper-dom"></span></div>
                            <div class="font-bold text-blue">International <span id="total-savingper-int"></span></div>
                        </div>
                    </div>
                    <div class="feed-element">
                        <h5 class="m-b-xs">Corporate Fares</h5>
                        <i class="fa fa-suitcase pull-left" aria-hidden="true" style="font-size: 2.5em;"></i>
                        <div class="media-body">
                            <div class="font-bold text-navy">Domestic <span id="corporate-fare-dom"></span></div>
                            <div class="font-bold text-blue">International <span id="corporate-fare-int"></span></div>
                        </div>
                    </div>
              <!--       <div class="feed-element">
                        <h5 class="m-b-xs">Average Adv Purchase</h5>
                        <i class="fa fa-calendar pull-left" aria-hidden="true" style="font-size: 2.5em;"></i>
                        <div class="media-body">
                            <div class="font-bold text-navy">Domestic <span id="avg-adv-pur-dom"></span></div>
                            <div class="font-bold text-blue">International <span id="avg-adv-pur-int"></span></div>
                        </div>
                    </div> -->
                    <!-- div class="feed-element">
                        <a href="https://demo.tripnomics.com/beta/pnr_flow_n.html"> <h5 class="m-b-xs">View Details <i class="fa fa-3xs fa-eye pull-left" aria-hidden="true"></i></h5></a>
                    </div> -->
                </div>
            </div>
            <div class="wrapper wrapper-content" style="width: 86%">
                <div class="row filterRow">
                    <div class="pull-left" style="margin-left: 14px;">
                        <div class="btn-group">
                            <button type="button" id="PNR" value="Pnr" class="btn btn-xs btn-white">PNR</button>
                            <button type="button" id="Ticket" value="Ticket" class="btn btn-xs btn-white active dataLoad">Ticket</button>
                        </div>
                    </div>
                    <div class="pull-right">
                        <div class="btn-group">
                            <button type="button" id="today" value="today" class="btn btn-xs btn-white">Today</button>
                            <button type="button" id="weekly" value="weekly" class="btn btn-xs btn-white">Weekly</button>
                            <button type="button" id="monthly" value="monthly" class="btn btn-xs btn-white  active selectedPeriod">Monthly</button>
                        </div>
                    </div> 
                </div>
                <div class="row" id="metric-chart-row-div">
                    <div class="col-lg-6">
                          <div class="ibox float-e-margins">
                            <div class="ibox-title">
                                <h5 class="metricTitle"><b>Domestic</b></h5>
                                <div class="ibox-content">
                                    <div id="metriceDom"></div>
                                </div>
                                <div id="metricDomLegend" class="metricLegend"></div>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-6">
                        <div class="ibox float-e-margins">
                            <div class="ibox-title">
                                <h5 class="metricTitle"><b>International</b></h5>
                                <div class="ibox-content">
                                     <div id="metricInt" ></div>
                                </div>
                                <div id="metricIntLegend" class="metricLegend"></div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row" id='non-compliance-div'>
                    <div class="col-lg-12">
                        <div class="ibox float-e-margins">
                            <div class="ibox-title">
                                <h5><b>Non Compliance</b></h5>
                            </div>
                            <div class="ibox-content">
                                <div id="nc-tabs">
                                    <div class="nc-tabs-container"></div>
                                    <div class="content  dx-fieldset">
                                        <div id="airline-tab">
                                            <div class="chart">
                                                    <div class="domestic">
                                                        <span class="ibox-title">
                                                                <h5><b>Domestic</b> <span class="badge badge-info">Based on Savings Share</span></h5>
                                                        </span>
                                                        <div class="dom-container" id="dom-airline" style="margin: auto;width: 300px;">
                                                            
                                                        </div>
                                                    </div>
                                                    <div class="international">
                                                        <span class="ibox-title">
                                                                <h5><b>International</b><span class="badge badge-info">Based on Savings Share</span></h5>
                                                        </span>
                                                        <div class="int-container" id="int-airline" style="margin: auto;width: 300px;">
                                                            
                                                        </div>
                                                    </div>
                                            </div>
                                        </div>
                                        <div id="sector-tab" style="display: none;">
                                             <div class="chart">
                                                    <div class="domestic">
                                                        <span class="ibox-title">
                                                                <h5><b>Domestic</b><span class="badge badge-info">Based on Savings Share</span></h5>
                                                        </span>
                                                        <div class="dom-container" id="dom-sector" style="margin: auto;">
                                                            
                                                        </div>
                                                    </div>
                                                    <div class="international">
                                                        <span class="ibox-title">
                                                                <h5><b>International</b><span class="badge badge-info">Based on Savings Share</span></h5>
                                                        </span>
                                                        <div class="int-container" id="int-sector" style="margin: auto;">
                                                            
                                                        </div>
                                                    </div>
                                            </div>
                                        </div>
                                        <div id="reason-code-tab" style="display: none;">
                                            <div class="chart">
                                                    <div class="domestic">
                                                        <span class="ibox-title">
                                                                <h5><b>Domestic</b><span class="badge badge-info">Based on Non Compliance Transaction</span></h5>
                                                        </span>
                                                        <div class="dom-container" id="dom-reason" style="width: 300px;margin:auto;">
                                                            
                                                        </div>
                                                    </div>
                                                    <div class="international">
                                                        <span class="ibox-title">
                                                                <h5><b>International</b><span class="badge badge-info">Based on Non Compliance Transaction</span></h5>
                                                        </span>
                                                        <div class="int-container" id="int-reason" style="width: 300px;margin:auto;">
                                                            
                                                        </div>
                                                    </div>
                                            </div> 
                                        </div>
                                        <div id="failure-code-tab" style="display: none;">
                                            <div class="chart">
                                              <!--   <div class="domestic">
                                                    <span class="ibox-title">
                                                            <h5><b>Domestic</b></h5>
                                                    </span>
                                                    <div class="dom-container" id="dom-failure" style="width: 100%;display: table;">
                                                     
                                                        <div id="jet-dom" style="display: table-cell;">
                                                            
                                                        </div>
                                                    </div>
                                                </div> -->
                                                <div class="international">
                                                        <span class="ibox-title">
                                                                <h5><b></b><span class="badge badge-info">Based on Non Compliance Transaction</span></h5>
                                                        </span>
                                                        <div class="int-container" id="failure-stack-chart" style="width: 487px;position: relative;left: 20%">
                                                            
                                                        </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="footer" id="footer"></div>
    
     <!-- Third Party scripts-->
    <script src="js/jquery-3.1.1.min.js"></script>
    <script src="dist/aws-cognito-sdk.js"></script>
    <script src="dist/amazon-cognito-identity.js"></script>
    <script src="aws_auth.js"></script>
    <script src="js/bootstrap.min.js"></script>
    <script src="js/d3.v4.min.js"></script>
    <script src="js/plugins/datapicker/bootstrap-datepicker.js"></script>
    <script src="js/screener/pagination.js"></script>
    <script src="js/plugins/metisMenu/jquery.metisMenu.js"></script>
    <script src="js/plugins/slimscroll/jquery.slimscroll.js"></script>
    <script src="js/inspinia.js"></script>
    <script src="js/plugins/pace/pace.min.js"></script>
    <script src="js/plugins/iCheck/icheck.min.js"></script>
    <script src="js/plugins/chosen/chosen.jquery.js"></script>
    <link href="css/plugins/chosen/bootstrap-chosen.css" rel="stylesheet">
    <script src="js/plugins/hyperapp/hyperapp.min.js"></script>
      

    <script src="js/components/header.js"></script>
    <script src="js/components/footer.js"></script>
    <script src="js/dx.all.js"></script>
    <script src="utils/utils.js"></script>    
    <script src="js/components/audit_dashboard.js"></script>
    <script>
        $("#PNR").click(function() {
            var selectedPeriod = $('.selectedPeriod').val();
            getMetricCharts(selectedPeriod,'pnr');
            $('#PNR').addClass('active');
            getAirlineCharts(selectedPeriod);
            getRCCharts(selectedPeriod);
            getFCCharts(selectedPeriod);
            $('#PNR').addClass('dataLoad');
            $('#Ticket').removeClass('active');
            $('#Ticket').removeClass('dataLoad');
        });
        $("#Ticket").click(function() {
            var selectedPeriod = $('.selectedPeriod').val();
            getMetricCharts(selectedPeriod,'ticket');
            getAirlineCharts(selectedPeriod);
            getRCCharts(selectedPeriod);
            getFCCharts(selectedPeriod);
            $('#Ticket').addClass('active');
            $('#PNR').removeClass('active');
            $('#Ticket').addClass('dataLoad');
            $('#PNR').removeClass('dataLoad');
        });
        $("#today").click(function() {
            var dataLoad = $('.dataLoad').val();
            getMetricCharts('today',dataLoad);
            getAirlineCharts('today');
            getRCCharts('today');
            getFCCharts('today');
            getSectorChart('today');
            $('#today').addClass('active');
            $('#today').addClass('selectedPeriod');
            $('#monthly').removeClass('active');
            $('#annual').removeClass('active');
            $('#weekly').removeClass('active');
            $('#monthly').removeClass('selectedPeriod');
            $('#weekly').removeClass('selectedPeriod');
        });
        $("#weekly").click(function() {
            var dataLoad = $('.dataLoad').val();

            getMetricCharts('weekly',dataLoad);
            getAirlineCharts('weekly');
            getRCCharts('weekly');
            getFCCharts('weekly');
            getSectorChart('weekly');
            $('#today').removeClass('active');
            $('#monthly').removeClass('active');
            $('#annual').removeClass('active');
            $('#weekly').addClass('active');
            $('#weekly').addClass('selectedPeriod');
            $('#monthly').removeClass('selectedPeriod');
            $('#today').removeClass('selectedPeriod');
        });
        $("#monthly").click(function() {
            var dataLoad = $('.dataLoad').val();
            getMetricCharts('monthly',dataLoad);
            getAirlineCharts('monthly');
            getRCCharts('monthly');
            getFCCharts('monthly');
            getSectorChart('monthly');
            $('#today').removeClass('active');
            $('#monthly').addClass('active');
            $('#monthly').addClass('selectedPeriod');
            $('#annual').removeClass('active');
            $('#weekly').removeClass('active');
            $('#weekly').removeClass('selectedPeriod');
            $('#today').removeClass('selectedPeriod');
        });
        

        $(document).ready(function() {
            getMetricCharts('monthly','ticket');
            getAirlineCharts('monthly');
            getRCCharts('monthly');
            getFCCharts('monthly');
            getSectorChart('monthly');
        });        
    </script>    
</body>
</html>
