<?php
    session_start();
//    print_r($_SESSION);
    include('dbcon.php');
    $customer_dropdown = '<select class="chosen-select" name="Customer">';
    $customers_info = mysqli_query($con,'select distinct(Customer) Customer from PNR_Ticket_Details where Customer not in ("TATACommu-test","TATA%20Commu-test")');
    while($customers = mysqli_fetch_assoc($customers_info)){
        if($customers['Customer'] == 'BOSCH')
            $customer_dropdown .= '<option selected="selected">'.$customers['Customer'].'</option>';
        else
            $customer_dropdown .= '<option>'.$customers['Customer'].'</option>';
    }
    $customer_dropdown .= '</select>';
?>
    <!DOCTYPE html>
    <html>

    <head>

        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">

        <title>Tripnomics | Fare Drop</title>

        <link href="css/bootstrap.min.css" rel="stylesheet">
        <link href="https://fonts.googleapis.com/css?family=Lato|Roboto" rel="stylesheet">
        <link href="font-awesome/css/font-awesome.css" rel="stylesheet">
        <link href="css/plugins/iCheck/custom.css" rel="stylesheet">
        <link href="css/animate.css" rel="stylesheet">
        <link href="css/style.css" rel="stylesheet">
        <link href="css/itin.css" rel="stylesheet">
        <link href="css/user-styles.css" rel="stylesheet">
        <link rel="stylesheet" href="airline_logos/logo.css">
        <link href="css/plugins/datapicker/datepicker3.css" rel="stylesheet">
        <link href="css/plugins/awesome-bootstrap-checkbox/awesome-bootstrap-checkbox.css" rel="stylesheet">
        <link rel="stylesheet" href="https://unpkg.com/simplebar@latest/dist/simplebar.css" />
        <link href="css/summernote/summernote.css" rel="stylesheet">
        <link href="css/summernote/summernote-bs3.css" rel="stylesheet">

        <link rel="stylesheet" type="text/css" href="css/dx.common.css" />
        <link rel="stylesheet" type="text/css" href="css/dx.light.css" />
        <link href="https://fonts.googleapis.com/css?family=Comfortaa" rel="stylesheet">
        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/jquery.scrollbar/0.2.11/jquery.scrollbar.css" />

        <link href="css/plugins/chosen/chosen.css" rel="stylesheet">
        <!--
    <link rel="stylesheet" href="https://cdn3.devexpress.com/jslib/18.1.3/css/dx.spa.css">
    <link rel="stylesheet" href="https://cdn3.devexpress.com/jslib/18.1.3/css/dx.common.css">
    <link rel="stylesheet" href="https://cdn3.devexpress.com/jslib/18.1.3/css/dx.light.css">
-->

        <style>
        .date-span {
            display: inline-block;
            position: relative;
            bottom: 14px;
            padding: 11px 17px 10px 6px;
            border-left: none;
            border-right: none;
            background-color: #ddd;
        }

        #journeyStartDate,
        #journeyEndDate,
        #missedStartDate,
        #missedEndDate {
            display: inline-block;
            width: 115px !important;
            max-width: 115px;
        }

        #journeyStartDate,
        #missedStartDate {
            border-bottom-right-radius: 0;
            border-top-right-radius: 0;
            margin-right: -2px;
        }


        #journeyEndDate,
        #missedEndDate {
            border-bottom-left-radius: 0;
            border-top-left-radius: 0;
            margin-left: -3px;
        }

        #journeyStartDate>div.dx-dropdowneditor-input-wrapper>div>input,
        #journeyEndDate>div.dx-dropdowneditor-input-wrapper>div>input,
        #missedStartDate>div.dx-dropdowneditor-input-wrapper>div>input,
        #missedEndDate>div.dx-dropdowneditor-input-wrapper>div>input {
            padding-right: 0px;
        }

        .right-side {
            position: absolute;
            right: 1px;
            top: 6px;
            margin-right: 15px;
            margin-left: 71%;
        }

        h5 {
            font-size: 13px;
        }

        .itinerary {
            font-size: 11px;
        }


        .agl {
            font-size: 16px;
        }

        .labels-font {
            font-size: 12px !important;
        }

        .board1 {
            float: left;
        }

        /* .navbar-brand { background: #ffffff !important; }*/

        .cl_img {
            width: 20px;
            cursor: pointer;
            margin-bottom: 5px;
        }

        .dataTables_filter label {
            float: right;

        }

        .table-responsive {
            overflow-x: hidden;
        }

        .pagination {
            margin: 0px 0;
            float: right;
        }

        .dataTables_info {
            padding-top: 35px;
        }

        .dataTables_filter {
            margin-right: -5px;
        }

        .dx-datagrid-rowsview .dx-row.dx-group-row {
            color: black;
            background-color: #fff;
            font-weight: bold;
        }



        #currentPnr {
            height: auto;
/*            height: 440px;*/
        }

        #currentPnr .dx-datagrid-content tr.dx-data-row {
            cursor: pointer;
        }
        #lowestFareTable {
            font-size: 14px;
        }

        .modal-ku {
          width: 750px;
          margin: auto;
        }
        /* .dx-datagrid .dx-data-row>td.bullet { padding-top: 0; padding-bottom: 0; }*/

    </style>
    </head>

    <body class="top-navigation md-skin body">
        <div id="wrapper">
        <div id="page-wrapper" class="gray-bg">
            <div class="row border-bottom white-bg" id="navbar_container">
            </div>
            <div id="page_wrapper" class="wrapper wrapper-content" style="height:100% !important">
                <div class="row">
                    <div class="col-lg-12">
                        <div class="ibox float-e-margins">
                            <div class="ibox-title">

                                <h5>Filter Data</h5>
                            </div>
                            <div class="ibox-content">
                                <form id="filter">
                                <!--<div class="form-group">
                                    <h5 class="font-normal">Booking Period</h5>
                                    <div id="journeyStartDate"></div>
                                    <span class="input-group-addon date-span">to</span>

                                    <div id="journeyEndDate"></div>

                                </div>-->
                                <!--<div class="form-group">
                                    <h5 class="font-normal">Ticket Period</h5>
                                    <div id="missedStartDate"></div>
                                    <span class="input-group-addon date-span">to</span>
                                    <div id="missedEndDate"></div>

                                </div>-->
                            <div class="row">
                            <div class="col-md-12">
                                <div class="form-group col-md-3" id="data_5">
                                    <label class="font-normal">Departure</label>
                                    <div class="input-daterange input-group" id="datepicker">
                                        <input autocomplete="off" id="start" type="text" class="input-sm form-control dateSelector" name="start" value="<?php echo date('d/m/Y',time()); ?>" />
                                        <span class="input-group-addon">to</span>
                                        <input autocomplete="off" id="end" type="text" class="input-sm form-control dateSelector" name="end" value="<?php echo date('d/m/Y',time()); ?>" />
                                    </div>
                                </div>
                                
                                <div class="form-group col-md-2" id="">
                                    <label class="font-normal">GDS Type</label>
                                    <select name="GDS_Type" id="tripType" data-placeholder="Select GDS Type" class="chosen-select" style="width:350px;" tabindex="4">
                                        <option value="">All</option>
                                        <option value="1G">1G</option>
                                        <option value="1A">1A</option>
                                    </select>
                                </div>
                                <div class="form-group col-md-2" id="">
                                    <label class="font-normal">Customer</label>
                                    <?php echo $customer_dropdown; ?>
                                </div>
                                <div class="form-group col-md-2" id="">
                                    <label class="font-normal">Trip Type</label>
                                    <select name="trip_type" id="tripType" data-placeholder="Select Trip Type" class="chosen-select" style="width:350px;" tabindex="4">
                                        <option value="">All</option>
                                        <option value="Domestic">Domestic</option>
                                        <option value="International">International</option>
                                    </select>
                                </div>
<!--
                                <div class="form-group col-md-2" id="">
                                    <label class="font-normal">Alt Fare Status</label>
                                    <select name="filter_status" id="" data-placeholder="Select Trip Type" class="chosen-select" style="width:350px;" tabindex="4">
                                        <option value="">All</option>
                                        <option value="no">No</option>
                                        <option value="yes">Yes</option>
                                    </select>
                                </div>
-->
                                <div class="form-group col-md-2" id="">
                                    <label class="font-normal">PNR</label>
                                    <input type="text" name="PNR" class="form-control"/>
                                </div>
                                <div class="form-group col-md-3" id="">
                                    <label class="font-normal">Tkt Number</label>
                                    <input type="text" name="TktNumber" class="form-control"/>
                                </div>
                                <div class="form-group col-md-3">
                                    <button style="margin-top:15px;" id="genpnrdata1" class="btn btn-sm btn-primary" type="button" onclick="genpnrdata()">Submit</button>
                                </div>
                            </div>
                            </div>
<!--
                                <div class="form-group" id="">
                                    <label class="font-normal">Travel in (Days)</label>
                                    <input placeholder="1-4" type="text" name="tdays" class="form-control"/>
                                </div>
-->
<!--
                                <div class="form-group" id="">
                                    <label class="font-normal">Airlines</label>
                                    <select id="airlines" data-placeholder="Choose Airlines" class="chosen-select" multiple style="width:350px;" tabindex="4">
                                        <option value="">Select</option>
                                        <option value="6E">Indigo</option>
                                        <option value="9W">Jet Airways</option>
                                        <option value="AI">Air India</option>
                                        <option value="UK">Air Vistara</option>
                                        <option value="SG">Spicejet</option>
                                        <option value="G8">Go Air</option>
                                    </select>
                                </div>
-->
                                
<!--
                                <div class="form-group">
                                    <label class="font-normal">Search</label>


                                    <div id="ticketNo"></div>
                                </div>
-->
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-lg-12">
                        <div class="ibox float-e-margins">
                            <div class="ibox-title">
                                <h5>Low fare</h5>

                            </div>
                            <div class="ibox-content">
                                <div class="demo-container">
                                    <div id="currentPnr">
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="footer" id="footer"></div>
        </div>
    </div>
        
        <div class="modal fade" id="myMail">
                <div class="modal-dialog modal-lg" style="width:850px;">
                    <div class="modal-content">
<!--
                        <div class="modal-header">
                            <div class="mail-box-header">
                                <div class="pull-right tooltip-demo">

                                    <button type="button" data-toggle="tooltip" data-placement="top" class="btn btn-danger btn-sm" data-dismiss="modal"><i class="fa fa-times"></i>Discard</button>
                                </div>
                                <h2>
                                    Compose mail
                                </h2>
                            </div>
                        </div>
-->
                        <!-- Modal body -->
                        <div class="modal-body">
                            <div class="mail-box">
                                <div class="mail-body">
                                    <form class="form-horizontal" id="mailForm">
                                        <div class="form-group"><label class="col-sm-1 control-label">To:</label>
                                            <div class="col-sm-10"><input id="toEmail" type="email" required class="form-control" name="toEmail[]" value=""></div>
                                        </div>
                                        <div class="form-group"><label class="col-sm-1 control-label">Subject: </label>
                                            <div class="col-sm-10"><input type="text" id="subject" name="subject" class="form-control" value="Fare Drop"></div>
                                        </div>
                                    </form>
                                    
                                    <div id="emailDiv" class="mail-text" style="margin-top:20px;max-height:300px;overflow-y:scroll">
                                        <div class="table-responsive">
                                            <p style="margin-top:20px;">Kindly be informed that we have identified a lower fare as below </p><br/>
                                            <table class="table table-bordered">
                                                <thead>
                                                    <tr>
                                                        <td>PNR</td>
                                                        <td>TktNumber</td>
                                                        <td>Itinerary</td>
                                                        <td>Fare</td>
                                                        <td>Alt Itinerary</td>
                                                        <td>Alt Fare</td>
                                                        <td>Savings</td>
                                                    </tr>
                                                </thead>
                                                <tbody id="lowestFareTable">
                                                    <tr>
                                                        <td id="em_PNR"></td>
                                                        <td id="em_TktNumber"></td>
                                                        <!-- <td><span id="em_cabin"></span><span id="em_Itinerary"></span></td> -->
                                                        <td><span id="em_cabin"></span><span id="em_Itinerary"></span></td>
                                                        <td id="em_fare" align="right"></td>
                                                        <td id="em_alt_itinerary"></td>
                                                        <td id="em_alt_fare" align="right"></td>
                                                        <td id="em_savings" align="right"></td>
                                                    </tr>
                                                    <tr>
                                                        <td colspan="7">Remarks : <span id="em_remarks"></span> </td>
                                                    </tr>
                                                </tbody>
                                            </table>
                                            <p style="margin-top:20px;"> Thanks &amp; Regards</p>
                                            <?php if(isset($_SESSION)) { 
                                                echo '<p>'.$_SESSION['user_info']['name'].'</p>
                                                <p>'.$_SESSION['user_info']['email'].'</p>
                                                <p>TravelSpends</p>';
                                            }
                                        ?>
                                        </div>
                                        <div class="clearfix"></div>
                                    </div>
                                </div>
                                <div class="clearfix"></div>
                            </div>
                        </div>
                        <!-- Modal footer -->
                        <div class="modal-footer">
                            <!-- <button type="button" class="btn btn-danger" data-dismiss="modal">Close</button>-->
                            <div class="mail-body text-right tooltip-demo">
                                <a href="javascript:void(0)" id="triggerMail" onclick="triggerMail()" class="btn btn-sm btn-primary" data-toggle="tooltip" data-placement="top" title="Send"><i class="fa fa-reply"></i> Send</a>
                                <!--<a href="mailbox.html" class="btn btn-white btn-sm" data-toggle="tooltip" data-placement="top" title="Discard email"><i class="fa fa-times"></i> Discard</a>-->
                                <button type="button" id="discard" data-toggle="tooltip" data-placement="top" class="btn btn-white btn-sm" data-dismiss="modal"><i class="fa fa-times"></i>Discard</button>
                                <!--<a href="mailbox.html" class="btn btn-white btn-sm" data-toggle="tooltip" data-placement="top" title="Move to draft folder"><i class="fa fa-pencil"></i> Draft</a>-->
                            </div>
                        </div>

                    </div>
                </div>
            </div>
            
            
            <div class="modal fade" id="fareDrop" role="dialog">
                    <div class="modal-dialog modal-xl">
                      <div class="modal-content">
                        <div class="modal-header">
                          <button id="clsmodal" type="button" class="close" data-dismiss="modal">&times;</button>
                          <h3 class="modal-title">Add Fare Drop Detail</h3>
                        </div>
                        <form id="addAltFare">
                        <div class="modal-body" id="addTicketSummary">
                            <div class="row">
                                <div class="col-md-3">
                                    <div class="form-group"><label class="editFont">PNR</label>
                                        <input readonly id="PNR" name="input[PNR]" type="text" class="form-control" value="">
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="editFont">Tkt Number</label>
                                        <input readonly id="TktNumber" name="input[TktNumber]" type="text" class="form-control">
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label class="editFont">Fare</label>
                                        <input readonly id="fare" name="input[fare]" type="text" class="form-control">
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="editFont">Current Itinerary</label>
                                        <textarea readonly id="Itinerary" name="input[itinerary]" class="form-control"></textarea>
<!--                                        <input id="paxName" name="input[Pax_Name]" type="text" class="form-control" value="">-->
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="editFont">Alt Itinerary</label>
                                        <textarea id="alt_itinerary" class="form-control" name="input[alt_itinerary]"></textarea>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label class="editFont">Alt Fare</label>
                                        <input onkeyup="calsavings(this.value)" id="alt_fare" name="input[alt_fare]" type="text" class="form-control">
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label class="editFont">Savings</label>
                                        <input id="savings" name="input[savings]" type="text" class="form-control">
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="editFont">Remarks</label>
                                        <textarea id="remarks" class="form-control" name="input[remarks]"></textarea>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="modal-footer">
                          <button type="button" id="addfareclose" class="btn btn-danger" data-dismiss="modal">Cancel</button>
                          <button type="submit" id="submit_manual" class="btn btn-primary">Submit</button>
                        </div>
                        </form>
                      </div>
                    </div>
            </div>
        
        <input type="hidden" id="refpnrs" />


        <!-- Third Party scripts-->

        <script src="js/jquery-3.1.1.min.js"></script>
        <!-- Image Paste -->
        <!--    <script src="screens/jquery-2.2.3.min.js"></script>-->
        <!--    <script src="screens/bootstrap.min.js"></script>-->
        <script src="screens/mpaste.js"></script>
        <script src="screens/pasteimg.js"></script>
        <script src="screens/divpaste.js"></script>
        <script src="screens/manfare.js"></script>
        <script src="js/plugins/select2/select2.full.min.js"></script>
        <script src="js/plugins/chosen/chosen.jquery.js"></script>
        
<!--
        <script src="dist/aws-cognito-sdk.js"></script>
        <script src="dist/amazon-cognito-identity.js"></script>
        <script src="aws_auth.js"></script>
-->
        <script src="https://code.jquery.com/ui/1.10.0/jquery-ui.js"></script>
        <script src="js/bootstrap.min.js"></script>
        <script src="js/plugins/datapicker/bootstrap-datepicker.js"></script>
        <script src="js/screener/pagination.js"></script>
        <script src="js/inspinia.js"></script>
        <script src="js/plugins/pace/pace.min.js"></script>
        <script src="js/plugins/iCheck/icheck.min.js"></script>
        <link rel="stylesheet" href="https://unpkg.com/simplebar@latest/dist/simplebar.css" />
        <script src="https://unpkg.com/simplebar@latest/dist/simplebar.js"></script>

        <!--    <script src="js/components/center.js"></script>-->
        <script src="js/summernote.min.js"></script>
        <script src="js/screener/details.js"></script>
        <?php
            /*if($_SESSION['user_info']['email'] == 'demo@tripnomics.com' || $_SESSION['user_info']['email'] == 'demo@travelspends.com')
                echo '<script src="js/screener/screener_user.js?v='.time().'"></script>';
            else
                echo '<script src="js/screener/screener_user.js?v='.time().'"></script>';*/
        ?>
        <!-- dev extreme -->
        
        <script type="text/javascript" src="js/jszip.min.js"></script>
        
            <script src="https://cdn3.devexpress.com/jslib/18.1.3/js/dx.all.js"></script>
<!--            <script src="https://cdn3.devexpress.com/jslib/18.1.3/js/jszip.min.js"></script>-->
        <script type="text/javascript" src="js/dx.web.js"></script>
        <script src="https://unpkg.com/simplebar@latest/dist/simplebar.js"></script>
        <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery.scrollbar/0.2.11/jquery.scrollbar.js"></script>
        <script src="js/hyperapp/hyperapp.js"></script>

        <!--     <script src="js/screener/screener.js"></script> -->
        <script src="js/components/data.js?v=<?php echo time(); ?>"></script>
        <!--    <script src="data/pnrList.js"></script>-->

        <script src="js/jquery.countdown.min.js"></script>
        <script src="js/components/footer.js"></script>
        <script src="js/components/legends.js"></script>
<!--        <script src="js/components/pnrList.js"></script>-->
<!--        <script src="js/components/pnrDetails.js"></script>-->
<!--        <script src="js/components/itinerary.js"></script>-->
        
        <?php
//            include('include_js.php');
            if($_SESSION['user_info']['email'] == 'demo@tripnomics.com' || $_SESSION['user_info']['email'] == 'demo@travelspends.com' || $_SESSION['user_info']['email'] == 'auditdemo@travelspends.com'){
//                echo '<script src="js/screener/screener_oper_demo.js?v='.time().'</script>';
//                echo '<script src="js/components/tickets_agent.js?v='.time().'"></script>';
//                echo '<script src="js/components/tickets_demo.js?v='.time().'"></script>';
                echo '<script src="js/components/header_agent.js?v='.time().'"></script>';
            }
            else if($_SESSION['user_info']['title'] == 'Agent'){
//                echo '<script src="js/components/tickets_agent.js?v='.time().'"></script>';
                echo '<script src="js/components/header_agent.js?v='.time().'"></script>';
            }   
            else{
//                echo '<script src="js/components/tickets.js?v='.time().'"></script>';
//                echo '<script src="js/screener/report.js?v='.time().'"></script>';
                echo '<script src="js/components/header.js?v='.time().'"></script>';
            }
        ?>


        <!-- <script src="js/components/fares.js"></script> -->
<!--        <script src="js/components/alt_fare.js"></script>-->
        <!-- <script src="js/components/fare_card.js"></script> -->

        <link rel="stylesheet" href="js/ui/jquery-ui.css">
        <!--    <link rel="stylesheet" href="resources/demos/style.css">-->


        <!-- <script src="js/components/fare_card.js"></script> -->
        <script>
        $('#data_5 .input-daterange').datepicker({
//            keyboardNavigation: false,
//            forceParse: false,
            autoclose: true,
            format: "dd/mm/yyyy"
        });
        var statuses = ["All", "DEL-BOM", "BOM-AMD", "DEL-BBI"];


        var currentPnrData = '';

        $(document).ready(function() {
            var dataGrid = $("#reshoppedPnr").dxDataGrid({
                dataSource: currentPnrData,
                keyExpr: "pnr",
                selection: {
                    mode: "single"
                },
                onSelectionChanged: function(e) {
                    e.component.collapseAll(-1);
                    e.component.expandRow(e.currentSelectedRowKeys[0]);
                },
                onContentReady: function(e) {
                    if (!e.component.getSelectedRowKeys().length)
                        e.component.selectRowsByIndexes(0);
                },
                export: {
                    enabled: true
                },

                columns: [{
                        dataField: "PNR",
                        caption: "Pnr"
                    },
                    {
                        dataField: "Airline_Code",
                        caption: "Airline"
                    },
                    {
                        dataField: "Trip_Type",
                        caption: "Trip Type",
                        width:50
                    },
                    {
                        dataField: "ARC",
                        caption: "Fare Basis"
                    },
                    {
                        dataField: "bookingDate",
                        caption: "Booking Date",
                        dataType: "date"
                    }
//                    ,{
//                        dataField: "ticket_date",
//                        caption: "Ticket Date",
//                        dataType: "date"
//                    }
                    ,{
                        dataField: "tkt_amount",
                        caption: "Ticket Amount",
                        alignment: "right"
                    }
                    ,{
                        dataField: "PNR",
                        caption: "MAIL"
                    }
                    
                    //,{
//                        dataField: "lowest_observed_fares",
//                        caption: "ReIssued Fares"
//                    },
//                    {
//                        dataField: "lowest_observed_at",
//                        caption: "ReIssue Time"
//                    },

//                    {
//                        dataField: "savings",
//                        caption: "Savings",
//                        alignment: "right"
//                    }
                ],
                masterDetail: {
                    enabled: false,
                    template: function(container, options) {
                        var currentEmployeeData = options.data;
                        container.append($('<div class="row">'+
                                               '<div class="col-lg-5"><dl class="dl-horizontal">'+
                                                    '<p><b>Departure</b> : ' + currentEmployeeData.departure + '</p>'+
                                                    '<p><b>Destinations</b> : ' + currentEmployeeData.destinations + '</p></dl>'+
                                               '</div>'+
                                               '<div class="col-lg-7" id="cluster_info">'+
                                               '<dl class="dl-horizontal" > <p><b>Airport</b> :' + currentEmployeeData.airport + '</p></dl>'+
                                               '</div>'+
                                           '</div>'));
                    }
                }

            }).dxDataGrid("instance");





//            $("#start").change(function() {
//                var startDate = $(this).val();
//                var endDate = $('#trstart').val();
//                var d = new Date(startDate);
//                var edate = new Date(endDate);
//                dataGrid.filter(["booking_date", ">=", new Date(d)], 'and', ["booking_date", "<=", new Date(edate)]);
//
//            });

            $("#trstart").change(function() {
                var endDate = $(this).val();
                var startDate = $('#start').val();
                var sDate = new Date(startDate);
                var d = new Date(endDate);
                // dataGrid.filter(["booking_date", "<", new Date(d)]);
                dataGrid.filter(["booking_date", ">=", new Date(sDate)], 'and', ["booking_date", "<=", new Date(d)]);
            });



            $("#ticketStartDate").change(function() {
                var startDate = $(this).val();
                var endDate = $('#ticketEndDate').val();
                var d = new Date(startDate);
                var eDate = new Date(endDate);
                // dataGrid.filter(["ticket_date", ">=", new Date(d)]);
                dataGrid.filter(["ticket_date", ">=", new Date(d)], 'and', ["ticket_date", "<=", new Date(eDate)]);
            });

            $("#ticketEndDate").change(function() {
                var startDate = $('#ticketStartDate').val();
                var endDate = $(this).val();
                var sDate = new Date(startDate);
                var d = new Date(endDate);
                //dataGrid.filter(["ticket_date", "<", new Date(d)]);
                dataGrid.filter(["ticket_date", ">=", new Date(sDate)], 'and', ["ticket_date", "<=", new Date(d)]);

            });




            $('.chosen-select').chosen({
                width: "100%"
            });





            $("#tripType").chosen({

                disable_search_threshold: 10

            }).change(function(event) {

                if (event.target == this) {
                    var airlineCodes = $(this).val();
                    var sb = [];
                    $.each(airlineCodes, function(i, l) {
                        if (i == 0) {
                            sb.push(["trip_type", "contains", airlineCodes[i]]);
                            dataGrid.filter(sb);
                        } else {
                            sb.push("or");
                            sb.push(["trip_type", "contains", airlineCodes[i]])
                            dataGrid.filter(sb);
                        }
                    });


                    if ($(this).val() == "") {
                        dataGrid.clearFilter();
                    } else {

                        //dataGrid.filter(["airline", "contains", airlineCodes[0]]);
                    }


                }

            });


            $("#airlines").chosen({

                disable_search_threshold: 10

            }).change(function(event) {

            });



            $("#pnr").dxTextBox({
                showClearButton: true,
                placeholder: "Search for Destinations",
                valueChangeEvent: "keyup",
                onValueChanged: function(data) {

                    if (data.value == "")
                        dataGrid.clearFilter();
                    else
                        dataGrid.filter(["destinations", "contains", data.value]);

                }
            });




            $("#ticketNo").dxTextBox({
                showClearButton: true,
                placeholder: "Search for Fare Basis",
                valueChangeEvent: "keyup",
                onValueChanged: function(data) {


                    if (data.value == "")
                        dataGrid.clearFilter();
                    else
                        dataGrid.filter(["fare_basis", "contains", data.value]);

                }
            });
            genpnrdata();
        });

        function populateCurrentData(currentData) {
            var deleteButton = $("#gridDeleteSelected").dxButton({
                text: "Contact TMC",
                height: 34,
                width: 195,
                disabled: true,
                onClick: function() {
                    $("#myModal").modal();
                    // var totalincome = parseInt(primaryincome) + parseInt(otherincome);

                    var data = currentPnrGrid.getSelectedRowsData();
                    var tableData = '';
                    var totalAmt = 0;
                    var totalSaving = 0;
                    if (data.length > 0) {
                        $.map(data, function(value) {
                            tableData += '<tr><td>'+value.PNR+'</td></tr>'
//                            tableData += '<tr><td>' + value.pnr + '</td><td>' + value.fare_basis + '</td><td>' + value.tkt_amount + '</td><td>' + value.lowest_observed_at + '</td><td>' + value.lowest_observed_fares + '</td><td>0.00</td></tr>'
//                            totalAmt = parseInt(totalAmt) + parseInt(value.tkt_amount);
//                            totalSaving = parseInt(totalSaving) + parseInt(value.lowest_observed_fares);
                        });
                    }
                    $('#myModal .modal-body tbody#lowestFareTable').html(tableData);
//                    var saving = 0;
//                    saving = parseInt(totalSaving) - parseInt(totalAmt);
//                    $('#totalticketAmount').html(totalAmt + ' INR');
//                    if (saving < 0)
//                        $('#totalSavings').html(0.0);
//                    else
//                        $('#totalSavings').html(saving + ' INR');

                    currentPnrGrid.refresh();
                }
            }).dxButton("instance");

            console.log("inside currentPnrData " + currentData);
            
            var currentPnrGrid = $("#currentPnr").dxDataGrid({
                dataSource: currentData,
                keyExpr: "PNRs",
                paging: {
                    pageSize: 5
                },
              pager: {
                showPageSizeSelector: true,
                showInfo: true,
                allowedPageSizes: [10, 25, 50, 100,200]

              },
                selection: {
                    mode: "single"
//                    mode: "multiple"
                },
                onSelectionChanged: function(e) {
                    var allSelectedRowsData = e.selectedRowsData;
                    var emAry = allSelectedRowsData[0].PNRs.split('_');
                    $('#subject').val('Fare drop : '+emAry[0]);
                    e.component.collapseAll(-1);
                    e.component.expandRow(e.currentSelectedRowKeys[0]);
                    deleteButton.option("disabled", !e.selectedRowsData.length);
//                    alert();
                },
                /*onContentReady: function(e) { if (!e.component.getSelectedRowKeys().length) e.component.selectRowsByIndexes(0); },*/

                columns: [{
                        dataField: "PNR",
                        caption: "PNR",
                        width: 70
                    },{
                        dataField: "PNRs",
                        caption: "Tkt Number",
                        width: 140,
                        cellTemplate: function (container, options) {
                        var splitary = options.value.split('_');
//                          htmldata = '<span class="width-120 label label-primary pull-left" title="Compliant" data-toggle="tooltip" data-placement="right">C</span>';
                        $('<div>')
                          .html(splitary[1])
                          .appendTo(container);
                      }
                    },
                    {
                        dataField: "TripType",
                        caption: "Trip Type",
                        width: 50
                    },
                    {
                        dataField: "Itinerary",
                        caption: "Itinerary",
                        cellTemplate: function(element, info) {
                            element.append("<div>"+info.value+"</div>");
                        }
                    },
                    {
                        dataField: "Dep_Date",
                        caption: "Travel Date",
                        width: 110
                    },
                    {
                        dataField: "diffdays",
                        caption: "Days",
                        width: 50
                    },
                    {
                        dataField: "BIC",
                        caption: "Fare Class",
                        width:50,
                        cellTemplate: function(element, info) {
                            if(info.data.lower == 1)
                                element.append("<div style='font-weight:bold;color:orange'>"+info.value+"</div>");
                            else
                                element.append("<div>"+info.value+"</div>");
                        }
                    },
//                    {
//                        dataField: "BIC",
//                        caption: "Fare Class",
//                        width: 100
//                    },
                    {
                        dataField: "CabinClass",
                        caption: "Cabin Class",
                        width: 100
                    },
                    {
                        dataField: "Tot_Amt",
                        caption: "Ticket Amt",
                        alignment: "right",
                        width: 90
                    },
                    {
                        dataField: "Customer",
                        caption: "Customer",
                        width: 90
                    },
                    {
                        dataField: "filter_status",
                        caption: "FD Status",
                        width: 90
                    },
                     {
                        dataField: "PNR",
                        caption: "Action",
                        width: 90,
                        cellTemplate: function(element, info) {
                            element.append("<div>Detail</div>");
                        }
                    },
                          
//                    ,
//                    {
//                        dataField: "lowest_observed_fares",
//                        caption: "Lowest Observed Fares",
//                        alignment: "right"
//                    },
//                    {
//                        dataField: "lowest_observed_at",
//                        caption: "Lowest Obsered Time"
//                    },
//
//                    {
//                        dataField: "savings",
//                        caption: "Savings",
//                        alignment: "right"
//                    }
                ]
//                ,masterDetail: {
//                    enabled: false,
//                    template: function(container, options) {
//                        var currentEmployeeData = options.data;
//                        container.append($('<div class="row"><div class="col-lg-5"><dl class="dl-horizontal"><p><b>Departures</b> : ' + currentEmployeeData.departure + '</p> <p><b>Destinations</b> : ' + currentEmployeeData.destinations + ' </p></dl></div><div class="col-lg-7" id="cluster_info"><dl class="dl-horizontal" > <p><b>Airport</b> :' + currentEmployeeData.airport + '</p></dl></div></div>'));
//                    }
//                },
                ,masterDetail: {
                    enabled: false,
                    template: function(container, options) {
                        var currentEmployeeData = options.data;
                        if(currentEmployeeData.fd_itinerary == null)
                            currentEmployeeData.fd_itinerary = '';
                        if(currentEmployeeData.fd_alt_itinerary == null)
                            currentEmployeeData.fd_alt_itinerary = '';
                        if(currentEmployeeData.fd_savings == null)
                            currentEmployeeData.fd_savings = '';
                        if(currentEmployeeData.fd_remarks == null)
                            currentEmployeeData.fd_remarks = '';
                        if(currentEmployeeData.ccStatus == 0)
                            currentEmployeeData.ccText = '';
                        // var str = currentEmployeeData.fd_alt_itinerary;
                        // var altItn = str.replace(/(?:\r\n|\r|\n)/g, '<br/>');
                        // console.log(altItn);
                        container.append($('<div class="row">'+
                                                '<div class="col-lg-12" style="margin-bottom:10px">'+
                                                    currentEmployeeData.ccText+
                                                '</div>'+
                                                '<div class="col-lg-4">'+
                                                    '<dl class="dl-horizontal">'+
                                                        '<p><b>Itinerary</b> : <br/>' + currentEmployeeData.Itinerary + '</p>'+
                                                    '</dl>'+
                                                '</div>'+
                                                '<div class="col-lg-4">'+
                                                    '<dl class="dl-horizontal">'+
                                                    '<input type="hidden" id="refFare_'+currentEmployeeData.PNRs+'" value="'+currentEmployeeData.Tot_Amt+'"/>'+
                                                    '<input type="hidden" id="refAltFare_'+currentEmployeeData.PNRs+'" value="'+currentEmployeeData.fd_alt_fare+'"/>'+
                                                    '<input type="hidden" id="refRemarks_'+currentEmployeeData.PNRs+'" value="'+currentEmployeeData.fd_remarks+'"/>'+
                                                    '<input type="hidden" id="refItinerary_'+currentEmployeeData.PNRs+'" value="'+currentEmployeeData.Itinerary.replace("<br/>","<br/>")+'"/>'+
                                                    '<input type="hidden" id="refAltItinerary_'+currentEmployeeData.PNRs+'" value="'+currentEmployeeData.fd_alt_itinerary.replace("<br/>","<br/>")+'"/>'+
                                                    '<input type="hidden" id="refCabin_'+currentEmployeeData.PNRs+'" value="'+currentEmployeeData.CabinClass+'"/>'+
                                                    '<input type="hidden" id="refSavings_'+currentEmployeeData.PNRs+'" value="'+currentEmployeeData.fd_savings+'"/>'+
                                                    // '<p><b>Alt Itinerary</b> : <br/><span id="altfiled_'+currentEmployeeData.PNRs+'">'+currentEmployeeData.fd_alt_itinerary.replace("<br/>","<br/>")+'</span></p>'+
                                                    '<p><b>Alt Itinerary</b> : <br/><span id="altfiled_'+currentEmployeeData.PNRs+'">'+currentEmployeeData.fd_alt_itinerary.replace(/(?:\r\n|\r|\n)/g, '<br/>')+'</span></p>'+
                                                    '</dl>'+
                                                '</div>'+
                                                '<div class="col-lg-2">'+
                                                    '<p><b>TS Savings</b> : <br/><span id="altsavings_'+currentEmployeeData.PNRs+'">'+currentEmployeeData.fd_savings+'</span></p>'+
                                                    '</dl>'+
                                                '</div>'+
                                                '<div class="col-lg-1">'+
                                                    '<dl class="dl-horizontal">'+
                                                        '<a class="btn btn-sm btn-primary" href="javascript:void(0)" onclick="addFare(\''+currentEmployeeData.PNRs+'\')">Add Fare</a>'+
                                                    '</dl>'+
                                                '</div>'+
                                                '<div class="col-lg-1">'+
                                                    '<dl class="dl-horizontal">'+
                                                        '<a class="btn btn-sm btn-primary" href="javascript:void(0)" onclick="sendMail(\''+currentEmployeeData.PNRs+'\')">Send Mail</a>'+
                                                    '</dl>'+
                                                '</div>'+
                                            '</div>'));
                    }
                },
                    
//                summary: {
//                    totalItems: [{
//                        column: "savings",
//                        summaryType: "sum",
//                        displayFormat: "Total {0}"
//                    }, {
//                        column: "tkt_amount",
//                        summaryType: "sum",
//                        displayFormat: "Total {0}"
//                    }]
//                }

            }).dxDataGrid("instance");

        }
        function sendMail(pnrs){
            if(pnrs){
                var iary = pnrs.split('_');
                var pnr = iary[0];
                var tktnumber = iary[1];
                $('#lowestFareTable').html('<tr><td id="em_PNR">'+pnr+'</td><td id="em_TktNumber">'+tktnumber+'</td><td><span id="em_Itinerary">'+$('#refItinerary_'+pnrs).val()+'<span style="display:none" id="em_cabin">'+$('#refCabin_'+pnrs).val()+'</span></td><td id="em_fare" align="right">'+$('#refFare_'+pnrs).val()+'</td><td id="em_alt_itinerary" align="right">'+$('#refAltItinerary_'+pnrs).val()+'</td><td id="em_alt_fare" align="right">'+$('#refAltFare_'+pnrs).val()+'</td><td id="em_savings" align="right">'+$('#refSavings_'+pnrs).val()+'</td></tr><tr><td colspan="7">Remarks : <span id="em_remarks">'+$('#refRemarks_'+pnrs).val()+'</span></td></tr>');
            }
            $('#myMail').modal('show');
        }
        function genpnrdata() {
            var currentData = '';
            $('#genpnrdata1').attr('disabled','disabled');
//            $("#currentPnr").html('Loading...');
//            var data = {
//                customer: "viacom"
//            };
            $.ajax({
                type: "POST",
                data: $('#filter').serialize(),
                url: 'genladder.php',
                success: function(data) {
                    $('#genpnrdata1').removeAttr('disabled');
                    $(".demo-container").removeClass("dx-selection");
                    currentData = JSON.parse(data);
                    console.log("currentData :: after ::: " + currentData);
                    populateCurrentData(currentData);
                },
                error: function() {
                    alert('Error');
                }
            });

        }

        var discountCellTemplate = function(container, options) {
            $("<div/>").dxBullet({
                onIncidentOccurred: null,
                size: {
                    width: 150,
                    height: 35
                },
                margin: {
                    top: 5,
                    bottom: 0,
                    left: 5
                },
                showTarget: false,
                showZeroLevel: true,
                value: options.value * 100,
                startScaleValue: 0,
                endScaleValue: 100,
                tooltip: {
                    enabled: true,
                    font: {
                        size: 18
                    },
                    paddingTopBottom: 2,
                    customizeTooltip: function() {
                        return {
                            text: options.text
                        };
                    },
                    zIndex: 5
                }
            }).appendTo(container);
        };

        var collapsed = false;
        
        function send_mail_f(pnr,tktnumber){
            $('#myMail').modal('show');
        }
        function addFare(pnrs){
            $('#refpnrs').val(pnrs);
            var infoary = pnrs.split('_');
            $('#PNR').val(infoary[0]);
            $('#TktNumber').val(infoary[1]);
            $('#fare').val($('#refFare_'+pnrs).val());
            $('#Itinerary').val($('#refItinerary_'+pnrs).val().replace('<br/>','\n'));
            $('#fareDrop').modal('show');
        }
        
        $("#addAltFare").submit(function(e) {
            var url = "add_fare_drop.php"; // the script where you handle the form input.
            $('#submit_manual').attr('disabled');
            var refary = ['PNR','TktNumber','Itinerary','fare','alt_fare','alt_itinerary','savings','remarks'];
            var nItinerary = $('#Itinerary').val().replace('\n',',');
            var nalt_itinerary = $('#alt_itinerary').val().replace('\n',',');
            
            $.ajax({
                   type: "POST",
                   url: url,
                   data: $("#addAltFare").serialize()+'&nItinerary='+nItinerary+'&nalt_itinerary='+nalt_itinerary, // serializes the form's elements.
                   success: function(datas)
                   {
                       var pdata = JSON.parse(datas);
                       if(pdata.status == '1'){
                           for (i = 0; i < refary.length; i++) {
                               if(i==2 || i==5){
                                   var iti2 = refary[i];
                                   var iti2 = $('#'+refary[i]).val().replace('\n','<br/>');
                                   $('#altfiled_'+pdata.utkts).html(iti2);
                                   $('#em_'+refary[i]).html(iti2);
                               }
                                else
                                    $('#em_'+refary[i]).html($('#'+refary[i]).val());
                            }
                           $('#altfiled_'+$('#refpnrs').val()).html($('#alt_itinerary').val().replace(/(?:\r\n|\r|\n)/g,'<br/>'));
                           $('#altsavings_'+$('#refpnrs').val()).html($('#savings').val());
                           $('#addfareclose').trigger('click');
                           addAltFare.reset();
                           send_mail_f();
                       }
                       $('#altsavings_'+pdata.utkts).html(pdata.savings);
                       $('#submit_manual').removeAttr('disabled');
                   },
                    error:function(){
                        alert('Request Failed');
                        $('#submit_manual').removeAttr('disabled');
                    }
                 });
                e.preventDefault(); // avoid to execute the actual submit of the form.
        });
        function calsavings(altval){
            $('#savings').val(parseInt($('#fare').val()) - parseInt(altval));
        }
        function triggerMail(){
            if($('#toEmail').val() == ""){
                alert('Email ID is empty.');
                return false;
            }
            else{
                // var regex = /^([a-zA-Z0-9_\.\-\+])+\@(([a-zA-Z0-9\-])+\.)+([a-zA-Z0-9]{2,4})+$/;
                // if(!regex.test($('#toEmail').val())) {
                //     alert('Invalid Email ID.');
                //     return false;
                // }
            }
            $('#triggerMail').html('<i class="fa fa-reply"></i> Sending...');
            $('#triggerMail').attr('disabled', 'disabled');
            var str = $('#em_alt_itinerary').html();
            var alt_iti = str.replace(/(?:\r\n|\r|\n)/g, '<br/>');
            var datainput = {'pnr':$('#em_PNR').html(),'tktNumber':$('#em_TktNumber').html(),'iti':$('#em_Itinerary').html(),'cabin':$('#em_cabin').html(),'fare':$('#em_fare').html(),'alt_iti':alt_iti,'alt_fare':$('#em_alt_fare').html(),'savings':$('#em_savings').html(),'frm':'k.ravi@travelspends.com','to':$("#toEmail").val(),'subject':$("#subject").val(),'remark':$("#em_remarks").html(),'mailBody':$('#lowestFareTable').html(),'name':"<?php if(isset($_SESSION['user_info'])) { echo $_SESSION['user_info']['name']; } ?>",'email':"<?php if(isset($_SESSION['user_info'])) { echo $_SESSION['user_info']['email']; } ?>"};
            $.ajax({
                type: "POST",
                data: datainput,
                url: 'triggerFareDropMail.php',
                success: function(data) {
                    $('#triggerMail').html('<i class="fa fa-reply"></i> Send');
                    $('#triggerMail').removeAttr("disabled");
                    
                    var pdata = JSON.parse(data);
                    if(pdata.status == 0){
                        $('#discard').trigger('click');
                        alert('Email sent successfully.');
                    }
                    else{
                        alert('Email request failed. Kindly try after sometime.');
                    }
//                    alert(data);
//                    $(".demo-container").removeClass("dx-selection");
//                    currentData = JSON.parse(data);
//                    console.log("currentData :: after ::: " + currentData);
//                    populateCurrentData(currentData);
                },
                error: function() {
                    alert('Error');
                }
            });
        }
    </script>


        <!-- end -->

    </body>

    </html>