<!DOCTYPE html>
<html>

<head>

    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <title>Tripnomics | Flown Statement</title>
    <link href="https://fonts.googleapis.com/css?family=Lato|Roboto" rel="stylesheet">
    <link href="css/bootstrap.min.css" rel="stylesheet">
    <link href="font-awesome/css/font-awesome.css" rel="stylesheet">
    <link href="css/plugins/steps/jquery.steps.css" rel="stylesheet">
    <link href="css/plugins/iCheck/custom.css" rel="stylesheet">
    <link href="css/animate.css" rel="stylesheet">
    <link href="css/style.css" rel="stylesheet">
    <link href="css/flownstatus.css" rel="stylesheet">
    <link href="css/plugins/codemirror/codemirror.css" rel="stylesheet">
    <link href="css/plugins/codemirror/ambiance.css" rel="stylesheet">
    <link rel="stylesheet" href="airline_logos/logo.css">
    <link rel="stylesheet" href="https://cdn3.devexpress.com/jslib/18.1.3/css/dx.spa.css">
    <link rel="stylesheet" href="https://cdn3.devexpress.com/jslib/18.1.3/css/dx.common.css">
    <link rel="stylesheet" href="https://cdn3.devexpress.com/jslib/18.1.3/css/dx.light.css">

    <style>
        .scroll-wrapper {
            overflow: hidden !important;
            padding: 0 !important;
            position: relative;
            height: calc(100vh - 200px) !important;
        }

        h5 {
            font-size: 13px;
        }

        .itinerary {
            font-size: 11px;
        }

        .table {
            font-size: 13px;
        }

        .table thead {
            font-weight: bold;
        }

        .table tr:hover {
            cursor: pointer;
        }

        .table span {
            font-size: 13px;
        }

        .agl {
            font-size: 13px;
        }

        .labels-font {
            font-size: 12px !important;
        }

        .board1 {
            float: left;
        }

        /*.navbar-brand { background: #ffffff !important; }*/

        .cl_img {
            width: 20px;
            cursor: pointer;
            margin-bottom: 5px;
        }

        .dataTables_filter label {
            float: right;

        }

        .table-responsive {
            overflow-x: hidden;
        }

        .pagination {
            margin: 0px 0;
            float: right;
        }

        .dataTables_info {
            padding-top: 35px;
        }

        .dataTables_filter {
            margin-right: -5px;
        }

        .dx-datagrid-rowsview .dx-row.dx-group-row {
            color: black;
            background-color: #fff;
            font-weight: bold;
        }

        #gridContainer>div>div.dx-datagrid-headers.dx-datagrid-nowrap>div>table>tbody>tr>td:nth-child(7)>div {
            color: white;
        }

        #lccContainer {
            height: 440px;
        }

        #lccContainer .dx-datagrid-content tr.dx-data-row {
            cursor: pointer;
        }

        body {
            font-family: "Lato", sans-serif;
        }

        .watermark {
            position: absolute;
            opacity: 0.25;
            font-size: 3em;
            width: 100%;
            text-align: center;
            z-index: 1000;
            padding-top: 82px;
        }

    </style>

</head>

<body class="top-navigation md-skin">

    <div id="wrapper">
        <div id="page-wrapper" class="gray-bg">
            <div class="row border-bottom white-bg" id="navbar_container">
            </div>
            <div class="wrapper wrapper-content" id="appContainer">
                <div class="row">
                    <div class="col-lg-6 p20-h p10-v">
                        <div class="ibox">
                            <div class="ibox-content">
                                <div class="s16 lato-family text-grey f500">Cancellation cum Flown Statement </div>

                                <div class="scrollbar-outer">
                                    <div class="watermark">Sample Data</div>
                                    <div id="gridContainer"></div>
                                </div>
                            </div>
                        </div>
                    </div>



                    <div class="col-lg-6 p20-h p20-v">
                        <div class="ibox">
                            <div class="ibox-content">
                                <h3 class="lato-family s12 f500">Unutilized Status PNR's</h3>
                                <div class="scrollbar-outer">
                                    <div id="lccContainer"></div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="footer" id="footer"></div>

        </div>
    </div>



    <!-- Mainly scripts -->
    <script src="js/jquery-3.1.1.min.js"></script>
    <script src="js/bootstrap.min.js"></script>
    <script src="js/plugins/metisMenu/jquery.metisMenu.js"></script>
    <script src="js/plugins/slimscroll/jquery.slimscroll.min.js"></script>


    <script src="js/plugins/validate/jquery.validate.min.js"></script>
    <script src="js/plugins/steps/jquery.steps.min.js"></script>
    <script src="js/plugins/dataTables/datatables.min.js"></script>



    <!-- Custom and plugin javascript -->
    <script src="js/inspinia.js"></script>
    <script src="js/plugins/pace/pace.min.js"></script>
    <script src="js/plugins/pdfjs/pdf.js"></script>

    <!-- Flot -->
    <script src="js/plugins/flot/jquery.flot.js"></script>
    <script src="js/plugins/flot/jquery.flot.tooltip.min.js"></script>
    <script src="js/plugins/flot/jquery.flot.resize.js"></script>

    <!-- Peity -->
    <script src="js/plugins/peity/jquery.peity.min.js"></script>
    <!-- Peity demo -->
    <script src="js/demo/peity-demo.js"></script>

    <!-- iCheck -->
    <script src="js/plugins/iCheck/icheck.min.js"></script>


    <script src="https://cdnjs.cloudflare.com/ajax/libs/cldrjs/0.4.4/cldr.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/cldrjs/0.4.4/cldr/event.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/cldrjs/0.4.4/cldr/supplemental.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/cldrjs/0.4.4/cldr/unresolved.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/globalize/1.1.1/globalize.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/globalize/1.1.1/globalize/message.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/globalize/1.1.1/globalize/number.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/globalize/1.1.1/globalize/currency.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/globalize/1.1.1/globalize/date.min.js"></script>
    <script src="https://cdn3.devexpress.com/jslib/18.1.3/js/dx.all.js"></script>

    <script src="https://unpkg.com/hyperapp"></script>
    <script src="js/Components/header.js"></script>
    <script src="js/Components/footer.js"></script>


    <link rel="stylesheet" href="https://unpkg.com/simplebar@latest/dist/simplebar.css" />
    <script src="https://unpkg.com/simplebar@latest/dist/simplebar.js"></script>
    <!-- or -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/jquery.scrollbar/0.2.11/jquery.scrollbar.css" />
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery.scrollbar/0.2.11/jquery.scrollbar.js"></script>



    <script>
        var flownData = [{
                finyear: '2015-2016',
                year: '2016',
                quarter: 'Q1',
                month: 'Jan',
                tmc: 'CWT',
                airline: '9W',
                type: 'INT',
                count: '10',
                possiblerefund: '1000',
                claimedrefund: '100'
            },
            {
                finyear: '2015-2016',
                year: '2016',
                quarter: 'Q1',
                month: 'Feb',
                tmc: 'CWT',
                airline: '9W',
                type: 'INT',
                count: '10',
                possiblerefund: '1000',
                claimedrefund: '100'
            },
            {
                finyear: '2015-2016',
                year: '2016',
                quarter: 'Q1',
                month: 'March',
                tmc: 'CWT',
                airline: '9W',
                type: 'INT',
                count: '10',
                possiblerefund: '1000',
                claimedrefund: '100'
            },
            {
                finyear: '2015-2016',
                year: '2016',
                quarter: 'Q2',
                month: 'April',
                tmc: 'AMEX',
                airline: '9W',
                type: 'INT',
                count: '10',
                possiblerefund: '1000',
                claimedrefund: '100'
            },
            {
                finyear: '2015-2016',
                year: '2016',
                quarter: 'Q2',
                month: 'May',
                tmc: 'CWT',
                airline: '6E',
                type: 'INT',
                count: '10',
                possiblerefund: '1000',
                claimedrefund: '100'
            },
            {
                finyear: '2015-2016',
                year: '2016',
                quarter: 'Q2',
                month: 'June',
                tmc: 'CWT',
                airline: '9W',
                type: 'INT',
                count: '10',
                possiblerefund: '1000',
                claimedrefund: '100'
            },
            {
                finyear: '2015-2016',
                year: '2016',
                quarter: 'Q3',
                month: 'July',
                tmc: 'CWT',
                airline: '6E',
                type: 'INT',
                count: '10',
                possiblerefund: '1000',
                claimedrefund: '100'
            },
            {
                finyear: '2015-2016',
                year: '2016',
                quarter: 'Q3',
                month: 'Aug',
                tmc: 'CWT',
                airline: '9W',
                type: 'INT',
                count: '10',
                possiblerefund: '1000',
                claimedrefund: '100'
            },
            {
                finyear: '2015-2016',
                year: '2016',
                quarter: 'Q3',
                month: 'Sept',
                tmc: 'CWT',
                airline: '9W',
                type: 'INT',
                count: '10',
                possiblerefund: '1000',
                claimedrefund: '100'
            },
            {
                finyear: '2015-2016',
                year: '2016',
                quarter: 'Q4',
                month: 'Oct',
                tmc: 'CWT',
                airline: '9W',
                type: 'INT',
                count: '10',
                possiblerefund: '1000',
                claimedrefund: '100'
            },
            {
                finyear: '2015-2016',
                year: '2016',
                quarter: 'Q4',
                month: 'Nov',
                tmc: 'CWT',
                airline: '9W',
                type: 'INT',
                count: '10',
                possiblerefund: '1000',
                claimedrefund: '100'
            },
            {
                finyear: '2015-2016',
                year: '2016',
                quarter: 'Q4',
                month: 'Nov',
                tmc: 'AMEX',
                airline: '9W',
                type: 'INT',
                count: '10',
                possiblerefund: '1000',
                claimedrefund: '100'
            },
            {
                finyear: '2015-2016',
                year: '2016',
                quarter: 'Q4',
                month: 'Dec',
                tmc: 'CWT',
                airline: '9W',
                type: 'INT',
                count: '10',
                possiblerefund: '1000',
                claimedrefund: '100'
            },
            {
                finyear: '2016-2017',
                year: '2017',
                quarter: 'Q1',
                month: 'Jan',
                tmc: 'CWT',
                airline: '9W',
                type: 'INT',
                count: '10',
                possiblerefund: '1000',
                claimedrefund: '100'
            },
            {
                finyear: '2016-2017',
                year: '2017',
                quarter: 'Q1',
                month: 'Feb',
                tmc: 'CWT',
                airline: '9W',
                type: 'INT',
                count: '10',
                possiblerefund: '1000',
                claimedrefund: '100'
            },
            {
                finyear: '2016-2017',
                year: '2017',
                quarter: 'Q1',
                month: 'March',
                tmc: 'CWT',
                airline: '9W',
                type: 'INT',
                count: '10',
                possiblerefund: '1000',
                claimedrefund: '100'
            },
            {
                finyear: '2016-2017',
                year: '2017',
                quarter: 'Q2',
                month: 'April',
                tmc: 'CWT',
                airline: '9W',
                type: 'INT',
                count: '10',
                possiblerefund: '1000',
                claimedrefund: '100'
            },
            {
                finyear: '2016-2017',
                year: '2017',
                quarter: 'Q2',
                month: 'May',
                tmc: 'CWT',
                airline: '6E',
                type: 'INT',
                count: '10',
                possiblerefund: '1000',
                claimedrefund: '100'
            },
            {
                finyear: '2016-2017',
                year: '2017',
                quarter: 'Q2',
                month: 'June',
                tmc: 'CWT',
                airline: '9W',
                type: 'INT',
                count: '10',
                possiblerefund: '1000',
                claimedrefund: '100'
            },
            {
                finyear: '2016-2017',
                year: '2017',
                quarter: 'Q3',
                month: 'July',
                tmc: 'CWT',
                airline: '6E',
                type: 'INT',
                count: '10',
                possiblerefund: '1000',
                claimedrefund: '100'
            },
            {
                finyear: '2016-2017',
                year: '2017',
                quarter: 'Q3',
                month: 'Aug',
                tmc: 'CWT',
                airline: '9W',
                type: 'INT',
                count: '10',
                possiblerefund: '1000',
                claimedrefund: '100'
            },
            {
                finyear: '2016-2017',
                year: '2017',
                quarter: 'Q3',
                month: 'Sept',
                tmc: 'CWT',
                airline: '9W',
                type: 'INT',
                count: '10',
                possiblerefund: '1000',
                claimedrefund: '100'
            },
            {
                finyear: '2016-2017',
                year: '2017',
                quarter: 'Q4',
                month: 'Oct',
                tmc: 'CWT',
                airline: '9W',
                type: 'INT',
                count: '10',
                possiblerefund: '1000',
                claimedrefund: '100'
            },
            {
                finyear: '2016-2017',
                year: '2017',
                quarter: 'Q4',
                month: 'Nov',
                tmc: 'CWT',
                airline: '9W',
                type: 'INT',
                count: '10',
                possiblerefund: '1000',
                claimedrefund: '100'
            },
            {
                finyear: '2016-2017',
                year: '2017',
                quarter: 'Q4',
                month: 'Dec',
                tmc: 'CWT',
                airline: '9W',
                type: 'INT',
                count: '10',
                possiblerefund: '1000',
                claimedrefund: '100'
            },
            {
                finyear: '2017-2018',
                year: '2018',
                quarter: 'Q1',
                month: 'Jan',
                tmc: 'CWT',
                airline: '9W',
                type: 'INT',
                count: '10',
                possiblerefund: '100',
                claimedrefund: '100'
            },
            {
                finyear: '2017-2018',
                year: '2018',
                quarter: 'Q1',
                month: 'Feb',
                tmc: 'CWT',
                airline: '9W',
                type: 'INT',
                count: '10',
                possiblerefund: '1000',
                claimedrefund: '100'
            },
            {
                finyear: '2017-2018',
                year: '2018',
                quarter: 'Q1',
                month: 'March',
                tmc: 'CWT',
                airline: '9W',
                type: 'INT',
                count: '10',
                possiblerefund: '1000',
                claimedrefund: '100'
            },
            {
                finyear: '2017-2018',
                year: '2018',
                quarter: 'Q2',
                month: 'April',
                tmc: 'CWT',
                airline: '9W',
                type: 'INT',
                count: '10',
                possiblerefund: '1000',
                claimedrefund: '100'
            },
            {
                finyear: '2017-2018',
                year: '2018',
                quarter: 'Q2',
                month: 'May',
                tmc: 'CWT',
                airline: '6E',
                type: 'INT',
                count: '10',
                possiblerefund: '1000',
                claimedrefund: '100'
            },
            {
                finyear: '2015-2016',
                year: '2016',
                quarter: 'Q1',
                month: 'Jan',
                tmc: 'CWT',
                airline: '9W',
                type: 'DOM',
                count: '10',
                possiblerefund: '1000',
                claimedrefund: '100'
            },
            {
                finyear: '2015-2016',
                year: '2016',
                quarter: 'Q1',
                month: 'Feb',
                tmc: 'CWT',
                airline: '9W',
                type: 'DOM',
                count: '10',
                possiblerefund: '1000',
                claimedrefund: '100'
            },
            {
                finyear: '2015-2016',
                year: '2016',
                quarter: 'Q1',
                month: 'March',
                tmc: 'CWT',
                airline: '9W',
                type: 'DOM',
                count: '10',
                possiblerefund: '1000',
                claimedrefund: '100'
            },
            {
                finyear: '2015-2016',
                year: '2016',
                quarter: 'Q2',
                month: 'April',
                tmc: 'AMEX',
                airline: '9W',
                type: 'DOM',
                count: '10',
                possiblerefund: '500',
                claimedrefund: '100'
            },
            {
                finyear: '2015-2016',
                year: '2016',
                quarter: 'Q2',
                month: 'May',
                tmc: 'CWT',
                airline: '6E',
                type: 'DOM',
                count: '10',
                possiblerefund: '1000',
                claimedrefund: '100'
            },
            {
                finyear: '2015-2016',
                year: '2016',
                quarter: 'Q2',
                month: 'June',
                tmc: 'CWT',
                airline: '9W',
                type: 'DOM',
                count: '10',
                possiblerefund: '1000',
                claimedrefund: '100'
            },
            {
                finyear: '2015-2016',
                year: '2016',
                quarter: 'Q3',
                month: 'July',
                tmc: 'CWT',
                airline: '6E',
                type: 'DOM',
                count: '10',
                possiblerefund: '200',
                claimedrefund: '100'
            },
            {
                finyear: '2015-2016',
                year: '2016',
                quarter: 'Q3',
                month: 'Aug',
                tmc: 'CWT',
                airline: '9W',
                type: 'DOM',
                count: '1',
                possiblerefund: '1000',
                claimedrefund: '100'
            },
            {
                finyear: '2015-2016',
                year: '2016',
                quarter: 'Q3',
                month: 'Sept',
                tmc: 'CWT',
                airline: '9W',
                type: 'DOM',
                count: '10',
                possiblerefund: '300',
                claimedrefund: '100'
            },
            {
                finyear: '2015-2016',
                year: '2016',
                quarter: 'Q4',
                month: 'Oct',
                tmc: 'CWT',
                airline: '9W',
                type: 'DOM',
                count: '3',
                possiblerefund: '1000',
                claimedrefund: '100'
            },
            {
                finyear: '2015-2016',
                year: '2016',
                quarter: 'Q4',
                month: 'Nov',
                tmc: 'CWT',
                airline: '9W',
                type: 'DOM',
                count: '10',
                possiblerefund: '1000',
                claimedrefund: '100'
            },
            {
                finyear: '2015-2016',
                year: '2016',
                quarter: 'Q4',
                month: 'Nov',
                tmc: 'AMEX',
                airline: '9W',
                type: 'DOM',
                count: '6',
                possiblerefund: '1000',
                claimedrefund: '100'
            },
            {
                finyear: '2015-2016',
                year: '2016',
                quarter: 'Q4',
                month: 'Dec',
                tmc: 'CWT',
                airline: '9W',
                type: 'DOM',
                count: '10',
                possiblerefund: '1000',
                claimedrefund: '100'
            },
            {
                finyear: '2016-2017',
                year: '2017',
                quarter: 'Q1',
                month: 'Jan',
                tmc: 'CWT',
                airline: '9W',
                type: 'DOM',
                count: '10',
                possiblerefund: '100',
                claimedrefund: '100'
            },
            {
                finyear: '2016-2017',
                year: '2017',
                quarter: 'Q1',
                month: 'Feb',
                tmc: 'CWT',
                airline: '9W',
                type: 'DOM',
                count: '2',
                possiblerefund: '1000',
                claimedrefund: '100'
            },
            {
                finyear: '2016-2017',
                year: '2017',
                quarter: 'Q1',
                month: 'March',
                tmc: 'CWT',
                airline: '9W',
                type: 'DOM',
                count: '10',
                possiblerefund: '100',
                claimedrefund: '100'
            },
            {
                finyear: '2016-2017',
                year: '2017',
                quarter: 'Q2',
                month: 'April',
                tmc: 'CWT',
                airline: '9W',
                type: 'DOM',
                count: '10',
                possiblerefund: '1000',
                claimedrefund: '100'
            },
            {
                finyear: '2016-2017',
                year: '2017',
                quarter: 'Q2',
                month: 'May',
                tmc: 'CWT',
                airline: '6E',
                type: 'DOM',
                count: '2',
                possiblerefund: '1000',
                claimedrefund: '100'
            },
            {
                finyear: '2016-2017',
                year: '2017',
                quarter: 'Q2',
                month: 'June',
                tmc: 'CWT',
                airline: '9W',
                type: 'DOM',
                count: '10',
                possiblerefund: '1000',
                claimedrefund: '100'
            },
            {
                finyear: '2016-2017',
                year: '2017',
                quarter: 'Q3',
                month: 'July',
                tmc: 'CWT',
                airline: '6E',
                type: 'DOM',
                count: '10',
                possiblerefund: '1000',
                claimedrefund: '100'
            },
            {
                finyear: '2016-2017',
                year: '2017',
                quarter: 'Q3',
                month: 'Aug',
                tmc: 'CWT',
                airline: '9W',
                type: 'DOM',
                count: '10',
                possiblerefund: '1000',
                claimedrefund: '100'
            },
            {
                finyear: '2016-2017',
                year: '2017',
                quarter: 'Q3',
                month: 'Sept',
                tmc: 'CWT',
                airline: '9W',
                type: 'DOM',
                count: '10',
                possiblerefund: '1000',
                claimedrefund: '100'
            },
            {
                finyear: '2016-2017',
                year: '2017',
                quarter: 'Q4',
                month: 'Oct',
                tmc: 'CWT',
                airline: '9W',
                type: 'DOM',
                count: '10',
                possiblerefund: '1000',
                claimedrefund: '100'
            },
            {
                finyear: '2016-2017',
                year: '2017',
                quarter: 'Q4',
                month: 'Nov',
                tmc: 'CWT',
                airline: '9W',
                type: 'DOM',
                count: '10',
                possiblerefund: '1000',
                claimedrefund: '100'
            },
            {
                finyear: '2016-2017',
                year: '2017',
                quarter: 'Q4',
                month: 'Dec',
                tmc: 'CWT',
                airline: '9W',
                type: 'DOM',
                count: '10',
                possiblerefund: '1000',
                claimedrefund: '100'
            },
            {
                finyear: '2017-2018',
                year: '2018',
                quarter: 'Q1',
                month: 'Jan',
                tmc: 'CWT',
                airline: '9W',
                type: 'DOM',
                count: '10',
                possiblerefund: '1000',
                claimedrefund: '100'
            },
            {
                finyear: '2017-2018',
                year: '2018',
                quarter: 'Q1',
                month: 'Feb',
                tmc: 'CWT',
                airline: '9W',
                type: 'DOM',
                count: '10',
                possiblerefund: '1000',
                claimedrefund: '100'
            },
            {
                finyear: '2017-2018',
                year: '2018',
                quarter: 'Q1',
                month: 'March',
                tmc: 'CWT',
                airline: '9W',
                type: 'DOM',
                count: '10',
                possiblerefund: '1000',
                claimedrefund: '100'
            },
            {
                finyear: '2017-2018',
                year: '2018',
                quarter: 'Q2',
                month: 'April',
                tmc: 'CWT',
                airline: '9W',
                type: 'DOM',
                count: '10',
                possiblerefund: '1000',
                claimedrefund: '100'
            },
            {
                finyear: '2017-2018',
                year: '2018',
                quarter: 'Q2',
                month: 'May',
                tmc: 'CWT',
                airline: '6E',
                type: 'DOM',
                count: '10',
                possiblerefund: '1000',
                claimedrefund: '100'
            }
        ];








        $(document).ready(function () {

            var currentData = '';
            $.ajax({
                type: "POST",
                url: 'getflowdata.php',
                success: function(data) {
                    currentData = JSON.parse(data);
                    console.log("currentData :: after ::: " + currentData);
                    populateFlownData(currentData);
                },
                error: function() {
                    alert('Error');
                }
            });


            $("#gridContainer").dxDataGrid({
                dataSource: flownData,
                /* paging: { pageSize: 10 },*/

                remoteOperations: false,
                searchPanel: {
                    visible: false,
                    highlightCaseSensitive: false
                },
                groupPanel: {
                    visible: false
                },
                grouping: {
                    autoExpandAll: false
                },
                allowColumnReordering: true,
                rowAlternationEnabled: true,
                export: {
                    enabled: true
                },




                columns: [{
                        dataField: "finyear",
                        caption: "Financial Year",
                        groupIndex: 1
                    },

                    {
                        dataField: "year",
                        caption: "Year",
                        groupIndex: 2

                    },
                    {
                        dataField: "quarter",
                        caption: "Quarter",
                        groupIndex: 3
                    },
                    {
                        dataField: "month",
                        caption: "Month",
                        groupIndex: 4
                    },
                    {
                        dataField: "tmc",
                        caption: "TMC",
                        groupIndex: 5

                    },

                    {
                        dataField: "airline",

                        caption: "Airline",
                        groupIndex: 6


                    },
                    {
                        dataField: "type",
                        caption: "Trip Type",
                        allowSorting: false,
                        groupIndex: 0



                    },
                    {
                        dataField: "count",
                        dataType: "number",
                        caption: "PNR Count",
                        allowSorting: false

                    },
                    {
                        dataField: "possiblerefund",
                        dataType: "number",
                        caption: "Possible Refund",
                        allowSorting: false
                    }, {
                        dataField: "claimedrefund",
                        dataType: "number",
                        caption: "Claimed Refund",
                        allowSorting: false
                    }
                ],

                summary: {
                    groupItems: [{
                            column: "count",
                            summaryType: "sum",
                            alignByColumn: true,
                            displayFormat: "{0}"
                        }, {
                            column: "possiblerefund",
                            summaryType: "sum",
                            alignByColumn: true,
                            displayFormat: "{0}"
                        }, {
                            column: "claimedrefund",
                            summaryType: "sum",
                            alignByColumn: true,
                            displayFormat: "{0}"
                        }

                    ]
                },
                onContentReady: function (e) {
                    if (!collapsed) {
                        collapsed = true;
                        e.component.expandRow(["EnviroCare"]);
                    }
                }
            });


            getDashboardDetails();
            getMissedPnrs();
            getOtherDetails();

            $('.missedList').DataTable({
                "order": [
                    [0, "desc"]
                ],
                pageLength: 10,
                responsive: true,
                dom: '<"html5buttons"B>lTfgitp',
                buttons: [{
                    extend: 'excel',
                    title: 'Unutilized_List'
                }]
            });
            $('.LCCList').DataTable({
                "order": [
                    [0, "desc"]
                ],
                pageLength: 10,
                responsive: true,
                dom: '<"html5buttons"B>lTfgitp',
                buttons: [{
                    extend: 'excel',
                    title: 'Low_Cost_List'
                }]
            });


        });

        function populateFlownData(currentData) {
            $("#lccContainer").dxDataGrid({
                dataSource: currentData,
                paging: {
                    pageSize: 10
                },

                remoteOperations: false,
                searchPanel: {
                    visible: true,
                    highlightCaseSensitive: true
                },
                groupPanel: {
                    visible: false
                },
                grouping: {
                    autoExpandAll: false
                },
                allowColumnReordering: true,
                rowAlternationEnabled: true,

                export: {
                    enabled: true
                },
                keyExpr: "paxName",
                selection: {
                    mode: "single"
                },
                onSelectionChanged: function(e) {
                    e.component.collapseAll(-1);
                    e.component.expandRow(e.currentSelectedRowKeys[0]);
                },
                onContentReady: function(e) {
                    if (!e.component.getSelectedRowKeys().length)
                        e.component.selectRowsByIndexes(0);
                },



                columns: [{
                        dataField: "pnr",
                        caption: "PNR"

                    },

                    {
                        dataField: "ticket_no",
                        caption: "Ticket No"

                    },
                    {
                        dataField: "flight_number",
                        caption: "Flight Number",

                    },
                    {
                        dataField: "journey_missed_date",
                        caption: "No Show "

                    }, {
                        dataField: "coupon_code",

                        caption: "Coupon Code"

                    },
                    {
                        dataField: "check_status",
                        dataType: "number",
                        caption: "Status",

                        alignment: "right"
                    }

                ],


                onContentReady: function(e) {
                    if (!collapsed) {
                        collapsed = true;
                        e.component.expandRow(["EnviroCare"]);
                    }
                },
                masterDetail: {
                    enabled: false,
                    template: function(container, options) {
                        var currentEmployeeData = options.data;
                        container.append($(
                            '<div class="row"><div class="col-lg-5"><dl class="dl-horizontal"><p><b>Sector</b> : ' +
                            currentEmployeeData.sector +
                            '</p> <p><b>Pax Name</b> : ' + currentEmployeeData.paxName +
                            ' </p></dl></div><div class="col-lg-7" id="cluster_info"><dl class="dl-horizontal" > <p><b>Customer</b> : ' +
                            currentEmployeeData.customer + '</p></dl> </div></div>'));
                    }
                }
            });
        }

        /* var discountCellTemplate = function (container, options) {
             $("<div/>").dxBullet({
                 onIncidentOccurred: null,
                 size: {
                     width: 150,
                     height: 35
                 },
                 margin: {
                     top: 5,
                     bottom: 0,
                     left: 5
                 },
                 showTarget: false,
                 showZeroLevel: true,
                 value: options.value * 100,
                 startScaleValue: 0,
                 endScaleValue: 100,
                 tooltip: {
                     enabled: true,
                     font: {
                         size: 18
                     },
                     paddingTopBottom: 2,
                     customizeTooltip: function () {
                         return {
                             text: options.text
                         };
                     },
                     zIndex: 5
                 }
             }).appendTo(container);
         };*/

        var collapsed = false;

        function getDashboardDetails() {
            var json = JSON.parse(
                '{"dashboard_summary": {"total_pnr": "200","flown_pnr": "42","unutilized_pnr": "0","upcoming_pnr": "70"}}'
            );
            $("#totalpnr").html(json.dashboard_summary.total_pnr);
            $("#flownPnr").html(json.dashboard_summary.flown_pnr);
            $("#unutilizedpnr").html(json.dashboard_summary.unutilized_pnr);
            $("#upcomingPnr").html(json.dashboard_summary.upcoming_pnr);
        }

        function getMissedPnrs() {
            var json = JSON.parse(
                '{"missed_pnr_details": [{"ticket_no": "TY342","pnr": "SHR6I4","flight_number": "UK 970","sector": "BOM-DEL","journey_missed_date": "06 June 2018","sector_missed": "BOM-DEL","coupon_code":"1","check_status":"open"},{"ticket_no": "TY342","pnr": "SINAHZ","flight_number": "EY 314","sector": "BOM-DEL","pax_name": "Harsh","journey_missed_date": "06 June 2018","sector_missed": "BOM-DEL","coupon_code":"E12345","check_status":"closed"}]}'
            );

            $.each(json, function (k) {
                $("#missedPnr").html('<tr><td>' + json.missed_pnr_details[0].ticket_no + '</td><td>' + json.missed_pnr_details[
                        0].pnr + '</td><td>' + json.missed_pnr_details[0].flight_number + '</td><td>' +
                    json.missed_pnr_details[0].sector + '</td><td>' + json.missed_pnr_details[0].journey_missed_date +
                    '</td><td>' + json.missed_pnr_details[0].sector_missed + '</td><td>' + json.missed_pnr_details[
                        0].coupon_code + '</td><td>' + json.missed_pnr_details[0].check_status +
                    '</td></tr>');
            });

        }

        function getOtherDetails() {
            var json = JSON.parse(
                '{"missed_pnr_details": [{"ticket_no": "TY342","pnr": "SHR6I4","flight_number": "UK 970","sector": "BOM-DEL","journey_missed_date": "06 June 2018","sector_missed": "BOM-DEL","coupon_code":"2","check_status":"closed"},{"ticket_no": "TY342","pnr": "SINAHZ","flight_number": "EY 314","sector": "BOM-DEL","pax_name": "Harsh","journey_missed_date": "06 June 2018","sector_missed": "BOM-DEL","coupon_code":"E12345","check_status":"open"}]}'
            );


            $.each(json, function (k) {
                $("#otherDetails").html('<tr><td>' + json.missed_pnr_details[0].ticket_no + '</td><td>' + json.missed_pnr_details[
                        0].pnr + '</td><td>' + json.missed_pnr_details[0].flight_number + '</td><td>' +
                    json.missed_pnr_details[0].sector + '</td><td>' + json.missed_pnr_details[0].journey_missed_date +
                    '</td><td>' + json.missed_pnr_details[0].sector_missed + '</td><td>' + json.missed_pnr_details[
                        0].coupon_code + '</td><td>' + json.missed_pnr_details[0].check_status +
                    '</td></tr>');
            });


        }

        $(document).ready(function() {


            $('.scrollbar-outer').scrollbar();
        });

    </script>


</body>

</html>