"use strict";

function prepareAccordion(fares) {
  $("#fareList").dxAccordion({
    dataSource: fares,
    collapsible: true,
    onItemTitleClick: function(e) {
      var id = e.itemElement.attr("id");
      if (
        e.itemElement
          .attr("class")
          .toString()
          .includes("closed")
      ) {
        console.log($(".dx-accordion-item-opened").length);
        // $("#fareList").addClass("scrollbox-full-box");
        // $("#fareList").removeClass("scrollbox-f");
        // $("#fareinfo").hide(200);
      } else {
        console.log($(".dx-accordion-item-opened").length);
        // if ($(".dx-accordion-item-opened").length === 0) {
        // $("#fareList").addClass("scrollbox-f");
        // $("#fareList").removeClass("scrollbox-full-box");
        // $("#fareinfo").show(200);

        // } else {
        // $("#fareList").addClass("scrollbox-full-box");
        // $("#fareList").removeClass("scrollbox-f");
        // $("#fareinfo").hide(200);

        // }
      }
    },

    multiple: false,
    itemTemplate: function(itemData, itemIndex, itemElement) {
      if (itemData.titleMessage !== "Picked Alternate Fare") {
        var divText = "";
        var a = itemData.legs;
        for (var index = 0, len = a.length; index < len; ++index) {
          var leg = a[index];
          var divText =
            divText +
            `
            <div class="gws-flights-results__leg ">
            <div class="gws-flights-results__leg-details gws-flights__flex-filler">
                <div class="gws-flights-results__leg-itinerary">
                    <div class="gws-flights-results__dotted-flight-icon"></div>
                    <div class="gws-flights-results__leg-departure gws-flights__flex-box">
                        <div>
                            <span aria-label="Departure time: 3:05 AM.">
                                <div>
                                    <span>` +
            leg.departureTime +
            `</span>
                                </div>
                            </span>
                        </div>
                        <div aria-hidden="true" class="gws-flights__separator"></div>
                        <div aria-label="Departs from Bengaluru International Airport.">
                            <span>` +
            leg.departureCity +
            `</span>
                            <span class="gws-flights-results__iata-code" >` +
            leg.departureAirportCode +
            `</span>
                            
                        </div>
                    </div>
                    <div class="gws-flights-results__leg-duration gws-flights__flex-box">
                        <div>Travel time:&nbsp;
                            <span>` +
            leg.traveltime +
            `</span>
                        </div>
                        <div aria-hidden="true" class="gws-flights__separator" ></div>`;
          if (leg.additionalTextType == "warning") {
            var divText =
              divText +
              `<div class="gws-flights-results__warning">` +
              leg.additionalText +
              `</div>`;
          }
          var divText =
            divText +
            `</div>
                    <div class="gws-flights-results__leg-arrival gws-flights__flex-box">
                        <div>
                            <span aria-label="Arrival time: 9:00 AM." >
                              
                                    <span>` +
            leg.arrivalTime +
            `</span>
                              
                            </span>
                        </div>
                        <div aria-hidden="true" class="gws-flights__separator"></div>
                        <div aria-label="Arrives at Frankfurt Airport.">
                            <span>` +
            leg.arrivalCity +
            `</span>
                            &nbsp;
                                <span class="gws-flights-results__iata-code" >` +
            leg.arrivalAirportCode +
            `</span>
                            
                        </div>
                    </div>
                </div>
                <div class="gws-flights-results__leg-flight gws-flights__flex-box gws-flights__align-center">
                    
                    <div>` +
            leg.airline +
            `</div>
                    <span aria-hidden="true" class="gws-flights__separator"></span>
                    <div class="gws-flights-results__seating-class-be-non-be">
                        <div class="gws-flights-results__non-basic-economy gws-flights-results__seating-class" >
                            ` +
            leg.cabinClass +
            `
                        </div>
                    </div>
                    <div class="gws-flights-results__other-leg-info gws-flights__flex-box gws-flights__align-center">
                        <div aria-hidden="true" class="gws-flights__separator" ></div>
                        <div class="gws-flights-results__aircraft-type" >
                            <span>` +
            leg.equipment +
            `</span>
                            <span aria-hidden="true" class="gws-flights__separator"></span>
                        </div>
                        <span>
                            <span>` +
            leg.operatingAirline +
            `</span>&nbsp;
                            <span>` +
            leg.flightNumber +
            `</span>
                        </span>
                        
                    </div>
                </div>
                <div class="gws-flights-results__leg-disclosure gws-flights__flex-box" >
                    <div style="display:none"></div>
                    <div style="display:none"></div>
                    <div class="gws-flights-results__marketing-airlines" >
                        <span>` +
            leg.optionalText +
            `</span>
                        
                    </div>
                </div>
                
                
            </div>
            <div class="gws-flights-results__leg-amenities gws-flights-results__amenities" >
                <ul>
                    <li class="" >
                        ` +
            leg.meta_a +
            `
                    </li>
                    <li class="" >
                    ` +
            leg.meta_b +
            `
                    </li>
                    <li class="" >
                    ` +
            leg.meta_c +
            `
                    </li>
                    <li class="" > ` +
            leg.meta_d +
            ` </li>
                </ul>
            </div>
        </div>`;

          if (leg.layover !== undefined) {
            var divText =
              divText +
              `<div class="gws-flights-results__stopover">
                <div class="gws-flights__flex-box">
                    <div>
                    ` +
              leg.layover.time +
              `
                        layover
                    </div>
                    <div aria-hidden="true" class="gws-flights__separator"></div>
                    <div>
                        <div>
                            <span>` +
              leg.layover.city +
              `</span>
                            <span>&nbsp;
                                <span class="gws-flights-results__iata-code" >` +
              leg.layover.code +
              `</span>
                            </span>
                        </div>
                    
                    </div>     
                </div>
              </div>`;
          }
        }
        itemElement.append(divText);
      } else {
        itemElement.append(
          $("<div>")
            .addClass("row s10 m0 p0")
            .append(
              $("<div>")
                .addClass("row m0 capitals text-grey s10 p10-h f700")
                .text("Alternate Itinerary"),
              $("<div>")
                .addClass("col-md-12 p10-h")
                .append(
                  $("<div>")
                    .addClass("col-md-8 p0 f600 text-black")
                    .append(itemData.itin),
                  $("<div>")
                    .addClass("col-md-4 text-right p0")
                    .append(
                      $("<div>")
                        .addClass("f700 text-grey")
                        .text("BASE FARE"),
                      $("<div>")
                        .addClass("text-green f700")
                        .text(itemData.base)
                    )
                ),
              $("<hr />"),
              $("<div>")
                .addClass("col-md-12 p10-h")
                .append(
                  $("<div>")
                    .addClass("col-md-8 p0")
                    .text("Was Reviewed At : " + itemData.wasReviewed),
                  $("<div>")
                    .addClass("col-md-8 p0")
                    .text("Was Available Until : " + itemData.wasAvailableAt)
                ),

              $("<div>")
                .addClass("col-md-12")
                .append(
                  $("<div>")
                    .addClass("col-md-8 bold-text")
                    .text(itemData.afq),
                  $("<div>")
                    .addClass("col-md-4 text-right bold-text")
                    .text(itemData.arc)
                )
            )
        );
      }
    },
    itemTitleTemplate: function(itemData, itemIndex, itemElement) {
      $(itemElement)
        .parent()
        .css("border-color", "#eee");

      itemElement.append(
        $("<div>")
          .addClass("row m0 p0")
          .append(
            $("<div>")
              .addClass("col-md-2 p0 m0")
              .append(
                $("<img>")
                  .attr("src", "img/airlines/" + itemData.airlineLogo + ".png")
                  .attr("height", "42px")
              ),
            $("<div>")
              .addClass("col-md-4 lh1-5  m0 p0")
              .append(
                $("<div>")
                  .addClass("row s10   text-grey f500 p0 m0")
                  .text(itemData.airlinesText),
                $("<div>")
                  .addClass("row s13 f600 text-blue p0 m0")
                  .text(itemData.titleMessage),
                $("<div>")
                  .addClass("row s10   text-grey f500 p0 m0")
                  .text(itemData.viaPoints)
              ),
            $("<div>")
              .addClass("col-md-3 lh1-5   p0 text-center")
              .append(
                $("<div>")
                  .addClass("row s10    text-grey f500 p0 m0")
                  .text("Travel Duration"),
                $("<div>")
                  .addClass("row s13 f600 text-blue p0 m0")
                  .text(itemData.traveltime),
                  $("<div>")
                  .addClass("row s13 f600 text-blue p0 m0")
//                  .html('<a href=\"#\" onclick=\"add_Manual_Fare_entry_screenshot(\'TEST12\');\"> Upload Screenshot<\/a>'),
                  //.html('<a href=\"javascript:void(0)\" onclick=\"pick_fare(\''+itemData.fareId+'\');\"> Pick Option<\/a>'),
//                  $("<div>")
//                  .addClass("row s13 f600 text-blue p0 m0")
//                  .html('<a href=\"#\" onclick=\"viewScreenshot();\"> View Screenshot<\/a>')
              ),
            $("<div>")
              .addClass("col-md-2 lh1-5 text-right p0  m5-r")
              .append(
                $("<div>")
                  .addClass("m0 p0  text-right  pull-right")
                  .append(
                    $("<div>")
                      .addClass("row s10   text-warning f500 ")
                      .text(itemData.fareType),
                    $("<div>")
                      .addClass("row f600 s13 text-green")
                      .text(itemData.amt)
                  )
              )
          )
      );
    }
  });
}
const fareInfo = {
  obj: {
    reasonCode: "B",
    reasonLongText: "Empty Description",
    savings: "8000",
    tmcSavings: "INR 1.76L",
    miles: "706",
    cost: "",
    fares: []
  }
};

const FareCard = ({ miles, tmc, savings, cost, reasonCode }) =>
  h(
    "div",
    {
      class: "col-md-12 p20-v p0-h m0",
      id: "fareCard"
    },
    [
      // h(
      //   "div",
      //   {
      //     class: "col-md-2 p0"
      //   },
      //   [
      //     h(
      //       "div",
      //       {
      //         class: "col-md-3 pull-left p0"
      //       },
      //       h("i", {
      //         class: "fa fa-plane fa-2x text-blue",
      //         "aria-hidden": "true"
      //       })
      //     ),
      //     h(
      //       "div",
      //       {
      //         class: "col-md-9 text-left "
      //       },
      //       [
      //         h(
      //           "div",
      //           {
      //             class: "row s10 text-green f400 capitals m0 p0"
      //           },
      //           "TS ReasonCode"
      //         )
      //         // h(
      //         //   "div",
      //         //   {
      //         //     class: "row bold-text text-primary p0 m0"
      //         //   },
      //         //   reasonCode
      //         // )
      //       ]
      //     )
      //   ]
      // ),
      // h(
      //   "div",
      //   {
      //     class: "col-md-3 p10-h"
      //   },
      //   [
      //     h(
      //       "div",
      //       {
      //         class: "col-md-3 p0"
      //       }
      //       // h("i", {
      //       //   class: "fa fa-rupee fa-2x text-green",
      //       //   "aria-hidden": "true"
      //       // })
      //     ),
      //     h(
      //       "div",
      //       {
      //         class: "col-md-9 p0 "
      //       },
      //       [
      //         h(
      //           "div",
      //           {
      //             class: "row s14 text-grey text-center f400 capitals p0 m0"
      //           },
      //           reasonCode
      //         )
      //         // h(
      //         //   "div",
      //         //   {
      //         //     class: "row bold-text text-left m0"
      //         //   },
      //         //   cost
      //         // )
      //       ]
      //     )
      //   ]
      // ),
      h(
        "div",
        {
          class: "col-md-3 p0 border-left p20-l pull-right"
        },
        [
          h(
            "div",
            {
              class: "col-md-3 p0"
            },
            h("i", {
              class: "fa fa-2x text-green",
              "aria-hidden": "true"
            })
          ),
          h(
            "div",
            {
              class: "col-md-9     p0"
            },
            [
              h(
                "div",
                {
                  class: "row s10 text-green text-     f400 capitals p0 m0"
                },
                "TS Savings"
              ),
              h(
                "div",
                {
                  class: "row bold-text text-left m0"
                },
                savings
              )
            ]
          )
        ]
      ),
      h(
        "div",
        {
          class: "col-md-3 col-md-offset-1 p0 pull-right"
        },
        [
          h(
            "div",
            {
              class: "col-md-3 p0"
            },
            h("i", {
              class: "fa  fa-2x text-blue",
              "aria-hidden": "true"
            })
          ),
          h(
            "div",
            {
              class: "col-md-9 p0"
            },
            [
              h(
                "div",
                {
                  class: "row s10 text-green text-left f400 capitals p0 m0"
                },
                "TMC Savings"
              ),
              h(
                "div",
                {
                  class: "row bold-text text-left m0"
                },
                tmc
              )
            ]
          )
        ]
      )
    ]
  );

const fareARCText = ({ reasonCode, reasonLongText }) =>
  h(
    "div",
    {
      class: "row p20-v m0",
      id: "fareARCText"
    },
    [
      h(
        "h3",
        {
          class: " col-md-offset-1 text-grey capitals s10 p20-v p0-h m0"
        },
        "Remarks"
      ),
      h(
        "div",
        {
          class:
            "text-center col-md-2 p10-v p10-h p0 s24 vcenter f700 text-warning  "
        },
        reasonCode
      ),
      h(
        "div",
        {
          class: "col-md-10 p20-h p20-v gray-bg text-center "
        },
        reasonLongText
      )
    ]
  );

const fareList = ({ fares }) => {
  return h("div", {
    id: "fareList",
    class: "col-md-12  p20  scrollbox-full-box s10 gws-flights__main",
    "data-simplebar": "true",
    "data-simplebar-auto-hide": "false",
    oncreate: () => {
      prepareAccordion(fares);
    },
    onupdate: () => {
      prepareAccordion(fares);
      console.log("update");
    }
  });
};
const FareView = (state, actions) => {

  
  var tmcSavings1 = JSON.stringify(state.obj.tmcSavings);

  var tmcSave = parseFloat(state.obj.tmcSavings);

  console.log("tmcSave :: :: ",tmcSave);



  var tmcSavings2= tmcSavings1.substring(1,tmcSavings1.lastIndexOf("."))

  
if(tmcSave<0.0){
  $("#tmcSavings").html(0);
}else{
  $("#tmcSavings").html(tmcSavings2);
}

  
  $("#tsSavings").html(state.obj.savings);
  
  $("#costSavings").html(state.obj.cost);
  $("#reasonCode").html(state.obj.reasonCode);
  $("#remarks").html(state.obj.reasonLongText);
  
  if (state.obj.reasonCode !== "--") {
    var el = h(fareARCText, {
      reasonCode: state.obj.reasonCode,
      reasonLongText: state.obj.reasonLongText
    });
  }
  else{
    el = ""
  }
  return h(
    "div",
    {
      class: "col-md-12 p0 m0 p10-t"
    },
    [
      // h(
      //   "div",
      //   {
      //     class: "row p0 m0",
      //     id: "fareinfo"
      //   },
      //   [
      //     h(FareCard, {
      //       savings: state.obj.savings,
      //       tmc: state.obj.tmcSavings,
      //       miles: state.obj.miles,
      //       cost: state.obj.cost,
      //       reasonCode: state.obj.reasonCode
      //     }),
      //     el
      //   ]
      // ),
      h(
        "div",
        {
          class: "row m0 p0"
        },
        h(
          "h3",
          {
            class: "s10 capitals text-grey"
          },
          "Available Fare Information"
        )
      ),
      h(
        fareList,
        {
          fares: state.obj.fares
        },
        null
      )
    ]
  );
};

const fareActions = {
  update: value => state => ({
    obj: value
  })
};

const fareApp = app(
  fareInfo,
  fareActions,
  FareView,
  document.getElementById("fareApp")
);
