        var tabs = [{id: 0,text: "Airline" },{ id: 1,text: "Sector"},{ id: 2,text: "Reason Code"},{ id: 3,text: "Failure Code"}];
                
        $("#nc-tabs > .nc-tabs-container").dxTabs({
                                    dataSource: tabs,
                                    selectedIndex: 0,
                                    onItemClick: function(e) {
                                            if(e.itemIndex === 0){
                                                $("#airline-tab").show();
                                                $("#sector-tab").hide();
                                                $("#reason-code-tab").hide();
                                                $("#failure-code-tab").hide();
                                            }
                                            else if(e.itemIndex === 1){
                                                $("#airline-tab").hide();
                                                $("#sector-tab").show();
                                                $("#reason-code-tab").hide();
                                                $("#failure-code-tab").hide();  
                                            }else if(e.itemIndex === 2){
                                                $("#airline-tab").hide();
                                                $("#sector-tab").hide();
                                                $("#reason-code-tab").show(); 
                                                $("#failure-code-tab").hide();
                                            }else if(e.itemIndex === 3){
                                                $("#airline-tab").hide();
                                                $("#sector-tab").hide();
                                                $("#reason-code-tab").hide();  
                                                $("#failure-code-tab").show();
                                            }
                                    }}).dxTabs("instance");

        function filterData(arr,prop){
            if(!arr) return undefined;
            arr =  arr.filter((val,index)=>{
                return parseInt(val.TS_Savings) > 0; 
            })  
            return arr.length > 0 ? arr : undefined;
        }

        function customHeader(header,info){
            $("<span>")
                .html(info.column.caption)
                .addClass("dashboardGridHeader")
                .appendTo(header);
        }

        function emptyDiv(id) {
            $(id).empty();
        }

        function formatLegendDiv(legendID1,legendID2){
            let domLegendHeight =  $(legendID1+'> svg').height();
            let intLegendHeight =  $(legendID2+'> svg').height();
            let max = domLegendHeight > intLegendHeight ? domLegendHeight : intLegendHeight;
            max = (50 + max )+ 'px';
            if($(legendID1)) $(legendID1).css('height',max);
            if($(legendID2)) $(legendID2).css('height',max);
        }

        function formatCabinChartData(data){
            if(!data) return null;

            data = data.map((val,index)=>{
                                    if(val["Cabin_Class"].toUpperCase().includes("BUSINESS")){  
                                            val["BUSINESS"] = "CLASS";
                                            val["Cabin_Class"] = "BUSINESS";
                                    }
                                    if(val["Cabin_Class"].toUpperCase().includes("ECONOMY")){
                                            val["ECONOMY"] = "CLASS";
                                            val["Cabin_Class"] = "ECONOMY";
                                        }
                                    return val;
                                })
            let obj1 = {"Cabin_Class":"ECONOMY","SavingShare":0,"SavingsPercent":0,"TS_Savings":0,"Tot_Amt":0,"tktCount":0,"alias":"ECO"};
            let obj2 = {"Cabin_Class":"BUSINESS","SavingShare":0,"SavingsPercent":0,"TS_Savings":0,"Tot_Amt":0,"tktCount":0,"alias":"BIZ"};

            for(let obj of data){
                if(obj.ECONOMY){
                    obj1["SavingShare"] += Number(obj["SavingShare"]);
                    obj1["SavingsPercent"] += Number(obj["SavingsPercent"]);
                    obj1["TS_Savings"] += Number(obj["TS_Savings"]);
                    obj1["Tot_Amt"] += Number(obj["Tot_Amt"]);
                    obj1["tktCount"] += Number(obj["tktCount"]);
                }
                if(obj.BUSINESS){
                  obj2["SavingShare"] += Number(obj["SavingShare"]);
                    obj2["SavingsPercent"] += Number(obj["SavingsPercent"])
                    obj2["TS_Savings"] += Number(obj["TS_Savings"])
                    obj2["Tot_Amt"] += Number(obj["Tot_Amt"])
                    obj2["tktCount"] += Number(obj["tktCount"])   
                }
             }
             
            data = [];
            data.push(obj1);
            data.push(obj2);
            return filterData(data);
        }

        function getMetricCharts(custName,filter_input,dataLoadType){
            var url;
            var legends;
            url ='count_pnr.php';
            if(dataLoadType=='pnr' || dataLoadType=='Pnr'){
                legends = "PNR"
            }else{
//                url ='count.php';
                legends = "Tickets"
            }
            
            $.ajax({
                type: "post",
                url: url,
                data: {
                    "audit-from" : filter_input['startDate'],
                    "audit-to" : filter_input['endDate'],
                    "customer": custName,
                    "dataLoadType": dataLoadType
                },
                success: function(data) {
                    
                    var countdata = JSON.parse(data);                    
                    var metricDomSource = [
                                { action: "Total "+legends, count: countdata.domTotalCount ? countdata.domTotalCount : 0 },
                                { action: legends+" Processed", count: countdata.domProcessedCount ? countdata.dominscopeCount  : 0},
                                { action: "Inscope", count: countdata.dominscopeCount ? countdata.dominscopeCount : 0},
                                { action: "Non Compliant", count: countdata.domNCCount ? countdata.domNCCount : 0 }
                                 ];

                                var metricIntSource = [
                                { action: "Total "+legends, count: countdata.intlTotalCount ? countdata.intlTotalCount : 0 },
                                { action: legends+" Processed", count: countdata.intlProcessedCount ? countdata.intlProcessedCount  :  0},
                                { action: "Inscope", count: countdata.intlinscopeCount ? countdata.intlinscopeCount : 0},
                                { action: "Non Compliant", count: countdata.intlNCCount ? countdata.intlNCCount : 0 }
                            ];        
                                function getValues(arr){
                                     return arr.map((val,index)=>{
                                        return  val.count ? val.count : 0;
                                    })
                                }

                                function getMaxValue(arr){
                                    return Math.max.apply(Math, arr.map(function(o) { return o.count; }));
                                }


                                let tempArr = [];
                                tempArr = metricDomSource.filter((obj)=>{
                                    return obj.count > 0;
                                })
                                let metricDom = 'metric-dom',metricInt = 'metric-int'; 
                                if(tempArr.length > 0){
                                    $("#"+metricDom).empty();
                                    $('#'+metricDom).append(createDiv(metricDom+'-viz'));
                                    $("#"+metricDom+"-viz").dxBarGauge({
                                            palette:colorPalette,
                                            startValue: 0,
                                            endValue: getMaxValue(metricDomSource),
                                            values: getValues(metricDomSource),
                                            tooltip: {
                                                enabled: true,
                                                customizeTooltip: function (arg) {
                                                    return {
                                                        text:  metricDomSource[arg.index].action + " - " + arg.valueText
                                                    };
                                                }
                                            },
                                            label: {
                                                 format: {
                                                type: "fixedPoint",
                                                precision: 0
                                            },
                                                 backgroundColor : "none",
                                                 position  : 'inside',
                                                indent: 30,
                                                font :{size : 14},
                                                customizeText: function (arg) {
                                                    return arg.valueText + "";
                                                }
                                            }
                                        });

                                    $("#metricDomLegend").empty();
                                    $("#metricDomLegend").append($.map(metricDomSource, function (obj,index) {
                                                 return $("<div class='colorBox' style='background:"+colorPalette[index]+"'></div><span style='margin-left:10px'>"+obj.action+"</span>");
                                    }));
                                }
                                else {
                                    $("#metricDomLegend").empty();
                                    showNoDataFound(metricDom);
                                }

                                tempArr = metricIntSource.filter((obj)=>{
                                    return obj.count > 0;
                                })

                                if(tempArr.length > 0){
                                    $("#"+metricInt).empty();
                                    $('#'+metricInt).append(createDiv(metricInt+'-viz'));
                                    $("#"+metricInt+"-viz").dxBarGauge({
                                        palette:colorPalette,
                                        startValue: 0,
                                        endValue: getMaxValue(metricIntSource) ,
                                        values: getValues(metricIntSource),
                                        tooltip: {
                                            enabled: true,
                                            customizeTooltip: function (arg) {
                                                return {
                                                    text:  metricIntSource[arg.index].action + " - " + arg.valueText
                                                };
                                            }
                                        },
                                        label: {
                                             format: {
                                            type: "fixedPoint",
                                            precision: 0
                                            },
                                            font :{size : 14},
                                            indent: 30,
                                            customizeText: function (arg) {
                                                return arg.valueText +'' ;
                                            }
                                        }
                                    });
                                    $("#metricIntLegend").empty();
                                    $("#metricIntLegend").append($.map(metricIntSource, function (obj,index) {
                                                    return $("<div class='colorBox' style='background:"+colorPalette[index]+"'></div><span style='margin-left:10px'>"+obj.action+"</span>");
                                    }));
                                }
                                else {
                                    $("#metricIntLegend").empty();
                                    showNoDataFound(metricInt);
                                }
                                
                            

//                            if(dataLoadType.toLowerCase()==='pnr')
//                                return;
                                // rightnav
                                var topSector = '-';
                                var msgNoData = "-";
                                let domNCCount = 0;
                                let intlNCCount = 0;
                                console.log(countdata.domNCCount+'dom');
                                console.log(countdata.intlNCCount+'int');
                                domNCCount = countdata.domNCCount ? parseInt(countdata.domNCCount) : 0;
                                intlNCCount = countdata.intlNCCount ? parseInt(countdata.intlNCCount) : 0;
                                if(domNCCount > intlNCCount){
                                    // topSector = 'Domestic '+ domNCCount;
                                    topSector = '<label class="text-navy">Domestic</label>';
                                }
                                else if(intlNCCount > domNCCount){
                                    // topSector = 'International '+ intlNCCount;
                                    topSector = 'Both <label class="text-navy">Domestic</label> and <label class="text-blue">International</label> are same';
                                }
                                else  if(domNCCount == intlNCCount){
                                    topSector = 'Both Domestic<label class="text-blue">International</label>';   
                                }
                                else{
                                    topSector = 'None';
                                }
                                $('#audit-deliver-saving').empty();
                                $('#audit-deliver-saving').append(countdata.savingPercent ? `<label class='text-green'>${countdata.savingPercent}</label>` : msgNoData);
                                $('#top-nc-sector').empty();
                                $('#top-nc-sector').append(topSector);
                                
                                $('#nc-perdom').text(countdata.domTSSavings ? countdata.domNCPer : msgNoData);
                                $('#nc-perint').text(countdata.intlTSSavings ? countdata.intlNCPer : msgNoData);
                                
                                $('#total-savings-dom').text(countdata.domTSSavings ? formatValue(defaultLocale,defaultCurrency,countdata.domTSSavings) : msgNoData);
                                $('#total-savings-int').text(countdata.intlTSSavings ? formatValue(defaultLocale,defaultCurrency,countdata.intlTSSavings) : msgNoData);
                                
                                $('#total-savingper-dom').text(countdata.domSavingsPer ? countdata.domSavingsPer  : msgNoData);
                                $('#total-savingper-int').text(countdata.intlSavingsPer ? countdata.intlSavingsPer : msgNoData);
                                
                                $('#corporate-fare-dom').text((countdata.domFareTypeCount ? countdata.domFareTypeCount : msgNoData));
                                $('#corporate-fare-int').text(countdata.intlFareTypeCount ? countdata.intlFareTypeCount : msgNoData);
                                
                                $('#avg-adv-pur-dom').text(countdata.domadvPurchase ? Math.round(countdata.domadvPurchase) + ' Days' : msgNoData);
                                $('#avg-adv-pur-int').text( countdata.intladvPurchase ? Math.round(countdata.intladvPurchase) + ' Days' : msgNoData);

                                }
                            });
        }
        function getAirlineCharts(custName,filter_input,dataLoadType) {
                            var url = 'apis/audit/audit_nc_airline.php';
                            $.ajax({
                                type: "post",
                                url: url,
                                data: {
                                    "audit-from" : filter_input['startDate'],
                                    "audit-to" : filter_input['endDate'],
                                    customer: custName,
                                    "dataLoadType": dataLoadType
                                },
                                success: function(data) {
                                    var airlinedata = JSON.parse(data);

                                    var domColorPallete = [],intColorPallete = [];
                              
                                    let domId = 'dom-airline',intId = 'int-airline';

                                    if(airlinedata.dom.length > 0){
                                        airlinedata.dom.map((val,index)=>{
                                            domColorPallete.push(airLineColorObj[val["Airline_Code"]])
                                           })
                                        $('#'+domId).empty();
                                        $('#'+domId).append(createDiv(domId+'-viz'));
                                        $("#"+domId+'-viz').dxPieChart({
                                                resolveLabelOverlapping: "shift",
                                              tooltip: {
                                                enabled: true,
                                                customizeTooltip: function (arg) {

                                                    let text =  'Airline : '+arg.point.data.Airline_Code +' ('+ arg.percentText+')<br>' + 
                                                                'Savings : '+arg.point.data.SavingsPercent + '%<br>'+
                                                                'Savings : '+formatValue(defaultLocale,defaultCurrency,arg.point.data.Savings) + '<br>' +
                                                                'Spends : '+formatValue(defaultLocale,defaultCurrency,arg.point.data['TotalSpend']) + '<br>' + 
                                                                'NC-TRX # : '+arg.point.data.NCCount + '<br>';
                                                     
                                                    return {
                                                        html : text
                                                        };
                                                    }
                                                },
                                                palette: domColorPallete,
                                                dataSource: airlinedata.dom,
                                                legend: {
                                                       horizontalAlignment: "center",
                                                    verticalAlignment: "bottom",
                                                    customizeText : function (arg,a){
                                                        return arg.pointName ;
                                                    }
                                                },
                                                "export": {
                                                    enabled: false
                                                },
                                                series: [{
                                                    argumentField: "Airline_Code",
                                                    valueField: "SavingShare",
                                                    label: {
                                                        visible: true,
                                                         backgroundColor : "none",
                                                 position  : 'inside',
                                                        connector: {
                                                            visible: true,
                                                            width: 0.5
                                                        },
                                                        customizeText: function (arg) {
                                                          

                                                    // let text =  'Airline : '+ arg.point.data.Airline_Code  +' ('+ arg.percentText+')<br>'  
                                                    //             + 'Savings : ' + arg.point.data.SavingsPercent + '%<br>'
                                                    //             + 'Savings : ' + formatValue(defaultLocale,defaultCurrency,arg.point.data.Savings) + '<br></span>'
                                                    //             + 'Spend : '+formatValue(defaultLocale,defaultCurrency,arg.point.data.TotalSpend)+ '<br>' 
                                                    //             + 'NC-TRX # : '+arg.point.data.NCCount + '<br>' ;
                                                    //            return text;
                                                                                                          return  arg.percentText;

                                                        }
                                                    }
                                                }]
                                            });
                                    }
                                    else 
                                        showNoDataFound(domId);

                                    if(airlinedata.int.length > 0){
                                          airlinedata.int.map((val,index)=>{
                                            intColorPallete.push(airLineColorObj[val["Airline_Code"]])
                                           })
                                            $('#'+intId).empty();
                                            $('#'+intId).append(createDiv(intId+'-viz'));
                                            $("#"+intId+'-viz').dxPieChart({
                                                resolveLabelOverlapping: "shift",
                                                tooltip: {
                                                enabled: true,
                                                customizeTooltip: function (arg) {

                                                    let text =  'Airline : '+arg.point.data.Airline_Code +' ('+ arg.percentText+')<br>' + 
                                                                'Savings : '+arg.point.data.SavingsPercent + '%<br>'+
                                                                'Savings : '+formatValue(defaultLocale,defaultCurrency,arg.point.data.Savings) + '<br>' +
                                                                'Spends : '+formatValue(defaultLocale,defaultCurrency,arg.point.data['TotalSpend']) + '<br>' + 
                                                                'NC-TRX # : '+arg.point.data.NCCount + '<br>';
                                                     
                                                    return {
                                                        html : text
                                                        };
                                                    }
                                                },
                                                palette: intColorPallete,
                                                dataSource: airlinedata.int,
                                                legend: {
                                                       horizontalAlignment: "center",
                                                    verticalAlignment: "bottom",
                                                    customizeText : function (arg,a){
                                                        return arg.pointName ;
                                                    }
                                                },
                                                "export": {
                                                    enabled: false
                                                },
                                                series: [{
                                                    argumentField: "Airline_Code",
                                                    valueField: "SavingShare",
                                                    label: {
                                                        visible: true,
                                                         backgroundColor : "none",
                                                 position  : 'inside',
                                                        connector: {
                                                            visible: true,
                                                            width: 0.5
                                                        },
                                                        customizeText: function (arg) {
                                                              // let text = 'Airline : ' + arg.point.data.Airline_Code  +' ('+ arg.percentText+')<br>' 
                                                              //   + 'Savings : ' + arg.point.data.SavingsPercent + '%<br>'
                                                              //   + 'Savings : ' + formatValue(defaultLocale,defaultCurrency,arg.point.data.Savings) + '<br></span>'
                                                              //   + 'Spend : '+formatValue(defaultLocale,defaultCurrency,arg.point.data.TotalSpend)+ '<br>' 
                                                              //   + 'NC-TRX # : '+arg.point.data.NCCount + '<br>' ;
                                                              //  return text;
                                                                                                                    return  arg.percentText;

                                                        }
                                                    }
                                                }]
                                            });
                                        }
                                    else 
                                        showNoDataFound(intId);
                                    
                                },
                                error: function() {
                                    alert('Request Failed.')
                                }
                            });
        }
        

        function getSectorChart(custName,filter_input,dataLoadType){
            var url = 'apis/audit/audit_nc_sector.php';
            $.ajax({
                type: "post",
                url: url,
                data: {
                     "audit-from" : filter_input['startDate'],
                     "audit-to" : filter_input['endDate'],
                    customer: custName,
                    "dataLoadType": dataLoadType
                },
                success: function(data) {        
                    var airlinedata = JSON.parse(data);

                    let domId = 'dom-sector',intId  = 'int-sector';
                    if(airlinedata.dom.length > 0  ){
                        $('#'+domId).empty();
                        $('#'+domId).append(createDiv(domId+'-viz'));
                        drawSectorVis('#'+domId+'-viz',airlinedata.dom);  
                    }   
                    else {
                            showNoDataFound(domId);
                        }

                    if(airlinedata.int.length > 0  ){
                            $('#'+intId).empty();
                            $('#'+intId).append(createDiv(intId+'-viz'));
                            drawSectorVis('#'+intId+'-viz',airlinedata.int);
                        }
                    else 
                        showNoDataFound(intId)
                },
                error: function() {
                    alert('Request Failed.')
                }
            });
        }

        function getRCCharts(custName,filter_input,dataLoadType){
            var url = 'apis/audit/audit_nc_reason.php';
            $.ajax({
                type: "post",
                url: url,
                data: {
                    "audit-from" : filter_input['startDate'],
                    "audit-to" : filter_input['endDate'],
                    customer: custName,
                    "dataLoadType": dataLoadType
                },
                success: function(data) {        
                    var airlinedata = JSON.parse(data);

                    airlinedata.dom = airlinedata.dom.filter((val,index)=>{
                        return val.Reasoncode !== 'NA'; 
                    })

                    airlinedata.int = airlinedata.int.filter((val,index)=>{
                        return val.Reasoncode !== 'NA'; 
                    })
                    let domId = 'dom-reason',intId = 'int-reason';
                    if(airlinedata.dom.length > 0){
                        $("#"+domId).empty();
                        $('#'+domId).append(createDiv(domId+'-viz'));
                        $("#"+domId+'-viz').dxPieChart({
                                            resolveLabelOverlapping: "shift",
                                          tooltip: {
                                            enabled: true,
                                            customizeTooltip: function (arg) {

                                                let text =  'Reason Code: '+arg.point.data.Reasoncode + ' ('+arg.percentText+')<br>' + 
                                                            'Savings : '+arg.point.data.SavingsPercent + '%<br>' +
                                                            'Savings : '+formatValue(defaultLocale,defaultCurrency,arg.point.data.Savings) + '<br>' + 
                                                            'Spends : '+formatValue(defaultLocale,defaultCurrency,arg.point.data['TotalSpend']) + '<br>' + 
                                                            'NC-TRX # : '+arg.point.data.NCCount + '<br>'   ;
                                                 
                                                return {
                                                    html : text
                                                    };
                                                }
                                            },
                                            palette: colorPalette,
                                            dataSource: airlinedata.dom,
                                            legend: {
                                                   horizontalAlignment: "center",
                                                verticalAlignment: "bottom",
                                                customizeText : function (arg,a){
                                                    return arg.pointName + " : " + airlinedata.dom[arg.pointIndex].Description;
                                                }
                                            },
                                            "export": {
                                                enabled: false
                                            },
                                            series: [{
                                                argumentField: "Reasoncode",
                                                valueField: "Tickets",
                                                label: {
                                                    visible: true,
                                                     backgroundColor : "none",
                                                 position  : 'inside',
                                                    connector: {
                                                        visible: true,
                                                        width: 0.5
                                                    },
                                                    customizeText: function (arg) {
                                                        return  arg.percentText;
                                                    }
                                                }
                                            }]
                                        });
                        
                    }
                    else 
                        showNoDataFound(domId);
                    if(airlinedata.int.length > 0)
                    {
                        $("#"+intId).empty();
                        $('#'+intId).append(createDiv(intId+'-viz'));
                        $("#"+intId+'-viz').dxPieChart({
                                        resolveLabelOverlapping: "shift",
                                        palette: colorPalette,
                                        dataSource: airlinedata.int,
                                        tooltip: {
                                            enabled: true,
                                            customizeTooltip: function (arg) {

                                                        let text =  'Reason Code: '+arg.point.data.Reasoncode +' ('+arg.percentText+')<br>' +  
                                                            'Savings : '+arg.point.data.SavingsPercent + '%<br>' +
                                                            'Savings : '+formatValue(defaultLocale,defaultCurrency,arg.point.data.Savings) + '<br>' + 
                                                            'Spends : '+formatValue(defaultLocale,defaultCurrency,arg.point.data['TotalSpend']) + '<br>' + 
                                                            'NC-TRX # : '+arg.point.data.NCCount + '<br>' ;
                                                 return {
                                                    html : text
                                                };
                                            }
                                        },
                                        legend: {
                                            horizontalAlignment: "center",
                                            verticalAlignment: "bottom",
                                            customizeText : function (arg,a){

                                                return arg.pointName + " : " + airlinedata.int[arg.pointIndex].Description;
                                            }
                                        },
                                        "export": {
                                            enabled: false
                                        },
                                        series: [{
                                            argumentField: "Reasoncode",
                                            valueField: "Tickets",
                                            label: {
                                                visible: true,
                                                 backgroundColor : "none",
                                                 position  : 'inside',
                                                connector: {
                                                    visible: true,
                                                    width: 0.5
                                                },
                                                customizeText: function (arg) {
                                                          return  arg.percentText ;
                                                }
                                            }
                                        }]
                                    });
                    }
                    else 
                        showNoDataFound(intId);
                },
                error: function() {
                    alert('Request Failed.')
                }
            });
        }

        function getFCCharts(custName,filter_input,dataLoadType){
            var url = 'apis/audit/audit_nc_failure.php';
            $.ajax({
                type: "post",
                url: url,
                data: {
                     "audit-from" : filter_input['startDate'],
                     "audit-to" : filter_input['endDate'],
                    customer: custName,
                    "dataLoadType": dataLoadType
                },
                success: function(data) {        
                    var airlinedata = JSON.parse(data);
                    // airlinedata.dom = airlinedata.dom ? filterData(airlinedata.dom) : undefined;
                    // airlinedata.int =  airlinedata.int ? filterData(airlinedata.int) : undefined;
                        let chartId = 'failure-stack-chart';
                        if(airlinedata.dom.length > 0 || airlinedata.int.length > 0){
                        let domData = airlinedata.dom;

                        let indigoDomData = domData.filter((val)=>(
                                val.Airline_Code ==='6E'
                            ))

                        let jetDomData = domData.filter((val)=>(
                                val.Airline_Code ==='9W'
                            ))

                        let domObj = {TripType : 'Domestic'};
                        let intObj = {TripType : 'International'};
                        let seriesObj = {};
                        var seriesArr = [];

                        airlinedata.dom.map((val)=>{
                            val.NCCount = parseInt(val.NCCount);
                            if(!seriesObj[val.Reasoncode])
                            {
                                seriesObj[val.Reasoncode] = 'field';
                                seriesArr.push({
                                    "valueField" : val.Reasoncode,
                                    "name" : val.Reasoncode,
                                    "description" : val.Description
                                })
                            }
                            domObj[val.Reasoncode] = val.NCCount;
                            domObj[val.Reasoncode+'data'] =  {};
                            domObj[val.Reasoncode+'data']['TotalSpend'] = val['TotalSpend'];
                            domObj[val.Reasoncode+'data']['NCCount'] = val['NCCount'];
                            domObj[val.Reasoncode+'data']['Savings'] = val['Savings'];
                            domObj[val.Reasoncode+'data']['SavingsPercent'] = val['SavingsPercent'];
                        });

                          airlinedata.int.map((val)=>{
                            val.NCCount = parseInt(val.NCCount);
                            if(!seriesObj[val.Reasoncode])
                            {
                                seriesObj[val.Reasoncode] = 'field';
                                seriesArr.push({
                                    "valueField" : val.Reasoncode,
                                    "name" : val.Reasoncode,
                                    "description" : val.Description
                                })
                            }
                            
                                intObj[val.Reasoncode] = val.NCCount;
                            intObj[val.Reasoncode+'data'] =  {};
                            intObj[val.Reasoncode+'data']['TotalSpend'] = val['TotalSpend'];
                            intObj[val.Reasoncode+'data']['NCCount'] = val['NCCount'];
                            intObj[val.Reasoncode+'data']['Savings'] = val['Savings'];
                            intObj[val.Reasoncode+'data']['SavingsPercent'] = val['SavingsPercent'];
                           
                        });
                    
                        $("#"+chartId).empty();
                        $('#'+chartId).append(createDiv(chartId+'-viz'));
                        $("#"+chartId+'-viz').dxChart({
                            palette: colorPalette,
                            dataSource: [domObj,intObj],
                                tooltip: {
                                        enabled: true,
                                        customizeTooltip: function (arg) {
                                                    let text =  
                                                        'Reason Code: '+arg.seriesName + '('+arg.percentText +')<br>' +
                                                        'Savings : '+arg.point.data[arg.seriesName+'data']['SavingsPercent'] + '%<br>' +
                                                        'Savings : '+formatValue(defaultLocale,defaultCurrency,arg.point.data[arg.seriesName+'data']['Savings']) + '<br>' + 
                                                        'Spends : '+formatValue(defaultLocale,defaultCurrency,arg.point.data[arg.seriesName+'data']['TotalSpend']) + '<br>' + 
                                                        'NC-TRX # : '+arg.point.data[arg.seriesName+'data']['NCCount'] + '<br>' ;
               
                                        return {
                                                html : text
                                            };
                                        }
                                    },
                                     legend: {
                                               horizontalAlignment: "center",
                                            verticalAlignment: "bottom",
                                            customizeText : function (arg,a){

                                            let description = {
                                                'AL' : 'Alternate Airline',
                                                'NS' : 'Non Issuance of Separate Tickets',
                                                'SL' : 'Same Airline',
                                                'NC' : 'Non Issuance of Combined Ticket'
                                            };

                                            let failurCode = arg.seriesName.split(',');
                                            let descStr = '';
                                                failurCode.map((code,index)=>{
                                                    let suffix = '';
                                                    if((failurCode.length-1) == index)
                                                        suffix = ''
                                                    else if((failurCode.length-1) > index)
                                                        suffix = ' & ';
                                                    else
                                                        suffix = ' , ';
                                                    descStr += description[code]+suffix;
                                                })


                                                return arg.seriesName + " : " + descStr ;
                                            }
                                        },
                            commonSeriesSettings: {
                                argumentField: "TripType",
                                type: "fullStackedBar",
                               label: {
                                             format: {
                                            type: "fixedPoint",
                                            precision: 0},
                                                            visible: true,
                                            indent: 30,
                                            font :{size : 14},
                                            customizeText: function (arg) {
                                                let text = arg;
                                                return arg.percentText + "";
                                            }
                                        },
                              
                            },
                            series: seriesArr,
                        });
                    }
                    else
                         showNoDataFound('failure-stack-chart')
                  
                },
                error: function() {
                    alert('Request Failed.')
                }
            });
        }
     


        function drawPieVis(id,data,mAxis){
            $(`${id} > svg `).remove();
            var margin = {top: 15, right: 10, bottom: 5, left: 40},
                width = ($(id).width()*.92) - margin.left - margin.right,
                height = ($(id).height()* 1) - margin.top - margin.bottom;

            var radius = Math.min(width, height) / 2 - margin.bottom,
                innerRadius = 0.25 * radius;

            var pie = d3.pie()
                                .sort(null)
                                .value(function (d) {
                                  return d.SavingShare;
                                });

            var pied_data = pie(data);
            var innerArc = d3.arc()
                            .innerRadius(innerRadius)
                            .outerRadius(function (d) {
                              return (radius - innerRadius) * (d.data.SavingShare / mAxis) + innerRadius;
                            });

            var outlineArc = d3.arc()
                                .innerRadius(innerRadius)
                                .outerRadius(radius);

            var svg = d3.select(id).append('svg')
                                    .attr('class', id+'pie')
                                    .attr("width", width * 2)
                                    .attr("height", height * 1.3)
                                    // .attr("transform", "translate(" + (width / 2 + (margin.left * 2)) + "," + ((height) / 2 +  margin.top) + ")");
                                    

            var pieSVG = svg.append("g")
                            .attr("class","pie-g")
                            .attr("transform", "translate(" + (width / 2 + (margin.left * 6)) + "," + ((height) / 2 +  margin.top) + ")");

            svg.append("g")
                .attr("class", "pie-labels")
                .attr("id",'pie-labels')
                .attr("transform", "translate(" + (width / 2 + (margin.left * 6)) + "," + ((height) / 2 +  margin.top) + ")");

            svg.append("g")
                .attr("class", "pie-lines")
                .attr("id",'pie-lines')
                .attr("transform", "translate(" + (width / 2 + (margin.left * 6)) + "," + ((height) / 2 +  margin.top) + ")");

            var innerPath = pieSVG.selectAll(".innerPath")
                            .data(pied_data)
                            .enter().append("path")
                            .attr("fill", function(d) { 
                                d.data['color'] = airLineColorObj[d.data.Airline_Code] ?airLineColorObj[d.data.Airline_Code] :'#000' ;  
                                return airLineColorObj[d.data.Airline_Code]; })
                            .attr("class", "innerPath")
                            .attr("d", innerArc)
                            .on("mouseover", function (d) {

                                let tooltipText = d.data.Airline_Code + ' : ' + d.data.SavingShare + '% <br>' 
                                                + 'Spend: '+formatValue(defaultLocale,defaultCurrency,d.data.TotalSpend)+ '<br>' 
                                                + 'NC TRX#: '+d.data.NCCount + '<br>' 
                                                + 'Savings: ' + formatValue(defaultLocale,defaultCurrency,d.data.Savings) + '<br>'
                                                + 'Savings: ' + d.data.SavingsPercent + ' % <br>';
                                 $("#tooltip")
                                    .css('background-color',d.data.color)
                                    .css("left", d3.event.pageX + "px")
                                    .css("top", d3.event.pageY + "px")
                                    .css("opacity", 1);
                                $("#tooltip #content").empty()
                                    .append(tooltipText);
                            })
                            .on("mouseout", function(d) {
                                   d3.select("#tooltip")
                                    .style("opacity", 0);
                            });

            var outerPath = pieSVG.selectAll(".outerPath")
                                .data(pied_data)
                                .enter().append("path")
                                .attr("class", "outerPath")
                                .attr("d", outlineArc);
              
            //Append Legend 'G' Element
                        
            
            drawPieLegend(svg,id,pied_data,innerArc,radius);
        }       

        function drawPieLegend(svg,svgID,pied_data,innerArc,radius){
            // var radius = 170;
            function midAngle(d) {
                return d.startAngle + (d.endAngle - d.startAngle) / 2;
            }

             var outerArc = d3.arc()
                .outerRadius(radius + 10)
                .innerRadius(radius + 20);

            var arc = innerArc;

            var polyline = svg.select('.pie-lines')
                .selectAll('polyline')
                .data(pied_data)
              .enter().append('polyline')
              .attr('stroke',function(d){
                                        return d.data.color;
                                    })
                .attr('points', function(d) {
                    // see label transform function for explanations of these three lines.
                    var pos = outerArc.centroid(d);
                    pos[0] = radius * 0.95 * (midAngle(d) < Math.PI ? 1 : -1);
                    return [arc.centroid(d), outerArc.centroid(d), pos]
                });
        

         var labels =    svg.select('.pie-labels').selectAll('foreignObject')
                .data(pied_data)
              .enter().append('foreignObject')
                .attr('dy', '.35em')
                .attr('height','55')
                .attr('width','400')
                .html(function(d) {
                    return ('<span class="label-aster"> <img height="60" width="100" style="margin-top: -45px;" src="img/airlines/'+d.data.Airline_Code+'.png"></img></span><span style="background: lightgrey;" class="label-aster">'+
                    d.data.Airline_Code + ' : ' + d.data.SavingShare + '% <br>' 
                                + 'Spend : '+formatValue(defaultLocale,defaultCurrency,d.data.TotalSpend)+ '<br>' 
                                + 'NC TRX#: '+d.data.NCCount + '<br>' 
                                + 'Savings : ' + formatValue(defaultLocale,defaultCurrency,d.data.Savings) + '<br></span>');
                })
                .attr('x', function(d) {
                    var pos = outerArc.centroid(d);
                    pos[0] = radius * 0.95 * (midAngle(d) < Math.PI ? 1 : -1);
                    return pos[0] < 0 ? pos[0] - 250 : pos[0] + 10  ;
                })
                .attr('y', function(d) {
                    var pos = outerArc.centroid(d);
                    pos[0] = radius * 0.95 * (midAngle(d) < Math.PI ? 1 : -1);
                    return pos[1]- 60;
                })
                .style('text-anchor', function(d) {
                    return (midAngle(d)) < Math.PI ? 'start' : 'end';
                });
 
            console.log('value',labels);
         }

        function getTransformation(transform) {
                /*
                 * This code comes from a StackOverflow answer to a question looking
                 * to replace the d3.transform() functionality from v3.
                 * http://stackoverflow.com/questions/38224875/replacing-d3-transform-in-d3-v4
                 */
                var g = document.createElementNS("http://www.w3.org/2000/svg", "g");

                g.setAttributeNS(null, "transform", transform);
                var matrix = g.transform.baseVal.consolidate()
                    .matrix;

                var {
                    a,
                    b,
                    c,
                    d,
                    e,
                    f
                } = matrix;
                var scaleX, scaleY, skewX;
                if (scaleX = Math.sqrt(a * a + b * b)) a /= scaleX, b /= scaleX;
                if (skewX = a * c + b * d) c -= a * skewX, d -= b * skewX;
                if (scaleY = Math.sqrt(c * c + d * d)) c /= scaleY, d /= scaleY, skewX /= scaleY;
                if (a * d < b * c) a = -a, b = -b, skewX = -skewX, scaleX = -scaleX;
                return {
                    translateX: e,
                    translateY: f,
                    rotate: Math.atan2(b, a) * Math.PI / 180,
                    skewX: Math.atan(skewX) * Math.PI / 180,
                    scaleX: scaleX,
                    scaleY: scaleY
                };
        }




        function drawSectorVis(targetDiv,data){   
            $(`${targetDiv} > svg `).remove();
            // set the dimensions and margins of the graph
            var margin = {top: 20, right: 20, bottom: 30, left: 40},
                width = 660 - margin.left - margin.right,
                height = 300 - margin.top - margin.bottom;

            let max1 = 0,max2 = 0;

            var showToolTip = function(d,i){
                                let tooltipText = 'Sector : ' + d.TicketSector + ' ('+d.SavingShare+'%)<br>'
                                                + 'Savings : ' + d.SavingsPercent + ' % <br>'
                                                + 'Savings : ' + formatValue(defaultLocale,defaultCurrency,d.Savings) + '<br>' 
                                                + 'Spend: '+formatValue(defaultLocale,defaultCurrency,d.TotalSpend)+ '<br>' 
                                                + 'NC-TRX # : '+d.NCCount + '<br>' 
                                 $("#tooltip")
                                    .css('background-color','#ffffff')
                                    .css("left", d3.event.pageX + "px")
                                    .css("top", d3.event.pageY + "px")
                                    .css("color","#232323")
                                    .css("opacity", 1);
                                $("#tooltip #content").empty()
                                    .append(tooltipText);
            }

            var hideToolTip = function(d){
                                   d3.select("#tooltip")
                                    .style("opacity", 0);
            }

            data.map((val,index)=>{
                val.Savings = parseInt(val.Savings);
                if(val.Savings > max1){
                    max1 = val.Savings;
                } 
            })



            // set the ranges
            var x = d3.scaleBand()
                      .range([0, width])
                      .padding(0.1);
            var y = d3.scaleLinear()
                      .range([height, 0]);



        // append the svg object to the body of the page
        // append a 'group' element to 'svg'
        // moves the 'group' element to the top left margin
        var svg = d3.select(targetDiv).append("svg")
            .attr("width", width + margin.left + margin.right)
            .attr("height", height + margin.top + margin.bottom+100)
            .attr("transform", 
                  "translate(" + 0 + "," + 40 + ")");

        var barGEle = svg.append("g")
                        .attr("width", width + margin.left + margin.right)
                        .attr("height", height + margin.top + margin.bottom)
                         .attr("transform", "translate(" + 0 + "," + 45 + ")");;

        var barTopGEle =  svg.append("g")
                              .attr('class','top-g-ele')
                               .attr("transform", "translate(" + 0 + "," + 45 + ")");;


        var barBottomGEle =  svg.append("g")
                                .attr('class','bottom-g-ele')
                               .attr("transform", "translate(" + 0 + "," + 400 + ")");;


        var barTextGEle =  svg.append("g")
                              .attr("width", width + margin.left + margin.right)
                              .attr("height", height + margin.top + margin.bottom)
                               .attr("transform", "translate(" + 0 + "," + 50 + ")");;




        x.domain(data.map(function(d) { return d.TicketSector; }));
        y.domain([0, d3.max(data, function(d) { return parseInt(d.Savings); })]);       



          // append the rectangles for the bar chart
        barGEle.selectAll(".bar")
            .data(data)
            .enter().append("rect")
            .attr("class", "bar")
            .attr("id",function(d,i){
                return 'bar-'+d.TicketSector+'-' + i;
            })
            .attr("fill",function(d,i){
                return i % 2 === 0 ? '#2e497b':'#55b04a';
            })
            .attr("x", function(d) { return x(d.TicketSector); })
            .attr("width", x.bandwidth())
            .attr("y", function(d) { return y(d.Savings); })
            .attr("height", function(d) { return (height - y(d.Savings))+ 50; })
            .on("mouseover", showToolTip)
            .on("mouseout",hideToolTip);

        barTextGEle.selectAll(".bar-text")
            .data(data)
            .enter().append("text")
            .attr("class", "below")
            .attr("x", function(d) { return x(d.TicketSector) + 20; })
            .attr("dy", "1.2em")
            .attr("y", function(d,i) { 
                var barHeight =d3.select('#bar-'+d.TicketSector+'-' +i).attr('height');
                return y(d.Savings) + Math.trunc(barHeight) - 30; 
            })
            .attr("text-anchor", "left")
            .text(function(d) { 
                  let text =  'Savings: ' + formatValue(defaultLocale,defaultCurrency,d.Savings) + '<br>'
                                                + 'Savings: ' + d.SavingShare + ' % <br>';
                        return d.SavingShare + ' %'; 
                    })
            .style("fill", "white");

        barTopGEle.selectAll('.axis-label')
                    .data(data)
                    .enter()
                    .append("text")
                    .attr("class","axis-label")
                    .attr("x", function(d) { return x(d.TicketSector) + 15; })
                    .attr("y", function(d) { return y(d.Savings) -  35; })
                    .text(function(d, i) { return d.TicketSector;});

        barTopGEle.selectAll('.top-triangle')
                    .data(data)
                    .enter()
                    .append("polygon")
                    .attr("class","polygon")
                    .attr("fill",function(d,i){
                        return i % 2 === 0 ? '#2e497b':'#55b04a';
                    })
                    .attr("points",function(d,i){
                        let p1,p2,p3,p4,p5;
                        let barX =  x(d.TicketSector);
                        let barY =  y(d.Savings) + 2;
                        let barHeight = (height - y(d.Savings));
                        let barWidth = x.bandwidth();
                        p1 = `${barX},${barY}`;
                        p2 = `${barX},${barY - 15}`;
                        p3 = `${barX+(barWidth/2)},${barY- 30}`;
                        p4 = `${barX+barWidth},${barY - 15}`;
                        p5 = `${barX+barWidth},${barY}`;
                        return `${p1} ${p2} ${p3} ${p4} ${p5}`;
                    })
                    .on("mouseover", showToolTip)
                    .on("mouseout",hideToolTip);

        barBottomGEle.selectAll('.bottom-triangle')
                    .data(data)
                    .enter()
                    .append("polygon")
                    .attr("class","polygon")
                    .attr("fill",function(d,i){
                        if(d.Savings === max1 || d.Savings ===max2)
                            return 'red'
                        return "lightgrey";
                        // return i % 2 === 0 ? '#2e497b':'#55b04a';
                    })
                    .attr("points",function(d,i){
                        let p1,p2,p3,p4,p5;
                        let barX =  x(d.TicketSector);
                        let barY =  -20;
                        let barHeight = -48;
                        let barWidth = x.bandwidth();
                        p1 = `${barX},${barHeight}`;
                        p2 = `${barX},${barHeight/2}`;
                        p3 = `${barX+(barWidth/2)},${0}`;
                        p4 = `${barX+barWidth},${barHeight/2}`;
                        p5 = `${barX+barWidth},${barHeight}`;
                        return `${p1} ${p2} ${p3} ${p4} ${p5}`;
                    })       .on("mouseover", showToolTip)
                    .on("mouseout",hideToolTip);
        }
