'use strict';

const {
    h,
    app
} = window.hyperapp;

const state = {
    count: 0
}

const view = (state, actions) =>
    h("div", null, [
        h("h1", null, state.count),
        h("button", {
            onclick: () => actions.down(1)
        }, "-"),
        h("button", {
            onclick: () => actions.up(1)
        }, "+")
    ])

const actions = {
    down: value => state => ({
        count: state.count - value
    }),
    up: value => state => ({
        count: state.count + value
    })
}

// const main = app(state, actions, view, document.getElementById('navbar_container'))

setInterval(main.up, 250, 1)