'use strict';

const itinerary = {
    legs: [{
            origin: "BOM",
            originCountry: "India",
            destination: "LHR",
            destinationCountry: "UK",
            depDateTime: "21Apr 1926",
            arrDateTime: "22Apr 0130",
            connections: "DXB",
            airlines: "9W"
        },
        {
            origin: "LHR",
            originCountry: "India",
            destination: "BOM",
            destinationCountry: "UK",
            depDateTime: "21Apr 1926",
            arrDateTime: "22Apr 0130",
            connections: "DXB",
            airlines: "9W"

        },
        {
            origin: "BOM",
            originCountry: "India",
            destination: "SIN",
            destinationCountry: "UK",
            depDateTime: "23Apr 1926",
            arrDateTime: "24Apr 0130",
            connections: "HYD",
            airlines: "9W"

        },
        {
            origin: "SIN",
            originCountry: "India",
            destination: "BOM",
            destinationCountry: "UK",
            depDateTime: "25Apr 1926",
            arrDateTime: "26Apr 0130",
            connections: "MAS",
            airlines: "9W"

        }

    ]
}

const singeLeg = ({
    leg
}) => (
    h("div", {
        class: "col-md-8 text-center"
    }, [
        h("div", {
            class: "col-md-4 text-center"
        }, [
            h("div", {
                class: "row s10 capitals"
            }, leg.originCountry),
            h("div", {
                class: "row f700 text-blue s16"
            }, leg.origin),
            h("div", {
                class: "row s8 capitals"
            }, leg.depDateTime)
        ]),
        h("div", {
            class: "col-md-4 text-center "
        }, [
            h("div", {
                class: "row s10"
            }, leg.connections),
            h("div", {
                class: "row text-blue"
            }, h("i", {
                class: "fa fa-arrows-h fa-2x"
            })),
            h("div", {
                class: "row s10 capitals"
            }, leg.airlines),
        ]),
        h("div", {
            class: "col-md-4 text-center"
        }, [
            h("div", {
                class: "row s10 capitals"
            }, leg.destinationCountry),
            h("div", {
                class: "row f700 capitals text-blue s16"
            }, leg.destination),
            h("div", {
                class: "row s8 capitals"
            }, leg.arrDateTime)
        ])

    ])
)
const singeLeg_ = ({
    leg,depDate
}) => (
    h("div", {
        class: "col-md-8 text-center"
    }, [
        h("div", {
            class: "col-md-4 text-center"
        }, [
            h("div", {
                class: "row s10 capitals"
            }, leg.originCountry),
            h("div", {
                class: "row f700 text-blue s16"
            }, leg.origin),
            h("div", {
                class: "row s8 capitals"
            }, leg.depDateTime)
        ]),
        h("div", {
            class: "col-md-4 text-center "
        }, [
            h("div", {
                class: "row s10"
            }, leg.connections),
            h("div", {
                class: "row text-blue"
            }, h("i", {
                class: "fa fa-arrows-h fa-2x"
            })),
            h("div", {
                class: "row s10 capitals"
            }, leg.airlines),
        ]),
        h("div", {
            class: "col-md-4 text-center"
        }, [
            h("div", {
                class: "row s10 capitals"
            }, leg.destinationCountry),
            h("div", {
                class: "row f700 capitals text-blue s16"
            }, leg.destination),
            h("div", {
                class: "row s8 capitals"
            }, depDate)
        ])

    ])
)

const FirstLeg = ({
    leg
}) => (
    h("div", {
        class: "col-md-4 text-center p0"
    }, [
        h("div", {
            class: "col-md-7 text-left"
        }, [
            h("div", {
                class: "row s10 capitals "
            }, leg.originCountry),
            h("div", {
                class: "row bold-text s16 text-blue"
            }, leg.origin),
            h("div", {
                class: "row s8 capitals"
            }, leg.depDateTime)
        ]),
        h("div", {
            class: "col-md-4 text-center col-md-offset-1 "
        }, [
            h("div", {
                class: "row s10 "
            }, leg.connections),
            h("div", {
                class: "row text-blue"
            }, h("i", {
                class: "fa fa-arrows-h fa-2x"
            })),
            h("div", {
                class: "row s10 capitals "
            }, leg.airlines),
        ])

    ])
)

const Destinations = ({
    destinations,
    arr,
    dep
}) => (

    h("div", {
        class: "col-md-4 text-center"
    }, [

        h("div", {
            class: "col-md-12 text-center"
        }, [
            h("div", {
                class: "row s10 capitals "
            }, "Multi-City"),
            h("div", {
                class: "row bold-text s16 text-blue"
            }, destinations.join("-")),
            h("div", {
                class: "row s8 text-center "
            }, arr + " - " + dep),
        ])

    ]))

const LastLeg = ({
    leg
}) => (
    h("div", {
        class: "col-md-4 text-center"
    }, [

        h("div", {
            class: "p0 col-md-4"
        }, [
            h("div", {
                class: "row s10 "
            }, leg.connections),
            h("div", {
                class: "row text-blue"
            }, h("i", {
                class: "fa fa-arrows-h fa-2x "
            })),
            h("div", {
                class: "row s10 text-center "
            }, leg.airlines),
        ]),
        h("div", {
            class: "p0 col-md-7 col-md-offset-1 text-right"
        }, [
            h("div", {
                class: "row s10 "
            }, leg.destinationCountry),
            h("div", {
                class: "row bold-text s16 text-blue"
            }, leg.destination),
            h("div", {
                class: "row s8 capitals "
            }, leg.arrDateTime)
        ])
    ])
)


const itineraryView = (state, actions) => {



    if (state.legs.length > 2) {
        var len = state.legs.length;
        var arr = state.legs[1].arrDateTime.substr(0, 5);
        var dep = state.legs[len - 1].depDateTime.substr(0, 5);
        var destinationArray = state.legs.slice(1, -1).map(function (element) {
            return element.destination
        })

        var renderArray = [
            h(FirstLeg, {
                leg: state.legs[0]
            }, null),
            h(Destinations, {
                destinations: destinationArray,
                arr: arr,
                dep: dep


            }, null),
            h(LastLeg, {
                leg: state.legs.slice(-1).pop()
            }, null)
        ]

        return h("div", {
            class: "col-md-12"
        }, renderArray)
    }
    if (state.legs.length == 1) {
        var renderArray = [
            h(singeLeg, {
                leg: state.legs[0]
            }, null)

        ]
        return h("div", {
            class: "col-md-offset-3"
        }, renderArray)
    }
    if (state.legs.length == 2) {
        var renderArray = [
            h(singeLeg_, {
                leg: state.legs[0],
                depDate : state.legs[1].depDateTime
            }, null),

            h(LastLeg, {
                leg: state.legs[state.legs.length - 1]
            }, null)
        ]

        return h("div", {
            class: "col-md-12  "
        }, renderArray)
    }

}
const itineraryUpdate = {
    update: value => state => ({
        legs: value
    })
}

const itineraryApp = app(itinerary, itineraryUpdate, itineraryView, document.getElementById('itineraryDiagram'))