
var bizUnitWisePieObj = {
        palette: colorPalette,
        legend: {
            orientation: "horizontal",
            itemTextPosition: "right",
            horizontalAlignment: "center",
            verticalAlignment: "bottom",
        },
};

var populateBizUnitWise = (tab,dataObj,bizUnitWise,bizUnitWiseClass)=>{
      $.ajax({
                type: "POST",
                url: "apis/spend/advplan/advplan_biz.php",
                data: dataObj,
                cache: false,
                success: function (d) {
                d = JSON.parse(d);
                console.log('value',d);
                let trxId = tab+'-trx', bizId = tab+'-biz';

                // $('#'+tab).append(appendIboxColLgDiv(tab+'-trx-spend','Overview','Based on Transaction and Spend'));

                $('#'+bizUnitWise).append(appendColLgDiv(6,trxId,'Transaction','height : 300px;width:480px;margin:auto;margin-bottom: 50px;'));
                
                $('#'+bizUnitWise).append(appendColLgDiv(6,bizId,'Amount Spend','height : 300px;width:480px;margin:auto;margin-bottom: 50px;'));

                  $('#'+trxId).dxPieChart({
                    dataSource :  d['bizData'],
                    series: [{
                        argumentField: "bu",
                        valueField: "count",
                        label: {
                            visible: true,
                             backgroundColor : "none",
                                position  : 'inside',
                            connector: {
                                visible: true,
                                width: 0.5
                            },
                            customizeText: function (arg) {
                                return  arg.percentText;
                            }
                        }
                    }],
                    onPointClick: function (arg,data) {
                        if(!(arg.target.data.bu.toLowerCase() === 'others'))
                            populateBizUnitWiseInsights(tab,dataObj,arg.target.data,bizUnitWiseClass)
                    },
                    ...bizUnitWisePieObj
                });


                  $('#'+bizId).dxPieChart({
                    dataSource :  d['bizData'],
                    series: [{
                            argumentField: "bu",
                            valueField: "amount",
                            label: {
                                visible: true,
                                 backgroundColor : "none",
                                    position  : 'inside',
                                connector: {
                                    visible: true,
                                    width: 0.5
                                },
                                customizeText: function (arg) {
                                    return  arg.percentText;
                                }
                            }
                        }],
                        onPointClick: function (arg,data) {
                             if(!(arg.target.data.bu.toLowerCase() === 'others'))
                                populateBizUnitWiseInsights(tab,dataObj,arg.target.data,bizUnitWiseClass)
                    },
                    ...bizUnitWisePieObj
                });

                },
                error: function () {
                    console.log("Ajax is not working");
                }
            });
}

var populateBizUnitWiseInsights =(tab,dataObj,currObj,bizUnitWiseClass) =>{
        let bizUnit =  currObj['bu'];
        let sectorId =  tab+'-biz-sector',airlineId = tab+'-biz-airline';
        let sectorRow = tab+'-biz-sector-row';
        $('#'+sectorId).remove();
        $('#'+airlineId).remove();
        $('#'+sectorRow+'-row').remove();
        $('#'+sectorRow+'-region-row').remove();
        $('#'+sectorRow+'-airline-row').remove();
        
        dataObj[tab+'-biz-unit'] = bizUnit;
        $('#'+tab).append(appendRowDiv(sectorRow,bizUnitWiseClass,''));
        
        $('#'+sectorRow+'-row').append(appendColLgDiv('6',sectorRow+'-region-row','','height : 300px;margin-bottom: 50px;',bizUnitWiseClass));
        
        $('#'+sectorRow+'-region-row').append(appendColLgDiv('12',sectorId,'Region','height : 300px;margin-bottom: 50px;',bizUnitWiseClass));
        
        $('#'+sectorRow+'-row').append(appendColLgDiv('6',sectorRow+'-airline-row','','height : 300px;margin-bottom: 50px;',bizUnitWiseClass));
    
        $('#'+sectorRow+'-airline-row').append(appendColLgDiv('12',airlineId,'Airline','height : 300px;margin-bottom: 50px;',bizUnitWiseClass));


        $.ajax({
                type: "POST",
                url: "apis/spend/advplan/advplan_biz_airline_sector.php",
                data: dataObj,
                cache: false,
                success: function (d) {
                d = JSON.parse(d);

                    $('#'+sectorId).dxChart({
                        dataSource : filterOverAllData(d['sectorData']),
                        ...barObj,
                        onPointClick: function (arg,data) {
                         populateSectorWiseDetails(tab,dataObj,arg.target.data,overviewDetailsClass);
                    }
                    })

                    $('#'+airlineId).dxChart({
                        dataSource : filterOverAllData(d['airlineData']),
                        ...barObj,
                        onPointClick: function (arg,data) {
                         // populateSectorWiseDetails(tab,dataObj,arg.target.data)
                    }
                    })

                },
                error: function () {
                    console.log("Ajax is not working");
                }
            });
    
}


var seriesArr = [
                    {
                        valueField : '0-2',
                        name : '0-2'            
                    },
                    {
                        valueField : '2-5',
                        name : '2-5'    
                    },
                    {
                        valueField : '5-14',
                        name : '5-14'    
                    },
                    {
                        valueField : '>14',
                        name : '14+'    
                    }
                ];

var barObj = {
                palette: colorPalette,
                equalBarWidth: {
                            width: 18,
                        },
                tooltip: {
                        enabled: true
                    },
                     legend: {
                               horizontalAlignment: "center",
                            verticalAlignment: "bottom",
                        },
                commonSeriesSettings: {
                    argumentField: "region",
                    type: "fullStackedBar",
                    label: {
                             format: {
                            type: "fixedPoint",
                            precision: 0},
                                            visible: true,
                            indent: 30,
                            font :{size : 14},
                            customizeText: function (arg) {
                                return arg.percentText + "";
                            }
                        },
                  
                },
                series: seriesArr,
            };

var populateOverallDetails =(tab,dataObj,overviewDetails,overviewDetailsClass)=>{
     $.ajax({
                type: "POST",
                url: "apis/spend/advplan/advplan_overall.php",
                data: dataObj,
                cache: false,
                success: function (d) {
                d = JSON.parse(d);
                let overAllData = d['overallData'],
                    leadtimeData = d['leadtimeData'];
                    overAllData = filterOverAllData(overAllData);

                    $('#'+overviewDetails).dxChart({
                        dataSource : overAllData,
                        ...barObj,
                        onPointClick: function (arg,data) {
                        populateRegionWiseDetails(tab,dataObj,arg.target.data,overviewDetailsClass)
                    }
                    })


                },
                error: function () {
                    console.log("Ajax is not working");
                }
            });
}

var filterOverAllData =(data)=>{
    /*
    region 
    0-2
    2-5
    5-14
    14+
    */
    let regionArr = _(data).chain().flatten().pluck('region').unique().value();
    let retdata = [];
    regionArr.map((region,index)=>{
        let obj = {
            "region" : region
        };
        data.map((currObj,index)=>{
            if(currObj['region']===region){
                let type =  currObj['type'],
                    count = parseInt(currObj['count']),
                    amt = parseInt(currObj['amt']),
                    ap = parseInt(currObj['act_ap'] ? currObj['act_ap'] : 0 );

                if(!obj.hasOwnProperty(type)){
                    obj[type] =count;
                    obj[type+'_amt'] = amt;
                    obj[type+'_ap'] = ap;
                }
                else{
                    obj[type]+=count;
                    obj[type+'_amt']+=amt;
                    obj[type+'_ap']+=ap;
                }
            }
        })
        retdata.push(obj);
    })
    console.log('value',retdata);
    return  retdata ;
}

var populateRegionWiseDetails =(tab,dataObj,currObj,overviewDetailsClass)=>{
        let region =  currObj['region'];
        let regionId =  tab+'-region',airlineId = tab+'-airline';
        let regionRow = tab+'-region-row';
        $('#'+regionId).remove();
        $('#'+airlineId).remove();
        $('#'+regionRow+'-row').remove();
        $('#'+regionRow+'-region-row').remove();
        $('#'+regionRow+'-airline-row').remove();
        
        dataObj[tab+'-region'] = region;
        $('#'+tab).append(appendRowDiv(regionRow,overviewDetailsClass,''));
        
        $('#'+regionRow+'-row').append(appendColLgDiv('6',regionRow+'-region-row','','height : 300px;margin-bottom: 50px;',overviewDetailsClass));
        
        $('#'+regionRow+'-region-row').append(appendColLgDiv('12',regionId,'Region','height : 300px;margin-bottom: 50px;',overviewDetailsClass));
        
        $('#'+regionRow+'-row').append(appendColLgDiv('6',regionRow+'-airline-row','','height : 300px;margin-bottom: 50px;',overviewDetailsClass));
    
        $('#'+regionRow+'-airline-row').append(appendColLgDiv('12',airlineId,'Airline','height : 300px;margin-bottom: 50px;',overviewDetailsClass));
            
         $.ajax({
                type: "POST",
                url: "apis/spend/advplan/advplan_region.php",
                data: dataObj,
                cache: false,
                success: function (d) {
                d = JSON.parse(d);

                    $('#'+regionId).dxChart({
                        dataSource : filterOverAllData(d['region']),
                        ...barObj,
                        onPointClick: function (arg,data) {
                         populateSectorWiseDetails(tab,dataObj,arg.target.data,overviewDetailsClass);
                    }
                    })

                    $('#'+airlineId).dxChart({
                        dataSource : filterOverAllData(d['airline']),
                        ...barObj,
                        onPointClick: function (arg,data) {
                         // populateSectorWiseDetails(tab,dataObj,arg.target.data)
                    }
                    })

                },
                error: function () {
                    console.log("Ajax is not working");
                }
            });
}

var populateSectorWiseDetails = (tab,dataObj,currObj,overviewDetailsClass)=>{
        let sectorId =  tab+'-region-sector',airlineId = tab+'-region-sector-airline';
        let sectorRow = tab+'-region-sector-row';
        $('#'+sectorId).remove();
        $('#'+airlineId).remove();
        $('#'+sectorRow+'-row').remove();
        $('#'+sectorRow+'-region-row').remove();
        $('#'+sectorRow+'-region-airline').remove();
        
        dataObj[tab+'-region'] = currObj['region'];
        $('#'+tab).append(appendRowDiv(sectorRow,overviewDetailsClass,''));
        
        $('#'+sectorRow+'-row').append(appendColLgDiv('6',sectorRow+'-region-row','','height : 300px;margin-bottom: 50px;',overviewDetailsClass));
        
        $('#'+sectorRow+'-region-row').append(appendColLgDiv('12',sectorId,'Sector','height : 300px;margin-bottom: 50px;',overviewDetailsClass));
        
        $('#'+sectorRow+'-row').append(appendColLgDiv('6',sectorRow+'-region-airline','','height : 300px;margin-bottom: 50px;',overviewDetailsClass));
    
        $('#'+sectorRow+'-region-airline').append(appendColLgDiv('12',airlineId,'Airline','height : 300px;margin-bottom: 50px;',overviewDetailsClass));
            
         $.ajax({
                type: "POST",
                url: "apis/spend/advplan/advplan_sector.php",
                data: dataObj,
                cache: false,
                success: function (d) {
                d = JSON.parse(d);

                    $('#'+sectorId).dxChart({
                        dataSource : filterOverAllData(d['sector']),
                        ...barObj,
                        onPointClick: function (arg,data) {
                         // showSectorWiseDetails(tab,dataObj,arg.target.data)
                    }
                    })

                    $('#'+airlineId).dxChart({
                        dataSource : filterOverAllData(d['airline']),
                        ...barObj,
                        onPointClick: function (arg,data) {
                         // showSectorWiseDetails(tab,dataObj,arg.target.data)
                    }
                    })

                },
                error: function () {
                    console.log("Ajax is not working");
                }
            });

}