var barObj = {
                palette: colorPalette,
                equalBarWidth: {
                            width: 18,
                        },
                tooltip: {
                        enabled: true
                    },
                     legend: {
                               horizontalAlignment: "center",
                            verticalAlignment: "bottom",
                        },
                commonSeriesSettings: {
                    argumentField: "airline",
                    type: "fullStackedBar",
                    label: {
                             format: {
                                        type: "fixedPoint",
                                        precision: 0
                                    },
                            visible: true,
                            indent: 30,
                            font :{
                                size : 14
                            },
                            customizeText: function (arg) {
                                return arg.percentText + "";
                            }
                        },
                  
                }
            };


var populateSectorViz = (tab,dataObj,corpMixId,TSIndexMixId)=>{
        let rangeArr = [];
            rangeArr.push(dataObj[tab+'-range-1-val'],dataObj[tab+'-range-2-val'],dataObj[tab+'-range-3-val']);
            dataObj[tab+'-range'] =  rangeArr;
        $.ajax({
                type: "POST",
                url: "apis/spend/advpursector/adv_purchase_sector.php",
                data: dataObj,
                cache: false,
                success: function (d) {
                d = JSON.parse(d)['data'];

                let corpData =  d.filter((obj,index)=>{
                    return obj.data_t === 'corp';
                })

                let tsiData =  d.filter((obj,index)=>{
                    return obj.data_t === 'tsi';
                })
                
                let seriesArr = getSeriesArr(dataObj[tab+'-range']);
                console.log('seriesArr value',seriesArr);
                corpData = filterVizData(corpData,dataObj);
                tsiData = filterVizData(tsiData,dataObj);

                  $('#'+corpMixId).dxChart({
                        dataSource : corpData,
                        series : seriesArr,
                        ...barObj
                    })

                  $('#'+TSIndexMixId).dxChart({
                        dataSource : tsiData,
                        series : seriesArr,
                        ...barObj
                    })

                
                },
                error: function () {
                    console.log("Ajax is not working");
                }
            });
}


var filterVizData =(data,dataObj)=>{
        // console.log('value',data);
        let airlineArr = _(data).chain().flatten().pluck('airline_code').unique().value();
        let retData = [];

        airlineArr.map((airline,index)=>{
                let obj = {
                    "airline" : airline
                };
                data.map((currObj,index)=>{
                    if(currObj['airline_code']===airline){
                        let type =  currObj['type'],
                            count = parseInt(currObj['count'] ? currObj['count'] : 0 ),
                            amt = parseInt(currObj['amt'] ? currObj['amt'] : 0 ),
                            ap = parseInt(currObj['adv_purchase'] ? currObj['adv_purchase'] : 0 );

                        if(!obj.hasOwnProperty(type)){
                            obj[type] =count;
                            obj[type+'_amt'] = amt; 
                            obj[type+'_ap'] = ap;
                        }
                        else{
                            obj[type]+=count;
                            obj[type+'_amt']+=amt;
                            obj[type+'_ap']+=ap;
                        }
                    }
                })
                retData.push(obj);
            })

        return  retData ;

}

var getSeriesArr =(rangeArr)=>{
    return rangeArr.map((obj,index)=>{
        return {
            valueField : obj,
            name : obj
        }       
    })
}

