var citypairVizObj = {
        commonSeriesSettings: {
            argumentField: "sector",
            type: "stackedBar"
        },
        "export": {
            enabled: false
        },
        tooltip: {
            enabled: true,
            location: "edge",
            customizeTooltip: function (arg) {
                return {
                    text: arg.seriesName 
                };
            }
        }
    };

var citypairGridObj = {
                showBorders: true,
                selection: {
                    mode: "single"
                },
                rowAlternationEnabled: true,
                columns : [{
                            dataField : 'sector',
                            caption : 'Sector'
                        },{
                            dataField : 'count',
                            caption : 'Count'
                        },{
                            dataField : 'amount',
                            caption : 'Amount'
                        },
                        {
                         dataField : 'atp',
                         caption : 'Avg Tkt Price'   
                        }],
                summary : {
                    totalItems : [{
                        column : 'count',
                        summaryType : 'sum',
                        customizeText: function(data) {
                            return "Total: " + data.value;
                        }
                    },
                    {
                        column : 'amount',
                        summaryType : 'sum',
                        customizeText: function(data) {
                            return "Total: " + data.value;
                        }
                    },
                    {
                        column : 'atp',
                        summaryType : 'avg',
                        customizeText: function(data) {
                            return "Average : " + Math.round(data.value);
                        }
                    }]
                }
                
    };


var getOneWayTripViz=(tab,dataObj,p1Id,p2Id)=>{
        $.ajax({
                type: "POST",
                url: "apis/spend/citypair/citypair_ow_trip.php",
                data: dataObj,
                cache: false,
                success: function (d) {
                d = JSON.parse(d);
                let data1 = formatCityPairVizData(d.oneway_period1,dataObj),
                 data2 = formatCityPairVizData(d.oneway_period2,dataObj);
                $("#"+p1Id).dxChart({
                    ...citypairVizObj,
                    dataSource : data1['chartData'],
                    series : data1['seriesArr'],
                    palette : data1['airlineColorPalette']
                });

                $("#"+p2Id).dxChart({
                    ...citypairVizObj,
                    dataSource : data2['chartData'],
                    series : data2['seriesArr'],
                    palette : data2['airlineColorPalette']
                });

                },
                error: function () {
                    console.log("Ajax is not working");
                }
            });
}

var getOneWayTripGrid=(tab,dataObj,p1Id,p2Id)=>{
        $.ajax({
                type: "POST",
                url: "apis/spend/citypair/citypair_ow_trip_grid.php",
                data: dataObj,
                cache: false,
                success: function (d) {
                 d = JSON.parse(d);
                   let data1 =  formatCityPairGridData(d['oneway_period1'],dataObj),
                   data2 = formatCityPairGridData(d['oneway_period2'],dataObj);
                   $("#"+p1Id).append(appendColLgDiv(12,p1Id+'-grid1'));
                    $("#"+p2Id).append(appendColLgDiv(12,p2Id+'-grid2'));
                    
                    $("#"+p1Id+'-grid1').dxDataGrid({dataSource: data1,...citypairGridObj});
                    $("#"+p2Id+'-grid2').dxDataGrid({dataSource: data2,...citypairGridObj});
                
                },
                error: function () {
                    console.log("Ajax is not working");
                }
            });
}



var getRoundTripViz=(tab,dataObj,p1Id,p2Id)=>{
        $.ajax({
                type: "POST",
                url: "apis/spend/citypair/citypair_rt_trip.php",
                data: dataObj,
                cache: false,
                success: function (d) {
                d = JSON.parse(d);
                    let data1 = formatCityPairVizData(d.rt_period1,dataObj),
                 data2 = formatCityPairVizData(d.rt_period2,dataObj);
                $("#"+p1Id).dxChart({
                    ...citypairVizObj,
                    dataSource : data1['chartData'],
                    series : data1['seriesArr'],
                    palette : data1['airlineColorPalette']
                });

                $("#"+p2Id).dxChart({
                    ...citypairVizObj,
                    dataSource : data2['chartData'],
                    series : data2['seriesArr'],
                    palette : data2['airlineColorPalette']
                });

                },
                error: function () {
                    console.log("Ajax is not working");
                }
            });
}



var getRoundTripGrid=(tab,dataObj,p1Id,p2Id)=>{
        $.ajax({
                type: "POST",
                url: "apis/spend/citypair/citypair_rt_trip_grid.php",
                data: dataObj,
                cache: false,
                success: function (d) {
                d = JSON.parse(d);
                 let data1 =  formatCityPairGridData(d['oneway_period1'],dataObj),
                   data2 = formatCityPairGridData(d['oneway_period2'],dataObj);

                    $("#"+p1Id).append(appendColLgDiv(12,p1Id+'-grid1'));
                    $("#"+p2Id).append(appendColLgDiv(12,p2Id+'-grid2'));
                    $("#"+p1Id+'-grid1').dxDataGrid({dataSource: data1,...citypairGridObj});
                    $("#"+p2Id+'-grid2').dxDataGrid({dataSource: data2,...citypairGridObj});
                },
                error: function () {
                    console.log("Ajax is not working");
                }
            });
}


var formatCityPairVizData = (data,dataObj)=>{
        let retVal = [];
        let sectorArr = _(data).chain().flatten().pluck('sector').unique().value();
        let sectorAmtArr = [];
        // top sectors 
        for (let i = 0; i < sectorArr.length; i++) {
            let currEle = data.filter(function (obj) {
                return obj.sector == sectorArr[i];
            });
            let amtStr = currEle[0]['g_amount'];
            let countStr = currEle[0]['g_cc'];
            let amtArr = [];
            let countArr = [];
            let sectorCount = 0;
            let sectorAmt = 0;
            if (countStr.indexOf(',') > -1) {
                countArr = countStr.split(',');
                for (let j = 0; j < countArr.length; j++) {
                    sectorCount = sectorCount + parseInt(countArr[j]);
                }
            }
            else {
                sectorCount = parseInt(countStr);
            }
            if (amtStr.indexOf(',') > -1) {
                amtArr = amtStr.split(',');
                for (let k = 0; k < amtArr.length; k++) {
                    sectorAmt = sectorAmt + parseInt(amtArr[k]);
                }
            }
            else {
                sectorAmt = parseInt(amtStr);
            }
            sectorAmtArr.push({
                sector: sectorArr[i]
                , value: sectorAmt
            });
        }
        sectorAmtArr = _.sortBy(sectorAmtArr, 'value');
        let topSectorObj = _.last(sectorAmtArr, dataObj['spend-city-pair-top-count-val']);
        let topSectorArr = _(topSectorObj).chain().flatten().pluck('sector').unique().value();
        let airlineColorPalette = [];
        let seriesArr = [];
        let chartData = [];
        for (let z = 0; z < topSectorArr.length; z++) {
            let tempObj = {};
            let currSecData = data.filter(function (k) {
                return k.sector == topSectorArr[z];
            });
            tempObj['sector'] = currSecData[0]['sector'];

            let airlineArr = currSecData[0]['g_airline_code'].split(','); 
            let amtArr = currSecData[0]['g_amount'].split(',');
            let countArr = currSecData[0]['g_cc'].split(',');
            if(z === 0){
                airlineArr.map((name)=>{
                    airlineColorPalette.push(airLineColorObj[name]);
                })
                airlineArr.map((name)=>{
                    seriesArr.push({
                        'valueField':name,
                        'name':name

                    })
                })
            }
            
            airlineArr.map((name,index)=>{
                tempObj[name] =  parseInt(countArr[index]);
                // tempObj[name+'_amt'] = amtArr[index];
            })
            chartData.push(tempObj);
        }

    return {chartData,airlineColorPalette,seriesArr};
}

// datasource,columns
var formatCityPairGridData = (data,dataObj)=>{
    console.log('value',data);
    return data;
} 
