var airlineTitleObj = {
    '9W' : 'Jet Airways',
    'AI' : 'Air India',
    'UK' : 'Vistara'
}

var airlineFareClassGrpArr = {
    '9W' : ['Above S', 'S', 'Above H', 'H', 'Below H'],
    'UK' : ['Above M', 'M', 'Above H', 'H', 'Below H'],
    'AI' : ['Above G', 'G', 'Above U', 'U', 'Below U']
}

var airlineFareClassArr = {
    '9W' : ['C', 'J', 'Z', 'I', 'P', 'Y', 'M', 'T', 'U', 'N', 'L', 'Q', 'S', 'K', 'H', 'V', 'O', 'W', 'B'],
    'UK' : ['C', 'J', 'D', 'Z', 'I', 'S', 'R', 'T', 'P', 'U', 'Y', 'B', 'M', 'A', 'H', 'N', 'L', 'K', 'W','Q', 'V', 'E', 'X', 'O'],
    'AI' : ['C', 'D', 'J', 'Z', 'Y', 'B', 'M', 'H', 'K', 'Q', 'V', 'W', 'G', 'L', 'U', 'T', 'S', 'E', 'N']
}

var airlineBizClass = {
    'AI' : ["C","D","J","Z"] ,
    '9W' : ["C","I","J","Z", "P"],
    'UK' : ["C","I","J","Z","D"] 
}

var airlineBizClass = {
    'AI' : ["C","D","J","Z"] ,
    '9W' : ["C","I","J","Z", "P"],
    'UK' : ["C","I","J","Z","D"] ,
    'UK_PREM' : ["U","P","T","R","S"]
}

var displayRBDViz =(tab,currAirlineData)=>{
    let airlineCode = currAirlineData[0]['airline_code'];
    let airlineDiv =tab+'-'+airlineCode; 
    let gridId = airlineDiv +'-grid';
    let vizId = airlineDiv+'-viz';
    $('#'+tab).append(appendIboxColLgDiv(airlineDiv,airlineTitleObj[airlineCode],'Based on Transaction and Spend'));
    $('#'+airlineDiv+'-content-row').append(appendColLgDiv(6,gridId,'','margin-bottom: 50px;'));
    $('#'+airlineDiv+'-content-row').append(appendColLgDiv(6,vizId,'','height : 300px;margin-bottom: 50px;'));
    showRBDViz(vizId,airlineCode,currAirlineData);
    showRBDGrid(gridId,airlineCode,currAirlineData);
}

var showRBDViz = (vizId,airlineCode,currAirlineData)=>{
    let atpData = [],countData = [],spendData= [];
    let l0_count = 0, l1_count = 0, l2_count = 0,l3_count = 0,l4_count = 0;
    let l0_spend = 0, l1_spend = 0, l2_spend = 0,l3_spend = 0 ,l4_spend = 0;

    for(var i=0;i<currAirlineData.length;i++){
        let currObj = currAirlineData[i];
        let fareClass = currObj['fare_class'],
            index = airlineFareClassArr[airlineCode].indexOf(fareClass),
            count = parseInt(currObj['count']),
            av = parseInt(currObj['average']);
       
        if (index < 12 ){
             l0_count = l0_count + count;
             l0_spend = l0_spend + (count*av);
           }else if(index ==12 ){
             l1_count = l1_count + count;
             l1_spend = l1_spend + (count*av);
           }else if(index > 12  && index < 14){
             l2_count = l2_count + count;
             l2_spend = l2_spend +(count*av);
           }else if(index ==14 ){
            l3_count = l3_count + count;
             l3_spend = l3_spend +(count*av);
           }else{
             l4_count = l4_count + count;
             l4_spend = l4_spend +(count*av);
           }
    }

    let l0_atp = (l0_spend/l0_count).toFixed(0) > 0 ? (l0_spend/l0_count).toFixed(0) : 0 ;
    let l1_atp = (l1_spend/l1_count).toFixed(0) > 0 ? (l1_spend/l1_count).toFixed(0)  : 0;
    let l2_atp = (l2_spend/l2_count).toFixed(0) > 0 ? (l2_spend/l2_count).toFixed(0) : 0 ;
    let l3_atp = (l3_spend/l3_count).toFixed(0) > 0 ? (l3_spend/l3_count).toFixed(0) : 0;
    let l4_atp = (l4_spend/l4_count).toFixed(0) > 0 ? (l4_spend/l4_count).toFixed(0) : 0;

    atpData.push(l0_atp,l1_atp,l2_atp,l3_atp,l4_atp);
    countData.push(l0_count,l1_count,l2_count,l3_count,l4_count);
    spendData.push(l0_spend,l1_spend,l2_spend,l3_spend,l4_spend);

    let updateVizData = airlineFareClassGrpArr[airlineCode].map((fareGrp,index)=>{
        let currObj = {'fare_grp' : fareGrp};
            currObj['atp'] = atpData[index];
            currObj['spend'] = atpData[index];
            currObj['count'] = countData[index];
            return currObj;
    })

    $("#"+vizId).dxPieChart({
        dataSource : updateVizData,
        ...vizObj
    });
}

var gridObj = {
                showBorders: true,
                selection: {
                    mode: "single"
                },
                rowAlternationEnabled: true,
                columns : [{
                            dataField : 'fare_class',
                            caption : 'Fare Class'
                        },{
                            dataField : 'count',
                            caption : 'Count'
                        },{
                            dataField : 'average',
                            caption : 'Average'
                        },{
                            dataField : 'mini',
                            caption : 'Min'
                        },{
                            dataField : 'maxi',
                            caption : 'Max'
                        },{
                            dataField : 'TS_INDEX',
                            caption : 'TS Index'
                        },{
                         dataField : 'dev',
                         caption : 'DEV'   
                        }
                        ],                
    };

var vizObj = {
        palette: ['#2d497b','#55b04a'],
        series: [{
            argumentField: "fare_grp",
            valueField: "atp",
            label: {
                             format: {
                            type: "fixedPoint",
                            precision: 0},
                                            visible: true,
                            indent: 30,
                            font :{size : 14},
                            customizeText: function (arg) {
                                return arg.percentText + "";
                            }
                        },
        }],
        legend: {
            orientation: "horizontal",
            itemTextPosition: "right",
            horizontalAlignment: "center",
            verticalAlignment: "bottom",
        },
};

var showRBDGrid = (gridId,airlineCode,currAirlineData)=>{
    // fare class ,count ,atp , min , max, tsindex, dev
                let gridData = [];
                   for(each in currAirlineData){
                        let currObj = currAirlineData[each],
                            currFareClass = currObj['fare_class']; 
                        if(airlineFareClassArr[airlineCode].indexOf(currFareClass) >-1 )
                        { 
                                var dev = parseInt(currObj['TS_INDEX']) - parseInt(currObj['average']);
                                var rbdClass = currFareClass;
                                let segment ;
                                if(airlineBizClass[airlineCode].indexOf(rbdClass) > -1)
                                    segment = 'Biz';
                                else if(airlineCode === 'UK' && airlineBizClass[airlineCode+'_PREM'].indexOf(rbdClass) > -1)
                                    segment = 'Prem Eco';
                                else
                                    segment = 'Eco';

                                let currVal = {};
                                currVal['fare_class'] = currFareClass + '('+segment+')';
                                currVal['count'] = parseInt(currObj['count']);
                                currVal['average'] = parseInt(currObj['average']);
                                currVal['mini'] = parseInt(currObj['mini']);
                                currVal['maxi'] = parseInt(currObj['maxi']);
                                currVal['TS_INDEX'] = parseInt(currObj['TS_INDEX']);
                                currVal['dev'] = dev;
                            
                                gridData.push(currVal);
                         }
                   }
                 
                   $('#'+gridId).dxDataGrid({
                    dataSource :  gridData,
                    ...gridObj
                   })
            }




var displayDashboardContain =(tab,dataObj)=>{
     $.ajax({
                type: "POST",
                url: "apis/spend/rbdanalysis/rbd_analysis.php",
                data: dataObj,
                cache: false,
                success: function (d) {
                    d = JSON.parse(d);

                    let data = d['rbd_data'];
                    let airlines = _(data).chain().flatten().pluck('airline_code').unique().value();

                    let airlineData = [] ;
                    airlines.map((airline,index)=>{
                        let currAirlineArr = [];
                        data.map((obj)=>{
                            if(airline === obj['airline_code']){
                                currAirlineArr.push(obj);
                            }
                        })
                        airlineData.push(currAirlineArr);
                    })

                    airlineData.map((currAirlineData)=>{
                        displayRBDViz(tab,currAirlineData);
                    })
                },
                error: function () {
                    console.log("Ajax is not working");
                }
            });
}

