 var populateIntlWeekAnalysis = (tab,dataObj,vizId,gridId)=>{
        $.ajax({
                type: "POST",
                url: "apis/spend/intlweek/intl_weekanalysis.php",
                data: dataObj,
                cache: false,
                success: function (d) {
                d = JSON.parse(d);
                let vizData =  d['weekdata'].map((obj)=>{
                    obj[obj['wd_wnd']] = parseInt(obj['amount']);
                    return obj;
                })

                $("#"+vizId).dxChart({
                    dataSource: vizData,
                            palette: ['#2d497b','#55b04a'],
                    commonSeriesSettings: {
                        argumentField: "Dest_Region",
                        type: "bar",
                        hoverMode: "allArgumentPoints",
                        selectionMode: "allArgumentPoints",
                        label: {
                            visible: true,
                            format: {
                                type: "fixedPoint",
                                precision: 0
                            }
                        }
                    },
                    series: [
                        { valueField: "weekday", name: "WeekDay" },
                        { valueField: "weekend", name: "WeekEnd" }
                    ],
                    legend: {
                        verticalAlignment: "bottom",
                        horizontalAlignment: "center"
                    },
                    onPointClick: function (e) {
                        e.target.select();
                    }
                });

            let regionArr = _(vizData).chain().flatten().pluck('Dest_Region').unique().value();
            let gridData = [];
            regionArr.map((region,index)=>{
                let currObj = {};
                currObj['region'] = region;
                    vizData.map((obj,index)=>{
                        if(region === obj['Dest_Region']){
                            if(obj['wd_wnd']==='weekday'){
                                currObj['weekday_trx'] = obj['count'] ;
                                currObj['weekday_amt'] = obj['amount'] ;
                                currObj['weekday_ap'] = obj['ap'] ;
                            }
                            if(obj['wd_wnd']==='weekend'){
                                currObj['weekend_trx'] = obj['count'] ;
                                currObj['weekend_amt'] = obj['amount'] ;
                                currObj['weekend_ap'] = obj['ap'] ;
                            }
                        }
                    })
                gridData.push(currObj);
            })

            let gridDefaultValue =(d)=>{
                 return d.value ? d.value : '0';
            }
            $("#"+gridId).append(appendColLgDiv(12,gridId+'-gridview'));
            let gridObj = {
                    dataSource: gridData,
                    columnAutoWidth: true,
                    allowColumnReordering: true,
                    showBorders: true,
                    columns: [ {
                        headerCellTemplate: function(container) {
                            container.append($("<div>Region</div>"));
                        },
                        dataField: "region"
                    }, {
                        caption: "WeekDay",
                        columns: [{
                            caption: "Transaction",
                            dataField: "weekday_trx",
                            format: "fixedPoint",
                            customizeText : gridDefaultValue
                        }, {
                            caption: "Advance Ticket",
                            dataField: "weekday_ap",
                            format: "fixedPoint",
                            customizeText : gridDefaultValue
                        },
                        {
                            caption: "Spend",
                            dataField: "weekday_amt",
                            format: "fixedPoint",
                            customizeText : gridDefaultValue
                        }]
                    },
                     {
                        caption: "WeekEnd",
                        columns: [{
                            caption: "Transaction",
                            dataField: "weekend_trx",
                            format: "fixedPoint",
                            customizeText : gridDefaultValue
                        }, {
                            caption: "Advance Ticket",
                            dataField: "weekend_ap",
                            format: "fixedPoint",
                            customizeText : gridDefaultValue
                        },
                        {
                            caption: "Spend",
                            dataField: "weekend_amt",
                            format: "fixedPoint",
                            customizeText : gridDefaultValue
                        }]
                    }]
                }

                
                 $("#"+gridId+'-gridview').dxDataGrid({
                    ...gridObj
                 })

                },
                error: function () {
                    console.log("Ajax is not working");
                }
            });
    }

