
var cityPairTabs = [{id: 0,text: "Economy" },{ id: 1,text: "Business"}];
var airlineTabs = [{id: 0,text: "Transactions" },{ id: 1,text: "Amount"}];

$("#citypair-tabs > .citypair-tabs-container").dxTabs({
                                    dataSource: cityPairTabs,
                                    selectedIndex: 0,
                                    onItemClick: function(e) {
                                            if(e.itemIndex === 0){
                                                $("#citypair-eco").show();
                                                $("#citypair-biz").hide();
                                            }
                                            else if(e.itemIndex === 1){
                                                $("#citypair-eco").hide();
                                                $("#citypair-biz").show();
                                            }                                     
                                    }}).dxTabs("instance");

$("#topairlines-tabs > .topairlines-tabs-container").dxTabs({
                                    dataSource: airlineTabs,
                                    selectedIndex: 0,
                                    onItemClick: function(e) {
                                            if(e.itemIndex === 0){
                                                $("#topairlines-trx").show();
                                                $("#topairlines-amt").hide();
                                            }
                                            else if(e.itemIndex === 1){
                                                $("#topairlines-trx").hide();
                                                $("#topairlines-amt").show();
                                            }                                     
                                    }}).dxTabs("instance");
$("#home-filter-form").submit(function(e) {
    e.preventDefault();
    var oc_amount, oc_count = 0;
    var op_amount, op_count = 0;
    var rc_amount, rc_count = 0;
    var rp_amount, rp_count = 0;
    var cc_amount, cc_count = 0;
    var cp_amount, cp_count = 0;
    var tc_amount, tc_count = 0;
    var tp_amount, tp_count = 0;
   
    $('#home-filter-choices').empty();
    $('#home-filter-modal').modal('hide');
    
    let formData = {};
    let groupCode = $('#home-filter-gcselect').find("option:selected").val();
    let groupName = $('#home-filter-gcselect').find("option:selected").text();
   
    $('#home-filter-choices').append('<li class="filter-choice"><span>Group Code : '+groupName+'</span></li>');
   
    let subCode = $('#home-filter-sgcselect').find("option:selected").val();
    $('#home-filter-choices').append('<li class="filter-choice"><span>Sub Code : '+subCode+'</span></li>');
   
    let segment = $('#home-filter-segment').find("option:selected").val();
    $('#home-filter-choices').append('<li class="filter-choice"><span>Segment : '+segment+'</span></li>');
   
    let criteria = $('#home-filter-criteria').find("option:selected").val();
    $('#home-filter-choices').append('<li class="filter-choice"><span>Criteria : '+criteria+'</span></li>');
   
    let year = $('#home-filter-year').find("option:selected").val();
   
    let finYear = $('#home-filter-finyear').find("option:selected").val();
   
    let quarter = $('#home-filter-quarter').find("option:selected").val();
   
    let month = $('#home-filter-month').find("option:selected").val();

    let date = '';
    let prevDate = '';

    if (criteria == "Month") {
        date = date + 'LIKE ' + "'" + year + '-' + month + '-%' + "'";
        if (month == 1) {
            prevDate = prevDate + 'LIKE ' + "'" + (year - 1) + '-' + '12' + '-%' + "'";
        }
        else {
            prevDate = prevDate + 'LIKE ' + "'" + year + '-0' + (month - 1) + '-%' + "'";
            }

        $('#home-filter-choices').append('<li class="filter-choice"><span>Month : '+month+'</span></li>');
    }
    else if (criteria == "Quarter") {
        if (quarter == "Q1") {
            date = date + 'BETWEEN ' + "'" + year + '-01-01' + "'" + ' and ' + "'" + year + '-03-31' + "'";
            prevDate = prevDate + 'BETWEEN ' + "'" + (year - 1) + '-10-01' + "'" + ' and ' + "'" + year + '-12-31' + "'";
        }
        else if (quarter == "Q2") {
            date = date + 'BETWEEN ' + "'" + year + '-04-01' + "'" + ' and ' + "'" + year + '-06-30' + "'";
            prevDate = prevDate + 'BETWEEN ' + "'" + year + '-01-01' + "'" + ' and ' + "'" + year + '-03-31' + "'";
        }
        else if (quarter == "Q3") {
            date = date + 'BETWEEN ' + "'" + year + '-07-01' + "'" + ' and ' + "'" + year + '-09-30' + "'";
            prevDate + 'BETWEEN ' + "'" + year + '-04-01' + "'" + ' and ' + "'" + year + '-06-30' + "'";
        }
        else if (quarter == 'Q4') {
            date = date + 'BETWEEN ' + "'" + year + '-10-01' + "'" + ' and ' + "'" + year + '-12-31' + "'";
            prevDate + 'BETWEEN ' + "'" + year + '-07-01' + "'" + ' and ' + "'" + year + '-09-30' + "'";
        }

        $('#home-filter-choices').append('<li class="filter-choice"><span>Quarter : '+quarter+'</span></li>');
    }
    else if (criteria == "Year") {
        date = date + 'LIKE ' + "'" + year + '-%' + "'";
        prevDate = prevDate + 'LIKE ' + "'" + (year - 1) + '-%' + "'";
        $('#home-filter-choices').append('<li class="filter-choice"><span>Year : '+year+'</span></li>');
    }
    else if (criteria == "FY") {
        let fy_array = finYear.split("-");
        date = date + 'BETWEEN ' + "'" + fy_array[0] + '-04-01' + "'" + ' and ' + "'" + fy_array[1] + '-03-31' + "'";
        prevDate = prevDate + 'BETWEEN ' + "'" + (fy_array[0] - 1) + '-04-01' + "'" + ' and ' + "'" + (fy_array[1] - 1) + '-03-31' + "'";
        $('#home-filter-choices').append('<li class="filter-choice"><span>Financial Year : '+finYear+'</span></li>');
    }

    let dataobject = {
    group_id: groupCode,
    subgroup_id: subCode,
    segment_id: segment,
    date_id: date,
    prev_date: prevDate,
    criteria : criteria
    };

    populatePage(dataobject);  
    selectedFilter();         
});
    
     
function selectedFilter(formData){
    if(!formData){
        formData = {};
        formData['groupName'] = $('#filtergroupcode').find("option:selected").text();
        formData['subCode'] = 'ALL';
        formData['criteriaText']='Year';
        formData['year'] = '2017';
        return;
    }

    $('#home-filter-choices').empty();
    $('#home-filter-choices').append('<li class="filter-choice"><span>Customer : '+formData['groupName']+'</span></li>');
	//    $('#home-filter-choices').append('<li class="filter-choice"><span>Sub Code : '+formData['subCode']+'</span></li>');
    $('#home-filter-choices').append('<li class="filter-choice"><span>Segment : '+formData['segment']+'</span></li>');
    $('#home-filter-choices').append('<li class="filter-choice"><span>Criteria : '+formData['criteriaText']+'</span></li>');
    if(formData['criteria'] == 'Year')
        $('#home-filter-choices').append('<li class="filter-choice"><span>Year : '+formData['year']+'</span></li>');
    if(formData['criteria'] == 'Quarter'){
        $('#home-filter-choices').append('<li class="filter-choice"><span>Year : '+formData['year']+'</span></li>');
        $('#home-filter-choices').append('<li class="filter-choice"><span>Quarter : '+formData['quarter']+'</span></li>');
    }
    if(formData['criteria'] == 'FY'){
        $('#home-filter-choices').append('<li class="filter-choice"><span>Financial Year : '+formData['finYear']+'</span></li>');  
    }
    if(formData['criteria'] == 'Month'){
        $('#home-filter-choices').append('<li class="filter-choice"><span>Year : '+formData['year']+'</span></li>');
        $('#home-filter-choices').append('<li class="filter-choice"><span>Month : '+formData['month']+'</span></li>');    
    }    
}

function populateTransactionCount(dataobject){
        $.ajax({
                type: "POST",
                url: "apis/spend/spend_cards.php",
                data: dataobject,
                cache: false,
                success: function (d) {
                    d = JSON.parse(d);
                    let ocAmount, ocCount = 0;
                    let opAmount, opCount = 0;
                    let rcAmount, rcCount = 0;
                    let rpAmount, rpCount = 0;
                    let ccAmount, ccCount = 0;
                    let cpAmount, cpCount = 0;
                    let tcAmount, tcCount = 0;
                    let tpAmount, tpCount = 0;
                    let originalCount = 0;
                    let refundCount = 0;
                    let reissueCount = 0;
                    let originalAmt = 0;
                    let refundAmt = 0;
                    let reissueAmt = 0;
                    for (let each in d['trxcount']) {
                            let invType = d['trxcount'][each]['inv_type'];
                            let count = parseInt(d['trxcount'][each]['count']);
                            let amt =  parseInt(d['trxcount'][each]['Amount']);
                            if ((invType).toUpperCase() == "ORIGINAL") {
                                originalCount = originalCount + count;
                                originalAmt = originalAmt + amt;
                            }
                            else if ((invType).toUpperCase() == "REFUND") {
                                refundCount = refundCount + count;
                                refundAmt = refundAmt + amt;
                            }
                            else if ((invType).toUpperCase() == "REISSUE") {
                                reissueCount = count;
                                reissueAmt = amt;
                            }
                    }
                    if (refundAmt < 0) {
                        refundAmt = -(refundAmt);
                    }

                    var totalCount = parseInt(originalCount) - parseInt(refundCount);
                    var totalAmt = parseInt(originalAmt) - parseInt(refundAmt) + parseInt(reissueAmt);
                    var overAllAmt = totalAmt;
                    ocAmount = ocAmount + parseInt(originalAmt);
                    ocCount = ocCount + parseInt(originalCount);
                    rcAmount = rcAmount + parseInt(reissueAmt);
                    rcCount = rcCount + parseInt(reissueCount);
                    ccAmount = ccAmount + parseInt(Math.abs(refundAmt));
                    ccCount = ccCount + parseInt(refundCount);
                    tcAmount = tcAmount + parseInt(totalAmt);
                    tcCount = tcCount + parseInt(totalCount);
                    $("#trx-original-count").text(originalCount);
                    $("#trx-reissue-count").text(reissueCount);
                    $("#trx-canel-count").text(refundCount);
                    $("#trx-travel-count").text(totalCount);
                    
                    let chartData =  [];

                    d['chartData'].map((d,i)=>{
                        let tempObj = {}
                        if(dataobject['criteria']=="Year"){
                            var number = d['type'].split("-")[1];
                            var month = monthArr[number-1];
                            tempObj['label'] = month;
                        }
                        else{
                        tempObj['label'] = d['type'];
                        }    
                        tempObj['amount']= parseInt(d['amount']);
                        chartData.push(tempObj);
                    });

                    $("#flot-chart").dxChart({
                                        palette: "Harmony Light",
                                        dataSource: chartData,
                                        commonSeriesSettings: {
                                            argumentField: "label"
                                        },
                                        series: [
                                            { valueField: "amount", name: "Amount" }
                                        ],
                                        margin: {
                                            bottom: 20
                                        },
                                        argumentAxis: {
                                            valueMarginsEnabled: false
                                        },
                                          tooltip: {
                                            enabled: true
                                        },
                                        tooltip: {
                                            enabled: true,
                                            customizeTooltip: function (arg) {
                                               return {
                                                    text: arg.argumentText + "<br/> Amount : " + formatValue(defaultLocale,defaultCurrency,arg.point._dataItem.data.amount)
                                                    };
                                            }
                                        }
                                    }).dxChart("instance");

                    var amtArray = [];
                    var trxArray = [];
                    amtArray.push({'invoice':'Original','value':originalAmt});
                    amtArray.push({'invoice':'Reissue','value':reissueAmt});
                    amtArray.push({'invoice':'Refund','value':refundAmt});
                    trxArray.push({'invoice':'Original','value':originalCount});
                    trxArray.push({'invoice':'Reissue','value':reissueCount});
                    trxArray.push({'invoice':'Refund','value':refundCount});


                    let pieChartObj = {
                        type: "doughnut",
                        palette: "Soft Pastel",
                        legend : {  
                            verticalAlignment: 'bottom',
                            horizontalAlignment: 'center',
                            itemTextPosition: 'right',
                            rowCount: 1
                        },
                        series: [{        
                            argumentField: "invoice",
                            valueField: "value",
                             label: {
                                format: {
    type: "fixedPoint", // the format of absolute values
    // precision: 1, // the precision of absolute values (123.456 --> 123.4)
    percentPrecision: 1 // the precision of percentage values (12.3456 % --> 12.34 %)
},
                                    visible: true,
                                    connector: {
                                        visible: true,
                                        width: 1
                                    },
                                    backgroundColor : "none",
                                             position  : 'inside',
                                         customizeText: function (arg) {
                                    return arg.percentText;
                                }
                                }
                        }],
                    };

                    $("#snapshot-trx-chart").dxPieChart({
                        dataSource : trxArray,
                        title : '<span style="font-size:18px;font-weight: bolda;">Transactions</span>',
                        tooltip: {
                            enabled: true,
                            customizeTooltip: function (arg) {
                               return {
                                        text: arg.argumentText + "<br/> Transactions : " + arg.point._dataItem.data.value
                                    };
                            }
                        },
                        ...pieChartObj
                    });
                      $("#snapshot-spend-chart").dxPieChart({
                        dataSource : amtArray,
                        title : '<span style="font-size:18px;font-weight: a;">Spends</span>',
                        tooltip: {
                            enabled: true,
                            customizeTooltip: function (arg) {
                               return {
                                        text: arg.argumentText + "<br/> Amount : " + formatValue(defaultLocale,defaultCurrency,arg.point._dataItem.data.value)
                                    };
                            },
                        },
                        ...pieChartObj
                    });
                }
                ,error: function () {
                    // $("#loading_icon").hide();
                    console.log("Ajax is not working");
                }
            });
}

function populateBusinessUnit(dataobject){
        $("#business-unit-eco").html("");
        $("#business-unit-biz").html("");
        $.ajax({
                type: "POST",
                url: "apis/spend/spend_top_business_units.php",
                data: dataobject,
                cache: false,
                success: function (d) {
                    d = JSON.parse(d);
                    let businessEcoData = d['ECO'];
                    let businessBizData = d['BIZ'];
                    let pieInstance = {
                        resolveLabelOverlapping: "shift",
                        palette: colorPalette,
                        legend: {
                            horizontalAlignment: "center",
                            verticalAlignment: "bottom"
                        },
                        "export": {
                            enabled: false
                        }, tooltip: {
                                    enabled: true,
                                    customizeTooltip: function (arg) {
                                       return {
                                                                text: arg.argumentText + "<br/> Spend : " + formatValue(defaultLocale,defaultCurrency,arg.point._dataItem.data.Total_Amount_Spent)
                                                            };
                                    }
                                },
                        series: [{
                            argumentField: "business_unit",
                            valueField: "Total_Amount_Spent",
                            label: {
                                visible: true,
                                connector: {
                                    visible: true,
                                    width: 0.5
                                },
                                format: {
                                        type: "fixedPoint", // the format of absolute values
                                        // precision: 1, // the precision of absolute values (123.456 --> 123.4)
                                        percentPrecision: 1 // the precision of percentage values (12.3456 % --> 12.34 %)
                                    },
                                customizeText: function (arg) {
                                    return arg.percentText;
                                },
                                backgroundColor : "none",
                                             position  : 'inside',
                            }
                        }]
                    };
                    if(businessEcoData.length < 1){
                        $("#business-unit-eco").html("<p class='spend-analysis-nodata'>No Data Found.</p>");
                    }
                    else{
                        $("#business-unit-eco").dxPieChart({
                        dataSource: businessEcoData,
                        title : '<span style="font-size:18px;">Economy</span>',
                        ...pieInstance
                     });
                    }

                    if(businessBizData.length < 1){
                        $("#business-unit-biz").html("<p class='spend-analysis-nodata'>No Data Found.</p>");
                    }
                    else{
                        $("#business-unit-biz").dxPieChart({
                        dataSource: businessBizData,
                        title : '<span style="font-size:18px;">Business</span>',
                        ...pieInstance
                     });
                    }
                }
                ,error: function () {
                    // $("#loading_icon").hide();
                    console.log("Ajax is not working");
                }
            });
}

function populateTopTravellers(dataobject){
    $('travellers-list').html("");
    $.ajax({
                type: "POST",
                url: "apis/spend/spend_top_travellers.php",
                data: dataobject,
                cache: false,
                success: function (d) {
                d = JSON.parse(d);
                if(d.length <1){
                  $('travellers-list').html("<p class='spend-analysis-nodata'>No Data Found.</p>");
                  return ;
                }
                    let travellerCount  = d.length >= 4 ? 3 : d.length;
                    for (var i = 0; i <= travellerCount; i++) {
                            $('#traveller-'+(i+1)).empty();
                            let amtSpend = formatValue(defaultLocale,defaultCurrency,d[i]['Total_Amount_Spent']) ;
                            let avgTktPrice = formatValue(defaultLocale,defaultCurrency,d[i]['ATP']) ;
                            let html = '<h5 class="m-b-md">'+(i+1)+'. '+d[i]['PAX_NAME'] +'</h5>'+
                                '<small>Amount Spent : '+amtSpend+'</small><br>'+
                                '<small>Average Ticket Price : '+avgTktPrice+'</small><br>'+
                                '<small>Tickets : '+d[i]['Tickets']+'</small><br>'+
                                '<small>Advance Purchase : '+d[i]['ap'] +' Days</small><br>'+
                            '</div>';
                            $('#traveller-'+(i+1)).append(html);
                    }
                },
                error: function () {
                    console.log("Ajax is not working");
                }
            });
}

function populateTopAirlines(dataobject){
        $("#airline-trx-chart-economy").html("");
        $("#airline-trx-chart-business").html("");
        $("#airline-amt-chart-economy").html("");
        $("#airline-amt-chart-business").html("");
        $.ajax({
                type: "POST",
                url: "apis/spend/spend_top_airlines.php",
                data: dataobject,
                cache: false,
                success: function (d) {
                    d = JSON.parse(d);
                    let airlineEcoData = d['ECO'];
                    let airlineBizData = d['BIZ'];
                    var ecoColorPallete = [],bizColorPallete = [];
                    
                    

                    airlineEcoData = airlineEcoData.map((d)=>{
                        d['count'] = parseInt(d['count']);
                        d['tot_fare'] = parseInt(d['tot_fare']);
                        ecoColorPallete.push(airLineColorObj[d["airline"]])
                        return d;
                    })

                    airlineBizData = airlineBizData.map((d)=>{
                        d['count'] = parseInt(d['count']);
                        d['tot_fare'] = parseInt(d['tot_fare']);
                        bizColorPallete.push(airLineColorObj[d["airline"]])
                        return d;
                    });

                    let trxSeries = {
                          commonSeriesSettings: {
                            type: "bar",
                            valueField: "tot_fare",
                            argumentField: "airline",
                            ignoreEmptyPoints: true
                        },
                         seriesTemplate: {
                                nameField: "airline"
                        },
                        tooltip: {
                            enabled: true,
                            customizeTooltip: function (arg) {
                               return {
                                    text: arg.argumentText + "<br/> Transactions :" + arg.point._dataItem.data.count
                                };
                            }
                        },
                    };



                    let amtSeries = {
                           commonSeriesSettings: {
                            type: "bar",
                            valueField: "count",
                            argumentField: "airline",
                            ignoreEmptyPoints: true
                        },
                         seriesTemplate: {
                                nameField: "airline"
                            },  
                        tooltip: {
                            enabled: true,
                            customizeTooltip: function (arg) {
                               return {
                                    text: arg.argumentText + "<br/> Spend :" + formatValue(defaultLocale,defaultCurrency,arg.point._dataItem.data.tot_fare)
                                };
                            }
                        },
                        };
                    var chartInstance = {
                                "valueAxis": {
                                    visible: true
                                    }
                                ,
                                "legend": {
                                    visible: true
                                }
                            };
                 if(airlineEcoData.length <  1){
                    $("#airline-trx-chart-economy").html("<p class='spend-analysis-nodata'>No Data Found.</p>");
                 }
                 else{
                    $("#airline-trx-chart-economy").dxChart({
                        dataSource: airlineEcoData,
                        palette : ecoColorPallete,
                        title : '<span style="font-size:18px;">Economy</span>',
                        ...chartInstance,
                        ...trxSeries
                    });
                 }
                 if (airlineBizData.length < 1) {
                    $("#airline-trx-chart-business").html("<p class='spend-analysis-nodata'>No Data Found.</p>");
                 }
                 else{
                    $("#airline-trx-chart-business").dxChart({
                        dataSource: airlineBizData,
                        palette : bizColorPallete,
                        title : '<span style="font-size:18px;">Business</span>',
                        ...chartInstance,
                        ...trxSeries
                    });
                 }

                 if(airlineEcoData.length < 1){
                    $("#airline-amt-chart-economy").html("<p class='spend-analysis-nodata'>No Data Found.</p>");
                 }
                 else{
                     $("#airline-amt-chart-economy").dxChart({
                            dataSource: airlineEcoData,
                            palette : ecoColorPallete,
                            title : '<span style="font-size:18px;">Economy</span>',
                            ...chartInstance,
                            ...amtSeries
                        });   
                }
                if(airlineBizData.length< 1){
                    $("#airline-amt-chart-business").html("<p class='spend-analysis-nodata'>No Data Found.</p>");
                }
                else{
                    $("#airline-amt-chart-business").dxChart({
                        dataSource: airlineBizData,
                        palette : bizColorPallete,
                        title : '<span style="font-size:18px;">Business</span>',
                        ...chartInstance,
                        ...amtSeries
                    });
                }
                 
                $("#topairlines-amt").hide();
                },
                error: function () {
                    // $("#loading_icon").hide();
                    console.log("Ajax is not working");
                }
            });        
}

function populateTopClassWise(dataobject){
     $("#class-wise-trx").html("");
     $.ajax({
                type: "POST",
                url: "apis/spend/spend_top_classwise.php",
                data: dataobject,
                cache: false,
                success: function (d) {
                    d = JSON.parse(d);
                    let pieInstance = {
                        resolveLabelOverlapping: "shift",
                        palette: colorPalette,
                        legend: {
                            horizontalAlignment: "center",
                            verticalAlignment: "bottom"
                        },
                        "export": {
                            enabled: false
                        }, tooltip: {
                                    enabled: true,
                                    customizeTooltip: function (arg) {
                                       return {
                                                                text: arg.argumentText + "<br/> Transactions :" + arg.point._dataItem.data.count
                                                            };
                                    }
                                },
                        series: [{
                            argumentField: "class",
                            valueField: "count",
                            label: {
                                visible: true,
                                connector: {
                                    visible: true,
                                    width: 0.5
                                },
                                format: {
    type: "fixedPoint", // the format of absolute values
    // precision: 1, // the precision of absolute values (123.456 --> 123.4)
    percentPrecision: 1 // the precision of percentage values (12.3456 % --> 12.34 %)
},
                                customizeText: function (arg) {
                                    return arg.percentText;
                                },
                                backgroundColor : "none",
                                             position  : 'inside',
                            }
                        }]
                    };

                    if(d.length < 1){
                        $("#class-wise-trx").html("<p class='spend-analysis-nodata'>No Data Found.</p>");
                        return;
                    }

                 $("#class-wise-trx").dxPieChart({
                        dataSource: d,
                        ...pieInstance
                     });

                },
                error: function () {
                                    // $("#loading_icon").hide();
                                    console.log("Ajax is not working");
                                }
                });
}

function populateRoutingWise(dataobject){
    $("#route-wise-trx").html("");
             $.ajax({
                type: "POST",
                url: "apis/spend/spend_routingwise.php",
                data: dataobject,
                cache: false,
                success: function (d) {
                    d = JSON.parse(d);
                    let pieInstance = {
                        resolveLabelOverlapping: "shift",
                        palette: colorPalette,
                        legend: {
                            horizontalAlignment: "center",
                            verticalAlignment: "bottom"
                        },
                        "export": {
                            enabled: false
                        }, tooltip: {
                                    enabled: true,
                                    customizeTooltip: function (arg) {
                                       return {
                                                                text: arg.argumentText + "<br/> Transactions :" + arg.point._dataItem.data.count
                                                            };
                                    }
                                },
                        series: [{
                            argumentField: "routing_type",
                            valueField: "count",
                            label: {
                                visible: true,
                                connector: {
                                    visible: true,
                                    width: 0.5
                                },
                                format: {
    type: "fixedPoint", // the format of absolute values
    // precision: 1, // the precision of absolute values (123.456 --> 123.4)
    percentPrecision: 1 // the precision of percentage values (12.3456 % --> 12.34 %)
},
                                customizeText: function (arg) {
                                    return  arg.percentText;
                                },
                                backgroundColor : "none",
                                             position  : 'inside',
                            }
                        }]
                    };
                if(d.length < 1){
                    $("#route-wise-trx").html("<p class='spend-analysis-nodata'>No Data Found.</p>");
                    return;
                }
                 $("#route-wise-trx").dxPieChart({
                        dataSource: d,
                        ...pieInstance
                     });

                },
                error: function () {
                                    // $("#loading_icon").hide();
                                    console.log("Ajax is not working");
                                }
                });
}

function populateTopCityPairs(dataobject){
    $("#oweco-citypair").html("");
    $("#rteco-citypair").html("");
    $("#owbiz-citypair").html("");
    $("#rtbiz-citypair").html("");

       $.ajax({
                type: "POST",
                url: "apis/spend/spend_city_pairs.php",
                data: dataobject,
                cache: false,
                success: function (d) {
                    d = JSON.parse(d);
                    let pieInstance = {
                        resolveLabelOverlapping: "shift",
                        palette: colorPalette,
                        legend: {
                            horizontalAlignment: "center",
                            verticalAlignment: "bottom"
                        },
                        "export": {
                            enabled: false
                        }, tooltip: {
                                    enabled: true,
                                    customizeTooltip: function (arg) {
                                       return {
                                                text: arg.argumentText + "<br/> Tickets :" + arg.point._dataItem.data.Tickets
                                            };
                                    }
                                },
                        series: [{
                            argumentField: "sector",
                            valueField: "Tickets",
                            label: {
                                visible: true,
                                connector: {
                                    visible: true,
                                    width: 0.5
                                },
                                format: {
                                    type: "fixedPoint", // the format of absolute values
                                    // precision: 1, // the precision of absolute values (123.456 --> 123.4)
                                    percentPrecision: 1 // the precision of percentage values (12.3456 % --> 12.34 %)
                                },
                                customizeText: function (arg) {
                                    return  arg.percentText;
                                },
                                backgroundColor : "none",
                                position  : 'inside',
                            }
                        }]
                    };

                    if(!(d['OW_ECO'].length)){
                        $("#oweco-citypair").html("<p class='spend-analysis-nodata'>No Data Found.</p>");
                    }
                    else{ 
                        $('#oweco-citypair').dxPieChart({
                                             dataSource : d['OW_ECO'],
                                             title : '<span style="font-size:18px;">One Way</span>',
                                             ...pieInstance
                                         })
                    }
                    if(!(d['RT_ECO'].length)){
                        $("#rteco-citypair").html("<p class='spend-analysis-nodata'>No Data Found.</p>");
                    }
                    else{
                        $('#rteco-citypair').dxPieChart({
                        dataSource : d['RT_ECO'],
                        title : '<span style="font-size:18px;">Round Trip</span>',
                        ...pieInstance
                        })    
                    }
                    

                    if(!(d['OW_BIZ'].length)){
                        $("#owbiz-citypair").html("<p class='spend-analysis-nodata'>No Data Found.</p>");
                    }
                    else{
                        $('#owbiz-citypair').dxPieChart({
                        dataSource : d['OW_BIZ'],
                        title : '<span style="font-size:18px;">One Way</span>',
                        ...pieInstance
                        })    
                    }
                    
                    if(!(d['RT_BIZ'].length)){
                        $("#rtbiz-citypair").html("<p class='spend-analysis-nodata'>No Data Found.</p>");
                    }
                    else{
                        $('#rtbiz-citypair').dxPieChart({
                        dataSource : d['RT_BIZ'],
                        title : '<span style="font-size:18px;">Round Trip</span>',
                        ...pieInstance
                        })    
                    }
                    $("#citypair-biz").hide();

                },
                error: function () {
                                    // $("#loading_icon").hide();
                                    console.log("Ajax is not working");
                                }
                });
}

function populateTopDestinations(dataobject){
    document.getElementById('destination-chart').innerHTML = "";
         $.ajax({
                type: "POST",
                url: "apis/spend/spend_gmap_destinations.php",
                data: dataobject,
                cache: false,
                success: function (d) {
                    let populate_data = JSON.parse(d);
                    let destination_data = [];
                    destination_data[0] = ['city', 'count'];
                var i = 1;
                $("#destination-chart").empty();
                if(populate_data.length <1){
                  document.getElementById('destination-chart').innerHTML = "<p class='spend-analysis-nodata'>No Data Found.</p>";
                }else{
                $.each(populate_data, function (k) {
                    var dest_calculator = getValueByKey(populate_data[i - 1]['DEST'], iata_data);
                    destination_data[i] = [dest_calculator, parseInt(populate_data[i - 1]['count'])];
                    i = i + 1;
                });
                // draw_chart(destination_data);
                function draw_chart(final_data1) {
                    var final_data1 = destination_data;
                    var data = google.visualization.arrayToDataTable(final_data1);
                    var options = {};
                    options['domain'] = "IN";
                    options['region'] = "IN";
                    options['colors'] = ['#183D81', '#39AF49'];
                    options['displayMode'] = 'markers';
                    var container = document.getElementById('destination-chart')
                    var chart = new google.visualization.GeoChart(container);
                    chart.draw(data, options);
                    }
                    google.charts.setOnLoadCallback(draw_chart);
                }
                },
                error: function () {
                                    // $("#loading_icon").hide();
                                    console.log("Ajax is not working");
                                }
                });
}

function getValueByKey(key, data) {
        var i, len = data.length;
        for (i = 0; i < len; i++) {
            if (data[i] && data[i].hasOwnProperty(key)) {
                return data[i][key];
            }
        }
        return -1;
}
