"use strict";


const ticketInfo = {
  ticketList: {
    "Agrawal/Tanuj": {
      tickets: [
        {
          ticketNumber: "1234567890",
          marker:"SOM-SOM",
          passengerType: "ADT",
          passengerName: "Agrawal/Tanuj",
          fareType: "REFUND | CORP",
          amt: "INR 58913",
          itin: "AI 307 K 29APR NRD DEL 1115 1700",
          baseFare: "INR 53565",
          farebasis: "KOSWTYR",
          baggage: "2P",
          class: "ECONOMY",
          afq: "AFQ 53566/ HFQ 44807",
          arc: "ARC B"
        },
        {
          ticketNumber: "1234567891",
          passengerType: "ADT",
          marker:"SOM-SOM",
          passengerName: "Agrawal/Tanuj",
          fareType: "REFUND | CORP",
          amt: "INR 58913",
          itin: "AI 307 K 29APR NRD DEL 1115 1700",
          baseFare: "INR 53565",
          farebasis: "KOSWTYR",
          baggage: "2P",
          class: "ECONOMY",
          afq: "AFQ 53566/ HFQ 44807",
          arc: "ARC B"
        }
      ]
    },
    "Agrawala/Tanuja": {
      tickets: [
        {
          ticketNumber: "1234567892",
          passengerType: "ADT",
          passengerName: "Agrawal/Tanuj",
          fareType: "REFUND | CORP",
          amt: "INR 58913",
          itin: "AI 307 K 29APR NRD DEL 1115 1700",
          baseFare: "INR 53565",
          farebasis: "KOSWTYR",
          marker:"SOM-SOM",
          baggage: "2P",
          class: "ECONOMY",
          afq: "AFQ 53566/ HFQ 44807",
          arc: "ARC B"
        },
        {
          ticketNumber: "1234567893",
          passengerType: "ADT",
          marker:"SOM-SOM",
          passengerName: "Agrawal/Tanuj",
          fareType: "REFUND | CORP",
          amt: "INR 58913",
          itin: "AI 307 K 29APR NRD DEL 1115 1700",
          baseFare: "INR 53565",
          farebasis: "KOSWTYR",
          baggage: "2P",
          class: "ECONOMY",
          afq: "AFQ 53566/ HFQ 44807",
          arc: "ARC B"
        }
      ]
    }
  }
};

const costMileCard = ({ miles, cost }) =>
  h(
    "div",
    {
      class: "col-md-10 col-md-offset-1 p5"
    },
    [
      h(
        "div",
        {
          class: "col-md-6 "
        },
        [
          h(
            "div",
            {
              class: "col-md-6 pull-left"
            },
            h("i", {
              class: "fa fa-plane fa-3x text-black",
              "aria-hidden": "true"
            })
          ),
          h(
            "div",
            {
              class: "col-md-6 text-right"
            },
            [
              h(
                "div",
                {
                  class: "row m0  m0  s10 text-green bold-text"
                },
                "MILES"
              ),
              h(
                "div",
                {
                  class: "row m0  m0  bold-text text-primary s16"
                },
                miles
              )
            ]
          )
        ]
      ),
      h(
        "div",
        {
          class: "col-md-6 "
        },
        [
          h(
            "div",
            {
              class: "col-md-6"
            },
            h("i", {
              class: "fa fa-rupee fa-3x text-black",
              "aria-hidden": "true"
            })
          ),
          h(
            "div",
            {
              class: "col-md-6 text-right"
            },
            [
              h(
                "div",
                {
                  class: "row m0  m0  s10 text-green bold-text"
                },
                "COST"
              ),
              h(
                "div",
                {
                  class: "row m0  m0  bold-text s16"
                },
                cost
              )
            ]
          )
        ]
      )
    ]
  );

const ticketList = ({ tickets }) => {
  
  return h("div", {
    id: "T" + tickets[0].ticketNumber,
    class: "col-md-12 p20  s10",
    oncreate: () => {
      $("#" + "T" + tickets[0].ticketNumber).dxAccordion({
        dataSource: tickets,
        collapsible: true,
        multiple: false,
        onSelectionChanged: function(e){
            if (e.addedItems.length === 0) {
                console.log("reducing")
                var heightInitial = $("#" + "T" + tickets[0].ticketNumber).height()
                $("#" + "T" + tickets[0].ticketNumber).height(10+tickets.length*50)
            }
            else  {
                console.log("reducing")
                
                $("#" + "T" + tickets[0].ticketNumber).height(220)
            }
            
        },
        itemTemplate: function(itemData, itemIndex, itemElement) {
          itemElement.append(
            $("<div>")
              .addClass("row m0  m0  s10")
              .append(
                $("<div>")
                  .addClass("col-md-12 p0-l")
                  .append(
                    $("<div>")
                      .addClass("col-md-8 capitals text-grey f700")
                      .append("Itinerary"),
                    $("<div>")
                      .addClass("col-md-4 text-right text-green f700")
                      .text(itemData.class),
                    $("<div>")
                      .addClass("col-md-8 text-black f700 p5-t")
                      .append(itemData.itin),
                    $("<div>")
                      .addClass("p5-t col-md-4 text-right ")
                      .append(
                        $("<div>")
                          .addClass("text-grey f600")
                          .text("BASE FARE"),
                        $("<div>")
                          .addClass("text-black f700")
                          .text(itemData.baseFare),
                        $("<div>")
                          .addClass("f600 p5-t text-grey")
                          .text("FARE BASIS"),
                        $("<div>")
                          .addClass("f700 text-black")
                          .text(itemData.farebasis)
                      )
                  ),
                $("<hr />"),
                $("<div>")
                  .addClass("col-md-12 p0-l p5-t")
                  .append(
                    $("<div>")
                      .addClass("col-md-8 text-grey f700")
                      .text("BAGGAGE : " + itemData.baggage)
                  ),

                $("<div>")
                  .addClass("col-md-12 p0-l")
                  .append(
                    $("<div>")
                      .addClass("col-md-8 f700 text-black")
                      .text(itemData.afq),
                    $("<div>")
                      .addClass("col-md-4 text-right text-black f700")
                      .text(itemData.arc)
                  )
              )
          );
        },
        itemTitleTemplate: function(itemData, itemIndex, itemElement) {
          itemElement.append(
            $("<div>")
              .addClass("row m0  m0 ")
              .append(
                $("<div>")
                  .addClass("col-md-4 s10 paxtype text-grey f700")
                  .text(itemData.marker),
                $("<div>")
                  .addClass("col-md-4 text-left p0")
                  .append(
                    $("<div>")
                      .addClass("row m0  p0 s12 f600 text-blue")
                      .text(itemData.ticketNumber),
                    $("<div>")
                      .addClass("row m0  m0  s10 p2-t text-grey f600")
                      .text("BASE FARE :" + itemData.baseFare)
                  ),
                $("<div>")
                  .addClass("col-md-3 p0 text-right")
                  .append(
                    $("<div>")
                      .addClass("row p0  m0  s10 text-green bold-text")
                      .text(itemData.fareType),
                    $("<div>")
                      .addClass("row p0  m0  s12 text-grey f600 p2-t")
                      .text(itemData.amt)
                  )
              )
          );
        }
      });
      var accordionObj = $("#" + "T" + tickets[0].ticketNumber).dxAccordion('instance')
      accordionObj.collapseItem(0)
    },
    onupdate: () => {
      $("#" + "T" + tickets[0].ticketNumber).dxAccordion({
        dataSource: tickets,
        collapsible: true,
        multiple: false,
        
        onSelectionChanged: function(e){
            if (e.addedItems.length === 0) {
                console.log("reducing")
                var heightInitial = $("#" + "T" + tickets[0].ticketNumber).height()
                $("#" + "T" + tickets[0].ticketNumber).height(10+tickets.length*50)
            }
            else  {
                console.log("reducing")
                
                $("#" + "T" + tickets[0].ticketNumber).height(220)
            }
            
        },
        itemTemplate: function(itemData, itemIndex, itemElement) {
          itemElement.append(
            console.log("itemData.itin in ticket.js ::: ::: ",itemData.itin),
            
            $("<div>")
              .addClass("row m0  m0  s10")
              .append(
                $("<div>")
                  .addClass("col-md-12 p0-l")
                  .append(
                    $("<div>")
                      .addClass("col-md-8 capitals text-grey f700")
                      .append("Itinerary"),
                    $("<div>")
                      .addClass("col-md-4 text-right text-green f700")
                      .text(itemData.class),
                    $("<div>")
                      .addClass("col-md-8 text-black f700 p5-t")
                      .append(itemData.itin),
                    $("<div>")
                      .addClass("p5-t col-md-4 text-right ")
                      .append(
                        $("<div>")
                          .addClass("text-grey f600")
                          .text("BASE FARE"),
                        $("<div>")
                          .addClass("text-black f700")
                          .text(itemData.baseFare),
                        $("<div>")
                          .addClass("f600 p5-t text-grey")
                          .text("FARE BASIS"),
                        $("<div>")
                          .addClass("f700 text-black")
                          .text(itemData.farebasis)
                      )
                  ),
                $("<hr />"),
                $("<div>")
                  .addClass("col-md-12 p0-l p5-t")
                  .append(
                    $("<div>")
                      .addClass("col-md-8 text-grey f700")
                      .text("BAGGAGE : " + itemData.baggage)
                  ),

                $("<div>")
                  .addClass("col-md-12 p0-l")
                  .append(
                    $("<div>")
                      .addClass("col-md-8 f700 text-black")
                      .text(itemData.afq),
                    $("<div>")
                      .addClass("col-md-4 text-right text-black f700")
                      .text(itemData.arc)
                  )
              )
          );
        },
        itemTitleTemplate: function(itemData, itemIndex, itemElement) {
          itemElement.append(
            console.log("itemData.marker in ticket.js ::: ::: ",itemData.marker),
            $("<div>")
              .addClass("row m0  m0 ")
              .append(
                $("<div>")
                  .addClass("col-md-4 s10 paxtype text-grey f700")
                  //.html('<a href="#" data-toggle="modal" data-target="#updateModal" > <i class="fa fa-2x fa-edit pull-left" aria-hidden="true"></i></a> '+itemData.marker),
                  .html(itemData.marker),
                $("<div>")
                  .addClass("col-md-4 text-left p0")
                  .append(
                    $("<div>")
                      .addClass("row m0  p0 s12 f600 text-blue")
                      .text(itemData.ticketNumber),
                    $("<div>")
                      .addClass("row m0  m0  s10 p2-t text-grey f600")
                      .text("BASE FARE :" + itemData.baseFare)
                  ),
                $("<div>")
                  .addClass("col-md-3 p0 text-right")
                  .append(
                    $("<div>")
                      .addClass("row p0  m0  s10 text-green bold-text")
                      .text(itemData.fareType),
                    $("<div>")
                      .addClass("row p0  m0  s12 text-grey f600 p2-t")
                      .text(itemData.amt)
                  )
              )
          );
        }
      });
      var accordionObj = $("#" + "T" + tickets[0].ticketNumber).dxAccordion('instance')
      accordionObj.collapseItem(0)
    }
  });
};

const ticketView = (state, actions) => {
  console.log(state.ticketList);
  return h(
    "div",
    {
      class: "col-md-12 p0 scrollbox-t",
      // "data-simplebar":"true",
      // "data-simplebar-auto-hide":"false"
    },
    Object.keys(state.ticketList).map(el =>
      h("div", { class: "" }, [
        h(
          "div",
          { class: "col-md-12 p0 s12 text-right" },
          state.ticketList[el].tickets[0].passengerType + " - " + el
        ),
        h(
          ticketList,
          {
            tickets: state.ticketList[el].tickets
          },
          null
        )
      ])
    )
  );
};

const ticketActions = {
  update: value => state => ({
    ticketList: value
  })
};

const ticketInfoApp = app(
  ticketInfo,
  ticketActions,
  ticketView,
  document.getElementById("ticketInfo")
);

function addAltTickets(){
    $.ajax({
        type:"POST",
        url:'create_json.php',
        data:{selectedPNR:selectedPNR},
        success:function(){
            console.log('success');
            $('#added_pnr').val(selectedPNR);
            $('#added_pnr1').val(selectedPNR);
            $('#added_pnr2').val(selectedPNR);
            $('#opensectors').trigger('click');
//            $('#reasons').modal('show');
        },
        error:function(){
            console.log('error');
        }
    });
    
//  $('#reasons').modal('show');
}

function closePNRModal(){
  $('#closePNR').modal('show');
}

function openExceptionReport(){
    
  html='<div class="row">'+ 
      '<input type="hidden" name="mnaltdata[sel_q]" class="form-control" id="selopt"/><input type="hidden" name="mntktid" class="form-control" id="mntktid" value=""/><input type="hidden" id="mntkt_version" name="mnaltdata[version]" value="1"/><input type="hidden" id="loop_json_val" name="loop_json_val" /><input type="hidden" id="corp_applied" name="corp_applied" /><input type="hidden" id="s_tax" name="s_tax" value="0" />'+
  '<div class="col-md-4"><div class="form-group"><label class="editFont">Sec No</label>'+
  '<input id="mntsecid" name="mnaltdata[SectorNo]" type="text" class="form-control"   value=""></div></div>'+
  '<div class="col-md-4"><div class="form-group"><label class="editFont">Tkt No</label>'+
  '<input id="mntktnumid" name="mnaltdata[TktNo]" type="text" class="form-control"   value=""></div></div>'+
  '<div class="col-md-4"><div class="form-group"><label class="editFont">PNR</label>'+
  '<input id="added_pnr3" name="mnaltdata[pnr]" type="text" class="form-control"   value=""></div></div>'+
  
  '<div class="col-md-10"><div class="form-group"><label class="editFont">Fare Construction</label>'+
  '<input id="mntktfareconstruction" name="mnaltdata[fare_construction]" type="text" class="form-control" value=""></div></div>'+
  '<div class="col-md-1">'+
  '<button type="button" class="btn btn-primary" style="margin-top: 18px;" onclick="checkfc()">Submit</button></div>'+
  '<div class="col-md-1">'+
  '<button type="button" onclick="mn_gen_flight_deals()" class="btn btn-primary" style="margin-top: 18px;">Check</button></div>'+
  '</div>'+
  
    '<div class="row"><div class="col-md-12" id="breakage_data"></div></div>'+
    '<div class="row"><div class="col-md-12" id="list_discount"></div></div>'+
 '<div class="row"><div class="col-md-10"><div class="form-group"><label class="editFont">Tax Construction</label>'+
  '<input id="tax_string" name="" type="text" class="form-control"   value=""></div></div>'+
  '<div class="col-md-2">'+
  '<button type="button" class="btn btn-primary" onclick="mn_add_tax()" style="margin-top: 18px;">Add Tax</button></div></div></div>'+
 
  '<!--</div>-->'+
  '<div class="row">'+

  '<div class="col-md-2"><div class="form-group"><label class="editFont">Base Fare</label>'+
  '<input id="mnamtid" name="mnaltdata[base_fare]" type="text" class="form-control"   value=""><input type="hidden" id="percentage_data" /></div></div>'+
  '<div class="col-md-2"><div class="form-group"><label class="editFont">YQ</label>'+
  '<input id="mnyqid" name="mnaltdata[YQ]" type="text" class="form-control"   value=""></div></div>'+
  '<div class="col-md-2"><div class="form-group"><label class="editFont">Tax</label>'+
  '<input id="mntaxid" name="mnaltdata[tax]" type="text" class="form-control" value=""></div></div>'+
  '<div class="col-md-2">'+
  '<button type="button" class="btn btn-primary" onclick="cal_ttl_fare()" style="margin-top: 18px;">Apply</button></div>'+
  '<div class="col-md-2"><div class="form-group"><label class="editFont">Total Retail Fare</label>'+
  '<input id="mntotamtid" name="mnaltdata[total_fare]" type="text" class="form-control"   value=""></div></div>'+
  '<div class="col-md-2"><div class="form-group"><label class="editFont">Total Corp Fare</label>'+
  '<input id="mncorpamtid" name="mnaltdata[corporate_fare]" type="text" class="form-control" value="0"><input type="hidden" id="mncorptotamtid" value="0"/></div></div>'+
  '</div>'+
  
  '<div class="row">'+
  
  '<div class="col-md-4"><div class="form-group"><label class="editFont">Cabin Type</label>'+
  '<select name="mnaltdata[class_type]" class="form-control">'+
  '<option selected>Economy</option>'+
  '<option>Business</option>'+
  '<option>First Class</option>'+
  '<option>Premium Economy</option>'+
  '<option>Discounted First Class</option>'+
  '</select>'+

  '</div></div>'+
  '<div class="col-md-4"><div class="form-group"><label class="editFont">Fare Type</label>'+
  '<select name="mnaltdata[fare_type]" id="mnaltdata_fare_type" class="form-control">'+
  '<option selected>Retail</option>'+
  '<option>Corporate</option>'+
  '</select>'+ 
  '</div></div>'+
  '<div class="col-md-4"><div class="form-group"><label class="editFont">Fare Class</label>'+
  '<input id="fareclassid" name="mnaltdata[fare_class]" type="text" class="form-control"   value=""></div></div>'+
  

  '<div class="col-md-3"><div class="form-group"><label class="editFont">Fare Basis</label>'+
  '<input id="mnfarebasisid" name="mnaltdata[fare_basis]" type="text" class="form-control"   value=""></div></div>'+
  
  '<div class="col-md-3"><div class="form-group"><label class="editFont">Airline</label>'+
  '<input id="" name="mnaltdata[airline]" type="text" class="form-control"   value=""></div></div>'+
  
  '<div class="col-md-3"><div class="form-group"><label class="editFont">Currency</label>'+
  '<input id="mncurrencyid" name="mnaltdata[currency]" type="text" class="form-control"   value=""></div></div>'+
  
  '<div class="col-md-3"><div class="form-group"><label class="editFont">Baggage</label>'+
  '<input id="" name="mnaltdata[baggage]" type="text" class="form-control" value=""></div></div>'+
  '</div>'+ 
  '<div class="row">'+
  '<div class="col-md-12"><div class="form-group"><label class="editFont">Itinerary Storing</label>'+
  '<textArea id="mnitineraryid" name="mnaltdata[itinerary]" type="text" class="form-control "></textArea></div></div>'+
  
  '<div class="col-md-12"><div class="form-group"><label class="editFont">Comments</label>'+
  '<textArea id="" name="mnaltdata[comments]" type="text" class="form-control "></textArea></div></div>'+
  
  '</div>'; 

  
  $('#exceptionReport').html(html);
    $('#added_pnr3').val(selectedPNR);
//    var sectorSelected = $("input[name='tktary[]']:checked").val();
//    alert("sectorSelected :: :: "+sectorSelected);
    
    event.preventDefault();
    var searchIDs = $("#gridContainer input:checkbox:checked").map(function(){
		return $(this).val();
    }).get();
    
    var fval="";
	var fval1="";
	var fval2="";
	var fval3="";
	var fval4="";
	if(searchIDs != "")
	{
        
        $('#sectorsSelection').modal('hide');

        $('#auditExceptionReport').modal('show');
        
		var ary1 = searchIDs.toString().split(',');
		for(var i=0;i<ary1.length;i++)
		{
			var ary2 = ary1[i].split('^');
			for(var j=0;j<1;j++)
			{
				fval = ary2[0]+','+fval;
				fval1 = ary2[1]+','+fval1;
				fval2 = ary2[2]+','+fval2;
				fval3 = ary2[3];
				fval4 = ary2[4];
			}
		}
		var fvalary = fval.substring(0, fval.length - 1).split(',');
		var fvalary1 = fval1.substring(0, fval1.length - 1).split(',');
		
		fvalary.reverse();
		fvalary1.reverse();
		
		fval = fvalary.toString();
		fval1 = fvalary1.toString();
		fval2 = fval2.substring(0, fval2.length - 1);
		//alert(fval2);
		$('#addfareclsid').trigger('click');
		$('#mntktnumid').val(fval);
		$('#mntsecid').val(fval1);
		$('#mntktid').val(fval2);
		//$('#mn_Origin').val(fval3);
		//$('#mn_Destination').val(fval4);
		$('#mncurrencyid').val($('#getcurrencyid').val());
		$('#manualaltfare').modal();
        
//        manualaltform.reset();
        $('#list_discount').html('');
        $('#fare_break_id').hide();
	}
	else
	{
		alert('Kindly Choose alteast one Sector');
        return false;
	}
 
}


function openSectors(){
  $.getJSON( "data/pnr/edit_tickets/"+selectedPNR+"/"+selectedPNR+".js", function( data ) {
    
 
    var jsonData = JSON.stringify(data);
 
     
     var itinData = JSON.parse(jsonData);
     var i = 0;
     $("#gridContainer").dxDataGrid({
       dataSource: itinData,
   
             columns: [{
               dataField: "",
               caption: "Select",
               width: "6%",
               headerCellTemplate: function (header, info) {
                 $("<div>")
                   .html(info.column.caption)
                   .css("font-size", "12px")
                   .css("text-transform", "uppercase")
                   .css("font-weight", "bold")
                   .css("color", "#2e497b")
                   .appendTo(header);
               },
               cellTemplate: function (container, options) {
                   
                    i++
                htmldata = '<input class="flat" type="checkbox" id="tktsec'+i+'" name="tktary[]" value="'+options.data.ticketNo+"^"+i+"^"+options.data.tktId+"^"+options.data.origin+"^"+options.data.arrival+'">'
               
                 $('<div class="width-120">')
                   .html(htmldata)
                   .css("font-size", "12px")
                   .css("text-transform", "uppercase")
                   .appendTo(container);
               }
             },{
               dataField: "",
               caption: "Sec No",
               width: "6%",
               headerCellTemplate: function(header, info) {
                   $('<div>')
                       .html(info.column.caption)
                       .css('font-size', '10px')
                       .css('text-transform', 'uppercase')
                       .css('font-weight', 'bold')
                       .css('color', '#2e497b')
                       .appendTo(header);
               }},{
                     dataField: "itinerary",
                     caption: "Sector",
                     headerCellTemplate: function(header, info) {
                         $('<div>')
                             .html(info.column.caption)
                             .css('font-size', '10px')
                             .css('text-transform', 'uppercase')
                             .css('font-weight', 'bold')
                             .css('color', '#2e497b')
                             .appendTo(header);
                     }},
                       {    
                          dataField: "pnr",
                           caption: "PNR",
                           headerCellTemplate: function(header, info) {
                               $('<div>')
                                   .html(info.column.caption)
                                   .css('font-size', '10px')
                                   .css('text-transform', 'uppercase')
                                   .css('font-weight', 'bold')
                                   .css('color', '#2e497b')
                                   .appendTo(header);
                           }},
                           {
                           dataField: "ticketNo",
                           caption: "TKT No",
                           headerCellTemplate: function(header, info) {
                               $('<div>')
                                   .html(info.column.caption)
                                   .css('font-size', '10px')
                                   .css('text-transform', 'uppercase')
                                   .css('font-weight', 'bold')
                                   .css('color', '#2e497b')
                                   .appendTo(header);
                           }},
                           {
                           dataField: "ticketNo",
                           caption: "Version",
                           headerCellTemplate: function(header, info) {
                               $('<div>')
                                   .html(info.column.caption)
                                   .css('font-size', '10px')
                                   .css('text-transform', 'uppercase')
                                   .css('font-weight', 'bold')
                                   .css('color', '#2e497b')
                                   .appendTo(header);
                           }}],
                       showBorders: true
     });
   
    });             
  $('#sectorsSelection').modal('show');
}

function genIti(){
    var htmlData='';
    $.ajax({
        url:'read_iti.php',
        method:'POST',
        data:{pnr:selectedPNR},
        success:function(data){
            var pdata = JSON.parse(data);
            if(pdata.istatus != 1){
                var ppdata = pdata.content;
                var j=0;
                $.each(ppdata, function(i, item) {
                    if(j % 2 == 0)
                        htmlData += '<div class="col-lg-2 text-center">'+
                                        '<div class="row s10 capitals">'+ppdata[i].country+'</div>'+
                                            '<div class="row f700 text-blue s16">'+ppdata[i].airportCode+'</div>'+
                                            '<div class="row s8 capitals dep">'+ppdata[i].depDate+'<br/>'+ppdata[i].depTime+'</div>'+
                                    '</div>';
                    else
                        htmlData += '<div class="col-lg-2 text-center">'+
                                        '<div class="row s10">'+ppdata[i].connections+'</div>'+
                                            '<!--<div class="row text-blue">'+
                                                '<i class="fa fa-arrows-h fa-2x"></i>'+
                                            '</div>-->'+
                                            '<div class="row">'+
                                                '<img src="img/airlines/'+ppdata[i].airline+'.png" alt="'+ppdata[i].airline+'" width="30" />'+
                                            '</div>'+
                                            '<div class="row s8 capitals g8 dep">'+ppdata[i].airline+'</div>'+
                                    '</div>';
                    j++;
                });
                $('#itiContent').html(htmlData);
            }
            else{
                $('#itiContent').html('');
            }
        },
        error:function(){
            alert('Request failed. Kindly try after sometime.');
        }
    });
}
function readAltFares(){
    $.ajax({
       method:"POST",
        url:"read_alt_fares.php",
        data:{pnr:selectedPNR},
        success:function(data){
            var htmlData = '';
//            console.log(data);
            var pdata = JSON.parse(data);
            if(pdata.status == 1){
                htmlData = 'Alternate fares not available';
            }
            else{
                htmlData += '<div class="accordion">';
                $.each(pdata.fareInfo, function(i, item) {
                htmlData += '<h3 class="h3" style="background-color:white;border-color:rgb(238, 238, 238);">'+
                                '<div class="col-sm-12">'+
                                    '<div class="row">'+
                                        '<div class="col-sm-2">'+
                                            '<img src="img/airlines/'+pdata.fareInfo[i].logo+'.png" height="40" width="30" class="img img-responsive">'+
                                        '</div>'+
                                        '<div class="col-sm-2" id="travel_duration">'+
                                            'Jet Airways'+
                                            '<p class="p1"><b>'+pdata.fareInfo[i].sector+'</b></p>'+
                                            '<p class="p2">'+pdata.fareInfo[i].via+'</p>'+
                                        '</div>'+
                                        '<div class="col-sm-3"  id="travel_duration">'+
                                            'Deparature Time'+
                                            '<p class="travel_duration"><b>'+pdata.fareInfo[i].departureTime+'</b></p>'+
                                        '</div>'+
                                        '<div class="col-sm-3" id="travel_duration">Travel Duration'+
                                            '<p class="travel_duration"><b>'+pdata.fareInfo[i].travel+'</b></p>'+
                                        '</div>'+
                                        '<div class="col-sm-2" id="corporate"><b>Corporate</b>'+
                                            '<p class="rcorporate"><b>'+pdata.fareInfo[i].amt+'</b></p>'+
                                        '</div>'+
                                    '</div>'+
                                '</div>'+
                            '</h3>'+
                        '<div class="accordion1">';
//                            console.log(pdata.fareInfo[i].legs);
//                            var plegs = JSON.parse(pdata.fareInfo[i].legs);
                            var legi = pdata.fareInfo[i].legs;
                            $.each(legi, function(j, items) {
//                                console.log('inn');
                            htmlData += '<div class="row">'+
                                    '<div class="col-sm-1">'+
                                        '<img src="img/itin/dotted_flight_80dp.png">'+
                                    '</div>'+
                                    '<div class="col-sm-6">'+
                                        '<p id="deparature_info"> '+legi[j].Departure+' . '+legi[j].departureCity+' ('+legi[j].departureAirportCode+')</p>'+
                                        '<p id="travel_time">Travel Time . </p>'+
                                        '<p id="arrival_info"> '+legi[j].Arrival+' . '+legi[j].arrivalCity+'('+legi[j].arrivalAirportCode+')</p>'+
                                    '</div>'+
                                    '<div class="col-sm-2">'+
                                        '<p class="p3">'+legi[j].meta_a+'</p>'+
                                        '<p class="p4">'+legi[j].meta_b+'</p>'+
                                        '<p id="p">'+legi[j].airline+' . '+legi[j].cabinClass+' . '+legi[j].operatingAirline+' . '+legi[j].flightNumber+'</p>'+
                                    '</div>'+
                                    '<div class="col-sm-3"></div>'+
                                '</div>';
                            });
                    htmlData += '</div>';
                });
                htmlData += '</div>';
            }
            $('#altFareInfo').html(htmlData);
            acc_init();
        },
        error:function(){
            alert('Request failed. Kindly try after sometime.');
        }
    });
}

function addTickets(){
  $('#addTickModal').modal('show');
 
    html = '<div class="row"> <div class="col-md-3"><div class="form-group"><label class="editFont">PNR</label>'+
                    '<input id="pnr" name="input[PNR]" type="text" class="form-control" value="'+selectedPNR+'"></div></div>'+
                    '<div class="col-md-3"><div class="form-group"><label class="editFont">PNR Count</label>'+
                    '<input id="pnrCount" name="input[Pnr_Count]" type="text" class="form-control" value=""></div></div>'+
                    
                    '<div class="col-md-3"><div class="form-group"><label class="editFont">Pax Name<font color="red">*</font></label>'+
                    '<input id="paxName" required name="input[Pax_Name]" type="text" class="form-control"   value=""></div></div>'+
                    
                    '<div class="col-md-3"><div class="form-group"><label class="editFont">Dep Date<font color="red">*</font></label>'+
                    '<input id="depDate" required  name="input[Dep_Date]" type="text" class="form-control"   value=""></div></div></div>'+
                    '<div class="row"> <div class="col-md-7"><div class="form-group"><label class="editFont">Fare Construction</label>'+
                    '<input id="fareConstruction" name="input[Fare_Construction]" type="text" class="form-control"   value=""></div></div>'+
                    '<div class="col-md-2"><div class="form-group"><label class="editFont">Compass ID</label>'+
                    '<input id="Compose_ID" name="input[Compose_ID]" type="text" class="form-control"   value=""></div></div>'+
                    '<div class="col-md-3"><div class="form-group"><label class="editFont">Dep Time<font color="red">*</font></label>'+
                    '<input id="depTime" required name="input[Dep_Time]" type="text" class="form-control"   value=""></div></div></div>'+
                    


                    '<div class="row"> <div class="col-md-3"><div class="form-group"><label class="editFont">Airline Code<font color="red">*</font></label>'+
                    '<input id="airlineCode" required name="input[Airline_Code]" type="text" class="form-control"   value=""></div></div>'+
                    '<div class="col-md-3"><div class="form-group"><label class="editFont">Flight No<font color="red">*</font></label>'+
                    '<input id="flightNo" required name="input[Flight_No]" type="text" class="form-control"   value=""></div></div>'+
                    
                    '<div class="col-md-3"><div class="form-group"><label class="editFont">Tkt Number <font color="red">*</font></label>'+
                    '<input id="tktNumber" required name="input[TktNumber]" type="text" class="form-control"   value=""></div></div>'+
                    
                    '<div class="col-md-3"><div class="form-group"><label class="editFont">Coupon Number</label>'+
                    '<input id="couponNo" name="input[CouponNum]" type="text" class="form-control"   value=""></div></div></div>'+ 
                                         
                    '<div class="row"> <div class="col-md-3"><div class="form-group"><label class="editFont">BIC<font color="red">*</font></label>'+
                    '<input id="BIC" required name="input[BIC]" type="text" class="form-control"   value=""></div></div>'+
                    '<div class="col-md-3"><div class="form-group"><label class="editFont">Fare Basis</label>'+
                    '<input id="fareBasis" name="input[Fare_Basis]" type="text" class="form-control"   value=""></div></div>'+
                    
                    '<div class="col-md-3"><div class="form-group"><label class="editFont">Cabin Class</label>'+
                    '<input id="cabinClass" name="input[Cabin_Class]" type="text" class="form-control"   value=""></div></div>'+
                    
                    '<div class="col-md-3"><div class="form-group"><label class="editFont">Start Airport<font color="red">*</font></label>'+
                    '<input id="startAirport" required name="input[Dep_Airport]" type="text" class="form-control"   value=""></div></div></div>'+
                    '<div class="row"> <div class="col-md-3"><div class="form-group"><label class="editFont">Start Country</label>'+
                    '<input id="startCountry" name="input[Start_Country]" type="text" class="form-control"   value=""></div></div>'+
                    '<div class="col-md-3"><div class="form-group"><label class="editFont">End Airport<font color="red">*</font></label>'+
                    '<input id="endAirport" required name="input[Arr_Airport]" type="text" class="form-control"   value=""></div></div>'+
                    
                    '<div class="col-md-3"><div class="form-group"><label class="editFont">End Country</label>'+
                    '<input id="endCountry" name="input[End_Country]" type="text" class="form-control"   value=""></div></div>'+
                    '<div class="col-md-3"><div class="form-group"><label class="editFont">Trip Type<font color="red">*</font></label>'+
                    '<input id="tripType" required name="input[Int_Dom]" type="text" class="form-control"   value=""></div></div></div>'+
                    


                    '<div class="row"> <div class="col-md-3"><div class="form-group"><label class="editFont">Routing Type</label>'+
                    '<select name="routingType" class="form-control" name="input[Routing_Type]"><option val="OW">OW</option><option val="RT">RT</option> </select></div></div>'+
                   
                   
                    
                    '<div class="col-md-3"><div class="form-group"><label class="editFont">Base Fare Currency</label>'+
                    '<input id="baseFareCurrency" name="input[Base_Fare_Currency]" type="text" class="form-control"   value=""></div></div>'+
                    '<div class="col-md-3"><div class="form-group"><label class="editFont">Base Fare Amount</label>'+
                    '<input id="baseFareAmount" name="input[Base_Fare_amt]" type="text" class="form-control"   value=""></div></div>'+
                    
                    '<div class="col-md-3"><div class="form-group"><label class="editFont">Total Amt Currency<font color="red">*</font></label>'+
                    '<input id="totalAmtCurrency" required name="input[Tot_Currency]" type="text" class="form-control"   value=""></div></div></div>'+
                    

                    '<div class="row"> <div class="col-md-3"><div class="form-group"><label class="editFont">Total Amount</label>'+
                    '<input id="totalAmount" name="input[Tot_Amt]" type="text" class="form-control"   value=""></div></div>'+
                    
                    '<div class="col-md-3"><div class="form-group"><label class="editFont">Result</label>'+
                    '<input id="result" name="input[Result]" type="text" class="form-control"   value=""></div></div>'+
                    '<div class="col-md-3"><div class="form-group"><label class="editFont">Out Of Scope</label>'+
                    '<input id="outOfScope" name="input[Out_Of_Scope]" type="text" class="form-control"   value=""></div></div>'+
                    
                    '<div class="col-md-3"><div class="form-group"><label class="editFont">Error Code</label>'+
                    '<input id="errorCode" name="input[Error_Codes]" type="text" class="form-control"   value=""></div></div></div>'+
                    
                   
                     '<div class="row"> <div class="col-md-3"><div class="form-group"><label class="editFont">Alt Airline</label>'+
                    '<input id="altAirline" name="input[Alt_Airline]" type="text" class="form-control"   value=""></div></div>'+
                    
                    '<div class="col-md-3"><div class="form-group"><label class="editFont">Alt Itinerary</label>'+
                    '<input id="altItinerary" name="input[Alt_Itinerary]" type="text" class="form-control"   value=""></div></div>'+
                    '<div class="col-md-3"><div class="form-group"><label class="editFont">Alt Fare</label>'+
                    '<input id="altFare" name="input[Alt_Fare]" type="text" class="form-control"   value=""></div></div>'+
                    
                    '<div class="col-md-3"><div class="form-group"><label class="editFont">AFQ</label>'+
                    '<input id="afq" name="input[AFQ]" type="text" class="form-control"   value=""></div></div></div>'+
                    

                    '<div class="row"> <div class="col-md-3"><div class="form-group"><label class="editFont">HFQ</label>'+
                    '<input id="hfq" name="input[HFQ]" type="text" class="form-control"   value=""></div></div>'+
                    
                    '<div class="col-md-3"><div class="form-group"><label class="editFont">TMC Alt Fare1</label>'+
                    '<input id="tmcAltFare1" name="input[tmc_alt_fare1]" type="text" class="form-control"   value=""></div></div>'+
                    '<div class="col-md-3"><div class="form-group"><label class="editFont">TMC Alt Fare2</label>'+
                    '<input id="tmcAltFare2" name="input[tmc_alt_fare2]" type="text" class="form-control"   value=""></div></div>'+
                    
                    '<div class="col-md-3"><div class="form-group"><label class="editFont">Declined Fare</label>'+
                    '<input id="declinedFare" name="input[Decline_Fare]" type="text" class="form-control"   value=""></div></div></div>'+
                    

                    '<div class="row"> <div class="col-md-3"><div class="form-group"><label class="editFont">Baggage</label>'+
                    '<input id="baggage" name="input[Baggage]" type="text" class="form-control"   value=""></div></div>'+
                    
                    '<div class="col-md-3"><div class="form-group"><label class="editFont">Visa Type</label>'+
                    '<input id="visaType" name="input[Visa_Type]" type="text" class="form-control"   value=""></div></div>'+
                    '<div class="col-md-3"><div class="form-group"><label class="editFont">fare Type</label>'+
                    '<input id="fareType" name="input[Fare_Type]" type="text" class="form-control"   value=""></div></div>'+
                    
                    '<div class="col-md-3"><div class="form-group"><label class="editFont">Refundable</label>'+

                    '<select name="refundable" class="form-control" name="input[Refundable]"><option val="Yes">Yes</option><option val="No">No</option> </select></div></div></div>'+


                   
                    

                    '<div class="row"> <div class="col-md-3"><div class="form-group"><label class="editFont">Sector</label>'+
                    '<input id="sector" name="input[Sector]" type="text" class="form-control"   value=""></div></div>'+
                    
                    '<div class="col-md-3"><div class="form-group"><label class="editFont">ARC</label>'+
                    '<input id="arc" name="input[ARC]" type="text" class="form-control"   value=""></div></div>'+
                    '<div class="col-md-3"><div class="form-group"><label class="editFont">Op Air</label>'+
                    '<input id="opAir" name="input[Op_Air]" type="text" class="form-control"   value=""></div></div>'+
                    
                    '<div class="col-md-3"><div class="form-group"><label class="editFont">Freq Flier</label>'+
                    '<input id="freqFlier" name="input[Freq_Flyer]" type="text" class="form-control"   value=""></div></div></div>'+
                   
                    
                    '<div class="row"> <div class="col-md-3"><div class="form-group"><label class="editFont">Itinerary</label>'+
                    '<input id="itinerary" name="input[Itinerary]" type="text" class="form-control"   value=""><input id="TktID" name="TktID" type="hidden"  value=""></div></div>'+
                    
                    '<div class="col-md-3"><div class="form-group"><label class="editFont">Carrier Type</label>'+
                    '<input id="carrierType" name="input[Carrier_Type]" type="text" class="form-control"   value=""></div></div>'+
                    '<div class="col-md-3"><div class="form-group"><label class="editFont">FC Fare Breakup</label>'+
                    '<input id="fcFareBreakup" name="input[fc_fare_breakage]" type="text" class="form-control"   value=""></div></div>'+
                    
                    '<div class="col-md-3"><div class="form-group"><label class="editFont">Remarks</label>'+
                    '<input id="remarks" name="input[Remarks]" type="text" class="form-control" value=""></div></div></div>';
                    
                    $('#addTicketSummary').html(html);
                
}
//function add_Manual_Fare_entry_screenshot('TEST12'){
////function uploadScreenshot(){
////    alert("Upload Screenshot");
////    $('#tktaddimgmdid').show();
//}

function delimg(shID)
{
    var data = {shid:shID};
    $.ajax({
            type:"POST",
            url : "delscreenshot.php",
            data: data,
            cache:false,
            success:function(data){
                /*if(data != "error")
                {*/
                    $("#imgdelmsg").show().delay(2000).fadeOut();
                    $('#tr'+shID).remove();
                /*}
                else
                {
                    alert('Your are not authorized to perform this action');
                }*/
            }
        });
}

function viewScreenshot(AltID){
//    var AltID=4282;
    $('#imgtable').empty();
			$('#imgtable').append("<tr><td colspan='4'>Loading...</td></tr>");
			$.ajax({
               type: "POST",
               //dataType: 'json',
               url: "get_screenshots.php",
               data: {altid:AltID}, // serializes the form's elements.
               success: function(data)
               {
				   var htmlData ="";
				   if(data != 0){
					   var jsonObject = $.parseJSON(data);
					   $('#imgtable').empty();
					   $.each(jsonObject, function(i, item) {
						   htmlData += '<tr id="tr'+jsonObject[i].ScreenshotID+'"><td>'+jsonObject[i].ScreenshotID+'</td><td>'+jsonObject[i].AltID+'</td><td><a target="_blank" href="'+jsonObject[i].Screenshot+'"><img src="'+jsonObject[i].Screenshot+'" width="50"></a></td><td><a href="javascript:void(0)" onclick="if(confirm(\'Are you sure?\')) delimg('+jsonObject[i].ScreenshotID+');"><i class="fa fa-trash"></i></a></td></tr>';
                    });
				   }
                   else{
					   $('#imgtable').empty();
					   htmlData = "<tr><td colspan='4'>No Records Found</td></tr>";
				   }
                   //
                   $('#imgtable').append(htmlData);
               }
             });
            $("#tktimgmdid").modal();
}

function updateAuditfn(ticketNo){
  
    
    $('#updateModal').modal('show');
  //D:\docroot\tripnomics-2.0 -DEMO\data\pnr\edit_tickets\M6WMFL
  
    try{
      $.getScript("data/editPnrs/"+selectedPNR+"/"+ticketNo+".js").done(function(
                      script,
                      textStatus
                    ) {
                      console.log("pnrObject.obj in ticket.js :: "+pnrObject.PNR);
                      if(pnrObject.fareConstruction === null)
                            pnrObject.fareConstruction = '';
                      if(pnrObject.fcFareBeakup === null)
                            pnrObject.fcFareBeakup = '';
                      if(pnrObject.outOfScope === null)
                            pnrObject.outOfScope = '';
                      if(pnrObject.error_code === null)
                            pnrObject.error_code = '';
                      if(pnrObject.altAirline === null)
                            pnrObject.altAirline = '';
                      if(pnrObject.altItn === null)
                            pnrObject.altItn = '';
                      if(pnrObject.declinedFare === null)
                            pnrObject.declinedFare = '';
                      if(pnrObject.Baggage === null)
                            pnrObject.Baggage = '';
                      if(pnrObject.visaType === null)
                            pnrObject.visaType = '';
                      if(pnrObject.arc === null)
                            pnrObject.arc = '';
                      if(pnrObject.OpAir === null)
                            pnrObject.OpAir = '';
                      if(pnrObject.freqFlier === null)
                            pnrObject.freqFlier = '';
                      if(pnrObject.remarks === null)
                            pnrObject.remarks = '';
                      if(pnrObject.fareBasis === null)
                            pnrObject.fareBasis = '';
                      if(pnrObject.baseFareCurrency === null)
                            pnrObject.baseFareCurrency = '';
                      if(pnrObject.totAmtCurrency === null)
                            pnrObject.totAmtCurrency = '';
                      if(pnrObject.afq === null)
                            pnrObject.afq = '';
                      if(pnrObject.FareType === null)
                            pnrObject.FareType = '';
                      if(pnrObject.Fare_Basis === null)
                            pnrObject.Fare_Basis = '';
                      if(pnrObject.Compose_ID != "undefined")
                            pnrObject.Compose_ID = '';
  
                      html = '<div class="row"> <div class="col-md-3"><div class="form-group"><label class="editFont">PNR</label>'+
                      '<input id="pnr" name="input[PNR]" type="text" class="form-control" value="'+pnrObject.PNR+'"></div></div>'+
                      '<div class="col-md-3"><div class="form-group"><label class="editFont">PNR Count</label>'+
                      '<input id="pnrCount" name="input[Pnr_Count]" type="text" class="form-control" value="'+pnrObject.PNR_Count+'"></div></div>'+
                      
                      '<div class="col-md-3"><div class="form-group"><label class="editFont">Pax Name</label>'+
                      '<input id="paxName" name="input[Pax_Name]" type="text" class="form-control" value="'+pnrObject.Pax_Name+'"></div></div>'+
                      
                      '<div class="col-md-3"><div class="form-group"><label class="editFont">Dep Date</label>'+
                      '<input id="depDate" name="input[Dep_Date]" type="text" class="form-control" value="'+pnrObject.Dep_Date+'"></div></div></div>'+
                      

                      '<div class="row"> <div class="col-md-7"><div class="form-group"><label class="editFont">Fare Construction</label>'+
                      '<input id="fareConstruction" name="input[Fare_Construction]" type="text" class="form-control"   value="'+pnrObject.fareConstruction+'"></div></div>'+
                          
                      '<div class="col-md-2"><div class="form-group"><label class="editFont">Compass ID</label>'+
                      '<input id="fareConstruction" name="input[Compose_ID]" type="text" class="form-control"   value="'+pnrObject.Compose_ID+'"></div></div>'+
                          
                      '<div class="col-md-3"><div class="form-group"><label class="editFont">Dep Time</label>'+
                      '<input id="depTime" name="input[Dep_Time]" type="text" class="form-control"   value="'+pnrObject.Dep_Time+'"></div></div></div>'+
                      


                      '<div class="row"> <div class="col-md-3"><div class="form-group"><label class="editFont">Airline Code</label>'+
                      '<input id="airlineCode" name="input[Airline_Code]" type="text" class="form-control"   value="'+pnrObject.Airline_Code+'"></div></div>'+
                      '<div class="col-md-3"><div class="form-group"><label class="editFont">Flight No</label>'+
                      '<input id="flightNo" name="input[Flight_No]" type="text" class="form-control"   value="'+pnrObject.flightNo+'"></div></div>'+
                      
                      '<div class="col-md-3"><div class="form-group"><label class="editFont">Tkt Number</label>'+
                      '<input id="tktNumber" name="input[TktNumber]" type="text" class="form-control"   value="'+pnrObject.tktNumber+'"></div></div>'+
                      
                      '<div class="col-md-3"><div class="form-group"><label class="editFont">Coupon Number</label>'+
                      '<input id="couponNo" name="input[CouponNum]" type="text" class="form-control"   value="'+pnrObject.couponNo+'"></div></div></div>'+ 
                                           
                      '<div class="row"> <div class="col-md-3"><div class="form-group"><label class="editFont">BIC</label>'+
                      '<input id="BIC" name="input[BIC]" type="text" class="form-control"   value="'+pnrObject.bic+'"></div></div>'+
                      '<div class="col-md-3"><div class="form-group"><label class="editFont">Fare Basis</label>'+
                      '<input id="fareBasis" name="input[Fare_Basis]" type="text" class="form-control"   value="'+pnrObject.Fare_Basis+'"></div></div>'+
                      
                      '<div class="col-md-3"><div class="form-group"><label class="editFont">Cabin Class</label>'+
                      '<input id="cabinClass" name="input[Cabin_Class]" type="text" class="form-control"   value="'+pnrObject.cabin_class+'"></div></div>'+
                      
                      '<div class="col-md-3"><div class="form-group"><label class="editFont">Start Airport</label>'+
                      '<input id="startAirport" name="input[Dep_Airport]" type="text" class="form-control"   value="'+pnrObject.start_Airport+'"></div></div></div>'+
                      '<div class="row"> <div class="col-md-3"><div class="form-group"><label class="editFont">Start Country</label>'+
                      '<input id="startCountry" name="input[Start_Country]" type="text" class="form-control"   value="'+pnrObject.start_Country+'"></div></div>'+
                      '<div class="col-md-3"><div class="form-group"><label class="editFont">End Airport</label>'+
                      '<input id="endAirport" name="input[Arr_Airport]" type="text" class="form-control"   value="'+pnrObject.end_Airport+'"></div></div>'+
                      
                      '<div class="col-md-3"><div class="form-group"><label class="editFont">End Country</label>'+
                      '<input id="endCountry" name="input[End_Country]" type="text" class="form-control"   value="'+pnrObject.end_Country+'"></div></div>'+
                      '<div class="col-md-3"><div class="form-group"><label class="editFont">Trip Type</label>'+
                      '<input id="tripType" name="input[Int_Dom]" type="text" class="form-control"   value="'+pnrObject.tripType+'"></div></div></div>'+
                      


                      '<div class="row"> <div class="col-md-3"><div class="form-group"><label class="editFont">Routing Type</label>'+
                      '<select name="routingType" class="form-control" name="input[Routing_Type]"><option val="OW">OW</option><option val="RT">RT</option> </select></div></div>'+
                     
                     // '<input id="routingType" name="input[Routing_Type]" type="text" class="form-control"   value="'+pnrObject.routingType+'"></div></div>'+
                      
                      '<div class="col-md-3"><div class="form-group"><label class="editFont">Base Fare Currency</label>'+
                      '<input id="baseFareCurrency" name="input[Base_Fare_Currency]" type="text" class="form-control"   value="'+pnrObject.baseFareCurrency+'"></div></div>'+
                      '<div class="col-md-3"><div class="form-group"><label class="editFont">Base Fare Amount</label>'+
                      '<input id="baseFareAmount" name="input[Base_Fare_amt]" type="text" class="form-control"   value="'+pnrObject.baseFareAmount+'"></div></div>'+
                      
                      '<div class="col-md-3"><div class="form-group"><label class="editFont">Total Amt Currency</label>'+
                      '<input id="totalAmtCurrency" name="input[Tot_Currency]" type="text" class="form-control"   value="'+pnrObject.totAmtCurrency+'"></div></div></div>'+
                      





                     
                      '<div class="row"> <div class="col-md-3"><div class="form-group"><label class="editFont">Total Amount</label>'+
                      '<input id="totalAmount" name="input[Tot_Amt]" type="text" class="form-control"   value="'+pnrObject.totalAmount+'"></div></div>'+
                      
                      '<div class="col-md-3"><div class="form-group"><label class="editFont">Result</label>'+
                      '<input id="result" name="input[Result]" type="text" class="form-control"   value="'+pnrObject.result+'"></div></div>'+
                      '<div class="col-md-3"><div class="form-group"><label class="editFont">Out Of Scope</label>'+
                      '<input id="outOfScope" name="input[Out_Of_Scope]" type="text" class="form-control"   value="'+pnrObject.outOfScope+'"></div></div>'+
                      
                      '<div class="col-md-3"><div class="form-group"><label class="editFont">Error Code</label>'+
                      '<input id="errorCode" name="input[Error_Codes]" type="text" class="form-control"   value="'+pnrObject.error_code+'"></div></div></div>'+
                      
                     
                       '<div class="row"> <div class="col-md-3"><div class="form-group"><label class="editFont">Alt Airline</label>'+
                      '<input id="altAirline" name="input[Alt_Airline]" type="text" class="form-control"   value="'+pnrObject.altAirline+'"></div></div>'+
                      
                      '<div class="col-md-3"><div class="form-group"><label class="editFont">Alt Itinerary</label>'+
                      '<input id="altItinerary" name="input[Alt_Itinerary]" type="text" class="form-control"   value="'+pnrObject.altItn+'"></div></div>'+
                      '<div class="col-md-3"><div class="form-group"><label class="editFont">Alt Fare</label>'+
                      '<input id="altFare" name="input[Alt_Fare]" type="text" class="form-control"   value="'+pnrObject.altFare+'"></div></div>'+
                      
                      '<div class="col-md-3"><div class="form-group"><label class="editFont">AFQ</label>'+
                      '<input id="afq" name="input[AFQ]" type="text" class="form-control"   value="'+pnrObject.afq+'"></div></div></div>'+
                      

                      '<div class="row"> <div class="col-md-3"><div class="form-group"><label class="editFont">HFQ</label>'+
                      '<input id="hfq" name="input[HFQ]" type="text" class="form-control"   value="'+pnrObject.hfq+'"></div></div>'+
                      
                      '<div class="col-md-3"><div class="form-group"><label class="editFont">TMC Alt Fare1</label>'+
                      '<input id="tmcAltFare1" name="input[tmc_alt_fare1]" type="text" class="form-control"   value="'+pnrObject.tmcAltFare1+'"></div></div>'+
                      '<div class="col-md-3"><div class="form-group"><label class="editFont">TMC Alt Fare2</label>'+
                      '<input id="tmcAltFare2" name="input[tmc_alt_fare2]" type="text" class="form-control"   value="'+pnrObject.tmcAltFare2+'"></div></div>'+
                      
                      '<div class="col-md-3"><div class="form-group"><label class="editFont">Declined Fare</label>'+
                      '<input id="declinedFare" name="input[Decline_Fare]" type="text" class="form-control"   value="'+pnrObject.declinedFare+'"></div></div></div>'+
                      

                      '<div class="row"> <div class="col-md-3"><div class="form-group"><label class="editFont">Baggage</label>'+
                      '<input id="baggage" name="input[Baggage]" type="text" class="form-control"   value="'+pnrObject.Baggage+'"></div></div>'+
                      
                      '<div class="col-md-3"><div class="form-group"><label class="editFont">Visa Type</label>'+
                      '<input id="visaType" name="input[Visa_Type]" type="text" class="form-control"   value="'+pnrObject.visaType+'"></div></div>'+
                      '<div class="col-md-3"><div class="form-group"><label class="editFont">fare Type</label>'+
                      '<input id="fareType" name="input[Fare_Type]" type="text" class="form-control"   value="'+pnrObject.FareType+'"></div></div>'+
                      
                      '<div class="col-md-3"><div class="form-group"><label class="editFont">Refundable</label>'+

                      '<select name="refundable" class="form-control" name="input[Refundable]"><option val="Yes">Yes</option><option val="No">No</option> </select></div></div></div>'+


                     // '<input id="refundable" name="input[Refundable]" type="text" class="form-control"   value="'+pnrObject.refundable+'"></div></div></div>'+
                      

                      '<div class="row"> <div class="col-md-3"><div class="form-group"><label class="editFont">Sector</label>'+
                      '<input id="sector" name="input[Sector]" type="text" class="form-control"   value="'+pnrObject.sector+'"></div></div>'+
                      
                      '<div class="col-md-3"><div class="form-group"><label class="editFont">ARC</label>'+
                      '<input id="arc" name="input[ARC]" type="text" class="form-control"   value="'+pnrObject.arc+'"></div></div>'+
                      '<div class="col-md-3"><div class="form-group"><label class="editFont">Op Air</label>'+
                      '<input id="opAir" name="input[Op_Air]" type="text" class="form-control"   value="'+pnrObject.OpAir+'"></div></div>'+
                      
                      '<div class="col-md-3"><div class="form-group"><label class="editFont">Freq Flier</label>'+
                      '<input id="freqFlier" name="input[Freq_Flyer]" type="text" class="form-control"   value="'+pnrObject.freqFlier+'"></div></div></div>'+
                     
                      
                      '<div class="row"> <div class="col-md-3"><div class="form-group"><label class="editFont">Itinerary</label>'+
                      '<input id="itinerary" name="input[Itinerary]" type="text" class="form-control"   value="'+pnrObject.itinerary+'"><input id="TktID" name="TktID" type="hidden"  value="'+ticketNo+'"></div></div>'+
                      
                      '<div class="col-md-3"><div class="form-group"><label class="editFont">Carrier Type</label>'+
                      '<input id="carrierType" name="input[Carrier_Type]" type="text" class="form-control"   value="'+pnrObject.carrierType+'"></div></div>'+
                      '<div class="col-md-3"><div class="form-group"><label class="editFont">FC Fare Breakup</label>'+
                      '<input id="fcFareBreakup" name="input[fc_fare_breakage]" type="text" class="form-control"   value="'+pnrObject.fcFareBeakup+'"></div></div>'+
                      
                      '<div class="col-md-3"><div class="form-group"><label class="editFont">Remarks</label>'+
                      '<input id="remarks" name="input[Remarks]" type="text" class="form-control"   value="'+pnrObject.remarks+'"></div></div></div>';
                     
                      


                      $('#updateModal .modal-body').html(html)
  
  
  
  
                      //pnrDetailsHeader.update(pnrObject.obj);
                    });
                  }
                  catch{
                    console.log("An Error")
                  }
  
  }
  
