'use strict';

const currentPNR = {
    obj: {
        pnr: "",
        complianceText: "",
        ticketedAmt :"INR 1.93L"
    }

}

const currentActions = {
    update: value => state => ({
        obj: value
    })
}

const pnrView = (state, actions) => (
    h("div", {
        class: "ibox",
        style: "overflow-y:hide;height:60px !important;"
    }, [
        h("div", {
            id: "pnrHeaderBox",
            class: "ibox-content p20-h",

        }, [

            h("div", {
                class: "row m0 ",

            }, [
                h("div", {
                    class: "col-md-6 p0 text-left",
                }, [
                    h("div", {
                        class: "f400 s10" + ((state.obj.complianceText == 'true') ? " text-green" : " text-danger"),
                    }, [((state.obj.complianceText == 'true') ? " COMPLIANT" : "NON-COMPLIANT")]),

                    h("div", {
                        class: "s24 f700 text-bold" + ((state.obj.complianceText == 'true') ? " text-green" : " text-danger"),
                    }, [state.obj.pnr]),

                ]), h("div", {
                    class: "col-md-6 text-right",
                }, [
                    h("div", {
                        class: "f400 s10 text-blue" ,
                    }, "Total Ticketed Amount"),

                    h("div", {
                        class: "s20 f700 text-bold" + ((state.obj.complianceText == 'true') ? " text-green" : " text-danger"),
                    }, [state.obj.ticketedAmt]),

                ])
            ])
        ]),

    ])

)

const pnrDetailsHeader = app(currentPNR, currentActions, pnrView, document.getElementById('pnrHeader'))

pnrDetailsHeader.update({
    pnr: "TEST",
    complianceText: "true",
    ticketedAmt:"1.93L"
})