"use strict";
var selectedPNR;
const stateList = {
  pnrList: mypnrList,
  selectedPNR: "",
  filteredList: ["O9IDMN", "OGYWZR", "OJCYRS", "ONDJSK"]
};

const actionsList = {
  update: value => state => ({
    pnrList: value
  }),
  selectedPNR: value => state => {
    if (value !== "") {
      var pnrlist = $("#pnrListContainer").dxList("instance");
      var indexNumber = pnrlist.option("items").findIndex(el => {
        return el.pnr == state.selectedPNR;
      });
      var listItemNodes = $("#pnrListContainer").find(".dx-list-item");
      pnrlist.selectItem(listItemNodes[indexNumber]);
    }
    return {
      selectedPNR: value
    };
  },
  filteredList: value => state => ({
    filteredList: value
  })
};

const viewList = (state, actions) =>
  h("div", {
    id: "pnrListContainer",
    class: "p0 full-width lato-family",
    oncreate: () => {
      console.log(
        state.pnrList.filter(el => {
          if (state.filteredList.indexOf(el.pnr) > -1) {
            if (el) {
              return el;
            }
          }
        })
      );
      var pnrlist = $("#pnrListContainer")
        .dxList({
          dataSource: new DevExpress.data.DataSource({
            store: {
              type: "array",
              data: state.pnrList.filter(el => {
                if (state.filteredList.indexOf(el.pnr) > -1) {
                  if (el) {
                    return el;
                  }
                }
              })
            },
            paginate: true,
            pageSize: 100,
            searchEnabled: true,
            searchExpr: "pnr"
          }),
          pageLoadMode: "scrollBottom",
          showScrollbar: 'always',
          onItemClick: function(e) {
            var pnr = e.itemData.pnr;
            var dom = e.itemData.dom;
            var itinerary = e.itemData.itinerary;
            if (itinerary.substring(0,3) == itinerary.substring(itinerary.length-3) ){
              var routingType = "ROUND TRIP"
            }
            else{
              var routingType = "ONE-WAY"
            }
            

            if (dom == "Domestic") {
              htmldata =
                '<span class="width-120 label label-primary pull-left" title="Domestic" data-toggle="tooltip" data-placement="right" >D</span>';
            } else {
              htmldata =
                '<span class="label label-primary pull-left" title="International" data-toggle="tooltip" data-placement="right" >I</span>';
            }
            


          //  $("#triproute").text(htmldata+" | "+ routingType.toUpperCase())
          $("#triproute").html(htmldata+" | ")
          
            try{

              $.getScript("data/pnr/pnrDetails/" + pnr + ".js").done(function(
                script,
                textStatus
              ) {
                pnrDetailsHeader.update(pnrObject.obj);
              });
            }
            catch{
              console.log("An Error")
            }

            try{
              $.getScript("data/pnr/itinerary/" + pnr + ".js").done(function(
                script,
                textStatus
              ) {
                itineraryApp.update(pnrObject.legs);
              });
            }
            catch{
              console.log("An Error")
            }

            try{
              $.getScript("data/pnr/ticketInfo/" + pnr + ".js").done(function(
                script,
                textStatus
              ) {
                ticketInfoApp.update(pnrObject.ticketList);
              });
            }
            catch{
              console.log("An Error")
            }

            try{
              $.getScript("data/fares/" + pnr + ".js").done(function(
                script,
                textStatus
              ) {
                fareApp.update(pnrObject);
              });
            }
            catch{
              console.log("An Error")
            }
          },
          itemTemplate: function(data, _, element) {
            if (data.compliance == "pass") {
              element.append(
                $("<div>")
                  .addClass("row p0 m0")
                  .append(
                    $("<div>")
                      .addClass("col-md-6 p0")
                      .append(
                        $("<div>")
                          .addClass("row m0 s10 text-muted f500")
                          .text(data.dom),
                        $("<div>")
                          .addClass("row m0 s16 f600")
                          .text(data.pnr),
                        $("<div>")
                          .addClass("row m0 s10 text-muted f500")
                          .text(data.itinerary)
                      ),
                    $("<div>")
                      .addClass("col-md-6  p0 text-right")
                      .append(
                        $("<div>")
                          .addClass("row m0 s10 text-muted capitals f500")
                          .text("BEST FARE"),
                        $("<div>")
                          .addClass("row m0 s16 f600")
                          .text(data.ticketedAmount.substring(0,data.ticketedAmount.lastIndexOf("."))),
                        $("<div>")
                          .addClass("row m0 s10  text-muted f500")
                          .text("Ticketed Fare")
                      )
                  )
              );
            } else {
              element.append(
                $("<div>")
                  .addClass("row m0 p5")
                  .append(
                    $("<div>")
                      .addClass("col-md-6 p0")
                      .append(
                        $("<div>")
                          .addClass("row m0 s10 text-muted f600")
                          .text(data.dom),
                        $("<div>")
                          .addClass("row m0 s16 f600 text-danger")
                          .text(data.pnr),
                        $("<div>")
                          .addClass("row m0 s10 text-muted f500")
                          .text(data.itinerary)
                      ),
                    $("<div>")
                      .addClass("col-md-6 p0 text-right")
                      .append(
                        $("<div>")
                          .addClass("s10 row m0 text-green f600")
                          .text("Can Save " + data.percentSavings+"%"),
                        $("<div>")
                          .addClass("row m0 text-danger f700 s16")
                          .text(data.ticketedAmount.substring(0,data.ticketedAmount.lastIndexOf("."))),
                        $("<div>")
                          .addClass("row m0 s10 text-green f500")
                          .text("INR: " + (parseFloat(data.ticketedAmount.replace("INR ",'')) - parseFloat(data.savings.replace("INR ",''))).toFixed(0).toString() +" available")
                      )
                  )
              );
            }
          }
        })
        .dxList("instance");
      if (state.selectedPNR !== "") {
        var indexNumber = pnrlist.option("items").findIndex(el => {
          return el.pnr == state.selectedPNR;
        });
        var listItemNodes = $("#pnrListContainer").find(".dx-list-item");
        listItemNodes[indexNumber].click();
      }
    },
    onupdate: () => {

     
      console.log(
        state.pnrList.filter(el => {
          if (state.filteredList.indexOf(el.pnr) > -1) {
            if (el) {
              return el;
            }
          }
        })
      );
      var pnrlist = $("#pnrListContainer")
        .dxList({
          dataSource: new DevExpress.data.DataSource({
            store: {
              type: "array",
              data: state.pnrList.filter(el => {
                if (state.filteredList.indexOf(el.pnr) > -1) {
                  if (el) {
                    return el;
                  }
                }
              })
            },
            paginate: true,
            pageSize: 100,
            searchEnabled: true,
            searchExpr: "pnr"
          }),
          onItemClick: function(e) {
            var pnr = e.itemData.pnr;
            var dom = e.itemData.dom;
            var itinerary = e.itemData.itinerary;
            console.log("itinerary  in pnrrrList.js :: :: "+itinerary);
            // if (itinerary.substring(0,3) == itinerary.substring(itinerary.length-3) ){
            //   var routingType = "ROUND TRIP"
            // }
            // else{
            //   var routingType = "ONE-WAY"
            // }


            if (itinerary.substring(0,3) == itinerary.substring(itinerary.length-3) ) {
             var routinghtmldata =
                '<span class="width-120 label label-primary pull-right" title="Round Trip" data-toggle="tooltip" data-placement="right" >RT</span>';
            } else {
              var  routinghtmldata =
                '<span class="label label-primary pull-right" title="One Way" data-toggle="tooltip" data-placement="right" >OW</span>';
            }

            //
            if (dom.toUpperCase() == "DOMESTIC") {
              htmldata =
                '<span class="width-120 label label-primary pull-right" title="Domestic" data-toggle="tooltip" data-placement="right" style="margin-right: 10px;">D</span>';
            } else {
              htmldata =
                '<span class="label label-primary pull-right" title="International" data-toggle="tooltip" data-placement="right" style="margin-right: 10px;">I</span>';
            }
            
            
           // $("#triproute").text(htmldata +" | "+ routingType.toUpperCase())
           //$("#triproute").html(htmldata +" &nbsp; "+routinghtmldata)
          
           $("#triproute").html(routinghtmldata +" &nbsp; "+htmldata)
            try{

              $.getScript("data/pnr/pnrDetails/" + pnr + ".js").done(function(
                script,
                textStatus
              ) {
                pnrDetailsHeader.update(pnrObject.obj);
              });
            }
            catch{
              console.log("An Error")
            }

            try{
              $.getScript("data/pnr/itinerary/" + pnr + ".js").done(function(
                script,
                textStatus
              ) {
                itineraryApp.update(pnrObject.legs);
              });
            }
            catch{
              console.log("An Error")
            }

            try{
              $.getScript("data/pnr/ticketInfo/" + pnr + ".js").done(function(
                script,
                textStatus
              ) {
                ticketInfoApp.update(pnrObject.ticketList);
              });
            }
            catch{
              console.log("An Error")
            }

            try{
              $.getScript("data/fares/" + pnr + ".js").done(function(
                script,
                textStatus
              ) {
                fareApp.update(pnrObject);
              });
            }
            catch{
              console.log("An Error")
            }


            
          },
          itemTemplate: function(data, _, element) {
            if (data.compliance == "pass") {
              element.append(
                $("<div>")
                  .addClass("row p0 m0")
                  .append(
                    $("<div>")
                      .addClass("col-md-6 p0")
                      .append(
                        $("<div>")
                          .addClass("row m0 s10 text-muted f500")
                          .text(data.dom),
                        $("<div>")
                          .addClass("row m0 s16 f600")
                          .text(data.pnr),
                        $("<div>")
                          .addClass("row m0 s10 text-muted f500")
                          .text(data.itinerary)
                      ),
                    $("<div>")
                      .addClass("col-md-6  p0 text-right")
                      .append(
                        $("<div>")
                          .addClass("row m0 s10 text-muted capitals f500")
                          .text("BEST FARE"),
                        $("<div>")
                          .addClass("row m0 s16 f600")
                          .text(data.ticketedAmount.substring(0,data.ticketedAmount.lastIndexOf("."))),
                        $("<div>")
                          .addClass("row m0 s10  text-muted f500")
                          .text("Ticketed Fare")
                      )
                  )
              );
            } else {
              element.append(
                $("<div>")
                  .addClass("row m0 p5")
                  .append(
                    $("<div>")
                      .addClass("col-md-6 p0")
                      .append(
                        $("<div>")
                          .addClass("row m0 s10 text-muted f600")
                          .text(data.dom),
                        $("<div>")
                          .addClass("row text-danger m0 s16 f600")
                          .text(data.pnr),
                        $("<div>")
                          .addClass("row m0 s10 text-muted f500")
                          .text(data.itinerary)
                      ),
                    $("<div>")
                      .addClass("col-md-6 p0 text-right")
                      .append(
                        $("<div>")
                          .addClass("s10 row m0 text-green f600")
                          .text("Can Save " + data.percentSavings +"%"),
                        $("<div>")
                          .addClass("row m0 text-danger f700 s16")
                          .text(data.ticketedAmount.substring(0,data.ticketedAmount.lastIndexOf("."))),
                        $("<div>")
                          .addClass("row m0 s10 text-green f500")
                          .text("INR: " + (parseFloat(data.ticketedAmount.replace("INR ",'')) - parseFloat(data.savings.replace("INR ",''))).toFixed(0).toString() +" available")
                      )
                  )
              );
            }
          }
        })
        .dxList("instance");
      if (state.selectedPNR !== "") {
        console.log(state.selectedPNR);
        selectedPNR = state.selectedPNR;
        var indexNumber = pnrlist.option("items").findIndex(el => {
          return el.pnr == state.selectedPNR;
        });
        console.log(indexNumber);
        checkprepend();
        getaltfare();
        var listItemNodes = $("#pnrListContainer").find(".dx-list-item");
        listItemNodes[indexNumber].click();
      }
    }
  });

const main = app(
  stateList,
  actionsList,
  viewList,
  document.getElementById("pnrList")
);

// var fetch = setInterval(loadPNRList, 5000)

function loadPNRList() {
  // $.getScript("data/pnrList.js").done(function(script, textStatus) {
  //   main.update(pnrList);
  // });
  $.ajax({
    url: "pnrList.php",
    success: function(data) {
      var listJson = $.parseJSON(data);
      
      console.log("listJson.pnrList :: :: ::: "+listJson.pnrList);

      main.update(listJson.pnrList);
    }
  });
}

loadPNRList();
