
var overallVizObj = {
        palette: ['#2d497b','#55b04a'],
        series: [{
            argumentField: "argument",
            valueField: "value",
            label: {
                         format: {
                        type: "fixedPoint",
                        precision: 0},
                                        visible: true,
                        indent: 30,
                        font :{size : 14},
                        customizeText: function (arg) {
                            return arg.percentText + "";
                        }
                    },
        }],
        legend: {
            orientation: "horizontal",
            itemTextPosition: "right",
            horizontalAlignment: "center",
            verticalAlignment: "bottom",
        },
};

var getOverviewViz = (tab,dataObj,trxmixId,amtSpndMixId) =>{
      $.ajax({
                type: "POST",
                url: "apis/spend/airlinewise/airlinewise_data.php",
                data: dataObj,
                cache: false,
                success: function (d) {
                d = JSON.parse(d);
                let overAllData = d['overall'];
                let trxData = [];
                let amtSpndMixData = [];
                overAllData.map((obj,index)=>{
                    trxData.push({
                        'argument' : obj['segment'],
                        'value' : obj['count'],
                        'type' : 'TRX'
                    })
                    amtSpndMixData.push({
                        'argument' : obj['segment'],
                        'value' : obj['amount'],
                        'type' : 'AMT'
                    })
                })

                let pointClick = (e)=>{
                        let point = e.target;
                        let segment = point.argument.toUpperCase();
                        dataObj['segment'] = segment;
                        getSegmentWiseViz(tab,dataObj);
                }

                $('#'+trxmixId).dxPieChart({
                    dataSource :  trxData,
                    onPointClick: pointClick,
                    ...overallVizObj
                });

               $('#'+amtSpndMixId).dxPieChart({
                    dataSource :  amtSpndMixData,
                    onPointClick: pointClick,
                    ...overallVizObj
                });
                },
                error: function () {
                    console.log("Ajax is not working");
                }
            });
}

var getSegmentWiseViz = (tab,dataObj)=>{

    let segmentTrxViz = 'segment-trx-viz',segmentSpendViz = 'segment-spend-viz';

    $('#'+tab).append(appendIboxColLgDiv(tab+'-segment-detail-view',dataObj['segment'],'Based on Transactions and Spend'));

    $('#'+tab+'-segment-detail-view-content-row').append(appendColLgDiv(6,segmentTrxViz,'Transaction Share ','height : 300px;margin-bottom: 50px;'));
    
    $('#'+tab+'-segment-detail-view-content-row').append(appendColLgDiv(6,segmentSpendViz,'Amount Spend Share','height : 300px;margin-bottom: 50px;'));

     $.ajax({
                type: "POST",
                url: "apis/spend/airlinewise/airlinewise_segment.php",
                data: dataObj,
                cache: false,
                success: function (segmentData) {
                segmentData = JSON.parse(segmentData);
                let trxData = [],amtSpndMixData = [],colorPallete=[];
                segmentData.map((obj,index)=>{
                    let airline = obj['airline_code']
                    trxData.push({
                        'argument' : airline,
                        'value' : obj['count'],
                    });
                    amtSpndMixData.push({
                        'argument' : airline,
                        'value' : obj['amount'],
                    });
                    colorPallete.push(airLineColorObj[airline]);

                    let pointClick = (e)=>{
                        let point = e.target;
                        let airline = point.argument.toUpperCase();
                        dataObj['airline'] = airline;
                        getAirlineWiseGrid(tab,dataObj);
                    }
                    $('#'+segmentTrxViz).dxPieChart({
                        dataSource :  trxData,
                        ...overallVizObj,
                        onPointClick : pointClick,
                        palette : colorPallete,
                    })

                    $('#'+segmentSpendViz).dxPieChart({
                        dataSource :  amtSpndMixData,
                        ...overallVizObj,
                        palette : colorPallete,
                        onPointClick : pointClick,
                    })

                })
                
                },
                error: function () {
                    console.log("Ajax is not working");
                }
            });
}

var getAirlineWiseGrid = (tab,dataObj)=>{

    let sectorGrid =tab +'sector-grid';
    $('#'+tab).append(appendIboxColLgDiv(tab+'-airline-grid',dataObj['airline'] + ' Grid','Based on Transactions and Spend'));

    $('#'+tab+'-airline-grid-content-row').append(appendColLgDiv(12,sectorGrid,'','margin-bottom: 50px;'));

    $.ajax({
                type: "POST",
                url: "apis/spend/airlinewise/airlinewise_grid.php",
                data: dataObj,
                cache: false,
                success: function (d) {
                    d = JSON.parse(d);
                       d.map((obj,index)=>{
                        obj['amount'] = parseInt(obj['amount']),
                        obj['count'] = parseInt(obj['count']),
                        obj['atp']  = Math.round(obj['amount'] / obj['count']);
                        return obj; 
                       })
                    let gridObj = {
                                showBorders: true,
                                selection: {
                                    mode: "single"
                                },
                                 paging: {
                                    pageSize: 10
                                },
                                rowAlternationEnabled: true,
                                columns : [{
                                            dataField : 'sector',
                                            caption : 'Sector'
                                        },{
                                         dataField : 'routing_type',
                                         caption : 'Routing Type'   
                                        },{
                                            dataField : 'count',
                                            caption : 'Count'
                                        },{
                                            dataField : 'amount',
                                            caption : 'Amount'
                                        },{
                                         dataField : 'atp',
                                         caption : 'Average Ticket Price'   
                                        }
                                        ],
                                
                            };
                    $('#'+sectorGrid).dxDataGrid({
                        dataSource : d,
                        ...gridObj
                    })
                },
                error: function () {
                    console.log("Ajax is not working");
                }
            });
}

