cur_var = {
  USD: "&#36;",
  USD: "&#36;",
  GBP: "&#163;",
  EUR: "&#128;",
  INR: "&#x20B9;",
  AED: "&#x62f;"
};

$("#data_5 .input-daterange").datepicker({
  keyboardNavigation: false,
  forceParse: false,
  autoclose: true,
  format: "dd/mm/yyyy"
});
$(document).ready(function () {
  getpnrrecords("g");
  $("#close_img").hide();
  $("#apply_filter").center();
  $("#details").hide();
});

function clear_filter() {
  filter_form.reset();
  $("#apply_filter").trigger("click");
}

$("#filter_form").submit(function (e) {
  $("#offset").val(0);
  getpnrrecords();
  e.preventDefault(); // avoid to execute the actual submit of the form.
});

$("#apply_filter").click(function () {
  $("#sub_filter_form").trigger("click");
});

function showtable() {
  $("#details").hide();
  $("#screener").show();
  $(".agl li").css("border-top", "1px solid #e7eaec");
  $(".agl li").css("border-bottom", "1px solid #e7eaec");
  $(".agl li").css("border-right", "1px solid #e7eaec");
  $(".agl li").css("background", "#FAFAFB");
}

function trigger_table_click(pnr) {
  $("#tblrid" + pnr).trigger("click");
}
function getpnrrecords_(params) {
  var dataGrid = $("#pnrtable").dxDataGrid("instance");
  var pageIndex = dataGrid.pageIndex();

  if (params == "f") {
    console.log("! Forward");
    dataGrid.pageIndex(pageIndex + 1);
  } else {
    if (pageIndex > 0) {
      console.log("! Backward");
      dataGrid.pageIndex(pageIndex - 1);
    }
  }
}

function getpnrrecords(params) {
  if (offset < 1) {
    return false;
  }
  var offset = $("#offset").val();
  if ($("#dateStart").val() == "") {
    var date_ = new Date();
    date_.setDate(date_.getDate() - 2);

    $("#dateStart")
      .datepicker({ dateFormat: "dd/mm/yyyy" })
      .datepicker("setDate", date_);
  } else {
    //        $('#dateStart').datepicker({ dateFormat: 'dd/mm/yyyy'});
  }
  if ($("#dateEnd").val() == "") {
    $("#dateEnd")
      .datepicker({ dateFormat: "dd/mm/yyyy" })
      .datepicker("setDate", new Date());
  } else {
    //        $('#dateStart').datepicker({ dateFormat: 'dd/mm/yyyy'});
  }
  var postData = $("#filter_form").serializeArray();
  if (params == "b" || params == "f") {
    var data = {
      direction: params,
      offset: offset
    };
  } else {
    var data = {
      offset: offset
    };
  }
  for (var key in data) {
    if (data.hasOwnProperty(key)) {
      postData.push({
        name: key,
        value: data[key]
      });
    }
  }

  pnrArray = [];
  

  function showSendMail(e) {
    console.log("inside show send mail", e);
    var htmlData = $('.summernote').html().toString();
    $("#myModal").modal();
    $('#myModal .modal-body #Name').html("Harsh Srivastava");
    $('#myModal .modal-body #pnr').html(e.PNR);
    $('#myModal .modal-body #reasonCode').html(e.Error_Codes);
    $('#myModal .modal-body #tsSaving').html(e.TS_Savings);
    var url = "loadAlternateFare.php";
    $.ajax({
      type: "POST",
      url: url,
      data: {pnr:e.PNR}, 
      success: function (data) {
        console.log("success data ::  ",data)

        // var test = "KU 302 L 19JUL 4 BOMKWI DK1  0535 0700\r\nKU 787 L 19JUL 4 KWIJED DK1  0905 1135"
        // test.replace("\r\n","<br/>")
        var altData = JSON.parse(data);
        var altitinerary = altData.itinerary.replace("\r\n","<br/>")


        $('#myModal .modal-body #altFares').html(altitinerary);
        
      }
    });

  }
  function gengrid(pdata) {
    var vh = $(document).height();
    vh = Math.ceil(10 + (parseFloat(vh) - 675) / 35);
    var dataGrid = $("#pnrtable")
      .dxDataGrid({
        // columnMinWidth: 90,
        dataSource: pdata,
        rowClick: function (e) {
          console.log(e.data);
        },
        selection: {
          mode: "single"
        },
        onRowPrepared: function (e) {
          console.log(e.data);
          try {
            pnrArray.push(e.data.PNR);
          } catch {
            console.log("header error");
          }
        },
        onSelectionChanged: function (e) {
          // Handler of the "selectionChanged" event
          $("#screener").hide();
          $("#details").show();
          var allSelectedRowsData = e.selectedRowsData;
          console.log(allSelectedRowsData[0].PNR);
          showPNR(allSelectedRowsData[0].PNR, pnrArray);
          pnrArray.length = 0;

          dataGrid.getVisibleRows().map(e => {
            return pnrArray.push(e.data.PNR);
          });
        },
        showRowLines: true,
        showBorders: false,
        showColumnLines: false,
        paging: {
          pageSize: vh
        },
        pager: {
          showPageSizeSelector: false,
          showInfo: true
          // showNavigationButtons:true,
        },
        remoteOperations: false,

        groupPanel: {
          visible: false
        },
        grouping: {
          autoExpandAll: false
        },
        allowColumnResizing: true,
        allowColumnReordering: true,
        rowAlternationEnabled: false,

        //   editing: {
        //     mode: "popup",
        //     allowUpdating: true,
        //     popup: {
        //         title: "Employee Info",
        //         showTitle: true,
        //         width: 700,
        //         height: 345,
        //         position: {
        //             my: "top",
        //             at: "top",
        //             of: window
        //         }
        //     }
        // },

        columns: [
          // {
          //   dataField: "Result",
          //   caption: "COMPLIANCE",
          //   width: 150,
          //   headerCellTemplate: function(header, info) {
          //     $("<div>")
          //       .html(info.column.caption)
          //       .css("font-size", "10px")
          //       .css("text-transform", "uppercase")
          //       .css("font-weight", "bold")
          //       .css("color", "#2e497b")
          //       .appendTo(header);
          //   },
          //   cellTemplate: function(container, options) {
          //     if (options.value == "Pass") {
          //       htmldata =
          //         '<span class="width-120 label label-primary pull-left">Compliant</span>';
          //     } else {
          //       htmldata =
          //         '<span class="label label-danger pull-left">Non Compliant</span>';
          //     }
          //     $('<div class="width-120">')
          //       .html(htmldata)
          //       .css("font-size", "12px")
          //       .css("text-transform", "uppercase")
          //       .appendTo(container);
          //   }
          // },
          {
            dataField: "Result",
            caption: "COMPLIANCE",
            width: "9%",
            headerCellTemplate: function (header, info) {
              $("<div>")
                .html(info.column.caption)
                .css("font-size", "10px")
                .css("text-transform", "uppercase")
                .css("font-weight", "bold")
                .css("color", "#2e497b")
                .appendTo(header);
            },
            cellTemplate: function (container, options) {
              if (options.value == "Pass") {
                htmldata =
                  '<span class="width-120 label label-primary pull-left">C</span>';
              } else {
                htmldata =
                  '<span class="label label-danger pull-left">NC</span>';
              }
              $('<div class="width-120">')
                .html(htmldata)
                .css("font-size", "12px")
                .css("text-transform", "uppercase")
                .appendTo(container);
            }
          },
          {
            dataField: "TripType",
            caption: "Trip Type",
            width: "7%",
            headerCellTemplate: function (header, info) {
              $("<div>")
                .html(info.column.caption)
                .css("font-size", "10px")
                .css("text-transform", "uppercase")
                .css("font-weight", "bold")
                .css("color", "#2e497b")
                .appendTo(header);
            },
            cellTemplate: function (container, options) {
              if (options.value == "Domestic") {
                htmldata =
                  '<span class="width-120 label label-primary pull-left">D</span>';
              } else {
                htmldata =
                  '<span class="label label-primary pull-left">I</span>';
              }
              $('<div class="width-120">')
                .html(htmldata)
                .css("font-size", "12px")
                .css("text-transform", "uppercase")
                .appendTo(container);
            }
          },

          //   {
          //   dataField: "TripType",
          //   caption: "Trip Type",
          //   width: 80,
          //   headerCellTemplate: function(header, info) {
          //     $("<div>")
          //       .html(info.column.caption)
          //       .css("font-size", "10px")
          //       .css("text-transform", "uppercase")
          //       .css("font-weight", "bold")
          //       .css("color", "#2e497b")
          //       .appendTo(header);
          //   },
          //   cellTemplate: function(container, options) {
          //     $("<div>")
          //       .html(options.value)
          //       .css("font-size", "12px")
          //       .css("text-transform", "uppercase")
          //       .css("font-family", "Lato")
          //       .appendTo(container);
          //   }
          // },

          {
            dataField: "Customer",
            caption: "Customer",
            width: "8%",
            headerCellTemplate: function (header, info) {
              $("<div>")
                .html(info.column.caption)
                .css("font-size", "10px")
                .css("text-transform", "uppercase")
                .css("font-weight", "bold")
                .css("color", "#2e497b")
                .appendTo(header);
            },
            cellTemplate: function (container, options) {
              $("<div>")
                .html(options.value)
                .css("font-size", "12px")
                .css("font-family", "Lato")
                .appendTo(container);
            }
          },
          {
            dataField: "PNR",
            caption: "PNR",
            //    width: 60,
            headerCellTemplate: function (header, info) {
              $("<div>")
                .html(info.column.caption)
                .css("font-size", "10px")
                .css("text-transform", "uppercase")
                .css("font-weight", "bold")
                .css("color", "#2e497b")
                .appendTo(header);
            },
            cellTemplate: function (container, options) {
              $("<div>")
                .html(options.value)
                .css("font-size", "12px")
                .css("font-family", "Lato")
                .css("font-weight", "bold")
                .appendTo(container);
            }
          },
          {
            dataField: "TimeStamp",
            caption: "Ticketed At",
            width: "9%",
            headerCellTemplate: function (header, info) {
              $("<div>")
                .html(info.column.caption)
                .css("font-size", "10px")
                .css("text-transform", "uppercase")
                .css("font-weight", "bold")
                .css("color", "#2e497b")
                .appendTo(header);
            },
            cellTemplate: function (container, options) {
              $("<div>")
                .html(options.value)
                .css("font-size", "12px")
                .css("font-family", "Lato")
                .appendTo(container);
            }
          },
          {
            dataField: "Airline_Code",
            caption: "Airline",

            headerCellTemplate: function (header, info) {
              $("<div>")
                .html(info.column.caption)
                .css("font-size", "10px")
                .css("text-transform", "uppercase")
                .css("font-weight", "bold")
                .css("color", "#2e497b")
                .appendTo(header);
            },

            cellTemplate: function (container, options) {
              htmldata = '<img src="img/airlines/' + options.value + '.png" style="height: 20px !important;">';


              $('<div class="width-120">')
                .html(htmldata)
                .css("font-size", "12px")
                .css("text-transform", "uppercase")
                .css("text-align", "center")
                .appendTo(container);
            }


            // cellTemplate: function(container, options) {
            //   $("<div>")
            //     .html(options.value)
            //     .css("font-size", "12px")
            //     .css("font-family", "Lato")
            //     .appendTo(container);
            // }
          }, {
            dataField: "DepDate",
            caption: "Dep Date",
            //      width: 80,
            headerCellTemplate: function (header, info) {
              $("<div>")
                .html(info.column.caption)
                .css("font-size", "10px")
                .css("text-transform", "uppercase")
                .css("font-weight", "bold")
                .css("color", "#2e497b")
                .appendTo(header);
            },
            cellTemplate: function (container, options) {
              $("<div>")
                .html(options.value)
                .css("font-size", "12px")
                .css("font-family", "Lato")
                .appendTo(container);
            }
          },
          {
            dataField: "PNR_ListOfAllStopOvers",
            caption: "Segments",
                 width: "8%",
            headerCellTemplate: function (header, info) {
              $("<div>")
                .html(info.column.caption)
                .css("font-size", "10px")
                .css("text-transform", "uppercase")
                .css("font-weight", "bold")
                .css("color", "#2e497b")
                .appendTo(header);
            },
            cellTemplate: function (container, options) {
              var str = options.value;
              console.log("str in pnrflow :: ::: ",str);
               
              // if(segments!=null){
                try {
                  var res = str.substring(0,str.indexOf("-"));
                  var res1 = str.substring(str.lastIndexOf("-")+1);
                  var segments = res+"-"+res1;
  
                  $("<div>")
                  .html(segments)
                  .css("font-size", "12px")
                  .css("font-family", "Lato")
                  .appendTo(container);
                } catch (error) {
                  console.log(error);
                }
                

              // }
              
            }
          },
           {
            dataField: "ARC",
            caption: "TMC RC",
            //     width: 40,
            headerCellTemplate: function (header, info) {
              $("<div>")
                .html(info.column.caption)
                .css("font-size", "10px")
                .css("text-transform", "uppercase")
                .css("font-weight", "bold")
                .css("color", "#2e497b")
                .appendTo(header);
            },
            cellTemplate: function (container, options) {
              $("<div>")
                .html(options.value)
                .css("text-align", "center")
                .css("font-size", "12px")
                .css("font-family", "Lato")
                .appendTo(container);
            }
          },

          {
            dataField: "Tot_Amt",
            caption: "Tot Amt",
            dataType: "number",
            format: "? #,##0.##",
            width: "9%",
            headerCellTemplate: function (header, info) {
              $("<div>")
                .html(info.column.caption)
                .css("font-size", "10px")
                .css("text-transform", "uppercase")
                .css("font-weight", "bold")
                .css("color", "#2e497b")
                .appendTo(header);
            },
            // cellTemplate: function(container, options) {
            //   $("<div>")
            //     .html(options.value)
            //     // .css("text-align", "right")
            //     // .css("font-size", "12px")
            //     // .css("font-family", "Lato")



            //     .appendTo(container);
            // }
          },
          // {
          //   dataField: "TS_Savings",
          //   caption: "TS Savings",
          //   dataType: "number",
          //  width: "9%",
          //   headerCellTemplate: function(header, info) {
          //     $("<div>")
          //       .html(info.column.caption)
          //       .css("font-size", "10px")
          //       .css("text-transform", "uppercase")
          //       .css("font-weight", "bold")
          //       .css("color", "#2e497b")
          //       .appendTo(header);
          //   },
          //   cellTemplate: function(container, options) {

          //     $("<div>")
          //       .html(options.value)
          //       .css("text-align", "right")
          //       .css("font-size", "12px")
          //       .css("font-family", "Lato")
          //       .appendTo(container);
          //   }
          // },
          {
            dataField: "savingPercentage",
            caption: "% TS Savings",
            dataType: "number",
            width: "10%",
            headerCellTemplate: function (header, info) {
              $("<div>")
                .html(info.column.caption)
                .css("font-size", "10px")
                .css("text-transform", "uppercase")
                .css("font-weight", "bold")
                .css("color", "#2e497b")
                .appendTo(header);
            },
            cellTemplate: function (container, options) {
              var value = parseFloat(Math.round(options.value)).toFixed(2);
              $("<div>")
                .html(value + '%')
                .css("text-align", "right")
                .css("font-size", "12px")
                .css("font-family", "Lato")
                .appendTo(container);
            }
          },

          {
            dataField: "Error_Codes",
            caption: "TS RC",
            //     width: 40,
            headerCellTemplate: function (header, info) {
              $("<div>")
                .html(info.column.caption)
                .css("font-size", "10px")
                .css("text-transform", "uppercase")
                .css("font-weight", "bold")
                .css("color", "#2e497b")
                .appendTo(header);
            },
            cellTemplate: function (container, options) {
              $("<div>")
                .html(options.value)
                .css("font-size", "12px")
                .css("font-family", "Lato")
                .css("text-align", "center")
                .appendTo(container);
            }
          },
          {
            dataField: "",
            caption: "Action",
            //     width: 40,
            headerCellTemplate: function (header, info) {
              $("<div>")
                .html(info.column.caption)
                .css("font-size", "10px")
                .css("text-transform", "uppercase")
                .css("font-weight", "bold")
                .css("color", "#2e497b")
                .appendTo(header);
            },
            cellTemplate: function (container, options) {
              if(options.data.Result != 'Pass'){
                $('<i class="fa fa-envelope-o">').addClass('dx-link').on('dxclick', function (evt) {
                  evt.stopPropagation();
                  
                 //console.log(options.data.Result)
                  showSendMail(options.data);
                }).appendTo(container);
              }
             

            }
          }

        ]

        //                ,
        //                onContentReady: function(e) {
        //                    if (!collapsed) {
        //                        collapsed = true;
        //                        e.component.expandRow(["EnviroCare"]);
        //                    }
        //                }
      })
      .dxDataGrid("instance");
  }
  var url = "list_filter_n.php"; // the script where you handle the form input.
  $.ajax({
    type: "POST",
    url: url,
    data: postData, // serializes the form's elements.
    success: function (data) {
      var htmldata = "";
      var htmlboard = "";
      var p_data = JSON.parse(data);
      var pdata = p_data.plist;

      var p_data = JSON.parse(data);
      gengrid(p_data.plist);

      //            $('#offset').val(p_data.offset);
      //            $('#ttl_cnt').html(p_data.tot_cnt);
      //            $('#offset_start').html(parseInt(p_data.offset) + 1);
      //            $('#offset_end').html(parseInt(p_data.offset) + 10);
      //            $('#pagination_id').show();
      //            $('#pnrtable tbody').html(htmldata);
      //            $('#genfiltered').html(htmlboard);
    }
  });
}
$(".table").on("click", "tbody tr", function (e) {
  var id = $(this).attr("value");
  $("#board_" + id).css("border-top", "1px solid #838181");
  $("#board_" + id).css("border-bottom", "1px solid #838181");
  $("#board_" + id).css("border-right", "1px solid #838181");
  $("#board_" + id).css("background", "#ffffff");
  showPNR(id, arrayList);
  $("#screener").hide();
  $("#details").show();
});

function showPNR(pnr) {
  console.log(pnr);
  console.log(pnrArray);
  main.selectedPNR(pnr);
  main.filteredList(pnrArray);
}

$(document).ready(function () {
  $("#screener").show();
  $("#details").hide();

  $("#ticketInfo").dxScrollView({
    scrollByContent: true,
    scrollByThumb: true,
    useNative: true,
    showScrollbar: "onHover" // enables the swipe gesture on all platform
  });
});
