// Config

const CognitoUserPool = AmazonCognitoIdentity.CognitoUserPool

const userAttribute = AWSCognito
	.CognitoIdentityServiceProvider
	.CognitoUserAttribute

// Cross-Form Interfaces

let userPool
let cognitoUser

// User Pool Management

const setUserPool = poolData => {
	const {UserPoolId, ClientId} = poolData

	sessionStorage.UserPoolId = UserPoolId
	sessionStorage.ClientId = ClientId

	//configForm.UserPoolId.value = UserPoolId
	//configForm.ClientId.value = ClientId

	try {
		userPool = new AWSCognito
			.CognitoIdentityServiceProvider
			.CognitoUserPool(poolData)
	} catch (err) {
		console.error(err)
		return false
	}

	return true
}


function configurePool(){
	const UserPoolId = 'ap-south-1_WS67VV3no'
	const ClientId = '2rjsjhv4b17scp25v5geieg793'

	const poolData = {
		UserPoolId,
		ClientId
	}

	const configured = setUserPool(poolData)

	if (configured) {
	//	alert('UserPool configured')
	}

}

function authenticateLogin(){
	console.log("inside authenticate Login");

	

	const email = $('#userName').val()
	const password = $('#password').val()

	const identityPoolId = 'ap-south-1_WS67VV3no'
	const clientId = '2rjsjhv4b17scp25v5geieg793'

	
    const authenticationData = {
        Username : email,
        Password : password,
    }
	const authenticationDetails = new AWSCognito
	.CognitoIdentityServiceProvider
	.AuthenticationDetails(authenticationData)
	
	if (!cognitoUser) {
		const userData = {
	        Username : email,
	        Pool: userPool
	    }

		cognitoUser = new AWSCognito
			.CognitoIdentityServiceProvider
			.CognitoUser(userData)
	}
	
	cognitoUser.authenticateUser(authenticationDetails, {
        onSuccess: result => {

            console.log('access token + ' + result.getAccessToken().getJwtToken())
			verifySession(result);
            // POTENTIAL: Region needs to be set if not already set previously elsewhere.
            // AWS.config.region = '<region>';

            AWS.config.credentials = new AWS.CognitoIdentityCredentials({
                IdentityPoolId: identityPoolId,
                Logins : {
                    'cognito-idp.us-east-1.amazonaws.com/us-east-1_gplidiDbz': result.getIdToken().getJwtToken()
                }
            })

            // Instantiate aws sdk service objects now that the credentials have been updated.
            // example: var s3 = new AWS.S3()
        },

        onFailure: err => {
            alert(err)
        }
    })

}

function verifySession(result){
	console.log("Result in VarifySession :: :: ",result);
	showSignedInUsers(result);
}		



