cur_var = {
    USD: "&#36;",
    USD: "&#36;",
    GBP: "&#163;",
    EUR: "&#128;",
    INR: "&#x20B9;",
    AED: "&#x62f;"
  };
  
  pnrArray = []
  
  $("#data_5 .input-daterange").datepicker({
    keyboardNavigation: false,
    forceParse: false,
    autoclose: true,
    format: "dd/mm/yyyy"
  });
  $(document).ready(function() {
    getpnrrecords("g");
    $("#close_img").hide();
    $("#apply_filter").center();
    $("#details").hide();
  });
  
  function clear_filter() {
    filter_form.reset();
    $("#apply_filter").trigger("click");
  }
  
  $("#filter_form").submit(function(e) {
    $("#offset").val(0);
    getpnrrecords();
    e.preventDefault(); // avoid to execute the actual submit of the form.
  });
  
  $("#apply_filter").click(function() {
    $("#sub_filter_form").trigger("click");
  });
  
  function showtable() {
    $("#details").hide();
    $("#screener").show();
    $(".agl li").css("border-top", "1px solid #e7eaec");
    $(".agl li").css("border-bottom", "1px solid #e7eaec");
    $(".agl li").css("border-right", "1px solid #e7eaec");
    $(".agl li").css("background", "#FAFAFB");
  }
  
  function trigger_table_click(pnr) {
    $("#tblrid" + pnr).trigger("click");
  }
  
  function getpnrrecords(params) {
    if (offset < 1) {
      return false;
    }
    var offset = $("#offset").val();
  
    var postData = $("#filter_form").serializeArray();
    if (params == "b" || params == "f") {
      var data = {
        direction: params,
        offset: offset
      };
    } else {
      var data = {
        offset: offset
      };
    }
    for (var key in data) {
      if (data.hasOwnProperty(key)) {
        postData.push({
          name: key,
          value: data[key]
        });
      }
    }
  
    var url = "list_filter.php"; // the script where you handle the form input.
    $.ajax({
      type: "POST",
      url: url,
      data: postData, // serializes the form's elements.
      success: function(data) {
        var htmldata = "";
        var htmlboard = "";
        var p_data = JSON.parse(data);
        var pdata = p_data.plist;
        $("#offset").val(p_data.offset);
        $("#ttl_cnt").html(p_data.tot_cnt);
        $("#offset_start").html(parseInt(p_data.offset) + 1);
        $("#offset_end").html(parseInt(p_data.offset) + 10);
        pnrArray.length = 0;
        $.each(pdata, function(k) {
          if (k == 0) {
            $("#show_btn_id").html(
              "<button onclick=\"trigger_table_click('" +
                pdata[k].PNR +
                '\')" type="button" class="btn btn-w-m btn-success-r ">Show in detail</button>'
            );
          }
          pnrArray.push(pdata[k].PNR)
          var restext =
            '<span class="label label-primary pull-left">Compliant</span>';
          var currency = cur_var[pdata[k].Base_Fare_Currency];
          if (typeof currency == "undefined") {
            currency = "";
          }
          var flown_status_t = "";
          var cstrng = "",
            sector_ary = [],
            n = {},
            unique_sector_ary = [];
          var sec = pdata[k].Info;
          var strng = sec.toString();
          if (strng.indexOf("<br>") != -1) {
            sector_ary = strng.split("<br>");
            for (var i = 0; i < sector_ary.length; i++) {
              if (!n[sector_ary[i]]) {
                n[sector_ary[i]] = true;
                unique_sector_ary.push(sector_ary[i]);
              }
            }
            infotext = unique_sector_ary.join("-");
          } else {
            infotext = strng;
          }
  
          var secaryn = infotext.split("-");
  
          for (var y = 0; y < secaryn.length - 1; y++) {
            if (secaryn[y] == secaryn[y + 1]) {
              secaryn.splice(y, 1);
            }
          }
  
          var infotextn = secaryn.join("-");
  
          if (typeof pdata[k].Flown_Status == "undefined") {
            flown_status = "";
          } else {
            if (pdata[k].Flown_Status == 0) {
              flown_status_t = "Open";
            } else if (pdata[k].Flown_Status == 1) {
              flown_status_t = "Flown";
            }
          }
          var info_str = pdata[k].Info;
          if (pdata[k].TripType == "International") {
            rtext = '<span class="label label-danger">International</span>';
          }
          if (pdata[k].Result == "Fail") {
            restext =
              '<span class="label label-danger pull-left">Non Compliant</span>';
          }
          htmldata +=
            '<tr id="tblrid' +
            pdata[k].PNR +
            '" class="read" value="' +
            pdata[k].PNR +
            '">' +
            '<td class="text-left width-120">' +
            restext +
            '</td><td class="blue-capitals onclick">' +
            pdata[k].PNR +
            "</td><td>" +
            pdata[k].TripType +
            "</td><td>" +
            pdata[k].Airline_Code +
            "</td><td>" +
            infotextn +
            "</td><td>" +
            pdata[k].DepDate +
            '</td><td class="text-center">' +
            pdata[k].ARC +
            '</td><td class="text-left">' +
            flown_status_t +
            '</td><td class="text-right">' +
            currency +
            " " +
            pdata[k].Tot_Amt +
            "</td></tr>";
          var res_status = "success-element";
          if (pdata[k].Result == "Fail") {
            res_status = "danger-element";
          }
  
          htmlboard +=
            '<li value="' +
            pdata[k].PNR +
            '" class="' +
            res_status +
            '" id="board_' +
            pdata[k].PNR +
            '"><div class="agile-detail"><div class="row" style="margin-right: 0px !important"><div class="col-lg-7"><h5>' +
            pdata[k].PNR +
            "</h5>" +
            infotextn +
            '</div><div class="col-lg-5" style><div class="row"><span class=" pull-right"><h5>' +
            currency +
            " " +
            pdata[k].Tot_Amt +
            '</h5></span></div><div class="row"><span class=" pull-right">' +
            pdata[k].DepDate +
            '</span></div><span class="pull-right"><p></p><p></p></span></div></div></div></li>';
        });
        $("#pagination_id").show();
        $("#pnrtable tbody").html(htmldata);
        $("#genfiltered").html(htmlboard);
      }
    });
  }
  $(".table").on("click", "tbody tr", function(e) {
    var id = $(this).attr("value");
  
    $("#board_" + id).css("border-top", "1px solid #838181");
    $("#board_" + id).css("border-bottom", "1px solid #838181");
    $("#board_" + id).css("border-right", "1px solid #838181");
    $("#board_" + id).css("background", "#ffffff");
    showPNR(id);
    // getpnrs(id);
    $("#screener").hide();
    $("#details").show();
  });
  
  function showPNR(pnr) {
    // console.log(pnr);
    console.log(pnrArray)
    main.selectedPNR(pnr);
    main.filteredList(pnrArray);
    // $.ajax({
    //   url: "pnrList.php",
    //   success: function(data) {
    //     var listJson = $.parseJSON(data)
    //     main.update(listJson.pnrList);
    //   }
    // });
  }
  
  $(document).ready(function() {
    $("#screener").show();
    $("#details").hide();
  });
  