const appendFilter=(tab,title)=>{
    let row = $('#'+tab).append(appendRowDiv(tab,'filter'));
    let rowDivId = '#'+tab +'-row';
    let colDivId = '#'+tab+'-filter-col';
    let formDiv = '#'+tab+'-filter-form';
    let modalDiv = '#'+tab+'-modal-body';
    $(rowDivId).append(appendColLgDiv(12,tab+'-filter-col'));
    $(colDivId).append(getSelectedFilterDiv(tab));

    $(colDivId).append(appendFilterBtn(tab));
    $(colDivId).append(getModalDiv(tab,title));

    $(formDiv).append(getModalBody(tab));
    $(formDiv).append(getModalFooter(tab));

    $(modalDiv).append(getGroup(tab));
    $(modalDiv).append(getSubGroup(tab));

    if(tab === 'spend-city-pair'){
        $(modalDiv).append(getSegement(tab));
        $(modalDiv).append(getClass(tab));
        $(modalDiv).append(getPeriodCalendar(tab,1));
        displayDatePicker(tab,1);
        $(modalDiv).append(getPeriodCalendar(tab,2));
        displayDatePicker(tab,2);
        $(modalDiv).append(getInputBox(tab+'-top-count','Top Count','number',5));
    }
    // else if(tab=='spend-fare-cache'){
    // } 
    else if(tab === 'spend-fare-disper-bench'){
        $(modalDiv).append(getSegement(tab));
        $(modalDiv).append(getClass(tab));
        $(modalDiv).append(getPeriodCalendar(tab,1));
        displayDatePicker(tab,1);
        $(modalDiv).append(getPeriodCalendar(tab,2));
        displayDatePicker(tab,2);
        $(modalDiv).append(getInputBox(tab+'-least-amt','Least Amount','number',0));
        $(modalDiv).append(getInputBox(tab+'-highest-amt','Highest Amount','number',10000));
        $(modalDiv).append(getSelectBox(tab+'-origin','Origin'));
        populateDropDown(tab+'-origin',iata_data);
        $(modalDiv).append(getSelectBox(tab+'-destination','Destination'));
        populateDropDown(tab+'-destination',iata_data);
    }
    else if(tab === 'spend-airline-analysis'){
        $(modalDiv).append(getClass(tab));
        $(modalDiv).append(getPeriodCalendar(tab,''));
        displayDatePicker(tab,'');
    }
    else if(tab ==='spend-intl-week-analysis'){
        $(modalDiv).append(getSegement(tab));
        $(modalDiv).append(getClass(tab));
        $(modalDiv).append(getTripType(tab));
        $(modalDiv).append(getInputBox(tab+'-base','Base Country','text','India'))
        $(modalDiv).append(getPeriodCalendar(tab,''));
        displayDatePicker(tab,'');
    }
    else if(tab ==='spend-adv-plan-analysis'){
        $(modalDiv).append(getClass(tab));
        $(modalDiv).append(getTripType(tab));
        $(modalDiv).append(getPeriodCalendar(tab,''));
        displayDatePicker(tab,'');
    }
    else if(tab ==='spend-adv-pur-km'){
    }   
    else if(tab === 'spend-adv-pur-sector'){
        $(modalDiv).append(getSegement(tab));
        $(modalDiv).append(getClass(tab));
        $(modalDiv).append(getTripType(tab));
        $(modalDiv).append(getSelectBox(tab+'-origin','Origin'));
        populateDropDown(tab+'-origin',iata_data);
        $(modalDiv).append(getSelectBox(tab+'-destination','Destination'));
        populateDropDown(tab+'-destination',iata_data);
        $(modalDiv).append(getPeriodCalendar(tab,''));
        displayDatePicker(tab,'');
        $(modalDiv).append(getInputBox(tab+'-range-1','Range 1','text','0-3'));
        $(modalDiv).append(getInputBox(tab+'-range-2','Range 2','text','4-7'));
        $(modalDiv).append(getInputBox(tab+'-range-3','Range 3','text','>7'));
    }
    else if(tab ==='spend-rbd-analysis'){
        $(modalDiv).append(getPeriodCalendar(tab,''));
        displayDatePicker(tab,'');
        $(modalDiv).append(getSelectBox(tab+'-origin','Origin'));
        populateDropDown(tab+'-origin',iata_data);
        $(modalDiv).append(getSelectBox(tab+'-destination','Destination'));
        populateDropDown(tab+'-destination',iata_data);
    }
    else if(tab ==='spend-benchmark-watch'){
        $(modalDiv).append(getSegement(tab));
        $(modalDiv).append(getClass(tab));
        $(modalDiv).append(getPeriodCalendar(tab,''));
        displayDatePicker(tab,'');
        $(modalDiv).append(getSelectBox(tab+'-origin','Origin'));
        populateDropDown(tab+'-origin',iata_data);
        $(modalDiv).append(getSelectBox(tab+'-destination','Destination'));
        populateDropDown(tab+'-destination',iata_data);

    }
    // else if(tab ==='spend-flight-schedule'){
    // }
    $('#'+tab+'-filter-btn').click();
    $('#'+tab+'-filter-form').submit((e)=>{
        e.preventDefault();
        var $inputs = $('#'+e.target.id + ' :input');
        var values = {};
        $inputs.each(function() {
            if(this.name)
            values[this.name] = $(this).val();
        });
        displayDashboard(tab,values);
    })
}

const getInputBox=(id,label,type,defaulVal)=>{
        if(!defaulVal && defaulVal !== 0)
            defaulVal = '';
        return (
                '<div class="row m-b">'+
                    '<label class="col-sm-5 col-form-label" style="padding-left: 4%;" >'+label+'</label>'+
                    '<div class="col-sm-7">'+
                        '<input type="'+type+'" class="form-control" name="'+id+'-val"  value="'+defaulVal+'"  autocomplete="off" required>'+
                    '</div>'+
                '</div>'
            )
 }

const populateDropDown = (id,data,otherLoc)=>{
    var d = $.map(data, function (obj,i) {
            let text = Object.values(obj);
            let sub  = Object.keys(obj)[0];
              return {
                        name : text +' ('+sub+')',
                        id : sub
                    };
            });

    $('#select-'+id).typeahead({
                source: d,
                items : 4,
                displayText : function(obj){
                    return obj.name;
                }
            }
        );
}

const getSelectBox =(id,label)=>{
    return (
        '<div class="row m-b">'
            +'<label class="col-sm-5 col-form-label" style="padding-left: 4%;">'+label+'</label>'
            +'<div class="col-sm-7">'
                +'<input type="text"  class="form-control" id="select-'+id+'" name="'+id+'" autocomplete="off" required/>'
            +'</div>'
        +'</div>'
)
}

const getTripType =(id)=>{
    return (
        '<div class="row m-b">'+
        '<label class="col-sm-5 col-form-label" style="padding-left: 4%;">Trip Type</label>'+
            '<div class="col-sm-7">'+
            '<select class="form-control" name="filtertriptype" id="'+id+'-triptype" required>'+
                '<option disabled value="selected hidden">Select Trip Type</option>'+
                '<option value="ONE_WAY">One Way</option>'+
                '<option value="RETURN">Return</option>'+
            '</select>'+
            '</div>'+
        '</div>'
        )
    };


const displayDatePicker=(id,num)=>{
    $('#'+id+'-period-'+num).datepicker({
                        keyboardNavigation: false,
                        forceParse: false,
                        autoclose: true,
                        format: "yyyy-mm-dd"
                    }) 
}

const appendRowDiv = (id,cl,style)=>{
    if(!style)
        style = '';
    return (
            '<div class="row '+cl+'" id="'+id+'-row" style="'+style+'"></div>'
        )
}

const appendColLgDiv =(size,id,title,style,cl)=>{
    let ele =  !title ? '' : '<div class="ibox-title"><h5>'+title+'</h5></div>';
     cl =  !cl ? '' : cl;
    return(
            '<div class="col-lg-'+size+' '+cl+'" id="'+id+'" style="'+style+'">'+ele+'</div>'
        )
}

const appendIboxTitle =(title)=>{
    return (
        '<div class="ibox-title"><h5>'+title+'</h5></div>'
        )
}

const getSelectedFilterDiv=(id)=>{
    return (
        '<div id="'+id+'-selected-filter-div" class="selected-filter-div">'+
                '<ul id="'+id+'-filter-choices" class="filter-choices">'+
                '</ul>'+
        '</div>')
}

const  getGroup = (id)=>{
    return (
        '<div class="row m-b" style="display:none">'+
            '<label class="col-sm-5 col-form-label" style="padding-left: 4%;">Group Code</label>'+
            '<div class="col-sm-7">'+
                '<select class="form-control col-sm-7" name="filtergroupcode" id="'+id+'filter-gcselect">'+
                     '<option value="'+agentChk+'">'+agentChk+'</option>'+
                '</select>'+
            '</div>'+
        '</div>'
        )
};

const getSubGroup = (id)=>{
    return (
        '<div class="row m-b">'+
            ' <label class="col-sm-5 col-form-label" style="padding-left: 4%;">Sub-Group</label>'+
            '<div class="col-sm-7">'+
                '<select class="form-control" name="filtersubgroupcode" id="'+id+'filter-sgcselect">'+
                    '<option selected="selected">'+
                        'All'+
                    '</option>'+
                '</select>'+ 
            '</div>'+
        '</div>'
        )
}

const getSegement =(id)=>{
	return (
        '<div class="row m-b">'+
            '<label class="col-sm-5 col-form-label" style="padding-left: 4%;">Segment</label>'+
            '<div class="col-sm-7">'+
    			'<select class="form-control" name="filtersegment" id="'+id+'-segment" required>'+
    	            '<option disabled value="selected hidden">Select Segment</option>'+
    	            '<option value="DOMESTIC">Domestic</option>'+
    	            '<option value="INTERNATIONAL">International</option>'+
    	        '</select>'+
            '</div>'+
        '</div>'
        )
    };

const getClass =(id)=>{
    return (
        '<div class="row m-b">'+
        '<label class="col-sm-5 col-form-label" style="padding-left: 4%;">Class</label>'+
            '<div class="col-sm-7">'+
            '<select class="form-control" name="filterclass" id="'+id+'-class" required>'+
                '<option disabled value="selected hidden">Select Class</option>'+
                '<option value="ECONOMY">Economy</option>'+
                '<option value="BUSINESS">Business</option>'+
                '<option value="FIRST">First</option>'+
                '<option value="PREMIUM_ECONOMY">Premium Economy</option>'+
            '</select>'+
            '</div>'+
        '</div>'
        )
    };

const  getCriteria=(id)=>{
	return ('<label class="col-sm-5 col-form-label">Criteria</label>'+
                   '<select class="form-control" name="filtercriteria" id="'+id+'-criteria" required>'+
                       '<option disabled value="" selected hidden>Select Criteria</option>'+
                       '<option value="Year">Year</option>'+
                       '<option value="FY">Financial Year</option>'+
                       '<option value="Quarter">Quarter</option>'+
                       '<option value="Month">Month</option>'+
                   '</select>')
		};

const getYear = (id)=>{
	return ('<label class="col-sm-5 col-form-label">Year</label>'+
            '<select class="form-control m-b" name="filteryear" id="'+id+'-year">'+
                '<option disabled value="" selected hidden>Select Year</option>'+
                '<option value="2014">2014</option>'+
                '<option value="2015">2015</option>'+   
                '<option value="2016">2016</option>'+
                '<option value="2017">2017</option>'+
                '<option value="2018">2018</option>'+
                '<option value="2018">2019</option>'+
            '</select>')
	   };

const getPeriodCalendar = (id,num)=>{
    return ('<div class="row m-b">'+
                '<label class="col-sm-5 col-form-label" style="padding-left: 4%;">Period '+num+'</label>'+
                '<div class="input-daterange input-group col-sm-6" style="margin:auto;" id="'+id+'-period-'+num+'">'+
                                '<input type="text" class="form-control" name="'+id+'-period'+num+'-from" value="2017-01-01" style="margin-left: -7%;">'+
                                '<span class="input-group-addon">To</span>'+
                                '<input type="text" class="form-control " name="'+id+'-period'+num+'-to" value="2017-12-31" style="margin-left: 7%;">'+

                    '</div>'+
            '</div>'
            )
        };


const getModalDiv=(id,title)=>{
        return ('<div class="modal inmodal" id="'+id+'-filter-modal" tabindex="-1" role="dialog" aria-hidden="true">'+
                    '<div class="modal-dialog">'+
                        '<div class="modal-content animated fadeIn">'+
                            '<div class="modal-header">'+
                                '<button type="button" class="btn filter-btn" data-dismiss="modal">'+
                                    '<i class="fa fa-close"></i>'+
                                '</button>'+
                                '<h3 style="float: left;">'+title+' Filter</h3>'+
                            '</div>'+
                            '<form action="#" method="post" id="'+id+'-filter-form" role="'+id+'_filter_form">'+
                            '</form>'+
                        '</div>'+
                    '</div>'+
                '</div>'
            )
        }

const getModalBody=(id)=>{
    return (
        '<div class="modal-body" id="'+id+'-modal-body"></div>'
        );
 }

const getModalFooter=()=>{
 	return ( 
 		'<div class="modal-footer">'+
            '<button type="button" class="btn btn-white" data-dismiss="modal" onClick="hideNav()">Close</button>'+
            '<button type="submit" class="btn btn-primary">Filter</button>'+
        '</div>'
 		)
 };


const getFinancialYear=(id)=>{
 	 return ('<label class="col-sm-5 col-form-label">Financial Year</label>'+
        ' <select class="form-control m-b" name="filterfinyear" id="'+id+'-filter-finyear">'+
             '<option disabled value="" selected hidden>Select Financial Year</option>'+
             '<option value="2013-2014">2013-2014</option>'+
             '<option value="2014-2015">2014-2015</option>'+
             '<option value="2015-2016">2015-2016</option>'+
             '<option value="2016-2017">2016-2017</option>'+
             '<option value="2017-2018">2017-2018</option>'+
             '<option value="2018-2019">2018-2019</option>'+
         "</select>")
 }

const getQuarter=(id)=>{
	return ('<label class="col-sm-5 col-form-label">Quarter</label>'+
        '<select class="form-control m-b" name="filterquarter" id="'+id+'-filter-quarter">'+
            '<option disabled value="" selected hidden>Select Quarter</option>'+
            '<option value="Q1">Quarter 1</option>'+
            '<option value="Q2">Quarter 2</option>'+     
            '<option value="Q3">Quarter 3</option>'+
            '<option value="Q4">Quarter 4</option>'+
        '</select>')
}

const getMonth = (id)=>{
	return ('<label class="col-sm-5 col-form-label">Month</label>'+
            '<select class="form-control m-b" name="filtermonth" id="'+id+'filter-month">'+
                '<option disabled value="" selected hidden>Select Month</option>'+
                '<option value="01">Jan</option>'+
                '<option value="02">Feb</option>'+
                '<option value="03">Mar</option>'+
                '<option value="04">Apr</option>'+
                '<option value="05">May</option>'+
                '<option value="06">June</option>'+
                '<option value="07">July</option>'+
                '<option value="08">Aug</option>'+
                '<option value="09">Sept</option>'+
                '<option value="10">Oct</option>'+
                '<option value="11">Nov</option>'+
                '<option value="12">Dec</option>'+
            '</select>')
}

const appendFilterBtn =(id)=>{
    return ('<button class="btn filter-btn" type="button" id="'+id+'-filter-btn" data-toggle="modal" data-target="#'+id+'-filter-modal">'+
                                        '<i class="fa fa-filter"></i>'+
            '</button>')
}

