<?php
date_default_timezone_set('Asia/Calcutta');
include 'db.php';
require 'vendor/autoload.php';
use \Slim\Middleware\JwtAuthentication;
use \Slim\Middleware\JwtAuthentication\RequestPathRule;

use Lcobucci\JWT\Builder;
use Lcobucci\JWT\Signer\Hmac\Sha256;

$app = new Slim\App();

//$app->config('debug', true);

$app->add(new JwtAuthentication([
    "secret" => 'secret',
    "rules" => [
        new RequestPathRule([
            "path" => "/submittedlist",
            "passthrough" => ["/token","/public"]
        ])
    ],
    "callback" => function ($request,$response,$args) use ($app) {
        $app->jwt = $args["decoded"];
//        echo'<pre>';print_r($args);echo'</pre>';exit;
    }
]));

$app->post("/public", function ($request,$response,$args) use ($app) {
//    echo'<pre>';print_r($app->jwt);echo'</pre>';exit;
    $data = array("message"=>" success","data"=>"Secured Content");
    echo json_encode($data);
    return $response;
});
$app->post("/paymentInfoInsert", function ($request,$response,$args) use ($app) {
    $sql = "SELECT * FROM tbl_users as TU WHERE TU.user_id=:id";
    try {
//        $db = getDB();
//        $stmt = $db->prepare($sql); 
//        $stmt->bindParam("id", $app->jwt->user_id);
//        $stmt->execute();		
//        $updates = $stmt->fetch(PDO::FETCH_OBJ);
//        $db = null;
//        if(!$updates){
//            $data = array("message"=>" error","data"=>"Invalid token");
//            echo json_encode($data);
//        }
//        else{
            $db = getDB();
            $sql = "INSERT INTO tbl_payment_info_record (tp_name, tp_email, tp_phone, tp_passport, tp_remarks, tp_amount, tp_timestamp) VALUES (?,?,?,?,?,?,?)";
            $db->prepare($sql)->execute([$_GET['name'],$_GET['email'],$_GET['phone'],$_GET['passport'],$_GET['remarks'],$_GET['amount'],date('Y-m-d H:i:s',time())]);
            $fary['message'] = 'success';
//        }
        
    } catch(PDOException $e) {
        echo '{"error":{"text":'. $e->getMessage() .'}}'; exit;
    }    
    return json_encode($fary);
});
$app->get("/requestPaymentInfo", function ($request,$response,$args) use ($app) {
    $sql = "SELECT * FROM tbl_users as TU WHERE TU.user_id=:id";
    try {
//        $db = getDB();
//        $stmt = $db->prepare($sql); 
//        $stmt->bindParam("id", $app->jwt->user_id);
//        $stmt->execute();		
//        $updates = $stmt->fetch(PDO::FETCH_OBJ);
//        $db = null;
//        if(!$updates){
//            $data = array("message"=>" error","data"=>"Invalid token");
//            echo json_encode($data);
//        }
//        else{
            $db = getDB();
            $sql = "SELECT 
                  request_number,
                  request_passport_number,
                  CONCAT(first_name, ' ', last_name) name,
                  status_name,
                  vr.modified_date,
                  visa_type_name,
                  country_name,
                  COALESCE(vrd.visa_discount_amount, 0) as discount,
                  COALESCE(vrd.visa_embassy_fee, 0) + COALESCE(vrd.visa_vsf_fee, 0) + COALESCE(vrd.visa_service_fee, 0) AS amt1,
                  COALESCE(vrd.visa_courier_amount, 0) + COALESCE(vrd.visa_notary_charges, 0) + COALESCE(vrd.visa_photo_charges, 0) + COALESCE(vrd.visa_other_amount, 0) AS amt2
                FROM
                  tbl_visa_requests vr 
                  INNER JOIN tbl_visa_request_trip_details td ON vr.request_id = td.visa_request_id 
                  INNER JOIN tbl_country ON td.visa_country_id = tbl_country.country_id 
                  INNER JOIN tbl_visa_type ON td.visa_type_id = tbl_visa_type.visa_type_id 
                  INNER JOIN tbl_status ts ON ts.status_id = vr.request_status
                  INNER JOIN tbl_visa_request_trip_details vrd ON vrd.`visa_request_id`=vr.`request_id`
                WHERE vr.request_number = :requestNumber";
            $stmt = $db->prepare($sql);
            $stmt->bindParam("requestNumber", $_GET['requestNumber']);
            $stmt->execute();
//            $requestList = $stmt->fetch(PDO::FETCH_ASSOC);
            $j=-1;
            $vinfo = array();
            $vinfo['recordFound'] = 'no';
            while( $row = $stmt->fetch() ) {
                $amt1 = $row['amt1'];
                $amt2 = $row['amt2'] + $row['amt2'] * 0.18;
                $vinfo['amount'] = $amt1 + $amt2 - $row['discount'];
                $vinfo['recordFound'] = 'yes';
                $vinfo['requestNumber'] = $row['request_number'];
                $vinfo['passportNumber'] = $row['request_passport_number'];
                $vinfo['paxName'] = $row['name'];
                $vinfo['status'] = $row['status_name'];
                $vinfo['visaType'] = $row['visa_type_name'];
                $vinfo['country'] = $row['country_name'];
            }
            $fdata['Info'] = $vinfo;
            $fdata['message'] = 'success';
    //        $data = array("message"=>"success","request_detail"=>"".);
            echo json_encode($fdata);
//        }
        
    } catch(PDOException $e) {
        echo '{"error":{"text":'. $e->getMessage() .'}}'; 
    }    
    return $response;
});
$app->get("/requestStatus", function ($request,$response,$args) use ($app) {
    $sql = "SELECT * FROM tbl_users as TU WHERE TU.user_id=:id";
    try {
//        $db = getDB();
//        $stmt = $db->prepare($sql); 
//        $stmt->bindParam("id", $app->jwt->user_id);
//        $stmt->execute();		
//        $updates = $stmt->fetch(PDO::FETCH_OBJ);
//        $db = null;
//        if(!$updates){
//            $data = array("message"=>" error","data"=>"Invalid token");
//            echo json_encode($data);
//        }
//        else{
            $db = getDB();
            $sql = "select request_number,request_passport_number,concat(first_name,' ',last_name) name,status_name,vr.modified_date,visa_type_name,country_name
            from tbl_visa_requests vr inner join tbl_visa_request_trip_details td on vr.request_id=td.visa_request_id inner join tbl_country on td.visa_country_id=tbl_country.country_id inner join tbl_visa_type on td.visa_type_id=tbl_visa_type.visa_type_id inner join tbl_status ts on ts.status_id=vr.request_status where vr.request_number = :requestNumber and vr.request_passport_number= :passportNumber";
            $stmt = $db->prepare($sql);
            $stmt->bindParam("requestNumber", $_GET['requestNumber']);
            $stmt->bindParam("passportNumber", $_GET['passportNumber']);
            $stmt->execute();
//            $requestList = $stmt->fetch(PDO::FETCH_ASSOC);
            $j=-1;
            $vinfo = array();
            $vinfo['recordFound'] = 'no';
            while( $row = $stmt->fetch() ) {
                $vinfo['recordFound'] = 'yes';
                $vinfo['requestNumber'] = $row['request_number'];
                $vinfo['passportNumber'] = $row['request_passport_number'];
                $vinfo['paxName'] = $row['name'];
                $vinfo['status'] = $row['status_name'];
                $vinfo['visaType'] = $row['visa_type_name'];
                $vinfo['country'] = $row['country_name'];
            }
            $fdata['Info'] = $vinfo;
            $fdata['message'] = 'success';
    //        $data = array("message"=>"success","request_detail"=>"".);
            echo json_encode($fdata);
//        }
        
    } catch(PDOException $e) {
        echo '{"error":{"text":'. $e->getMessage() .'}}'; 
    }    
    return $response;
});
$app->get("/test", function ($request,$response,$args) use ($app) {
    $sql = "SELECT * FROM tbl_users as TU WHERE TU.user_id=:id";
    try {
//        $db = getDB();
//        $stmt = $db->prepare($sql); 
//        $stmt->bindParam("id", $app->jwt->user_id);
//        $stmt->execute();		
//        $updates = $stmt->fetch(PDO::FETCH_OBJ);
//        $db = null;
//        if(!$updates){
//            $data = array("message"=>" error","data"=>"Invalid token");
//            echo json_encode($data);
//        }
//        else{
            $db = getDB();
            $sql = "SELECT * from Airline_List limit 20";
            $stmt = $db->prepare($sql);
            $stmt->execute();
//            $requestList = $stmt->fetch(PDO::FETCH_ASSOC);
            $j=-1;
            $vinfo = array();
            while( $row = $stmt->fetch() ) {
                $vinfo[++$j]['CODE'] = $row['CODE'];
                $vinfo[$j]['NAME'] = $row['NAME'];
                $vinfo[$j]['COUNTRY'] = $row['COUNTRY'];
            }
            $fary['info'] = $vinfo;
            echo json_encode($fary);
//        }
        
    } catch(PDOException $e) {
        echo '{"error":{"text":'. $e->getMessage() .'}}'; 
    }    
    return $response;
});
$app->get("/countryVisaInfo", function ($request,$response,$args) use ($app) {
    $sql = "SELECT * FROM tbl_users as TU WHERE TU.user_id=:id";
    try {
//        $db = getDB();
//        $stmt = $db->prepare($sql); 
//        $stmt->bindParam("id", $app->jwt->user_id);
//        $stmt->execute();		
//        $updates = $stmt->fetch(PDO::FETCH_OBJ);
//        $db = null;
//        if(!$updates){
//            $data = array("message"=>" error","data"=>"Invalid token");
//            echo json_encode($data);
//        }
//        else{
            $db = getDB();
            $sql = "SELECT * from tbl_visa_type tv inner join (select * from tbl_visa_type_rates where visa_country_id = :countryId and visa_type_id = :visaTypeId) tr on tr.visa_type_id = tv.visa_type_id";
            $stmt = $db->prepare($sql);
            $stmt->bindParam("countryId", $_GET['countryId']);
            $stmt->bindParam("visaTypeId", $_GET['visaTypeId']);
            $stmt->execute();
//            $requestList = $stmt->fetch(PDO::FETCH_ASSOC);
            $j=-1;
            $vinfo = array();
            while( $row = $stmt->fetch() ) {
                $vinfo['visaEmbassyFee'] = $row['visa_vsf_fee'];
                $vinfo['visaVFSFee'] = $row['visa_vsf_fee'];
                $vinfo['remarks'] = $row['visa_type_remarks'];
                $db1 = getDB();
                $sql1 = "select * from tbl_visa_type_rates_child where rec_vtr_id = ".$row['visa_type_rate_id'];
                $stmt1 = $db1->prepare($sql1);
                $stmt1->execute();
                $k=-1;
                while( $row1 = $stmt1->fetch() ) {
                    $cInfo[++$k]['city'] = $row1['rec_city'];
                    $cInfo[$k]['tags'] = $row1['rec_tags'];
                    $cInfo[$k]['proccessDays'] = $row1['rec_process_days'];
                }
                $vinfo['additional'] = $cInfo;
            }
            $fdata['visaList'] = $vinfo;
            $fdata['message'] = 'success';
    //        $data = array("message"=>"success","request_detail"=>"".);
            echo json_encode($fdata);
//        }
        
    } catch(PDOException $e) {
        echo '{"error":{"text":'. $e->getMessage() .'}}'; 
    }    
    return $response;
});
$app->get("/countryVisaList", function ($request,$response,$args) use ($app) {
    $sql = "SELECT * FROM tbl_users as TU WHERE TU.user_id=:id";
    try {
//        $db = getDB();
//        $stmt = $db->prepare($sql); 
//        $stmt->bindParam("id", $app->jwt->user_id);
//        $stmt->execute();		
//        $updates = $stmt->fetch(PDO::FETCH_OBJ);
//        $db = null;
//        if(!$updates){
//            $data = array("message"=>" error","data"=>"Invalid token");
//            echo json_encode($data);
//        }
//        else{
            $db = getDB();
            $sql = "SELECT visa_type_name,tv.visa_type_id from tbl_visa_type tv inner join (select visa_type_id,visa_country_id from tbl_visa_type_rates where visa_country_id = :countryId) tr on tr.visa_type_id = tv.visa_type_id";        
            $stmt = $db->prepare($sql); 
            $stmt->bindParam("countryId", $_GET['countryId']);
            $stmt->execute();
//            $requestList = $stmt->fetch(PDO::FETCH_ASSOC);
            $j=-1;
            while( $row = $stmt->fetch() ) {
                $reqList[++$j]['visaName'] = $row['visa_type_name'];
                $reqList[$j]['visaTypeId'] = $row['visa_type_id'];
            }
            $fdata['visaList'] = $reqList;
            $fdata['message'] = 'success';
    //        $data = array("message"=>"success","request_detail"=>"".);
            echo json_encode($fdata);
//        }
        
    } catch(PDOException $e) {
        echo '{"error":{"text":'. $e->getMessage() .'}}'; 
    }    
    return $response;
});
$app->get("/countryList", function ($request,$response,$args) use ($app) {
//    $sql = "SELECT * FROM tbl_users as TU WHERE TU.user_id=:id";
    try {
//        $db = getDB();
//        $stmt = $db->prepare($sql); 
//        $stmt->bindParam("id", $app->jwt->user_id);
//        $stmt->execute();		
//        $updates = $stmt->fetch(PDO::FETCH_OBJ);
//        $db = null;
//        if(!$updates){
//            $data = array("message"=>" error","data"=>"Invalid token");
//            echo json_encode($data);
//        }
//        else{
            $db = getDB();
            $sql = "SELECT country_id,country_name,country_code from tbl_country where is_active = 1 order by country_name asc";        
            $stmt = $db->prepare($sql); 
    //        $stmt->bindParam("is_active", 1);
            $stmt->execute();		
//            $requestList = $stmt->fetch(PDO::FETCH_ASSOC);
            $j=-1;
            while( $row = $stmt->fetch() ) {
                $requestList[++$j]['countryId'] = $row['country_id'];
                $requestList[$j]['countryName'] = $row['country_name'];
                $requestList[$j]['countryCode'] = $row['country_code'];
            }
            $fdata['countryInfo'] = $requestList;
//            $fdata['message'] = 'success';
    //        $data = array("message"=>"success","request_detail"=>"".);
            echo json_encode($fdata);
//        }
        
    } catch(PDOException $e) {
        echo '{"error":{"text":'. $e->getMessage() .'}}'; 
    }    
    return $response;
});
$app->get("/submittedlist", function ($request,$response,$args) use ($app) {
    $sql = "SELECT * FROM tbl_users as TU WHERE TU.user_id=:id";
    try {
        $db = getDB();
        $stmt = $db->prepare($sql); 
        $stmt->bindParam("id", $app->jwt->user_id);
        $stmt->execute();		
        $updates = $stmt->fetch(PDO::FETCH_OBJ);
        $db = null;
        if(!$updates){
            $data = array("message"=>" error","data"=>"Invalid token");
            echo json_encode($data);
        }
        $db = getDB();
        $sql = "SELECT TVR.*, TU1.user_first_name as modifiedFName, TU1.user_last_name as modifiedLName, TU.user_first_name, TU.user_last_name, TCB.cust_branch_name, TVD.visa_depature_data, TVT.visa_type_name, TVD.visa_embassy_fee, TVD.visa_service_fee, TVD.visa_vsf_fee, TVD.visa_dd_number, TVD.visa_dd_amount, TVD.visa_courier_amount, TVD.visa_other_amount, TVD.visa_discount_amount, TC.country_name, TCOB.comp_branch_name, TCOB1.comp_branch_name as modifiedBranch 
                FROM (`tbl_visa_requests` as TVR) 
                LEFT JOIN `tbl_users` as TU ON `TU`.`user_id` = `TVR`.`excutive_assign_id` 
                LEFT JOIN `tbl_customer_branch` as TCB ON `TCB`.`cust_branch_id` = `TVR`.`customer_branch_id` 
                LEFT JOIN `tbl_company_branch` as TCOB ON `TCOB`.`comp_branch_id` = `TVR`.`request_branch` 
                JOIN `tbl_visa_request_trip_details` as TVD ON `TVD`.`visa_request_id` = `TVR`.`request_id` 
                JOIN `tbl_visa_type` as TVT ON `TVT`.`visa_type_id` = `TVD`.`visa_type_id` 
                JOIN `tbl_country` as TC ON `TC`.`country_id` = `TVD`.`visa_country_id` 
                LEFT JOIN `tbl_users` as TU1 ON `TU1`.`user_id` = `TVR`.`modified_by` 
                LEFT JOIN `tbl_company_branch` as TCOB1 ON `TCOB1`.`comp_branch_id` = `TU1`.`comp_branch_id` 
                WHERE 
                `TVR`.`request_status` = 8 
                AND 
                `TVR`.`excutive_assign_id` = ':userId' 
                AND 
                `TVR`.`request_service_branch` = ':branchId' 
                ORDER BY `request_id` DESC";        
        $stmt = $db->prepare($sql); 
        $stmt->bindParam("userId", $updates->user_id);
        $stmt->bindParam("branchId", $updates->comp_branch_id);
        $stmt->execute();		
        $requestList = $stmt->fetch(PDO::FETCH_OBJ);
        $data = array("message"=>"success","request_detail"=>"".$requestList);
        echo json_encode($data);
    } catch(PDOException $e) {
        echo '{"error":{"text":'. $e->getMessage() .'}}'; 
    }    
    return $response;
});
$app->get("/token", function ($request,$response,$args) use ($app) {
    
    $post = $request->getParams();
    
    if($post['email'] =='' && $post['password'] == ''){
        $data = array("message"=>" error","data"=>"Unable to process username or password missing");
        echo json_encode($data);
    }
    $sql = "SELECT * FROM tbl_users as TU WHERE TU.user_email=:email AND TU.user_password=:password";
    $password = sha1($post['password']);
    try {
        $db = getDB();
        $stmt = $db->prepare($sql); 
        $stmt->bindParam("email", $post['email']);
        $stmt->bindParam("password", $password);
        $stmt->execute();		
        $updates = $stmt->fetch(PDO::FETCH_OBJ);       
        if(!$updates){
            $data = array("message"=>" error","data"=>"Invalid useremail or Password");
            echo json_encode($data);
        }
        /* Here generate and return JWT to the client. */
        $signer = new Sha256(); 
        echo'gdfggdfhgfdhfg<pre>';print_r(phpinfo());echo'</pre>';exit;
        $token = (new Builder())->setIssuer('https://demo.myvisatrack.com') // Configures the issuer (iss claim)
            ->setAudience('mobileApp') // Configures the audience (aud claim)
            ->setId($updates->user_id, true) // Configures the id (jti claim), replicating as a header item
            ->setIssuedAt(time()) // Configures the time that the token was issue (iat claim)
            //    ->setNotBefore(time() + 60) // Configures the time that the token can be used (nbf claim)
            //    ->setExpiration(time() + 120) // Configures the expiration time of the token (exp claim)
            ->set('user_id', $updates->user_id) // Configures a new claim, called "uid"
            ->set('scope', array('read','write','delete')) // Configures a new claim, called "uid"
            ->sign($signer, 'secret') // creates a signature using "testing" as key
            ->getToken(); // Retrieves the generated token  
         echo'gdfggdfhgfdhfg<pre>';print_r($token);echo'</pre>';exit;
        $data = array("message"=>"success","access_token"=>"".$token,"user_detail"=>$updates);
        echo json_encode($data);
    } catch(PDOException $e) {
        echo '{"error":{"text":'. $e->getMessage() .'}}'; 
    }catch(Exception $e) {
        echo '{"error":{"text":'. $e->getMessage() .'}}'; 
    }
    
});
$app->run();
?>